/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.windows.WinBase;
import org.lwjgl.system.windows.WindowsUtil;

public class WindowsLibrary
extends SharedLibrary.Default {
    public static final long HINSTANCE;

    public WindowsLibrary(String string) {
        String string2 = string;
        this(string2, WindowsLibrary.loadLibrary(string2));
    }

    public WindowsLibrary(String string, long l2) {
        super(string, l2);
    }

    private static long loadLibrary(String string) {
        long l2;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            IntBuffer intBuffer = memoryStack.mallocInt(1);
            l2 = WinBase.LoadLibrary(intBuffer, memoryStack.UTF16(string));
            if (l2 == 0L) {
                throw new UnsatisfiedLinkError("Failed to load library: " + string + " (error code = " + intBuffer.get(0) + ")");
            }
            if (memoryStack != null) {
                memoryStack.close();
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (memoryStack != null) {
                    if (throwable != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        memoryStack.close();
                    }
                }
                throw throwable4;
            }
        }
        return l2;
    }

    /*
     * Loose catch block
     */
    @Override
    public @Nullable String getPath() {
        int n2;
        MemoryStack memoryStack;
        int n3 = 256;
        ByteBuffer byteBuffer = MemoryUtil.memAlloc(256);
        while (true) {
            int n4;
            memoryStack = MemoryStack.stackPush();
            Throwable throwable = null;
            try {
                IntBuffer intBuffer = memoryStack.mallocInt(1);
                n4 = WinBase.GetModuleFileName(intBuffer, this.address(), byteBuffer);
                n2 = intBuffer.get(0);
                if (memoryStack != null) {
                    memoryStack.close();
                }
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (memoryStack != null) {
                        if (throwable != null) {
                            try {
                                memoryStack.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            memoryStack.close();
                        }
                    }
                    throw throwable4;
                }
            }
            if (n2 != 0) break block15;
            memoryStack = n4 == 0 ? null : MemoryUtil.memUTF16(byteBuffer, n4);
            break;
        }
        catch (Throwable throwable) {
            MemoryUtil.memFree(byteBuffer);
            throw throwable;
        }
        {
            block15: {
                MemoryUtil.memFree(byteBuffer);
                return memoryStack;
            }
            if (n2 != 122) {
                MemoryUtil.memFree(byteBuffer);
                return null;
            }
            n3 = n3 * 3 / 2;
            byteBuffer = MemoryUtil.memRealloc(byteBuffer, n3);
            continue;
        }
    }

    @Override
    public long getFunctionAddress(ByteBuffer byteBuffer) {
        return WinBase.GetProcAddress(null, this.address(), byteBuffer);
    }

    @Override
    public void free() {
        MemoryStack memoryStack = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            IntBuffer intBuffer = memoryStack.mallocInt(1);
            if (!WinBase.FreeLibrary(intBuffer, this.address())) {
                WindowsUtil.windowsThrowException("Failed to unload library: " + this.getName(), intBuffer);
            }
            if (memoryStack != null) {
                memoryStack.close();
                return;
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (memoryStack != null) {
                    if (throwable != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        memoryStack.close();
                    }
                }
                throw throwable4;
            }
        }
    }

    static {
        MemoryStack memoryStack = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            IntBuffer intBuffer = memoryStack.mallocInt(1);
            HINSTANCE = WinBase.GetModuleHandle(intBuffer, memoryStack.UTF16(Library.JNI_LIBRARY_NAME));
            if (HINSTANCE == 0L) {
                WindowsUtil.windowsThrowException("Failed to retrieve LWJGL module handle.", intBuffer);
            }
            if (memoryStack != null) {
                memoryStack.close();
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (memoryStack != null) {
                    if (throwable != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        memoryStack.close();
                    }
                }
                throw throwable4;
            }
        }
    }
}

