/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class MOUSEINPUT
extends Struct<MOUSEINPUT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DX;
    public static final int DY;
    public static final int MOUSEDATA;
    public static final int DWFLAGS;
    public static final int TIME;
    public static final int DWEXTRAINFO;

    protected MOUSEINPUT(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected MOUSEINPUT create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new MOUSEINPUT(l2, byteBuffer);
    }

    public MOUSEINPUT(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), MOUSEINPUT.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LONG")
    public int dx() {
        return MOUSEINPUT.ndx(this.address());
    }

    @NativeType(value="LONG")
    public int dy() {
        return MOUSEINPUT.ndy(this.address());
    }

    @NativeType(value="DWORD")
    public int mouseData() {
        return MOUSEINPUT.nmouseData(this.address());
    }

    @NativeType(value="DWORD")
    public int dwFlags() {
        return MOUSEINPUT.ndwFlags(this.address());
    }

    @NativeType(value="DWORD")
    public int time() {
        return MOUSEINPUT.ntime(this.address());
    }

    @NativeType(value="ULONG_PTR")
    public long dwExtraInfo() {
        return MOUSEINPUT.ndwExtraInfo(this.address());
    }

    public MOUSEINPUT dx(@NativeType(value="LONG") int n2) {
        MOUSEINPUT.ndx(this.address(), n2);
        return this;
    }

    public MOUSEINPUT dy(@NativeType(value="LONG") int n2) {
        MOUSEINPUT.ndy(this.address(), n2);
        return this;
    }

    public MOUSEINPUT mouseData(@NativeType(value="DWORD") int n2) {
        MOUSEINPUT.nmouseData(this.address(), n2);
        return this;
    }

    public MOUSEINPUT dwFlags(@NativeType(value="DWORD") int n2) {
        MOUSEINPUT.ndwFlags(this.address(), n2);
        return this;
    }

    public MOUSEINPUT time(@NativeType(value="DWORD") int n2) {
        MOUSEINPUT.ntime(this.address(), n2);
        return this;
    }

    public MOUSEINPUT dwExtraInfo(@NativeType(value="ULONG_PTR") long l2) {
        MOUSEINPUT.ndwExtraInfo(this.address(), l2);
        return this;
    }

    public MOUSEINPUT set(int n2, int n3, int n4, int n5, int n6, long l2) {
        this.dx(n2);
        this.dy(n3);
        this.mouseData(n4);
        this.dwFlags(n5);
        this.time(n6);
        this.dwExtraInfo(l2);
        return this;
    }

    public MOUSEINPUT set(MOUSEINPUT mOUSEINPUT) {
        MemoryUtil.memCopy(mOUSEINPUT.address(), this.address(), SIZEOF);
        return this;
    }

    public static MOUSEINPUT malloc() {
        return new MOUSEINPUT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static MOUSEINPUT calloc() {
        return new MOUSEINPUT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static MOUSEINPUT create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new MOUSEINPUT(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static MOUSEINPUT create(long l2) {
        return new MOUSEINPUT(l2, null);
    }

    public static @Nullable MOUSEINPUT createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new MOUSEINPUT(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(MOUSEINPUT.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = MOUSEINPUT.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    @Deprecated
    public static MOUSEINPUT mallocStack() {
        return MOUSEINPUT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MOUSEINPUT callocStack() {
        return MOUSEINPUT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MOUSEINPUT mallocStack(MemoryStack memoryStack) {
        return MOUSEINPUT.malloc(memoryStack);
    }

    @Deprecated
    public static MOUSEINPUT callocStack(MemoryStack memoryStack) {
        return MOUSEINPUT.calloc(memoryStack);
    }

    @Deprecated
    public static Buffer mallocStack(int n2) {
        return MOUSEINPUT.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int n2) {
        return MOUSEINPUT.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return MOUSEINPUT.malloc(n2, memoryStack);
    }

    @Deprecated
    public static Buffer callocStack(int n2, MemoryStack memoryStack) {
        return MOUSEINPUT.calloc(n2, memoryStack);
    }

    public static MOUSEINPUT malloc(MemoryStack memoryStack) {
        return new MOUSEINPUT(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MOUSEINPUT calloc(MemoryStack memoryStack) {
        return new MOUSEINPUT(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ndx(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)DX);
    }

    public static int ndy(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)DY);
    }

    public static int nmouseData(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)MOUSEDATA);
    }

    public static int ndwFlags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)DWFLAGS);
    }

    public static int ntime(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TIME);
    }

    public static long ndwExtraInfo(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DWEXTRAINFO);
    }

    public static void ndx(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)DX, n2);
    }

    public static void ndy(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)DY, n2);
    }

    public static void nmouseData(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)MOUSEDATA, n2);
    }

    public static void ndwFlags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)DWFLAGS, n2);
    }

    public static void ntime(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TIME, n2);
    }

    public static void ndwExtraInfo(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DWEXTRAINFO, l3);
    }

    static {
        Struct.Layout layout = MOUSEINPUT.__struct(MOUSEINPUT.__member(4), MOUSEINPUT.__member(4), MOUSEINPUT.__member(4), MOUSEINPUT.__member(4), MOUSEINPUT.__member(4), MOUSEINPUT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DX = layout.offsetof(0);
        DY = layout.offsetof(1);
        MOUSEDATA = layout.offsetof(2);
        DWFLAGS = layout.offsetof(3);
        TIME = layout.offsetof(4);
        DWEXTRAINFO = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<MOUSEINPUT, Buffer>
    implements NativeResource {
        private static final MOUSEINPUT ELEMENT_FACTORY = MOUSEINPUT.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected MOUSEINPUT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LONG")
        public int dx() {
            return MOUSEINPUT.ndx(((Pointer.Default)this).address());
        }

        @NativeType(value="LONG")
        public int dy() {
            return MOUSEINPUT.ndy(((Pointer.Default)this).address());
        }

        @NativeType(value="DWORD")
        public int mouseData() {
            return MOUSEINPUT.nmouseData(((Pointer.Default)this).address());
        }

        @NativeType(value="DWORD")
        public int dwFlags() {
            return MOUSEINPUT.ndwFlags(((Pointer.Default)this).address());
        }

        @NativeType(value="DWORD")
        public int time() {
            return MOUSEINPUT.ntime(((Pointer.Default)this).address());
        }

        @NativeType(value="ULONG_PTR")
        public long dwExtraInfo() {
            return MOUSEINPUT.ndwExtraInfo(((Pointer.Default)this).address());
        }

        public Buffer dx(@NativeType(value="LONG") int n2) {
            MOUSEINPUT.ndx(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer dy(@NativeType(value="LONG") int n2) {
            MOUSEINPUT.ndy(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer mouseData(@NativeType(value="DWORD") int n2) {
            MOUSEINPUT.nmouseData(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer dwFlags(@NativeType(value="DWORD") int n2) {
            MOUSEINPUT.ndwFlags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer time(@NativeType(value="DWORD") int n2) {
            MOUSEINPUT.ntime(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer dwExtraInfo(@NativeType(value="ULONG_PTR") long l2) {
            MOUSEINPUT.ndwExtraInfo(((Pointer.Default)this).address(), l2);
            return this;
        }
    }
}

