/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.windows.RECT;

public class MONITORINFOEX
extends Struct<MONITORINFOEX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CBSIZE;
    public static final int RCMONITOR;
    public static final int RCWORK;
    public static final int DWFLAGS;
    public static final int SZDEVICE;

    protected MONITORINFOEX(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected MONITORINFOEX create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new MONITORINFOEX(l2, byteBuffer);
    }

    public MONITORINFOEX(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), MONITORINFOEX.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="DWORD")
    public int cbSize() {
        return MONITORINFOEX.ncbSize(this.address());
    }

    public RECT rcMonitor() {
        return MONITORINFOEX.nrcMonitor(this.address());
    }

    public RECT rcWork() {
        return MONITORINFOEX.nrcWork(this.address());
    }

    @NativeType(value="DWORD")
    public int dwFlags() {
        return MONITORINFOEX.ndwFlags(this.address());
    }

    @NativeType(value="TCHAR[32]")
    public ByteBuffer szDevice() {
        return MONITORINFOEX.nszDevice(this.address());
    }

    @NativeType(value="TCHAR[32]")
    public String szDeviceString() {
        return MONITORINFOEX.nszDeviceString(this.address());
    }

    public MONITORINFOEX cbSize(@NativeType(value="DWORD") int n2) {
        MONITORINFOEX.ncbSize(this.address(), n2);
        return this;
    }

    public MONITORINFOEX set(MONITORINFOEX mONITORINFOEX) {
        MemoryUtil.memCopy(mONITORINFOEX.address(), this.address(), SIZEOF);
        return this;
    }

    public static MONITORINFOEX malloc() {
        return new MONITORINFOEX(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static MONITORINFOEX calloc() {
        return new MONITORINFOEX(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static MONITORINFOEX create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new MONITORINFOEX(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static MONITORINFOEX create(long l2) {
        return new MONITORINFOEX(l2, null);
    }

    public static @Nullable MONITORINFOEX createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new MONITORINFOEX(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(MONITORINFOEX.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = MONITORINFOEX.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    @Deprecated
    public static MONITORINFOEX mallocStack() {
        return MONITORINFOEX.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MONITORINFOEX callocStack() {
        return MONITORINFOEX.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static MONITORINFOEX mallocStack(MemoryStack memoryStack) {
        return MONITORINFOEX.malloc(memoryStack);
    }

    @Deprecated
    public static MONITORINFOEX callocStack(MemoryStack memoryStack) {
        return MONITORINFOEX.calloc(memoryStack);
    }

    @Deprecated
    public static Buffer mallocStack(int n2) {
        return MONITORINFOEX.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int n2) {
        return MONITORINFOEX.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return MONITORINFOEX.malloc(n2, memoryStack);
    }

    @Deprecated
    public static Buffer callocStack(int n2, MemoryStack memoryStack) {
        return MONITORINFOEX.calloc(n2, memoryStack);
    }

    public static MONITORINFOEX malloc(MemoryStack memoryStack) {
        return new MONITORINFOEX(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static MONITORINFOEX calloc(MemoryStack memoryStack) {
        return new MONITORINFOEX(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ncbSize(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)CBSIZE);
    }

    public static RECT nrcMonitor(long l2) {
        return RECT.create(l2 + (long)RCMONITOR);
    }

    public static RECT nrcWork(long l2) {
        return RECT.create(l2 + (long)RCWORK);
    }

    public static int ndwFlags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)DWFLAGS);
    }

    public static ByteBuffer nszDevice(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)SZDEVICE, 64);
    }

    public static String nszDeviceString(long l2) {
        return MemoryUtil.memUTF16(l2 + (long)SZDEVICE);
    }

    public static void ncbSize(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)CBSIZE, n2);
    }

    static {
        Struct.Layout layout = MONITORINFOEX.__struct(MONITORINFOEX.__member(4), MONITORINFOEX.__member(RECT.SIZEOF, RECT.ALIGNOF), MONITORINFOEX.__member(RECT.SIZEOF, RECT.ALIGNOF), MONITORINFOEX.__member(4), MONITORINFOEX.__array(2, 32));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CBSIZE = layout.offsetof(0);
        RCMONITOR = layout.offsetof(1);
        RCWORK = layout.offsetof(2);
        DWFLAGS = layout.offsetof(3);
        SZDEVICE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<MONITORINFOEX, Buffer>
    implements NativeResource {
        private static final MONITORINFOEX ELEMENT_FACTORY = MONITORINFOEX.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected MONITORINFOEX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="DWORD")
        public int cbSize() {
            return MONITORINFOEX.ncbSize(((Pointer.Default)this).address());
        }

        public RECT rcMonitor() {
            return MONITORINFOEX.nrcMonitor(((Pointer.Default)this).address());
        }

        public RECT rcWork() {
            return MONITORINFOEX.nrcWork(((Pointer.Default)this).address());
        }

        @NativeType(value="DWORD")
        public int dwFlags() {
            return MONITORINFOEX.ndwFlags(((Pointer.Default)this).address());
        }

        @NativeType(value="TCHAR[32]")
        public ByteBuffer szDevice() {
            return MONITORINFOEX.nszDevice(((Pointer.Default)this).address());
        }

        @NativeType(value="TCHAR[32]")
        public String szDeviceString() {
            return MONITORINFOEX.nszDeviceString(((Pointer.Default)this).address());
        }

        public Buffer cbSize(@NativeType(value="DWORD") int n2) {
            MONITORINFOEX.ncbSize(((Pointer.Default)this).address(), n2);
            return this;
        }
    }
}

