/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class HARDWAREINPUT
extends Struct<HARDWAREINPUT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int UMSG;
    public static final int WPARAML;
    public static final int WPARAMH;

    protected HARDWAREINPUT(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected HARDWAREINPUT create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new HARDWAREINPUT(l2, byteBuffer);
    }

    public HARDWAREINPUT(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), HARDWAREINPUT.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="DWORD")
    public int uMsg() {
        return HARDWAREINPUT.nuMsg(this.address());
    }

    @NativeType(value="WORD")
    public short wParamL() {
        return HARDWAREINPUT.nwParamL(this.address());
    }

    @NativeType(value="WORD")
    public short wParamH() {
        return HARDWAREINPUT.nwParamH(this.address());
    }

    public HARDWAREINPUT uMsg(@NativeType(value="DWORD") int n2) {
        HARDWAREINPUT.nuMsg(this.address(), n2);
        return this;
    }

    public HARDWAREINPUT wParamL(@NativeType(value="WORD") short s2) {
        HARDWAREINPUT.nwParamL(this.address(), s2);
        return this;
    }

    public HARDWAREINPUT wParamH(@NativeType(value="WORD") short s2) {
        HARDWAREINPUT.nwParamH(this.address(), s2);
        return this;
    }

    public HARDWAREINPUT set(int n2, short s2, short s3) {
        this.uMsg(n2);
        this.wParamL(s2);
        this.wParamH(s3);
        return this;
    }

    public HARDWAREINPUT set(HARDWAREINPUT hARDWAREINPUT) {
        MemoryUtil.memCopy(hARDWAREINPUT.address(), this.address(), SIZEOF);
        return this;
    }

    public static HARDWAREINPUT malloc() {
        return new HARDWAREINPUT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static HARDWAREINPUT calloc() {
        return new HARDWAREINPUT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static HARDWAREINPUT create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new HARDWAREINPUT(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static HARDWAREINPUT create(long l2) {
        return new HARDWAREINPUT(l2, null);
    }

    public static @Nullable HARDWAREINPUT createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new HARDWAREINPUT(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(HARDWAREINPUT.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = HARDWAREINPUT.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    @Deprecated
    public static HARDWAREINPUT mallocStack() {
        return HARDWAREINPUT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HARDWAREINPUT callocStack() {
        return HARDWAREINPUT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static HARDWAREINPUT mallocStack(MemoryStack memoryStack) {
        return HARDWAREINPUT.malloc(memoryStack);
    }

    @Deprecated
    public static HARDWAREINPUT callocStack(MemoryStack memoryStack) {
        return HARDWAREINPUT.calloc(memoryStack);
    }

    @Deprecated
    public static Buffer mallocStack(int n2) {
        return HARDWAREINPUT.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int n2) {
        return HARDWAREINPUT.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return HARDWAREINPUT.malloc(n2, memoryStack);
    }

    @Deprecated
    public static Buffer callocStack(int n2, MemoryStack memoryStack) {
        return HARDWAREINPUT.calloc(n2, memoryStack);
    }

    public static HARDWAREINPUT malloc(MemoryStack memoryStack) {
        return new HARDWAREINPUT(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static HARDWAREINPUT calloc(MemoryStack memoryStack) {
        return new HARDWAREINPUT(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nuMsg(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)UMSG);
    }

    public static short nwParamL(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)WPARAML);
    }

    public static short nwParamH(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)WPARAMH);
    }

    public static void nuMsg(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)UMSG, n2);
    }

    public static void nwParamL(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)WPARAML, s2);
    }

    public static void nwParamH(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)WPARAMH, s2);
    }

    static {
        Struct.Layout layout = HARDWAREINPUT.__struct(HARDWAREINPUT.__member(4), HARDWAREINPUT.__member(2), HARDWAREINPUT.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        UMSG = layout.offsetof(0);
        WPARAML = layout.offsetof(1);
        WPARAMH = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<HARDWAREINPUT, Buffer>
    implements NativeResource {
        private static final HARDWAREINPUT ELEMENT_FACTORY = HARDWAREINPUT.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected HARDWAREINPUT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="DWORD")
        public int uMsg() {
            return HARDWAREINPUT.nuMsg(((Pointer.Default)this).address());
        }

        @NativeType(value="WORD")
        public short wParamL() {
            return HARDWAREINPUT.nwParamL(((Pointer.Default)this).address());
        }

        @NativeType(value="WORD")
        public short wParamH() {
            return HARDWAREINPUT.nwParamH(((Pointer.Default)this).address());
        }

        public Buffer uMsg(@NativeType(value="DWORD") int n2) {
            HARDWAREINPUT.nuMsg(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer wParamL(@NativeType(value="WORD") short s2) {
            HARDWAREINPUT.nwParamL(((Pointer.Default)this).address(), s2);
            return this;
        }

        public Buffer wParamH(@NativeType(value="WORD") short s2) {
            HARDWAREINPUT.nwParamH(((Pointer.Default)this).address(), s2);
            return this;
        }
    }
}

