/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.Struct;
import org.lwjgl.system.libc.LibCStdlib;
import org.lwjgl.system.macosx.EnumerationMutationHandlerI;
import org.lwjgl.system.macosx.ObjCMethodDescription;
import org.lwjgl.system.macosx.ObjCPropertyAttribute;

public class ObjCRuntime {
    private static final SharedLibrary OBJC = Library.loadNative(ObjCRuntime.class, "org.lwjgl", "objc");
    public static final long nil = 0L;
    public static final byte YES = 1;
    public static final byte NO = 0;
    public static final char _C_ID = '@';
    public static final char _C_CLASS = '#';
    public static final char _C_SEL = ':';
    public static final char _C_CHR = 'c';
    public static final char _C_UCHR = 'C';
    public static final char _C_SHT = 's';
    public static final char _C_USHT = 'S';
    public static final char _C_INT = 'i';
    public static final char _C_UINT = 'I';
    public static final char _C_LNG = 'l';
    public static final char _C_ULNG = 'L';
    public static final char _C_LNG_LNG = 'q';
    public static final char _C_ULNG_LNG = 'Q';
    public static final char _C_FLT = 'f';
    public static final char _C_DBL = 'd';
    public static final char _C_BFLD = 'b';
    public static final char _C_BOOL = 'B';
    public static final char _C_VOID = 'v';
    public static final char _C_UNDEF = '?';
    public static final char _C_PTR = '^';
    public static final char _C_CHARPTR = '*';
    public static final char _C_ATOM = '%';
    public static final char _C_ARY_B = '[';
    public static final char _C_ARY_E = ']';
    public static final char _C_UNION_B = '(';
    public static final char _C_UNION_E = ')';
    public static final char _C_STRUCT_B = '{';
    public static final char _C_STRUCT_E = '}';
    public static final char _C_VECTOR = '!';
    public static final char _C_CONST = 'r';
    public static final int OBJC_ASSOCIATION_ASSIGN = 0;
    public static final int OBJC_ASSOCIATION_RETAIN_NONATOMIC = 1;
    public static final int OBJC_ASSOCIATION_COPY_NONATOMIC = 3;
    public static final int OBJC_ASSOCIATION_RETAIN = 1401;
    public static final int OBJC_ASSOCIATION_COPY = 1403;

    public static SharedLibrary getLibrary() {
        return OBJC;
    }

    protected ObjCRuntime() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="id")
    public static long object_copy(@NativeType(value="id") long l2, @NativeType(value="size_t") long l3) {
        long l4 = Functions.object_copy;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="id")
    public static long object_dispose(@NativeType(value="id") long l2) {
        long l3 = Functions.object_dispose;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long object_getClass(@NativeType(value="id") long l2) {
        long l3 = Functions.object_getClass;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long object_setClass(@NativeType(value="id") long l2, @NativeType(value="Class") long l3) {
        long l4 = Functions.object_setClass;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long nobject_getClassName(long l2) {
        long l3 = Functions.object_getClassName;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char const *")
    public static @Nullable String object_getClassName(@NativeType(value="id") long l2) {
        return MemoryUtil.memUTF8Safe(ObjCRuntime.nobject_getClassName(l2));
    }

    @NativeType(value="void *")
    public static long object_getIndexedIvars(@NativeType(value="id") long l2) {
        long l3 = Functions.object_getIndexedIvars;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="id")
    public static long object_getIvar(@NativeType(value="id") long l2, @NativeType(value="Ivar") long l3) {
        long l4 = Functions.object_getIvar;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static void object_setIvar(@NativeType(value="id") long l2, @NativeType(value="Ivar") long l3, @NativeType(value="id") long l4) {
        long l5 = Functions.object_setIvar;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        JNI.invokePPPV(l2, l3, l4, l5);
    }

    public static long nobject_setInstanceVariable(long l2, long l3, long l4) {
        long l5 = Functions.object_setInstanceVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPPP(l2, l3, l4, l5);
    }

    @NativeType(value="Ivar")
    public static long object_setInstanceVariable(@NativeType(value="id") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="void *") ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobject_setInstanceVariable(l2, MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(byteBuffer2));
    }

    @NativeType(value="Ivar")
    public static long object_setInstanceVariable(@NativeType(value="id") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="void *") ByteBuffer byteBuffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nobject_setInstanceVariable(l2, l3, MemoryUtil.memAddress(byteBuffer));
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobject_getInstanceVariable(long l2, long l3, long l4) {
        long l5 = Functions.object_getInstanceVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPPP(l2, l3, l4, l5);
    }

    @NativeType(value="Ivar")
    public static long object_getInstanceVariable(@NativeType(value="id") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="void **") PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.check(pointerBuffer, 1);
        }
        return ObjCRuntime.nobject_getInstanceVariable(l2, MemoryUtil.memAddress(byteBuffer), MemoryUtil.memAddress(pointerBuffer));
    }

    @NativeType(value="Ivar")
    public static long object_getInstanceVariable(@NativeType(value="id") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="void **") PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.check(pointerBuffer, 1);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nobject_getInstanceVariable(l2, l3, MemoryUtil.memAddress(pointerBuffer));
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getClass(long l2) {
        long l3 = Functions.objc_getClass;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long objc_getClass(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getClass(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Class")
    public static long objc_getClass(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = ObjCRuntime.nobjc_getClass(memoryStack.getPointerAddress());
            return l2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getMetaClass(long l2) {
        long l3 = Functions.objc_getMetaClass;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long objc_getMetaClass(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getMetaClass(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Class")
    public static long objc_getMetaClass(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = ObjCRuntime.nobjc_getMetaClass(memoryStack.getPointerAddress());
            return l2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_lookUpClass(long l2) {
        long l3 = Functions.objc_lookUpClass;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long objc_lookUpClass(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_lookUpClass(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Class")
    public static long objc_lookUpClass(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = ObjCRuntime.nobjc_lookUpClass(memoryStack.getPointerAddress());
            return l2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getRequiredClass(long l2) {
        long l3 = Functions.objc_getRequiredClass;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class")
    public static long objc_getRequiredClass(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getRequiredClass(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Class")
    public static long objc_getRequiredClass(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = ObjCRuntime.nobjc_getRequiredClass(memoryStack.getPointerAddress());
            return l2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static int nobjc_getClassList(long l2, int n2) {
        long l3 = Functions.objc_getClassList;
        return JNI.invokePI(l2, n2, l3);
    }

    public static int objc_getClassList(@NativeType(value="Class *") @Nullable PointerBuffer pointerBuffer) {
        return ObjCRuntime.nobjc_getClassList(MemoryUtil.memAddressSafe(pointerBuffer), Checks.remainingSafe(pointerBuffer));
    }

    public static long nobjc_copyClassList(long l2) {
        long l3 = Functions.objc_copyClassList;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Class *")
    public static @Nullable PointerBuffer objc_copyClassList() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        Comparable<IntBuffer> comparable = memoryStack.callocInt(1);
        try {
            comparable = MemoryUtil.memPointerBufferSafe(ObjCRuntime.nobjc_copyClassList(MemoryUtil.memAddress(comparable)), comparable.get(0));
            return comparable;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getName(long l2) {
        long l3 = Functions.class_getName;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char const *")
    public static @Nullable String class_getName(@NativeType(value="Class") long l2) {
        return MemoryUtil.memUTF8Safe(ObjCRuntime.nclass_getName(l2));
    }

    @NativeType(value="BOOL")
    public static boolean class_isMetaClass(@NativeType(value="Class") long l2) {
        long l3 = Functions.class_isMetaClass;
        return JNI.invokePZ(l2, l3);
    }

    @NativeType(value="Class")
    public static long class_getSuperclass(@NativeType(value="Class") long l2) {
        long l3 = Functions.class_getSuperclass;
        return JNI.invokePP(l2, l3);
    }

    public static int class_getVersion(@NativeType(value="Class") long l2) {
        long l3 = Functions.class_getVersion;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePI(l2, l3);
    }

    public static void class_setVersion(@NativeType(value="Class") long l2, int n2) {
        long l3 = Functions.class_setVersion;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, n2, l3);
    }

    @NativeType(value="size_t")
    public static long class_getInstanceSize(@NativeType(value="Class") long l2) {
        long l3 = Functions.class_getInstanceSize;
        return JNI.invokePP(l2, l3);
    }

    public static long nclass_getInstanceVariable(long l2, long l3) {
        long l4 = Functions.class_getInstanceVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="Ivar")
    public static long class_getInstanceVariable(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_getInstanceVariable(l2, MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Ivar")
    public static long class_getInstanceVariable(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nclass_getInstanceVariable(l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getClassVariable(long l2, long l3) {
        long l4 = Functions.class_getClassVariable;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="Ivar")
    public static long class_getClassVariable(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_getClassVariable(l2, MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Ivar")
    public static long class_getClassVariable(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nclass_getClassVariable(l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_copyIvarList(long l2, long l3) {
        long l4 = Functions.class_copyIvarList;
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="Ivar *")
    public static @Nullable PointerBuffer class_copyIvarList(@NativeType(value="Class") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(ObjCRuntime.nclass_copyIvarList(l2, MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="Method")
    public static long class_getInstanceMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3) {
        long l4 = Functions.class_getInstanceMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="Method")
    public static long class_getClassMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3) {
        long l4 = Functions.class_getClassMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="IMP")
    public static long class_getMethodImplementation(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3) {
        long l4 = Functions.class_getMethodImplementation;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="BOOL")
    public static boolean class_respondsToSelector(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3) {
        long l4 = Functions.class_respondsToSelector;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static long nclass_copyMethodList(long l2, long l3) {
        long l4 = Functions.class_copyMethodList;
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="Method *")
    public static @Nullable PointerBuffer class_copyMethodList(@NativeType(value="Class") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(ObjCRuntime.nclass_copyMethodList(l2, MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="BOOL")
    public static boolean class_conformsToProtocol(@NativeType(value="Class") long l2, @NativeType(value="Protocol *") long l3) {
        long l4 = Functions.class_conformsToProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static long nclass_copyProtocolList(long l2, long l3) {
        long l4 = Functions.class_copyProtocolList;
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="Protocol **")
    public static @Nullable PointerBuffer class_copyProtocolList(@NativeType(value="Class") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(ObjCRuntime.nclass_copyProtocolList(l2, MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getProperty(long l2, long l3) {
        long l4 = Functions.class_getProperty;
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="objc_property_t")
    public static long class_getProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_getProperty(l2, MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="objc_property_t")
    public static long class_getProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nclass_getProperty(l2, l3);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_copyPropertyList(long l2, long l3) {
        long l4 = Functions.class_copyPropertyList;
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="objc_property_t *")
    public static @Nullable PointerBuffer class_copyPropertyList(@NativeType(value="Class") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(ObjCRuntime.nclass_copyPropertyList(l2, MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getIvarLayout(long l2) {
        long l3 = Functions.class_getIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="uint8_t const *")
    public static @Nullable String class_getIvarLayout(@NativeType(value="Class") long l2) {
        return MemoryUtil.memASCIISafe(ObjCRuntime.nclass_getIvarLayout(l2));
    }

    public static long nclass_getWeakIvarLayout(long l2) {
        long l3 = Functions.class_getWeakIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="uint8_t const *")
    public static @Nullable String class_getWeakIvarLayout(@NativeType(value="Class") long l2) {
        return MemoryUtil.memASCIISafe(ObjCRuntime.nclass_getWeakIvarLayout(l2));
    }

    public static boolean nclass_addMethod(long l2, long l3, long l4, long l5) {
        long l6 = Functions.class_addMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        return JNI.invokePPPPZ(l2, l3, l4, l5, l6);
    }

    @NativeType(value="BOOL")
    public static boolean class_addMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3, @NativeType(value="IMP") long l4, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_addMethod(l2, l3, l4, MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="BOOL")
    public static boolean class_addMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3, @NativeType(value="IMP") long l4, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l5 = memoryStack.getPointerAddress();
            boolean bl = ObjCRuntime.nclass_addMethod(l2, l3, l4, l5);
            return bl;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_replaceMethod(long l2, long l3, long l4, long l5) {
        long l6 = Functions.class_replaceMethod;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        return JNI.invokePPPPP(l2, l3, l4, l5, l6);
    }

    @NativeType(value="IMP")
    public static long class_replaceMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3, @NativeType(value="IMP") long l4, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_replaceMethod(l2, l3, l4, MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="IMP")
    public static long class_replaceMethod(@NativeType(value="Class") long l2, @NativeType(value="SEL") long l3, @NativeType(value="IMP") long l4, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l5 = memoryStack.getPointerAddress();
            long l6 = ObjCRuntime.nclass_replaceMethod(l2, l3, l4, l5);
            return l6;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static boolean nclass_addIvar(long l2, long l3, long l4, byte by, long l5) {
        long l6 = Functions.class_addIvar;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPPUPZ(l2, l3, l4, by, l5, l6);
    }

    @NativeType(value="BOOL")
    public static boolean class_addIvar(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="size_t") long l3, @NativeType(value="uint8_t") byte by, @NativeType(value="char const *") ByteBuffer byteBuffer2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
            Checks.checkNT1(byteBuffer2);
        }
        return ObjCRuntime.nclass_addIvar(l2, MemoryUtil.memAddress(byteBuffer), l3, by, MemoryUtil.memAddress(byteBuffer2));
    }

    @NativeType(value="BOOL")
    public static boolean class_addIvar(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="size_t") long l3, @NativeType(value="uint8_t") byte by, @NativeType(value="char const *") CharSequence charSequence2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            memoryStack.nUTF8(charSequence2, true);
            long l5 = memoryStack.getPointerAddress();
            boolean bl = ObjCRuntime.nclass_addIvar(l2, l4, l3, by, l5);
            return bl;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="BOOL")
    public static boolean class_addProtocol(@NativeType(value="Class") long l2, @NativeType(value="Protocol *") long l3) {
        long l4 = Functions.class_addProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static boolean nclass_addProperty(long l2, long l3, long l4, int n2) {
        long l5 = Functions.class_addProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Struct.validate(l4, n2, ObjCPropertyAttribute.SIZEOF, ObjCPropertyAttribute::validate);
        }
        return JNI.invokePPPZ(l2, l3, l4, n2, l5);
    }

    @NativeType(value="BOOL")
    public static boolean class_addProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute.Buffer buffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nclass_addProperty(l2, MemoryUtil.memAddress(byteBuffer), ((Pointer.Default)buffer).address(), buffer.remaining());
    }

    @NativeType(value="BOOL")
    public static boolean class_addProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute.Buffer buffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            boolean bl = ObjCRuntime.nclass_addProperty(l2, l3, ((Pointer.Default)buffer).address(), buffer.remaining());
            return bl;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nclass_replaceProperty(long l2, long l3, long l4, int n2) {
        long l5 = Functions.class_replaceProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Struct.validate(l4, n2, ObjCPropertyAttribute.SIZEOF, ObjCPropertyAttribute::validate);
        }
        JNI.invokePPPV(l2, l3, l4, n2, l5);
    }

    public static void class_replaceProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute.Buffer buffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nclass_replaceProperty(l2, MemoryUtil.memAddress(byteBuffer), ((Pointer.Default)buffer).address(), buffer.remaining());
    }

    public static void class_replaceProperty(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute.Buffer buffer) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nclass_replaceProperty(l2, l3, ((Pointer.Default)buffer).address(), buffer.remaining());
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nclass_setIvarLayout(long l2, long l3) {
        long l4 = Functions.class_setIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static void class_setIvarLayout(@NativeType(value="Class") long l2, @NativeType(value="uint8_t const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nclass_setIvarLayout(l2, MemoryUtil.memAddress(byteBuffer));
    }

    public static void class_setIvarLayout(@NativeType(value="Class") long l2, @NativeType(value="uint8_t const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nclass_setIvarLayout(l2, l3);
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nclass_setWeakIvarLayout(long l2, long l3) {
        long l4 = Functions.class_setWeakIvarLayout;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static void class_setWeakIvarLayout(@NativeType(value="Class") long l2, @NativeType(value="uint8_t const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nclass_setWeakIvarLayout(l2, MemoryUtil.memAddress(byteBuffer));
    }

    public static void class_setWeakIvarLayout(@NativeType(value="Class") long l2, @NativeType(value="uint8_t const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nASCII(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nclass_setWeakIvarLayout(l2, l3);
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="id")
    public static long class_createInstance(@NativeType(value="Class") long l2, @NativeType(value="size_t") long l3) {
        long l4 = Functions.class_createInstance;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static long nobjc_constructInstance(long l2, long l3) {
        long l4 = Functions.objc_constructInstance;
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="id")
    public static long objc_constructInstance(@NativeType(value="Class") long l2, @NativeType(value="void *") @Nullable ByteBuffer byteBuffer) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkSafe((Buffer)byteBuffer, ObjCRuntime.class_getInstanceSize(l2));
        }
        return ObjCRuntime.nobjc_constructInstance(l2, MemoryUtil.memAddressSafe(byteBuffer));
    }

    @NativeType(value="void *")
    public static long objc_destructInstance(@NativeType(value="id") long l2) {
        long l3 = Functions.objc_destructInstance;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long nobjc_allocateClassPair(long l2, long l3, long l4) {
        long l5 = Functions.objc_allocateClassPair;
        return JNI.invokePPPP(l2, l3, l4, l5);
    }

    @NativeType(value="Class")
    public static long objc_allocateClassPair(@NativeType(value="Class") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="size_t") long l3) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_allocateClassPair(l2, MemoryUtil.memAddress(byteBuffer), l3);
    }

    @NativeType(value="Class")
    public static long objc_allocateClassPair(@NativeType(value="Class") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="size_t") long l3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            long l5 = ObjCRuntime.nobjc_allocateClassPair(l2, l4, l3);
            return l5;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void objc_registerClassPair(@NativeType(value="Class") long l2) {
        long l3 = Functions.objc_registerClassPair;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static void objc_disposeClassPair(@NativeType(value="Class") long l2) {
        long l3 = Functions.objc_disposeClassPair;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    @NativeType(value="SEL")
    public static long method_getName(@NativeType(value="Method") long l2) {
        long l3 = Functions.method_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="IMP")
    public static long method_getImplementation(@NativeType(value="Method") long l2) {
        long l3 = Functions.method_getImplementation;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long nmethod_getTypeEncoding(long l2) {
        long l3 = Functions.method_getTypeEncoding;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char const *")
    public static @Nullable String method_getTypeEncoding(@NativeType(value="Method") long l2) {
        return MemoryUtil.memUTF8Safe(ObjCRuntime.nmethod_getTypeEncoding(l2));
    }

    @NativeType(value="unsigned int")
    public static int method_getNumberOfArguments(@NativeType(value="Method") long l2) {
        long l3 = Functions.method_getNumberOfArguments;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePI(l2, l3);
    }

    public static long nmethod_copyReturnType(long l2) {
        long l3 = Functions.method_copyReturnType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char *")
    public static @Nullable String method_copyReturnType(@NativeType(value="Method") long l2) {
        return MemoryUtil.memUTF8Safe(ObjCRuntime.nmethod_copyReturnType(l2));
    }

    public static long nmethod_copyArgumentType(long l2, int n2) {
        long l3 = Functions.method_copyArgumentType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, n2, l3);
    }

    @NativeType(value="char *")
    public static @Nullable String method_copyArgumentType(@NativeType(value="Method") long l2, @NativeType(value="unsigned int") int n2) {
        @Nullable long l3 = 0L;
        try {
            l3 = ObjCRuntime.nmethod_copyArgumentType(l2, n2);
            String string = MemoryUtil.memUTF8Safe(l3);
            return string;
        }
        finally {
            if (l3 != 0L) {
                LibCStdlib.nfree(l3);
            }
        }
    }

    public static void nmethod_getReturnType(long l2, long l3, long l4) {
        long l5 = Functions.method_getReturnType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPPV(l2, l3, l4, l5);
    }

    public static void method_getReturnType(@NativeType(value="Method") long l2, @NativeType(value="char *") ByteBuffer byteBuffer) {
        ObjCRuntime.nmethod_getReturnType(l2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    @NativeType(value="void")
    public static String method_getReturnType(@NativeType(value="Method") long l2, @NativeType(value="size_t") long l3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            ByteBuffer byteBuffer = memoryStack.malloc((int)l3);
            ObjCRuntime.nmethod_getReturnType(l2, MemoryUtil.memAddress(byteBuffer), l3);
            String string = MemoryUtil.memUTF8(MemoryUtil.memByteBufferNT1(MemoryUtil.memAddress(byteBuffer), (int)l3));
            return string;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void nmethod_getArgumentType(long l2, int n2, long l3, long l4) {
        long l5 = Functions.method_getArgumentType;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePPPV(l2, n2, l3, l4, l5);
    }

    public static void method_getArgumentType(@NativeType(value="Method") long l2, @NativeType(value="unsigned int") int n2, @NativeType(value="char *") ByteBuffer byteBuffer) {
        ObjCRuntime.nmethod_getArgumentType(l2, n2, MemoryUtil.memAddress(byteBuffer), byteBuffer.remaining());
    }

    @NativeType(value="void")
    public static String method_getArgumentType(@NativeType(value="Method") long l2, @NativeType(value="unsigned int") int n2, @NativeType(value="size_t") long l3) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n3 = memoryStack.getPointer();
        try {
            ByteBuffer byteBuffer = memoryStack.malloc((int)l3);
            ObjCRuntime.nmethod_getArgumentType(l2, n2, MemoryUtil.memAddress(byteBuffer), l3);
            String string = MemoryUtil.memUTF8(MemoryUtil.memByteBufferNT1(MemoryUtil.memAddress(byteBuffer), (int)l3));
            return string;
        }
        finally {
            memoryStack.setPointer(n3);
        }
    }

    @NativeType(value="IMP")
    public static long method_setImplementation(@NativeType(value="Method") long l2, @NativeType(value="IMP") long l3) {
        long l4 = Functions.method_setImplementation;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static void method_exchangeImplementations(@NativeType(value="Method") long l2, @NativeType(value="Method") long l3) {
        long l4 = Functions.method_exchangeImplementations;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static long nivar_getName(long l2) {
        long l3 = Functions.ivar_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char const *")
    public static @Nullable String ivar_getName(@NativeType(value="Ivar") long l2) {
        return MemoryUtil.memUTF8Safe(ObjCRuntime.nivar_getName(l2));
    }

    public static long nivar_getTypeEncoding(long l2) {
        long l3 = Functions.ivar_getTypeEncoding;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char const *")
    public static @Nullable String ivar_getTypeEncoding(@NativeType(value="Ivar") long l2) {
        return MemoryUtil.memUTF8Safe(ObjCRuntime.nivar_getTypeEncoding(l2));
    }

    @NativeType(value="ptrdiff_t")
    public static long ivar_getOffset(@NativeType(value="Ivar") long l2) {
        long l3 = Functions.ivar_getOffset;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    public static long nproperty_getName(long l2) {
        long l3 = Functions.property_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char const *")
    public static @Nullable String property_getName(@NativeType(value="objc_property_t") long l2) {
        return MemoryUtil.memUTF8Safe(ObjCRuntime.nproperty_getName(l2));
    }

    public static long nproperty_getAttributes(long l2) {
        long l3 = Functions.property_getAttributes;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char const *")
    public static @Nullable String property_getAttributes(@NativeType(value="objc_property_t") long l2) {
        return MemoryUtil.memUTF8Safe(ObjCRuntime.nproperty_getAttributes(l2));
    }

    public static long nproperty_copyAttributeList(long l2, long l3) {
        long l4 = Functions.property_copyAttributeList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="objc_property_attribute_t *")
    public static @Nullable ObjCPropertyAttribute.Buffer property_copyAttributeList(@NativeType(value="objc_property_t") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            ObjCPropertyAttribute.Buffer buffer = ObjCPropertyAttribute.createSafe(ObjCRuntime.nproperty_copyAttributeList(l2, MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return buffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nproperty_copyAttributeValue(long l2, long l3) {
        long l4 = Functions.property_copyAttributeValue;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="char *")
    public static @Nullable String property_copyAttributeValue(@NativeType(value="objc_property_t") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        @Nullable long l3 = 0L;
        try {
            l3 = ObjCRuntime.nproperty_copyAttributeValue(l2, MemoryUtil.memAddress(byteBuffer));
            String string = MemoryUtil.memUTF8Safe(l3);
            return string;
        }
        finally {
            if (l3 != 0L) {
                LibCStdlib.nfree(l3);
            }
        }
    }

    @NativeType(value="char *")
    public static @Nullable String property_copyAttributeValue(@NativeType(value="objc_property_t") long l2, @NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        long l3 = 0L;
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            l3 = ObjCRuntime.nproperty_copyAttributeValue(l2, l4);
            String string = MemoryUtil.memUTF8Safe(l3);
            return string;
        }
        finally {
            if (l3 != 0L) {
                LibCStdlib.nfree(l3);
            }
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_getProtocol(long l2) {
        long l3 = Functions.objc_getProtocol;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Protocol *")
    public static long objc_getProtocol(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_getProtocol(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Protocol *")
    public static long objc_getProtocol(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = ObjCRuntime.nobjc_getProtocol(memoryStack.getPointerAddress());
            return l2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_copyProtocolList(long l2) {
        long l3 = Functions.objc_copyProtocolList;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Protocol **")
    public static @Nullable PointerBuffer objc_copyProtocolList() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        Comparable<IntBuffer> comparable = memoryStack.callocInt(1);
        try {
            comparable = MemoryUtil.memPointerBufferSafe(ObjCRuntime.nobjc_copyProtocolList(MemoryUtil.memAddress(comparable)), comparable.get(0));
            return comparable;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="BOOL")
    public static boolean protocol_conformsToProtocol(@NativeType(value="Protocol *") long l2, @NativeType(value="Protocol *") long l3) {
        long l4 = Functions.protocol_conformsToProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    @NativeType(value="BOOL")
    public static boolean protocol_isEqual(@NativeType(value="Protocol *") long l2, @NativeType(value="Protocol *") long l3) {
        long l4 = Functions.protocol_isEqual;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static long nprotocol_getName(long l2) {
        long l3 = Functions.protocol_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char const *")
    public static @Nullable String protocol_getName(@NativeType(value="Protocol *") long l2) {
        return MemoryUtil.memUTF8Safe(ObjCRuntime.nprotocol_getName(l2));
    }

    public static native void nprotocol_getMethodDescription(long var0, long var2, boolean var4, boolean var5, long var6, long var8);

    public static void nprotocol_getMethodDescription(long l2, long l3, boolean bl, boolean bl2, long l4) {
        long l5 = Functions.protocol_getMethodDescription;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        ObjCRuntime.nprotocol_getMethodDescription(l2, l3, bl, bl2, l5, l4);
    }

    @NativeType(value="struct objc_method_description")
    public static ObjCMethodDescription protocol_getMethodDescription(@NativeType(value="Protocol *") long l2, @NativeType(value="SEL") long l3, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2, @NativeType(value="struct objc_method_description") ObjCMethodDescription objCMethodDescription) {
        ObjCRuntime.nprotocol_getMethodDescription(l2, l3, bl, bl2, objCMethodDescription.address());
        return objCMethodDescription;
    }

    public static long nprotocol_copyMethodDescriptionList(long l2, boolean bl, boolean bl2, long l3) {
        long l4 = Functions.protocol_copyMethodDescriptionList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, bl, bl2, l3, l4);
    }

    @NativeType(value="struct objc_method_description *")
    public static @Nullable ObjCMethodDescription.Buffer protocol_copyMethodDescriptionList(@NativeType(value="Protocol *") long l2, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            ObjCMethodDescription.Buffer buffer = ObjCMethodDescription.createSafe(ObjCRuntime.nprotocol_copyMethodDescriptionList(l2, bl, bl2, MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return buffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nprotocol_getProperty(long l2, long l3, boolean bl, boolean bl2) {
        long l4 = Functions.protocol_getProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, bl, bl2, l4);
    }

    @NativeType(value="objc_property_t")
    public static long protocol_getProperty(@NativeType(value="Protocol *") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nprotocol_getProperty(l2, MemoryUtil.memAddress(byteBuffer), bl, bl2);
    }

    @NativeType(value="objc_property_t")
    public static long protocol_getProperty(@NativeType(value="Protocol *") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            long l4 = ObjCRuntime.nprotocol_getProperty(l2, l3, bl, bl2);
            return l4;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nprotocol_copyPropertyList(long l2, long l3) {
        long l4 = Functions.protocol_copyPropertyList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="objc_property_t *")
    public static @Nullable PointerBuffer protocol_copyPropertyList(@NativeType(value="Protocol *") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(ObjCRuntime.nprotocol_copyPropertyList(l2, MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nprotocol_copyProtocolList(long l2, long l3) {
        long l4 = Functions.protocol_copyProtocolList;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="Protocol **")
    public static @Nullable PointerBuffer protocol_copyProtocolList(@NativeType(value="Protocol *") long l2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe(ObjCRuntime.nprotocol_copyProtocolList(l2, MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return pointerBuffer;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_allocateProtocol(long l2) {
        long l3 = Functions.objc_allocateProtocol;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="Protocol *")
    public static long objc_allocateProtocol(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nobjc_allocateProtocol(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="Protocol *")
    public static long objc_allocateProtocol(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = ObjCRuntime.nobjc_allocateProtocol(memoryStack.getPointerAddress());
            return l2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void objc_registerProtocol(@NativeType(value="Protocol *") long l2) {
        long l3 = Functions.objc_registerProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static void nprotocol_addMethodDescription(long l2, long l3, long l4, boolean bl, boolean bl2) {
        long l5 = Functions.protocol_addMethodDescription;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        JNI.invokePPPV(l2, l3, l4, bl, bl2, l5);
    }

    public static void protocol_addMethodDescription(@NativeType(value="Protocol *") long l2, @NativeType(value="SEL") long l3, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nprotocol_addMethodDescription(l2, l3, MemoryUtil.memAddress(byteBuffer), bl, bl2);
    }

    public static void protocol_addMethodDescription(@NativeType(value="Protocol *") long l2, @NativeType(value="SEL") long l3, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l4 = memoryStack.getPointerAddress();
            ObjCRuntime.nprotocol_addMethodDescription(l2, l3, l4, bl, bl2);
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static void protocol_addProtocol(@NativeType(value="Protocol *") long l2, @NativeType(value="Protocol *") long l3) {
        long l4 = Functions.protocol_addProtocol;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        JNI.invokePPV(l2, l3, l4);
    }

    public static void nprotocol_addProperty(long l2, long l3, long l4, int n2, boolean bl, boolean bl2) {
        long l5 = Functions.protocol_addProperty;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Struct.validate(l4, n2, ObjCPropertyAttribute.SIZEOF, ObjCPropertyAttribute::validate);
        }
        JNI.invokePPPV(l2, l3, l4, n2, bl, bl2, l5);
    }

    public static void protocol_addProperty(@NativeType(value="Protocol *") long l2, @NativeType(value="char const *") ByteBuffer byteBuffer, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute.Buffer buffer, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        ObjCRuntime.nprotocol_addProperty(l2, MemoryUtil.memAddress(byteBuffer), ((Pointer.Default)buffer).address(), buffer.remaining(), bl, bl2);
    }

    public static void protocol_addProperty(@NativeType(value="Protocol *") long l2, @NativeType(value="char const *") CharSequence charSequence, @NativeType(value="objc_property_attribute_t const *") ObjCPropertyAttribute.Buffer buffer, @NativeType(value="BOOL") boolean bl, @NativeType(value="BOOL") boolean bl2) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l3 = memoryStack.getPointerAddress();
            ObjCRuntime.nprotocol_addProperty(l2, l3, ((Pointer.Default)buffer).address(), buffer.remaining(), bl, bl2);
            return;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nobjc_copyImageNames(long l2) {
        long l3 = Functions.objc_copyImageNames;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char const **")
    public static @Nullable PointerBuffer objc_copyImageNames() {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        Comparable<IntBuffer> comparable = memoryStack.callocInt(1);
        try {
            comparable = MemoryUtil.memPointerBufferSafe(ObjCRuntime.nobjc_copyImageNames(MemoryUtil.memAddress(comparable)), comparable.get(0));
            return comparable;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nclass_getImageName(long l2) {
        long l3 = Functions.class_getImageName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char const *")
    public static @Nullable String class_getImageName(@NativeType(value="Class") long l2) {
        return MemoryUtil.memUTF8Safe(ObjCRuntime.nclass_getImageName(l2));
    }

    public static long nobjc_copyClassNamesForImage(long l2, long l3) {
        long l4 = Functions.objc_copyClassNamesForImage;
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="char const **")
    public static @Nullable PointerBuffer objc_copyClassNamesForImage(@NativeType(value="char const *") ByteBuffer comparable) {
        if (Checks.CHECKS) {
            Checks.checkNT1(comparable);
        }
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        IntBuffer intBuffer = memoryStack.callocInt(1);
        try {
            comparable = MemoryUtil.memPointerBufferSafe(ObjCRuntime.nobjc_copyClassNamesForImage(MemoryUtil.memAddress(comparable), MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return comparable;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="char const **")
    public static @Nullable PointerBuffer objc_copyClassNamesForImage(@NativeType(value="char const *") CharSequence object) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.callocInt(1);
            memoryStack.nUTF8((CharSequence)object, true);
            object = MemoryUtil.memPointerBufferSafe(ObjCRuntime.nobjc_copyClassNamesForImage(memoryStack.getPointerAddress(), MemoryUtil.memAddress(intBuffer)), intBuffer.get(0));
            return object;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nsel_getName(long l2) {
        long l3 = Functions.sel_getName;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="char const *")
    public static @Nullable String sel_getName(@NativeType(value="SEL") long l2) {
        return MemoryUtil.memUTF8Safe(ObjCRuntime.nsel_getName(l2));
    }

    public static long nsel_getUid(long l2) {
        long l3 = Functions.sel_getUid;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="SEL")
    public static long sel_getUid(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nsel_getUid(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="SEL")
    public static long sel_getUid(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = ObjCRuntime.nsel_getUid(memoryStack.getPointerAddress());
            return l2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    public static long nsel_registerName(long l2) {
        long l3 = Functions.sel_registerName;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="SEL")
    public static long sel_registerName(@NativeType(value="char const *") ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkNT1(byteBuffer);
        }
        return ObjCRuntime.nsel_registerName(MemoryUtil.memAddress(byteBuffer));
    }

    @NativeType(value="SEL")
    public static long sel_registerName(@NativeType(value="char const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n2 = memoryStack.getPointer();
        try {
            memoryStack.nUTF8(charSequence, true);
            long l2 = ObjCRuntime.nsel_registerName(memoryStack.getPointerAddress());
            return l2;
        }
        finally {
            memoryStack.setPointer(n2);
        }
    }

    @NativeType(value="BOOL")
    public static boolean sel_isEqual(@NativeType(value="SEL") long l2, @NativeType(value="SEL") long l3) {
        long l4 = Functions.sel_isEqual;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPZ(l2, l3, l4);
    }

    public static void objc_enumerationMutation(@NativeType(value="id") long l2) {
        long l3 = Functions.objc_enumerationMutation;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    public static void nobjc_setEnumerationMutationHandler(long l2) {
        long l3 = Functions.objc_setEnumerationMutationHandler;
        JNI.invokePV(l2, l3);
    }

    public static void objc_setEnumerationMutationHandler(@NativeType(value="EnumerationMutationHandler") EnumerationMutationHandlerI enumerationMutationHandlerI) {
        ObjCRuntime.nobjc_setEnumerationMutationHandler(enumerationMutationHandlerI.address());
    }

    @NativeType(value="IMP")
    public static long imp_implementationWithBlock(@NativeType(value="id") long l2) {
        long l3 = Functions.imp_implementationWithBlock;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="id")
    public static long imp_getBlock(@NativeType(value="IMP") long l2) {
        long l3 = Functions.imp_getBlock;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="BOOL")
    public static boolean imp_removeBlock(@NativeType(value="IMP") long l2) {
        long l3 = Functions.imp_removeBlock;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        return JNI.invokePZ(l2, l3);
    }

    public static long nobjc_loadWeak(long l2) {
        long l3 = Functions.objc_loadWeak;
        return JNI.invokePP(l2, l3);
    }

    @NativeType(value="id")
    public static long objc_loadWeak(@NativeType(value="id *") @Nullable PointerBuffer pointerBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe(pointerBuffer, 1);
        }
        return ObjCRuntime.nobjc_loadWeak(MemoryUtil.memAddressSafe(pointerBuffer));
    }

    public static long nobjc_storeWeak(long l2, long l3) {
        long l4 = Functions.objc_storeWeak;
        if (Checks.CHECKS) {
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    @NativeType(value="id")
    public static long objc_storeWeak(@NativeType(value="id *") PointerBuffer pointerBuffer, @NativeType(value="id") long l2) {
        if (Checks.CHECKS) {
            Checks.check(pointerBuffer, 1);
        }
        return ObjCRuntime.nobjc_storeWeak(MemoryUtil.memAddress(pointerBuffer), l2);
    }

    public static void objc_setAssociatedObject(@NativeType(value="id") long l2, @NativeType(value="void const *") long l3, @NativeType(value="id") long l4, @NativeType(value="objc_AssociationPolicy") long l5) {
        long l6 = Functions.objc_setAssociatedObject;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
            Checks.check(l4);
        }
        JNI.invokePPPPV(l2, l3, l4, l5, l6);
    }

    @NativeType(value="id")
    public static long objc_getAssociatedObject(@NativeType(value="id") long l2, @NativeType(value="void const *") long l3) {
        long l4 = Functions.objc_getAssociatedObject;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.check(l3);
        }
        return JNI.invokePPP(l2, l3, l4);
    }

    public static void objc_removeAssociatedObjects(@NativeType(value="id") long l2) {
        long l3 = Functions.objc_removeAssociatedObjects;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.invokePV(l2, l3);
    }

    static /* synthetic */ SharedLibrary access$000() {
        return OBJC;
    }

    public static final class Functions {
        public static final long object_copy = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_copy");
        public static final long object_dispose = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_dispose");
        public static final long object_getClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_getClass");
        public static final long object_setClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_setClass");
        public static final long object_getClassName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_getClassName");
        public static final long object_getIndexedIvars = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_getIndexedIvars");
        public static final long object_getIvar = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_getIvar");
        public static final long object_setIvar = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_setIvar");
        public static final long object_setInstanceVariable = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_setInstanceVariable");
        public static final long object_getInstanceVariable = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "object_getInstanceVariable");
        public static final long objc_getClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getClass");
        public static final long objc_getMetaClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getMetaClass");
        public static final long objc_lookUpClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_lookUpClass");
        public static final long objc_getRequiredClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getRequiredClass");
        public static final long objc_getClassList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getClassList");
        public static final long objc_copyClassList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_copyClassList");
        public static final long class_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getName");
        public static final long class_isMetaClass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_isMetaClass");
        public static final long class_getSuperclass = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getSuperclass");
        public static final long class_getVersion = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getVersion");
        public static final long class_setVersion = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_setVersion");
        public static final long class_getInstanceSize = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getInstanceSize");
        public static final long class_getInstanceVariable = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getInstanceVariable");
        public static final long class_getClassVariable = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getClassVariable");
        public static final long class_copyIvarList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_copyIvarList");
        public static final long class_getInstanceMethod = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getInstanceMethod");
        public static final long class_getClassMethod = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getClassMethod");
        public static final long class_getMethodImplementation = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getMethodImplementation");
        public static final long class_respondsToSelector = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_respondsToSelector");
        public static final long class_copyMethodList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_copyMethodList");
        public static final long class_conformsToProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_conformsToProtocol");
        public static final long class_copyProtocolList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_copyProtocolList");
        public static final long class_getProperty = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getProperty");
        public static final long class_copyPropertyList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_copyPropertyList");
        public static final long class_getIvarLayout = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getIvarLayout");
        public static final long class_getWeakIvarLayout = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getWeakIvarLayout");
        public static final long class_addMethod = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_addMethod");
        public static final long class_replaceMethod = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_replaceMethod");
        public static final long class_addIvar = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_addIvar");
        public static final long class_addProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_addProtocol");
        public static final long class_addProperty = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_addProperty");
        public static final long class_replaceProperty = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_replaceProperty");
        public static final long class_setIvarLayout = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_setIvarLayout");
        public static final long class_setWeakIvarLayout = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_setWeakIvarLayout");
        public static final long class_createInstance = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_createInstance");
        public static final long objc_constructInstance = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_constructInstance");
        public static final long objc_destructInstance = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_destructInstance");
        public static final long objc_allocateClassPair = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_allocateClassPair");
        public static final long objc_registerClassPair = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_registerClassPair");
        public static final long objc_disposeClassPair = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_disposeClassPair");
        public static final long method_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getName");
        public static final long method_getImplementation = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getImplementation");
        public static final long method_getTypeEncoding = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getTypeEncoding");
        public static final long method_getNumberOfArguments = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getNumberOfArguments");
        public static final long method_copyReturnType = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_copyReturnType");
        public static final long method_copyArgumentType = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_copyArgumentType");
        public static final long method_getReturnType = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getReturnType");
        public static final long method_getArgumentType = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_getArgumentType");
        public static final long method_setImplementation = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_setImplementation");
        public static final long method_exchangeImplementations = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "method_exchangeImplementations");
        public static final long ivar_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "ivar_getName");
        public static final long ivar_getTypeEncoding = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "ivar_getTypeEncoding");
        public static final long ivar_getOffset = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "ivar_getOffset");
        public static final long property_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "property_getName");
        public static final long property_getAttributes = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "property_getAttributes");
        public static final long property_copyAttributeList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "property_copyAttributeList");
        public static final long property_copyAttributeValue = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "property_copyAttributeValue");
        public static final long objc_getProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getProtocol");
        public static final long objc_copyProtocolList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_copyProtocolList");
        public static final long protocol_conformsToProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_conformsToProtocol");
        public static final long protocol_isEqual = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_isEqual");
        public static final long protocol_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_getName");
        public static final long protocol_getMethodDescription = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_getMethodDescription");
        public static final long protocol_copyMethodDescriptionList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_copyMethodDescriptionList");
        public static final long protocol_getProperty = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_getProperty");
        public static final long protocol_copyPropertyList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_copyPropertyList");
        public static final long protocol_copyProtocolList = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_copyProtocolList");
        public static final long objc_allocateProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_allocateProtocol");
        public static final long objc_registerProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_registerProtocol");
        public static final long protocol_addMethodDescription = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_addMethodDescription");
        public static final long protocol_addProtocol = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_addProtocol");
        public static final long protocol_addProperty = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "protocol_addProperty");
        public static final long objc_copyImageNames = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_copyImageNames");
        public static final long class_getImageName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "class_getImageName");
        public static final long objc_copyClassNamesForImage = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_copyClassNamesForImage");
        public static final long sel_getName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "sel_getName");
        public static final long sel_getUid = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "sel_getUid");
        public static final long sel_registerName = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "sel_registerName");
        public static final long sel_isEqual = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "sel_isEqual");
        public static final long objc_enumerationMutation = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_enumerationMutation");
        public static final long objc_setEnumerationMutationHandler = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_setEnumerationMutationHandler");
        public static final long imp_implementationWithBlock = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "imp_implementationWithBlock");
        public static final long imp_getBlock = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "imp_getBlock");
        public static final long imp_removeBlock = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "imp_removeBlock");
        public static final long objc_loadWeak = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_loadWeak");
        public static final long objc_storeWeak = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_storeWeak");
        public static final long objc_setAssociatedObject = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_setAssociatedObject");
        public static final long objc_getAssociatedObject = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_getAssociatedObject");
        public static final long objc_removeAssociatedObjects = APIUtil.apiGetFunctionAddress(ObjCRuntime.access$000(), "objc_removeAssociatedObjects");

        private Functions() {
        }
    }
}

