/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.macosx.CoreFoundation;
import org.lwjgl.system.macosx.MacOSXLibrary;

public class MacOSXLibraryBundle
extends MacOSXLibrary {
    public MacOSXLibraryBundle(String string, long l2) {
        super(string, l2);
    }

    public static MacOSXLibraryBundle getWithIdentifier(String object) {
        long l2 = 0L;
        try {
            MemoryStack memoryStack = MemoryStack.stackPush();
            Throwable throwable = null;
            try {
                l2 = MacOSXLibraryBundle.CString2CFString(memoryStack.UTF8((CharSequence)object), 0x8000100);
                long l3 = CoreFoundation.CFBundleGetBundleWithIdentifier(l2);
                if (l3 == 0L) {
                    throw new UnsatisfiedLinkError("Failed to retrieve bundle with identifier: ".concat(String.valueOf(object)));
                }
                CoreFoundation.CFRetain(l3);
                object = new MacOSXLibraryBundle((String)object, l3);
                if (memoryStack != null) {
                    memoryStack.close();
                }
                return object;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (memoryStack != null) {
                        if (throwable != null) {
                            try {
                                memoryStack.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            memoryStack.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        finally {
            if (l2 != 0L) {
                CoreFoundation.CFRelease(l2);
            }
        }
    }

    public static MacOSXLibraryBundle create(String object) {
        long l2 = 0L;
        long l3 = 0L;
        try {
            MemoryStack memoryStack = MemoryStack.stackPush();
            Throwable throwable = null;
            try {
                l2 = MacOSXLibraryBundle.CString2CFString(memoryStack.UTF8((CharSequence)object), 0x8000100);
                l3 = Checks.check(CoreFoundation.CFURLCreateWithFileSystemPath(0L, l2, 0L, true));
                long l4 = CoreFoundation.CFBundleCreate(0L, l3);
                if (l4 == 0L) {
                    throw new UnsatisfiedLinkError("Failed to create bundle: ".concat(String.valueOf(object)));
                }
                object = new MacOSXLibraryBundle((String)object, l4);
                if (memoryStack != null) {
                    memoryStack.close();
                }
                return object;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (memoryStack != null) {
                        if (throwable != null) {
                            try {
                                memoryStack.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            memoryStack.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        finally {
            if (l3 != 0L) {
                CoreFoundation.CFRelease(l3);
            }
            if (l2 != 0L) {
                CoreFoundation.CFRelease(l2);
            }
        }
    }

    @Override
    public @Nullable String getPath() {
        return null;
    }

    @Override
    public long getFunctionAddress(ByteBuffer byteBuffer) {
        long l2 = MacOSXLibraryBundle.CString2CFString(byteBuffer, 1536);
        try {
            long l3 = CoreFoundation.CFBundleGetFunctionPointerForName(this.address(), l2);
            return l3;
        }
        finally {
            CoreFoundation.CFRelease(l2);
        }
    }

    private static long CString2CFString(ByteBuffer byteBuffer, int n2) {
        return Checks.check(CoreFoundation.CFStringCreateWithCStringNoCopy(0L, byteBuffer, n2, CoreFoundation.kCFAllocatorNull));
    }

    @Override
    public void free() {
        CoreFoundation.CFRelease(this.address());
    }
}

