/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CGPoint
extends Struct<CGPoint>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;

    protected CGPoint(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected CGPoint create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new CGPoint(l2, byteBuffer);
    }

    public CGPoint(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), CGPoint.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CGFloat")
    public double x() {
        return CGPoint.nx(this.address());
    }

    @NativeType(value="CGFloat")
    public double y() {
        return CGPoint.ny(this.address());
    }

    public CGPoint x(@NativeType(value="CGFloat") double d2) {
        CGPoint.nx(this.address(), d2);
        return this;
    }

    public CGPoint y(@NativeType(value="CGFloat") double d2) {
        CGPoint.ny(this.address(), d2);
        return this;
    }

    public CGPoint set(double d2, double d3) {
        this.x(d2);
        this.y(d3);
        return this;
    }

    public CGPoint set(CGPoint cGPoint) {
        MemoryUtil.memCopy(cGPoint.address(), this.address(), SIZEOF);
        return this;
    }

    public static CGPoint malloc() {
        return new CGPoint(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CGPoint calloc() {
        return new CGPoint(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CGPoint create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new CGPoint(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static CGPoint create(long l2) {
        return new CGPoint(l2, null);
    }

    public static @Nullable CGPoint createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new CGPoint(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CGPoint.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = CGPoint.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    @Deprecated
    public static CGPoint mallocStack() {
        return CGPoint.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CGPoint callocStack() {
        return CGPoint.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CGPoint mallocStack(MemoryStack memoryStack) {
        return CGPoint.malloc(memoryStack);
    }

    @Deprecated
    public static CGPoint callocStack(MemoryStack memoryStack) {
        return CGPoint.calloc(memoryStack);
    }

    @Deprecated
    public static Buffer mallocStack(int n2) {
        return CGPoint.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int n2) {
        return CGPoint.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return CGPoint.malloc(n2, memoryStack);
    }

    @Deprecated
    public static Buffer callocStack(int n2, MemoryStack memoryStack) {
        return CGPoint.calloc(n2, memoryStack);
    }

    public static CGPoint malloc(MemoryStack memoryStack) {
        return new CGPoint(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CGPoint calloc(MemoryStack memoryStack) {
        return new CGPoint(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static double nx(long l2) {
        return MemoryUtil.memGetDouble(l2 + (long)X);
    }

    public static double ny(long l2) {
        return MemoryUtil.memGetDouble(l2 + (long)Y);
    }

    public static void nx(long l2, double d2) {
        MemoryUtil.memPutDouble(l2 + (long)X, d2);
    }

    public static void ny(long l2, double d2) {
        MemoryUtil.memPutDouble(l2 + (long)Y, d2);
    }

    static {
        Struct.Layout layout = CGPoint.__struct(CGPoint.__member(8), CGPoint.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CGPoint, Buffer>
    implements NativeResource {
        private static final CGPoint ELEMENT_FACTORY = CGPoint.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected CGPoint getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CGFloat")
        public double x() {
            return CGPoint.nx(((Pointer.Default)this).address());
        }

        @NativeType(value="CGFloat")
        public double y() {
            return CGPoint.ny(((Pointer.Default)this).address());
        }

        public Buffer x(@NativeType(value="CGFloat") double d2) {
            CGPoint.nx(((Pointer.Default)this).address(), d2);
            return this;
        }

        public Buffer y(@NativeType(value="CGFloat") double d2) {
            CGPoint.ny(((Pointer.Default)this).address(), d2);
            return this;
        }
    }
}

