/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.linux.KernelTimespec;

@NativeType(value="struct io_uring_sync_cancel_reg")
public class IOURingSyncCancelReg
extends Struct<IOURingSyncCancelReg>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDR;
    public static final int FD;
    public static final int FLAGS;
    public static final int TIMEOUT;
    public static final int OPCODE;
    public static final int PAD;
    public static final int PAD2;

    protected IOURingSyncCancelReg(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingSyncCancelReg create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingSyncCancelReg(l2, byteBuffer);
    }

    public IOURingSyncCancelReg(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingSyncCancelReg.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u64")
    public long addr() {
        return IOURingSyncCancelReg.naddr(this.address());
    }

    @NativeType(value="__s32")
    public int fd() {
        return IOURingSyncCancelReg.nfd(this.address());
    }

    @NativeType(value="__u32")
    public int flags() {
        return IOURingSyncCancelReg.nflags(this.address());
    }

    @NativeType(value="struct __kernel_timespec")
    public KernelTimespec timeout() {
        return IOURingSyncCancelReg.ntimeout(this.address());
    }

    @NativeType(value="__u8")
    public byte opcode() {
        return IOURingSyncCancelReg.nopcode(this.address());
    }

    public IOURingSyncCancelReg addr(@NativeType(value="__u64") long l2) {
        IOURingSyncCancelReg.naddr(this.address(), l2);
        return this;
    }

    public IOURingSyncCancelReg fd(@NativeType(value="__s32") int n2) {
        IOURingSyncCancelReg.nfd(this.address(), n2);
        return this;
    }

    public IOURingSyncCancelReg flags(@NativeType(value="__u32") int n2) {
        IOURingSyncCancelReg.nflags(this.address(), n2);
        return this;
    }

    public IOURingSyncCancelReg timeout(@NativeType(value="struct __kernel_timespec") KernelTimespec kernelTimespec) {
        IOURingSyncCancelReg.ntimeout(this.address(), kernelTimespec);
        return this;
    }

    public IOURingSyncCancelReg timeout(Consumer<KernelTimespec> consumer) {
        consumer.accept(this.timeout());
        return this;
    }

    public IOURingSyncCancelReg opcode(@NativeType(value="__u8") byte by) {
        IOURingSyncCancelReg.nopcode(this.address(), by);
        return this;
    }

    public IOURingSyncCancelReg set(long l2, int n2, int n3, KernelTimespec kernelTimespec, byte by) {
        this.addr(l2);
        this.fd(n2);
        this.flags(n3);
        this.timeout(kernelTimespec);
        this.opcode(by);
        return this;
    }

    public IOURingSyncCancelReg set(IOURingSyncCancelReg iOURingSyncCancelReg) {
        MemoryUtil.memCopy(iOURingSyncCancelReg.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingSyncCancelReg malloc() {
        return new IOURingSyncCancelReg(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingSyncCancelReg calloc() {
        return new IOURingSyncCancelReg(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingSyncCancelReg create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingSyncCancelReg(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingSyncCancelReg create(long l2) {
        return new IOURingSyncCancelReg(l2, null);
    }

    public static @Nullable IOURingSyncCancelReg createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingSyncCancelReg(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingSyncCancelReg.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingSyncCancelReg.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingSyncCancelReg malloc(MemoryStack memoryStack) {
        return new IOURingSyncCancelReg(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingSyncCancelReg calloc(MemoryStack memoryStack) {
        return new IOURingSyncCancelReg(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long naddr(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)ADDR);
    }

    public static int nfd(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FD);
    }

    public static int nflags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FLAGS);
    }

    public static KernelTimespec ntimeout(long l2) {
        return KernelTimespec.create(l2 + (long)TIMEOUT);
    }

    public static byte nopcode(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)OPCODE);
    }

    public static ByteBuffer npad(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)PAD, 7);
    }

    public static byte npad(long l2, int n2) {
        return MemoryUtil.memGetByte(l2 + (long)PAD + Checks.check(n2, 7));
    }

    public static LongBuffer npad2(long l2) {
        return MemoryUtil.memLongBuffer(l2 + (long)PAD2, 3);
    }

    public static long npad2(long l2, int n2) {
        return MemoryUtil.memGetLong(l2 + (long)PAD2 + (Checks.check(n2, 3) << 3));
    }

    public static void naddr(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)ADDR, l3);
    }

    public static void nfd(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FD, n2);
    }

    public static void nflags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FLAGS, n2);
    }

    public static void ntimeout(long l2, KernelTimespec kernelTimespec) {
        MemoryUtil.memCopy(kernelTimespec.address(), l2 + (long)TIMEOUT, KernelTimespec.SIZEOF);
    }

    public static void nopcode(long l2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)OPCODE, by);
    }

    public static void npad(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 7);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)PAD, byteBuffer.remaining());
    }

    public static void npad(long l2, int n2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)PAD + Checks.check(n2, 7), by);
    }

    public static void npad2(long l2, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(longBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(longBuffer), l2 + (long)PAD2, longBuffer.remaining() << 3);
    }

    public static void npad2(long l2, int n2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)PAD2 + (Checks.check(n2, 3) << 3), l3);
    }

    static {
        Struct.Layout layout = IOURingSyncCancelReg.__struct(IOURingSyncCancelReg.__member(8), IOURingSyncCancelReg.__member(4), IOURingSyncCancelReg.__member(4), IOURingSyncCancelReg.__member(KernelTimespec.SIZEOF, KernelTimespec.ALIGNOF), IOURingSyncCancelReg.__member(1), IOURingSyncCancelReg.__array(1, 7), IOURingSyncCancelReg.__array(8, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ADDR = layout.offsetof(0);
        FD = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        TIMEOUT = layout.offsetof(3);
        OPCODE = layout.offsetof(4);
        PAD = layout.offsetof(5);
        PAD2 = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<IOURingSyncCancelReg, Buffer>
    implements NativeResource {
        private static final IOURingSyncCancelReg ELEMENT_FACTORY = IOURingSyncCancelReg.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingSyncCancelReg getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u64")
        public long addr() {
            return IOURingSyncCancelReg.naddr(((Pointer.Default)this).address());
        }

        @NativeType(value="__s32")
        public int fd() {
            return IOURingSyncCancelReg.nfd(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int flags() {
            return IOURingSyncCancelReg.nflags(((Pointer.Default)this).address());
        }

        @NativeType(value="struct __kernel_timespec")
        public KernelTimespec timeout() {
            return IOURingSyncCancelReg.ntimeout(((Pointer.Default)this).address());
        }

        @NativeType(value="__u8")
        public byte opcode() {
            return IOURingSyncCancelReg.nopcode(((Pointer.Default)this).address());
        }

        public Buffer addr(@NativeType(value="__u64") long l2) {
            IOURingSyncCancelReg.naddr(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer fd(@NativeType(value="__s32") int n2) {
            IOURingSyncCancelReg.nfd(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer flags(@NativeType(value="__u32") int n2) {
            IOURingSyncCancelReg.nflags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer timeout(@NativeType(value="struct __kernel_timespec") KernelTimespec kernelTimespec) {
            IOURingSyncCancelReg.ntimeout(((Pointer.Default)this).address(), kernelTimespec);
            return this;
        }

        public Buffer timeout(Consumer<KernelTimespec> consumer) {
            consumer.accept(this.timeout());
            return this;
        }

        public Buffer opcode(@NativeType(value="__u8") byte by) {
            IOURingSyncCancelReg.nopcode(((Pointer.Default)this).address(), by);
            return this;
        }
    }
}

