/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_sqe")
public class IOURingSQE
extends Struct<IOURingSQE>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OPCODE;
    public static final int FLAGS;
    public static final int IOPRIO;
    public static final int FD;
    public static final int OFF;
    public static final int ADDR2;
    public static final int CMD_OP;
    public static final int __PAD1;
    public static final int ADDR;
    public static final int SPLICE_OFF_IN;
    public static final int LEVEL;
    public static final int OPTNAME;
    public static final int LEN;
    public static final int RW_FLAGS;
    public static final int FSYNC_FLAGS;
    public static final int POLL_EVENTS;
    public static final int POLL32_EVENTS;
    public static final int SYNC_RANGE_FLAGS;
    public static final int MSG_FLAGS;
    public static final int TIMEOUT_FLAGS;
    public static final int ACCEPT_FLAGS;
    public static final int CANCEL_FLAGS;
    public static final int OPEN_FLAGS;
    public static final int STATX_FLAGS;
    public static final int FADVISE_ADVICE;
    public static final int SPLICE_FLAGS;
    public static final int RENAME_FLAGS;
    public static final int UNLINK_FLAGS;
    public static final int HARDLINK_FLAGS;
    public static final int XATTR_FLAGS;
    public static final int MSG_RING_FLAGS;
    public static final int URING_CMD_FLAGS;
    public static final int WAITID_FLAGS;
    public static final int FUTEX_FLAGS;
    public static final int INSTALL_FD_FLAGS;
    public static final int NOP_FLAGS;
    public static final int USER_DATA;
    public static final int BUF_INDEX;
    public static final int BUF_GROUP;
    public static final int PERSONALITY;
    public static final int SPLICE_FD_IN;
    public static final int FILE_INDEX;
    public static final int OPTLEN;
    public static final int ADDR_LEN;
    public static final int __PAD3;
    public static final int ADDR3;
    public static final int __PAD2;
    public static final int OPTVAL;
    public static final int CMD;

    protected IOURingSQE(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingSQE create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingSQE(l2, byteBuffer);
    }

    public IOURingSQE(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingSQE.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u8")
    public byte opcode() {
        return IOURingSQE.nopcode(this.address());
    }

    @NativeType(value="__u8")
    public byte flags() {
        return IOURingSQE.nflags(this.address());
    }

    @NativeType(value="__u16")
    public short ioprio() {
        return IOURingSQE.nioprio(this.address());
    }

    @NativeType(value="__s32")
    public int fd() {
        return IOURingSQE.nfd(this.address());
    }

    @NativeType(value="__u64")
    public long off() {
        return IOURingSQE.noff(this.address());
    }

    @NativeType(value="__u64")
    public long addr2() {
        return IOURingSQE.naddr2(this.address());
    }

    @NativeType(value="__u32")
    public int cmd_op() {
        return IOURingSQE.ncmd_op(this.address());
    }

    @NativeType(value="__u32")
    public int __pad1() {
        return IOURingSQE.n__pad1(this.address());
    }

    @NativeType(value="__u64")
    public long addr() {
        return IOURingSQE.naddr(this.address());
    }

    @NativeType(value="__u64")
    public long splice_off_in() {
        return IOURingSQE.nsplice_off_in(this.address());
    }

    @NativeType(value="__u32")
    public int level() {
        return IOURingSQE.nlevel(this.address());
    }

    @NativeType(value="__u32")
    public int optname() {
        return IOURingSQE.noptname(this.address());
    }

    @NativeType(value="__u32")
    public int len() {
        return IOURingSQE.nlen(this.address());
    }

    @NativeType(value="__kernel_rwf_t")
    public int rw_flags() {
        return IOURingSQE.nrw_flags(this.address());
    }

    @NativeType(value="__u32")
    public int fsync_flags() {
        return IOURingSQE.nfsync_flags(this.address());
    }

    @NativeType(value="__u16")
    public short poll_events() {
        return IOURingSQE.npoll_events(this.address());
    }

    @NativeType(value="__u32")
    public int poll32_events() {
        return IOURingSQE.npoll32_events(this.address());
    }

    @NativeType(value="__u32")
    public int sync_range_flags() {
        return IOURingSQE.nsync_range_flags(this.address());
    }

    @NativeType(value="__u32")
    public int msg_flags() {
        return IOURingSQE.nmsg_flags(this.address());
    }

    @NativeType(value="__u32")
    public int timeout_flags() {
        return IOURingSQE.ntimeout_flags(this.address());
    }

    @NativeType(value="__u32")
    public int accept_flags() {
        return IOURingSQE.naccept_flags(this.address());
    }

    @NativeType(value="__u32")
    public int cancel_flags() {
        return IOURingSQE.ncancel_flags(this.address());
    }

    @NativeType(value="__u32")
    public int open_flags() {
        return IOURingSQE.nopen_flags(this.address());
    }

    @NativeType(value="__u32")
    public int statx_flags() {
        return IOURingSQE.nstatx_flags(this.address());
    }

    @NativeType(value="__u32")
    public int fadvise_advice() {
        return IOURingSQE.nfadvise_advice(this.address());
    }

    @NativeType(value="__u32")
    public int splice_flags() {
        return IOURingSQE.nsplice_flags(this.address());
    }

    @NativeType(value="__u32")
    public int rename_flags() {
        return IOURingSQE.nrename_flags(this.address());
    }

    @NativeType(value="__u32")
    public int unlink_flags() {
        return IOURingSQE.nunlink_flags(this.address());
    }

    @NativeType(value="__u32")
    public int hardlink_flags() {
        return IOURingSQE.nhardlink_flags(this.address());
    }

    @NativeType(value="__u32")
    public int xattr_flags() {
        return IOURingSQE.nxattr_flags(this.address());
    }

    @NativeType(value="__u32")
    public int msg_ring_flags() {
        return IOURingSQE.nmsg_ring_flags(this.address());
    }

    @NativeType(value="__u32")
    public int uring_cmd_flags() {
        return IOURingSQE.nuring_cmd_flags(this.address());
    }

    @NativeType(value="__u32")
    public int waitid_flags() {
        return IOURingSQE.nwaitid_flags(this.address());
    }

    @NativeType(value="__u32")
    public int futex_flags() {
        return IOURingSQE.nfutex_flags(this.address());
    }

    @NativeType(value="__u32")
    public int install_fd_flags() {
        return IOURingSQE.ninstall_fd_flags(this.address());
    }

    @NativeType(value="__u32")
    public int nop_flags() {
        return IOURingSQE.nnop_flags(this.address());
    }

    @NativeType(value="__u64")
    public long user_data() {
        return IOURingSQE.nuser_data(this.address());
    }

    @NativeType(value="__u16")
    public short buf_index() {
        return IOURingSQE.nbuf_index(this.address());
    }

    @NativeType(value="__u16")
    public short buf_group() {
        return IOURingSQE.nbuf_group(this.address());
    }

    @NativeType(value="__u16")
    public short personality() {
        return IOURingSQE.npersonality(this.address());
    }

    @NativeType(value="__s32")
    public int splice_fd_in() {
        return IOURingSQE.nsplice_fd_in(this.address());
    }

    @NativeType(value="__u32")
    public int file_index() {
        return IOURingSQE.nfile_index(this.address());
    }

    @NativeType(value="__u32")
    public int optlen() {
        return IOURingSQE.noptlen(this.address());
    }

    @NativeType(value="__u16")
    public short addr_len() {
        return IOURingSQE.naddr_len(this.address());
    }

    @NativeType(value="__u16[1]")
    public ShortBuffer __pad3() {
        return IOURingSQE.n__pad3(this.address());
    }

    @NativeType(value="__u16")
    public short __pad3(int n2) {
        return IOURingSQE.n__pad3(this.address(), n2);
    }

    @NativeType(value="__u64")
    public long addr3() {
        return IOURingSQE.naddr3(this.address());
    }

    @NativeType(value="__u64[1]")
    public LongBuffer __pad2() {
        return IOURingSQE.n__pad2(this.address());
    }

    @NativeType(value="__u64")
    public long __pad2(int n2) {
        return IOURingSQE.n__pad2(this.address(), n2);
    }

    @NativeType(value="__u64")
    public long optval() {
        return IOURingSQE.noptval(this.address());
    }

    @NativeType(value="__u8[0]")
    public ByteBuffer cmd() {
        return IOURingSQE.ncmd(this.address());
    }

    @NativeType(value="__u8")
    public byte cmd(int n2) {
        return IOURingSQE.ncmd(this.address(), n2);
    }

    public IOURingSQE opcode(@NativeType(value="__u8") byte by) {
        IOURingSQE.nopcode(this.address(), by);
        return this;
    }

    public IOURingSQE flags(@NativeType(value="__u8") byte by) {
        IOURingSQE.nflags(this.address(), by);
        return this;
    }

    public IOURingSQE ioprio(@NativeType(value="__u16") short s2) {
        IOURingSQE.nioprio(this.address(), s2);
        return this;
    }

    public IOURingSQE fd(@NativeType(value="__s32") int n2) {
        IOURingSQE.nfd(this.address(), n2);
        return this;
    }

    public IOURingSQE off(@NativeType(value="__u64") long l2) {
        IOURingSQE.noff(this.address(), l2);
        return this;
    }

    public IOURingSQE addr2(@NativeType(value="__u64") long l2) {
        IOURingSQE.naddr2(this.address(), l2);
        return this;
    }

    public IOURingSQE cmd_op(@NativeType(value="__u32") int n2) {
        IOURingSQE.ncmd_op(this.address(), n2);
        return this;
    }

    public IOURingSQE __pad1(@NativeType(value="__u32") int n2) {
        IOURingSQE.n__pad1(this.address(), n2);
        return this;
    }

    public IOURingSQE addr(@NativeType(value="__u64") long l2) {
        IOURingSQE.naddr(this.address(), l2);
        return this;
    }

    public IOURingSQE splice_off_in(@NativeType(value="__u64") long l2) {
        IOURingSQE.nsplice_off_in(this.address(), l2);
        return this;
    }

    public IOURingSQE level(@NativeType(value="__u32") int n2) {
        IOURingSQE.nlevel(this.address(), n2);
        return this;
    }

    public IOURingSQE optname(@NativeType(value="__u32") int n2) {
        IOURingSQE.noptname(this.address(), n2);
        return this;
    }

    public IOURingSQE len(@NativeType(value="__u32") int n2) {
        IOURingSQE.nlen(this.address(), n2);
        return this;
    }

    public IOURingSQE rw_flags(@NativeType(value="__kernel_rwf_t") int n2) {
        IOURingSQE.nrw_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE fsync_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nfsync_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE poll_events(@NativeType(value="__u16") short s2) {
        IOURingSQE.npoll_events(this.address(), s2);
        return this;
    }

    public IOURingSQE poll32_events(@NativeType(value="__u32") int n2) {
        IOURingSQE.npoll32_events(this.address(), n2);
        return this;
    }

    public IOURingSQE sync_range_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nsync_range_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE msg_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nmsg_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE timeout_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.ntimeout_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE accept_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.naccept_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE cancel_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.ncancel_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE open_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nopen_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE statx_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nstatx_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE fadvise_advice(@NativeType(value="__u32") int n2) {
        IOURingSQE.nfadvise_advice(this.address(), n2);
        return this;
    }

    public IOURingSQE splice_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nsplice_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE rename_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nrename_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE unlink_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nunlink_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE hardlink_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nhardlink_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE xattr_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nxattr_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE msg_ring_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nmsg_ring_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE uring_cmd_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nuring_cmd_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE waitid_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nwaitid_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE futex_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nfutex_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE install_fd_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.ninstall_fd_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE nop_flags(@NativeType(value="__u32") int n2) {
        IOURingSQE.nnop_flags(this.address(), n2);
        return this;
    }

    public IOURingSQE user_data(@NativeType(value="__u64") long l2) {
        IOURingSQE.nuser_data(this.address(), l2);
        return this;
    }

    public IOURingSQE buf_index(@NativeType(value="__u16") short s2) {
        IOURingSQE.nbuf_index(this.address(), s2);
        return this;
    }

    public IOURingSQE buf_group(@NativeType(value="__u16") short s2) {
        IOURingSQE.nbuf_group(this.address(), s2);
        return this;
    }

    public IOURingSQE personality(@NativeType(value="__u16") short s2) {
        IOURingSQE.npersonality(this.address(), s2);
        return this;
    }

    public IOURingSQE splice_fd_in(@NativeType(value="__s32") int n2) {
        IOURingSQE.nsplice_fd_in(this.address(), n2);
        return this;
    }

    public IOURingSQE file_index(@NativeType(value="__u32") int n2) {
        IOURingSQE.nfile_index(this.address(), n2);
        return this;
    }

    public IOURingSQE optlen(@NativeType(value="__u32") int n2) {
        IOURingSQE.noptlen(this.address(), n2);
        return this;
    }

    public IOURingSQE addr_len(@NativeType(value="__u16") short s2) {
        IOURingSQE.naddr_len(this.address(), s2);
        return this;
    }

    public IOURingSQE __pad3(@NativeType(value="__u16[1]") ShortBuffer shortBuffer) {
        IOURingSQE.n__pad3(this.address(), shortBuffer);
        return this;
    }

    public IOURingSQE __pad3(int n2, @NativeType(value="__u16") short s2) {
        IOURingSQE.n__pad3(this.address(), n2, s2);
        return this;
    }

    public IOURingSQE addr3(@NativeType(value="__u64") long l2) {
        IOURingSQE.naddr3(this.address(), l2);
        return this;
    }

    public IOURingSQE __pad2(@NativeType(value="__u64[1]") LongBuffer longBuffer) {
        IOURingSQE.n__pad2(this.address(), longBuffer);
        return this;
    }

    public IOURingSQE __pad2(int n2, @NativeType(value="__u64") long l2) {
        IOURingSQE.n__pad2(this.address(), n2, l2);
        return this;
    }

    public IOURingSQE optval(@NativeType(value="__u64") long l2) {
        IOURingSQE.noptval(this.address(), l2);
        return this;
    }

    public IOURingSQE cmd(@NativeType(value="__u8[0]") ByteBuffer byteBuffer) {
        IOURingSQE.ncmd(this.address(), byteBuffer);
        return this;
    }

    public IOURingSQE cmd(int n2, @NativeType(value="__u8") byte by) {
        IOURingSQE.ncmd(this.address(), n2, by);
        return this;
    }

    public IOURingSQE set(IOURingSQE iOURingSQE) {
        MemoryUtil.memCopy(iOURingSQE.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingSQE malloc() {
        return new IOURingSQE(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingSQE calloc() {
        return new IOURingSQE(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingSQE create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingSQE(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingSQE create(long l2) {
        return new IOURingSQE(l2, null);
    }

    public static @Nullable IOURingSQE createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingSQE(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingSQE.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingSQE.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingSQE malloc(MemoryStack memoryStack) {
        return new IOURingSQE(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingSQE calloc(MemoryStack memoryStack) {
        return new IOURingSQE(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static byte nopcode(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)OPCODE);
    }

    public static byte nflags(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)FLAGS);
    }

    public static short nioprio(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)IOPRIO);
    }

    public static int nfd(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FD);
    }

    public static long noff(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)OFF);
    }

    public static long naddr2(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)ADDR2);
    }

    public static int ncmd_op(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)CMD_OP);
    }

    public static int n__pad1(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)__PAD1);
    }

    public static long naddr(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)ADDR);
    }

    public static long nsplice_off_in(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)SPLICE_OFF_IN);
    }

    public static int nlevel(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)LEVEL);
    }

    public static int noptname(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)OPTNAME);
    }

    public static int nlen(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)LEN);
    }

    public static int nrw_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)RW_FLAGS);
    }

    public static int nfsync_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FSYNC_FLAGS);
    }

    public static short npoll_events(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)POLL_EVENTS);
    }

    public static int npoll32_events(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)POLL32_EVENTS);
    }

    public static int nsync_range_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SYNC_RANGE_FLAGS);
    }

    public static int nmsg_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)MSG_FLAGS);
    }

    public static int ntimeout_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TIMEOUT_FLAGS);
    }

    public static int naccept_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)ACCEPT_FLAGS);
    }

    public static int ncancel_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)CANCEL_FLAGS);
    }

    public static int nopen_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)OPEN_FLAGS);
    }

    public static int nstatx_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)STATX_FLAGS);
    }

    public static int nfadvise_advice(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FADVISE_ADVICE);
    }

    public static int nsplice_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SPLICE_FLAGS);
    }

    public static int nrename_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)RENAME_FLAGS);
    }

    public static int nunlink_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)UNLINK_FLAGS);
    }

    public static int nhardlink_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)HARDLINK_FLAGS);
    }

    public static int nxattr_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)XATTR_FLAGS);
    }

    public static int nmsg_ring_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)MSG_RING_FLAGS);
    }

    public static int nuring_cmd_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)URING_CMD_FLAGS);
    }

    public static int nwaitid_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)WAITID_FLAGS);
    }

    public static int nfutex_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FUTEX_FLAGS);
    }

    public static int ninstall_fd_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)INSTALL_FD_FLAGS);
    }

    public static int nnop_flags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)NOP_FLAGS);
    }

    public static long nuser_data(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)USER_DATA);
    }

    public static short nbuf_index(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)BUF_INDEX);
    }

    public static short nbuf_group(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)BUF_GROUP);
    }

    public static short npersonality(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)PERSONALITY);
    }

    public static int nsplice_fd_in(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SPLICE_FD_IN);
    }

    public static int nfile_index(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FILE_INDEX);
    }

    public static int noptlen(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)OPTLEN);
    }

    public static short naddr_len(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)ADDR_LEN);
    }

    public static ShortBuffer n__pad3(long l2) {
        return MemoryUtil.memShortBuffer(l2 + (long)__PAD3, 1);
    }

    public static short n__pad3(long l2, int n2) {
        return MemoryUtil.memGetShort(l2 + (long)__PAD3 + (Checks.check(n2, 1) << 1));
    }

    public static long naddr3(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)ADDR3);
    }

    public static LongBuffer n__pad2(long l2) {
        return MemoryUtil.memLongBuffer(l2 + (long)__PAD2, 1);
    }

    public static long n__pad2(long l2, int n2) {
        return MemoryUtil.memGetLong(l2 + (long)__PAD2 + (Checks.check(n2, 1) << 3));
    }

    public static long noptval(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)OPTVAL);
    }

    public static ByteBuffer ncmd(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)CMD, 0);
    }

    public static byte ncmd(long l2, int n2) {
        return MemoryUtil.memGetByte(l2 + (long)CMD + Checks.check(n2, 0));
    }

    public static void nopcode(long l2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)OPCODE, by);
    }

    public static void nflags(long l2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)FLAGS, by);
    }

    public static void nioprio(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)IOPRIO, s2);
    }

    public static void nfd(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FD, n2);
    }

    public static void noff(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)OFF, l3);
    }

    public static void naddr2(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)ADDR2, l3);
    }

    public static void ncmd_op(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)CMD_OP, n2);
    }

    public static void n__pad1(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)__PAD1, n2);
    }

    public static void naddr(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)ADDR, l3);
    }

    public static void nsplice_off_in(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)SPLICE_OFF_IN, l3);
    }

    public static void nlevel(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)LEVEL, n2);
    }

    public static void noptname(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)OPTNAME, n2);
    }

    public static void nlen(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)LEN, n2);
    }

    public static void nrw_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)RW_FLAGS, n2);
    }

    public static void nfsync_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FSYNC_FLAGS, n2);
    }

    public static void npoll_events(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)POLL_EVENTS, s2);
    }

    public static void npoll32_events(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)POLL32_EVENTS, n2);
    }

    public static void nsync_range_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SYNC_RANGE_FLAGS, n2);
    }

    public static void nmsg_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)MSG_FLAGS, n2);
    }

    public static void ntimeout_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TIMEOUT_FLAGS, n2);
    }

    public static void naccept_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)ACCEPT_FLAGS, n2);
    }

    public static void ncancel_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)CANCEL_FLAGS, n2);
    }

    public static void nopen_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)OPEN_FLAGS, n2);
    }

    public static void nstatx_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)STATX_FLAGS, n2);
    }

    public static void nfadvise_advice(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FADVISE_ADVICE, n2);
    }

    public static void nsplice_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SPLICE_FLAGS, n2);
    }

    public static void nrename_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)RENAME_FLAGS, n2);
    }

    public static void nunlink_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)UNLINK_FLAGS, n2);
    }

    public static void nhardlink_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)HARDLINK_FLAGS, n2);
    }

    public static void nxattr_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)XATTR_FLAGS, n2);
    }

    public static void nmsg_ring_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)MSG_RING_FLAGS, n2);
    }

    public static void nuring_cmd_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)URING_CMD_FLAGS, n2);
    }

    public static void nwaitid_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)WAITID_FLAGS, n2);
    }

    public static void nfutex_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FUTEX_FLAGS, n2);
    }

    public static void ninstall_fd_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)INSTALL_FD_FLAGS, n2);
    }

    public static void nnop_flags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)NOP_FLAGS, n2);
    }

    public static void nuser_data(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)USER_DATA, l3);
    }

    public static void nbuf_index(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)BUF_INDEX, s2);
    }

    public static void nbuf_group(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)BUF_GROUP, s2);
    }

    public static void npersonality(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)PERSONALITY, s2);
    }

    public static void nsplice_fd_in(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SPLICE_FD_IN, n2);
    }

    public static void nfile_index(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FILE_INDEX, n2);
    }

    public static void noptlen(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)OPTLEN, n2);
    }

    public static void naddr_len(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)ADDR_LEN, s2);
    }

    public static void n__pad3(long l2, ShortBuffer shortBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(shortBuffer, 1);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(shortBuffer), l2 + (long)__PAD3, shortBuffer.remaining() << 1);
    }

    public static void n__pad3(long l2, int n2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)__PAD3 + (Checks.check(n2, 1) << 1), s2);
    }

    public static void naddr3(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)ADDR3, l3);
    }

    public static void n__pad2(long l2, LongBuffer longBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(longBuffer, 1);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(longBuffer), l2 + (long)__PAD2, longBuffer.remaining() << 3);
    }

    public static void n__pad2(long l2, int n2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)__PAD2 + (Checks.check(n2, 1) << 3), l3);
    }

    public static void noptval(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)OPTVAL, l3);
    }

    public static void ncmd(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 0);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)CMD, byteBuffer.remaining());
    }

    public static void ncmd(long l2, int n2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)CMD + Checks.check(n2, 0), by);
    }

    static {
        Struct.Layout layout = IOURingSQE.__struct(IOURingSQE.__member(1), IOURingSQE.__member(1), IOURingSQE.__member(2), IOURingSQE.__member(4), IOURingSQE.__union(IOURingSQE.__member(8), IOURingSQE.__member(8), IOURingSQE.__struct(IOURingSQE.__member(4), IOURingSQE.__member(4))), IOURingSQE.__union(IOURingSQE.__member(8), IOURingSQE.__member(8), IOURingSQE.__struct(IOURingSQE.__member(4), IOURingSQE.__member(4))), IOURingSQE.__member(4), IOURingSQE.__union(IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(2), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4)), IOURingSQE.__member(8), IOURingSQE.__union(IOURingSQE.__member(2), IOURingSQE.__member(2)), IOURingSQE.__member(2), IOURingSQE.__union(IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__member(4), IOURingSQE.__struct(IOURingSQE.__member(2), IOURingSQE.__array(2, 1))), IOURingSQE.__union(IOURingSQE.__struct(IOURingSQE.__member(8), IOURingSQE.__array(8, 1)), IOURingSQE.__member(8), IOURingSQE.__array(1, 0)));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OPCODE = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        IOPRIO = layout.offsetof(2);
        FD = layout.offsetof(3);
        OFF = layout.offsetof(5);
        ADDR2 = layout.offsetof(6);
        CMD_OP = layout.offsetof(8);
        __PAD1 = layout.offsetof(9);
        ADDR = layout.offsetof(11);
        SPLICE_OFF_IN = layout.offsetof(12);
        LEVEL = layout.offsetof(14);
        OPTNAME = layout.offsetof(15);
        LEN = layout.offsetof(16);
        RW_FLAGS = layout.offsetof(18);
        FSYNC_FLAGS = layout.offsetof(19);
        POLL_EVENTS = layout.offsetof(20);
        POLL32_EVENTS = layout.offsetof(21);
        SYNC_RANGE_FLAGS = layout.offsetof(22);
        MSG_FLAGS = layout.offsetof(23);
        TIMEOUT_FLAGS = layout.offsetof(24);
        ACCEPT_FLAGS = layout.offsetof(25);
        CANCEL_FLAGS = layout.offsetof(26);
        OPEN_FLAGS = layout.offsetof(27);
        STATX_FLAGS = layout.offsetof(28);
        FADVISE_ADVICE = layout.offsetof(29);
        SPLICE_FLAGS = layout.offsetof(30);
        RENAME_FLAGS = layout.offsetof(31);
        UNLINK_FLAGS = layout.offsetof(32);
        HARDLINK_FLAGS = layout.offsetof(33);
        XATTR_FLAGS = layout.offsetof(34);
        MSG_RING_FLAGS = layout.offsetof(35);
        URING_CMD_FLAGS = layout.offsetof(36);
        WAITID_FLAGS = layout.offsetof(37);
        FUTEX_FLAGS = layout.offsetof(38);
        INSTALL_FD_FLAGS = layout.offsetof(39);
        NOP_FLAGS = layout.offsetof(40);
        USER_DATA = layout.offsetof(41);
        BUF_INDEX = layout.offsetof(43);
        BUF_GROUP = layout.offsetof(44);
        PERSONALITY = layout.offsetof(45);
        SPLICE_FD_IN = layout.offsetof(47);
        FILE_INDEX = layout.offsetof(48);
        OPTLEN = layout.offsetof(49);
        ADDR_LEN = layout.offsetof(51);
        __PAD3 = layout.offsetof(52);
        ADDR3 = layout.offsetof(55);
        __PAD2 = layout.offsetof(56);
        OPTVAL = layout.offsetof(57);
        CMD = layout.offsetof(58);
    }

    public static class Buffer
    extends StructBuffer<IOURingSQE, Buffer>
    implements NativeResource {
        private static final IOURingSQE ELEMENT_FACTORY = IOURingSQE.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingSQE getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u8")
        public byte opcode() {
            return IOURingSQE.nopcode(((Pointer.Default)this).address());
        }

        @NativeType(value="__u8")
        public byte flags() {
            return IOURingSQE.nflags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16")
        public short ioprio() {
            return IOURingSQE.nioprio(((Pointer.Default)this).address());
        }

        @NativeType(value="__s32")
        public int fd() {
            return IOURingSQE.nfd(((Pointer.Default)this).address());
        }

        @NativeType(value="__u64")
        public long off() {
            return IOURingSQE.noff(((Pointer.Default)this).address());
        }

        @NativeType(value="__u64")
        public long addr2() {
            return IOURingSQE.naddr2(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int cmd_op() {
            return IOURingSQE.ncmd_op(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int __pad1() {
            return IOURingSQE.n__pad1(((Pointer.Default)this).address());
        }

        @NativeType(value="__u64")
        public long addr() {
            return IOURingSQE.naddr(((Pointer.Default)this).address());
        }

        @NativeType(value="__u64")
        public long splice_off_in() {
            return IOURingSQE.nsplice_off_in(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int level() {
            return IOURingSQE.nlevel(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int optname() {
            return IOURingSQE.noptname(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int len() {
            return IOURingSQE.nlen(((Pointer.Default)this).address());
        }

        @NativeType(value="__kernel_rwf_t")
        public int rw_flags() {
            return IOURingSQE.nrw_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int fsync_flags() {
            return IOURingSQE.nfsync_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16")
        public short poll_events() {
            return IOURingSQE.npoll_events(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int poll32_events() {
            return IOURingSQE.npoll32_events(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int sync_range_flags() {
            return IOURingSQE.nsync_range_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int msg_flags() {
            return IOURingSQE.nmsg_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int timeout_flags() {
            return IOURingSQE.ntimeout_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int accept_flags() {
            return IOURingSQE.naccept_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int cancel_flags() {
            return IOURingSQE.ncancel_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int open_flags() {
            return IOURingSQE.nopen_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int statx_flags() {
            return IOURingSQE.nstatx_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int fadvise_advice() {
            return IOURingSQE.nfadvise_advice(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int splice_flags() {
            return IOURingSQE.nsplice_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int rename_flags() {
            return IOURingSQE.nrename_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int unlink_flags() {
            return IOURingSQE.nunlink_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int hardlink_flags() {
            return IOURingSQE.nhardlink_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int xattr_flags() {
            return IOURingSQE.nxattr_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int msg_ring_flags() {
            return IOURingSQE.nmsg_ring_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int uring_cmd_flags() {
            return IOURingSQE.nuring_cmd_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int waitid_flags() {
            return IOURingSQE.nwaitid_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int futex_flags() {
            return IOURingSQE.nfutex_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int install_fd_flags() {
            return IOURingSQE.ninstall_fd_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int nop_flags() {
            return IOURingSQE.nnop_flags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u64")
        public long user_data() {
            return IOURingSQE.nuser_data(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16")
        public short buf_index() {
            return IOURingSQE.nbuf_index(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16")
        public short buf_group() {
            return IOURingSQE.nbuf_group(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16")
        public short personality() {
            return IOURingSQE.npersonality(((Pointer.Default)this).address());
        }

        @NativeType(value="__s32")
        public int splice_fd_in() {
            return IOURingSQE.nsplice_fd_in(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int file_index() {
            return IOURingSQE.nfile_index(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int optlen() {
            return IOURingSQE.noptlen(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16")
        public short addr_len() {
            return IOURingSQE.naddr_len(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16[1]")
        public ShortBuffer __pad3() {
            return IOURingSQE.n__pad3(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16")
        public short __pad3(int n2) {
            return IOURingSQE.n__pad3(((Pointer.Default)this).address(), n2);
        }

        @NativeType(value="__u64")
        public long addr3() {
            return IOURingSQE.naddr3(((Pointer.Default)this).address());
        }

        @NativeType(value="__u64[1]")
        public LongBuffer __pad2() {
            return IOURingSQE.n__pad2(((Pointer.Default)this).address());
        }

        @NativeType(value="__u64")
        public long __pad2(int n2) {
            return IOURingSQE.n__pad2(((Pointer.Default)this).address(), n2);
        }

        @NativeType(value="__u64")
        public long optval() {
            return IOURingSQE.noptval(((Pointer.Default)this).address());
        }

        @NativeType(value="__u8[0]")
        public ByteBuffer cmd() {
            return IOURingSQE.ncmd(((Pointer.Default)this).address());
        }

        @NativeType(value="__u8")
        public byte cmd(int n2) {
            return IOURingSQE.ncmd(((Pointer.Default)this).address(), n2);
        }

        public Buffer opcode(@NativeType(value="__u8") byte by) {
            IOURingSQE.nopcode(((Pointer.Default)this).address(), by);
            return this;
        }

        public Buffer flags(@NativeType(value="__u8") byte by) {
            IOURingSQE.nflags(((Pointer.Default)this).address(), by);
            return this;
        }

        public Buffer ioprio(@NativeType(value="__u16") short s2) {
            IOURingSQE.nioprio(((Pointer.Default)this).address(), s2);
            return this;
        }

        public Buffer fd(@NativeType(value="__s32") int n2) {
            IOURingSQE.nfd(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer off(@NativeType(value="__u64") long l2) {
            IOURingSQE.noff(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer addr2(@NativeType(value="__u64") long l2) {
            IOURingSQE.naddr2(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer cmd_op(@NativeType(value="__u32") int n2) {
            IOURingSQE.ncmd_op(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer __pad1(@NativeType(value="__u32") int n2) {
            IOURingSQE.n__pad1(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer addr(@NativeType(value="__u64") long l2) {
            IOURingSQE.naddr(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer splice_off_in(@NativeType(value="__u64") long l2) {
            IOURingSQE.nsplice_off_in(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer level(@NativeType(value="__u32") int n2) {
            IOURingSQE.nlevel(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer optname(@NativeType(value="__u32") int n2) {
            IOURingSQE.noptname(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer len(@NativeType(value="__u32") int n2) {
            IOURingSQE.nlen(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer rw_flags(@NativeType(value="__kernel_rwf_t") int n2) {
            IOURingSQE.nrw_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer fsync_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nfsync_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer poll_events(@NativeType(value="__u16") short s2) {
            IOURingSQE.npoll_events(((Pointer.Default)this).address(), s2);
            return this;
        }

        public Buffer poll32_events(@NativeType(value="__u32") int n2) {
            IOURingSQE.npoll32_events(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer sync_range_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nsync_range_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer msg_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nmsg_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer timeout_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.ntimeout_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer accept_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.naccept_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer cancel_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.ncancel_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer open_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nopen_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer statx_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nstatx_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer fadvise_advice(@NativeType(value="__u32") int n2) {
            IOURingSQE.nfadvise_advice(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer splice_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nsplice_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer rename_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nrename_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer unlink_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nunlink_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer hardlink_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nhardlink_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer xattr_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nxattr_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer msg_ring_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nmsg_ring_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer uring_cmd_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nuring_cmd_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer waitid_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nwaitid_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer futex_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nfutex_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer install_fd_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.ninstall_fd_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer nop_flags(@NativeType(value="__u32") int n2) {
            IOURingSQE.nnop_flags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer user_data(@NativeType(value="__u64") long l2) {
            IOURingSQE.nuser_data(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer buf_index(@NativeType(value="__u16") short s2) {
            IOURingSQE.nbuf_index(((Pointer.Default)this).address(), s2);
            return this;
        }

        public Buffer buf_group(@NativeType(value="__u16") short s2) {
            IOURingSQE.nbuf_group(((Pointer.Default)this).address(), s2);
            return this;
        }

        public Buffer personality(@NativeType(value="__u16") short s2) {
            IOURingSQE.npersonality(((Pointer.Default)this).address(), s2);
            return this;
        }

        public Buffer splice_fd_in(@NativeType(value="__s32") int n2) {
            IOURingSQE.nsplice_fd_in(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer file_index(@NativeType(value="__u32") int n2) {
            IOURingSQE.nfile_index(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer optlen(@NativeType(value="__u32") int n2) {
            IOURingSQE.noptlen(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer addr_len(@NativeType(value="__u16") short s2) {
            IOURingSQE.naddr_len(((Pointer.Default)this).address(), s2);
            return this;
        }

        public Buffer __pad3(@NativeType(value="__u16[1]") ShortBuffer shortBuffer) {
            IOURingSQE.n__pad3(((Pointer.Default)this).address(), shortBuffer);
            return this;
        }

        public Buffer __pad3(int n2, @NativeType(value="__u16") short s2) {
            IOURingSQE.n__pad3(((Pointer.Default)this).address(), n2, s2);
            return this;
        }

        public Buffer addr3(@NativeType(value="__u64") long l2) {
            IOURingSQE.naddr3(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer __pad2(@NativeType(value="__u64[1]") LongBuffer longBuffer) {
            IOURingSQE.n__pad2(((Pointer.Default)this).address(), longBuffer);
            return this;
        }

        public Buffer __pad2(int n2, @NativeType(value="__u64") long l2) {
            IOURingSQE.n__pad2(((Pointer.Default)this).address(), n2, l2);
            return this;
        }

        public Buffer optval(@NativeType(value="__u64") long l2) {
            IOURingSQE.noptval(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer cmd(@NativeType(value="__u8[0]") ByteBuffer byteBuffer) {
            IOURingSQE.ncmd(((Pointer.Default)this).address(), byteBuffer);
            return this;
        }

        public Buffer cmd(int n2, @NativeType(value="__u8") byte by) {
            IOURingSQE.ncmd(((Pointer.Default)this).address(), n2, by);
            return this;
        }
    }
}

