/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_recvmsg_out")
public class IOURingRecvmsgOut
extends Struct<IOURingRecvmsgOut>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAMELEN;
    public static final int CONTROLLEN;
    public static final int PAYLOADLEN;
    public static final int FLAGS;

    protected IOURingRecvmsgOut(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingRecvmsgOut create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingRecvmsgOut(l2, byteBuffer);
    }

    public IOURingRecvmsgOut(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingRecvmsgOut.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u32")
    public int namelen() {
        return IOURingRecvmsgOut.nnamelen(this.address());
    }

    @NativeType(value="__u32")
    public int controllen() {
        return IOURingRecvmsgOut.ncontrollen(this.address());
    }

    @NativeType(value="__u32")
    public int payloadlen() {
        return IOURingRecvmsgOut.npayloadlen(this.address());
    }

    @NativeType(value="__u32")
    public int flags() {
        return IOURingRecvmsgOut.nflags(this.address());
    }

    public IOURingRecvmsgOut namelen(@NativeType(value="__u32") int n2) {
        IOURingRecvmsgOut.nnamelen(this.address(), n2);
        return this;
    }

    public IOURingRecvmsgOut controllen(@NativeType(value="__u32") int n2) {
        IOURingRecvmsgOut.ncontrollen(this.address(), n2);
        return this;
    }

    public IOURingRecvmsgOut payloadlen(@NativeType(value="__u32") int n2) {
        IOURingRecvmsgOut.npayloadlen(this.address(), n2);
        return this;
    }

    public IOURingRecvmsgOut flags(@NativeType(value="__u32") int n2) {
        IOURingRecvmsgOut.nflags(this.address(), n2);
        return this;
    }

    public IOURingRecvmsgOut set(int n2, int n3, int n4, int n5) {
        this.namelen(n2);
        this.controllen(n3);
        this.payloadlen(n4);
        this.flags(n5);
        return this;
    }

    public IOURingRecvmsgOut set(IOURingRecvmsgOut iOURingRecvmsgOut) {
        MemoryUtil.memCopy(iOURingRecvmsgOut.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingRecvmsgOut malloc() {
        return new IOURingRecvmsgOut(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingRecvmsgOut calloc() {
        return new IOURingRecvmsgOut(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingRecvmsgOut create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingRecvmsgOut(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingRecvmsgOut create(long l2) {
        return new IOURingRecvmsgOut(l2, null);
    }

    public static @Nullable IOURingRecvmsgOut createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingRecvmsgOut(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingRecvmsgOut.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingRecvmsgOut.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingRecvmsgOut malloc(MemoryStack memoryStack) {
        return new IOURingRecvmsgOut(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingRecvmsgOut calloc(MemoryStack memoryStack) {
        return new IOURingRecvmsgOut(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nnamelen(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)NAMELEN);
    }

    public static int ncontrollen(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)CONTROLLEN);
    }

    public static int npayloadlen(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)PAYLOADLEN);
    }

    public static int nflags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FLAGS);
    }

    public static void nnamelen(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)NAMELEN, n2);
    }

    public static void ncontrollen(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)CONTROLLEN, n2);
    }

    public static void npayloadlen(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)PAYLOADLEN, n2);
    }

    public static void nflags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FLAGS, n2);
    }

    static {
        Struct.Layout layout = IOURingRecvmsgOut.__struct(IOURingRecvmsgOut.__member(4), IOURingRecvmsgOut.__member(4), IOURingRecvmsgOut.__member(4), IOURingRecvmsgOut.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAMELEN = layout.offsetof(0);
        CONTROLLEN = layout.offsetof(1);
        PAYLOADLEN = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<IOURingRecvmsgOut, Buffer>
    implements NativeResource {
        private static final IOURingRecvmsgOut ELEMENT_FACTORY = IOURingRecvmsgOut.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingRecvmsgOut getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u32")
        public int namelen() {
            return IOURingRecvmsgOut.nnamelen(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int controllen() {
            return IOURingRecvmsgOut.ncontrollen(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int payloadlen() {
            return IOURingRecvmsgOut.npayloadlen(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int flags() {
            return IOURingRecvmsgOut.nflags(((Pointer.Default)this).address());
        }

        public Buffer namelen(@NativeType(value="__u32") int n2) {
            IOURingRecvmsgOut.nnamelen(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer controllen(@NativeType(value="__u32") int n2) {
            IOURingRecvmsgOut.ncontrollen(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer payloadlen(@NativeType(value="__u32") int n2) {
            IOURingRecvmsgOut.npayloadlen(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer flags(@NativeType(value="__u32") int n2) {
            IOURingRecvmsgOut.nflags(((Pointer.Default)this).address(), n2);
            return this;
        }
    }
}

