/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_rsrc_register")
public class IOURingRSRCRegister
extends Struct<IOURingRSRCRegister>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NR;
    public static final int FLAGS;
    public static final int RESV2;
    public static final int DATA;
    public static final int TAGS;

    protected IOURingRSRCRegister(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingRSRCRegister create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingRSRCRegister(l2, byteBuffer);
    }

    public IOURingRSRCRegister(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingRSRCRegister.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u32")
    public int nr() {
        return IOURingRSRCRegister.nnr(this.address());
    }

    @NativeType(value="__u32")
    public int flags() {
        return IOURingRSRCRegister.nflags(this.address());
    }

    @NativeType(value="__u64")
    public long data() {
        return IOURingRSRCRegister.ndata(this.address());
    }

    @NativeType(value="__u64")
    public long tags() {
        return IOURingRSRCRegister.ntags(this.address());
    }

    public IOURingRSRCRegister nr(@NativeType(value="__u32") int n2) {
        IOURingRSRCRegister.nnr(this.address(), n2);
        return this;
    }

    public IOURingRSRCRegister flags(@NativeType(value="__u32") int n2) {
        IOURingRSRCRegister.nflags(this.address(), n2);
        return this;
    }

    public IOURingRSRCRegister data(@NativeType(value="__u64") long l2) {
        IOURingRSRCRegister.ndata(this.address(), l2);
        return this;
    }

    public IOURingRSRCRegister tags(@NativeType(value="__u64") long l2) {
        IOURingRSRCRegister.ntags(this.address(), l2);
        return this;
    }

    public IOURingRSRCRegister set(int n2, int n3, long l2, long l3) {
        this.nr(n2);
        this.flags(n3);
        this.data(l2);
        this.tags(l3);
        return this;
    }

    public IOURingRSRCRegister set(IOURingRSRCRegister iOURingRSRCRegister) {
        MemoryUtil.memCopy(iOURingRSRCRegister.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingRSRCRegister malloc() {
        return new IOURingRSRCRegister(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingRSRCRegister calloc() {
        return new IOURingRSRCRegister(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingRSRCRegister create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingRSRCRegister(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingRSRCRegister create(long l2) {
        return new IOURingRSRCRegister(l2, null);
    }

    public static @Nullable IOURingRSRCRegister createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingRSRCRegister(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingRSRCRegister.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingRSRCRegister.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingRSRCRegister malloc(MemoryStack memoryStack) {
        return new IOURingRSRCRegister(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingRSRCRegister calloc(MemoryStack memoryStack) {
        return new IOURingRSRCRegister(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nnr(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)NR);
    }

    public static int nflags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FLAGS);
    }

    public static long nresv2(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)RESV2);
    }

    public static long ndata(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)DATA);
    }

    public static long ntags(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)TAGS);
    }

    public static void nnr(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)NR, n2);
    }

    public static void nflags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FLAGS, n2);
    }

    public static void nresv2(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)RESV2, l3);
    }

    public static void ndata(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)DATA, l3);
    }

    public static void ntags(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)TAGS, l3);
    }

    static {
        Struct.Layout layout = IOURingRSRCRegister.__struct(IOURingRSRCRegister.__member(4), IOURingRSRCRegister.__member(4), IOURingRSRCRegister.__member(8), IOURingRSRCRegister.__member(8), IOURingRSRCRegister.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NR = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        RESV2 = layout.offsetof(2);
        DATA = layout.offsetof(3);
        TAGS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<IOURingRSRCRegister, Buffer>
    implements NativeResource {
        private static final IOURingRSRCRegister ELEMENT_FACTORY = IOURingRSRCRegister.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingRSRCRegister getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u32")
        public int nr() {
            return IOURingRSRCRegister.nnr(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int flags() {
            return IOURingRSRCRegister.nflags(((Pointer.Default)this).address());
        }

        @NativeType(value="__u64")
        public long data() {
            return IOURingRSRCRegister.ndata(((Pointer.Default)this).address());
        }

        @NativeType(value="__u64")
        public long tags() {
            return IOURingRSRCRegister.ntags(((Pointer.Default)this).address());
        }

        public Buffer nr(@NativeType(value="__u32") int n2) {
            IOURingRSRCRegister.nnr(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer flags(@NativeType(value="__u32") int n2) {
            IOURingRSRCRegister.nflags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer data(@NativeType(value="__u64") long l2) {
            IOURingRSRCRegister.ndata(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer tags(@NativeType(value="__u64") long l2) {
            IOURingRSRCRegister.ntags(((Pointer.Default)this).address(), l2);
            return this;
        }
    }
}

