/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_probe_op")
public class IOURingProbeOp
extends Struct<IOURingProbeOp>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OP;
    public static final int RESV;
    public static final int FLAGS;
    public static final int RESV2;

    protected IOURingProbeOp(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingProbeOp create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingProbeOp(l2, byteBuffer);
    }

    public IOURingProbeOp(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingProbeOp.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u8")
    public byte op() {
        return IOURingProbeOp.nop(this.address());
    }

    @NativeType(value="__u16")
    public short flags() {
        return IOURingProbeOp.nflags(this.address());
    }

    public IOURingProbeOp op(@NativeType(value="__u8") byte by) {
        IOURingProbeOp.nop(this.address(), by);
        return this;
    }

    public IOURingProbeOp flags(@NativeType(value="__u16") short s2) {
        IOURingProbeOp.nflags(this.address(), s2);
        return this;
    }

    public IOURingProbeOp set(byte by, short s2) {
        this.op(by);
        this.flags(s2);
        return this;
    }

    public IOURingProbeOp set(IOURingProbeOp iOURingProbeOp) {
        MemoryUtil.memCopy(iOURingProbeOp.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingProbeOp malloc() {
        return new IOURingProbeOp(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingProbeOp calloc() {
        return new IOURingProbeOp(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingProbeOp create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingProbeOp(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingProbeOp create(long l2) {
        return new IOURingProbeOp(l2, null);
    }

    public static @Nullable IOURingProbeOp createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingProbeOp(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingProbeOp.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingProbeOp.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingProbeOp malloc(MemoryStack memoryStack) {
        return new IOURingProbeOp(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingProbeOp calloc(MemoryStack memoryStack) {
        return new IOURingProbeOp(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static byte nop(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)OP);
    }

    public static byte nresv(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)RESV);
    }

    public static short nflags(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)FLAGS);
    }

    public static int nresv2(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)RESV2);
    }

    public static void nop(long l2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)OP, by);
    }

    public static void nresv(long l2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)RESV, by);
    }

    public static void nflags(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)FLAGS, s2);
    }

    public static void nresv2(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)RESV2, n2);
    }

    static {
        Struct.Layout layout = IOURingProbeOp.__struct(IOURingProbeOp.__member(1), IOURingProbeOp.__member(1), IOURingProbeOp.__member(2), IOURingProbeOp.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OP = layout.offsetof(0);
        RESV = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RESV2 = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<IOURingProbeOp, Buffer>
    implements NativeResource {
        private static final IOURingProbeOp ELEMENT_FACTORY = IOURingProbeOp.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingProbeOp getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u8")
        public byte op() {
            return IOURingProbeOp.nop(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16")
        public short flags() {
            return IOURingProbeOp.nflags(((Pointer.Default)this).address());
        }

        public Buffer op(@NativeType(value="__u8") byte by) {
            IOURingProbeOp.nop(((Pointer.Default)this).address(), by);
            return this;
        }

        public Buffer flags(@NativeType(value="__u16") short s2) {
            IOURingProbeOp.nflags(((Pointer.Default)this).address(), s2);
            return this;
        }
    }
}

