/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.linux.liburing.IOURingProbeOp;

@NativeType(value="struct io_uring_probe")
public class IOURingProbe
extends Struct<IOURingProbe>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LAST_OP;
    public static final int OPS_LEN;
    public static final int RESV;
    public static final int RESV2;
    public static final int OPS;

    protected IOURingProbe(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingProbe create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingProbe(l2, byteBuffer);
    }

    public IOURingProbe(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingProbe.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u8")
    public byte last_op() {
        return IOURingProbe.nlast_op(this.address());
    }

    @NativeType(value="__u8")
    public byte ops_len() {
        return IOURingProbe.nops_len(this.address());
    }

    @NativeType(value="struct io_uring_probe_op[0]")
    public IOURingProbeOp.Buffer ops() {
        return IOURingProbe.nops(this.address());
    }

    @NativeType(value="struct io_uring_probe_op")
    public IOURingProbeOp ops(int n2) {
        return IOURingProbe.nops(this.address(), n2);
    }

    public IOURingProbe last_op(@NativeType(value="__u8") byte by) {
        IOURingProbe.nlast_op(this.address(), by);
        return this;
    }

    public IOURingProbe ops_len(@NativeType(value="__u8") byte by) {
        IOURingProbe.nops_len(this.address(), by);
        return this;
    }

    public IOURingProbe ops(@NativeType(value="struct io_uring_probe_op[0]") IOURingProbeOp.Buffer buffer) {
        IOURingProbe.nops(this.address(), buffer);
        return this;
    }

    public IOURingProbe ops(int n2, @NativeType(value="struct io_uring_probe_op") IOURingProbeOp iOURingProbeOp) {
        IOURingProbe.nops(this.address(), n2, iOURingProbeOp);
        return this;
    }

    public IOURingProbe ops(Consumer<IOURingProbeOp.Buffer> consumer) {
        consumer.accept(this.ops());
        return this;
    }

    public IOURingProbe ops(int n2, Consumer<IOURingProbeOp> consumer) {
        consumer.accept(this.ops(n2));
        return this;
    }

    public IOURingProbe set(byte by, byte by2, IOURingProbeOp.Buffer buffer) {
        this.last_op(by);
        this.ops_len(by2);
        this.ops(buffer);
        return this;
    }

    public IOURingProbe set(IOURingProbe iOURingProbe) {
        MemoryUtil.memCopy(iOURingProbe.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingProbe malloc() {
        return new IOURingProbe(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingProbe calloc() {
        return new IOURingProbe(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingProbe create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingProbe(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingProbe create(long l2) {
        return new IOURingProbe(l2, null);
    }

    public static @Nullable IOURingProbe createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingProbe(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingProbe.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingProbe.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingProbe malloc(MemoryStack memoryStack) {
        return new IOURingProbe(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingProbe calloc(MemoryStack memoryStack) {
        return new IOURingProbe(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static byte nlast_op(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)LAST_OP);
    }

    public static byte nops_len(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)OPS_LEN);
    }

    public static short nresv(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)RESV);
    }

    public static IntBuffer nresv2(long l2) {
        return MemoryUtil.memIntBuffer(l2 + (long)RESV2, 3);
    }

    public static int nresv2(long l2, int n2) {
        return MemoryUtil.memGetInt(l2 + (long)RESV2 + (Checks.check(n2, 3) << 2));
    }

    public static IOURingProbeOp.Buffer nops(long l2) {
        return IOURingProbeOp.create(l2 + (long)OPS, 0);
    }

    public static IOURingProbeOp nops(long l2, int n2) {
        return IOURingProbeOp.create(l2 + (long)OPS + Checks.check(n2, 0) * (long)IOURingProbeOp.SIZEOF);
    }

    public static void nlast_op(long l2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)LAST_OP, by);
    }

    public static void nops_len(long l2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)OPS_LEN, by);
    }

    public static void nresv(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)RESV, s2);
    }

    public static void nresv2(long l2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(intBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(intBuffer), l2 + (long)RESV2, intBuffer.remaining() << 2);
    }

    public static void nresv2(long l2, int n2, int n3) {
        MemoryUtil.memPutInt(l2 + (long)RESV2 + (Checks.check(n2, 3) << 2), n3);
    }

    public static void nops(long l2, IOURingProbeOp.Buffer buffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(buffer, 0);
        }
        MemoryUtil.memCopy(((Pointer.Default)buffer).address(), l2 + (long)OPS, buffer.remaining() * IOURingProbeOp.SIZEOF);
    }

    public static void nops(long l2, int n2, IOURingProbeOp iOURingProbeOp) {
        MemoryUtil.memCopy(iOURingProbeOp.address(), l2 + (long)OPS + Checks.check(n2, 0) * (long)IOURingProbeOp.SIZEOF, IOURingProbeOp.SIZEOF);
    }

    static {
        Struct.Layout layout = IOURingProbe.__struct(IOURingProbe.__member(1), IOURingProbe.__member(1), IOURingProbe.__member(2), IOURingProbe.__array(4, 3), IOURingProbe.__array(IOURingProbeOp.SIZEOF, IOURingProbeOp.ALIGNOF, 0));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LAST_OP = layout.offsetof(0);
        OPS_LEN = layout.offsetof(1);
        RESV = layout.offsetof(2);
        RESV2 = layout.offsetof(3);
        OPS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<IOURingProbe, Buffer>
    implements NativeResource {
        private static final IOURingProbe ELEMENT_FACTORY = IOURingProbe.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingProbe getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u8")
        public byte last_op() {
            return IOURingProbe.nlast_op(((Pointer.Default)this).address());
        }

        @NativeType(value="__u8")
        public byte ops_len() {
            return IOURingProbe.nops_len(((Pointer.Default)this).address());
        }

        @NativeType(value="struct io_uring_probe_op[0]")
        public IOURingProbeOp.Buffer ops() {
            return IOURingProbe.nops(((Pointer.Default)this).address());
        }

        @NativeType(value="struct io_uring_probe_op")
        public IOURingProbeOp ops(int n2) {
            return IOURingProbe.nops(((Pointer.Default)this).address(), n2);
        }

        public Buffer last_op(@NativeType(value="__u8") byte by) {
            IOURingProbe.nlast_op(((Pointer.Default)this).address(), by);
            return this;
        }

        public Buffer ops_len(@NativeType(value="__u8") byte by) {
            IOURingProbe.nops_len(((Pointer.Default)this).address(), by);
            return this;
        }

        public Buffer ops(@NativeType(value="struct io_uring_probe_op[0]") IOURingProbeOp.Buffer buffer) {
            IOURingProbe.nops(((Pointer.Default)this).address(), buffer);
            return this;
        }

        public Buffer ops(int n2, @NativeType(value="struct io_uring_probe_op") IOURingProbeOp iOURingProbeOp) {
            IOURingProbe.nops(((Pointer.Default)this).address(), n2, iOURingProbeOp);
            return this;
        }

        public Buffer ops(Consumer<IOURingProbeOp.Buffer> consumer) {
            consumer.accept(this.ops());
            return this;
        }

        public Buffer ops(int n2, Consumer<IOURingProbeOp> consumer) {
            consumer.accept(this.ops(n2));
            return this;
        }
    }
}

