/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_napi")
public class IOURingNAPI
extends Struct<IOURingNAPI>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUSY_POLL_TO;
    public static final int PREFER_BUSY_POLL;
    public static final int PAD;
    public static final int RESV;

    protected IOURingNAPI(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingNAPI create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingNAPI(l2, byteBuffer);
    }

    public IOURingNAPI(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingNAPI.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u32")
    public int busy_poll_to() {
        return IOURingNAPI.nbusy_poll_to(this.address());
    }

    @NativeType(value="__u8")
    public byte prefer_busy_poll() {
        return IOURingNAPI.nprefer_busy_poll(this.address());
    }

    public IOURingNAPI busy_poll_to(@NativeType(value="__u32") int n2) {
        IOURingNAPI.nbusy_poll_to(this.address(), n2);
        return this;
    }

    public IOURingNAPI prefer_busy_poll(@NativeType(value="__u8") byte by) {
        IOURingNAPI.nprefer_busy_poll(this.address(), by);
        return this;
    }

    public IOURingNAPI set(int n2, byte by) {
        this.busy_poll_to(n2);
        this.prefer_busy_poll(by);
        return this;
    }

    public IOURingNAPI set(IOURingNAPI iOURingNAPI) {
        MemoryUtil.memCopy(iOURingNAPI.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingNAPI malloc() {
        return new IOURingNAPI(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingNAPI calloc() {
        return new IOURingNAPI(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingNAPI create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingNAPI(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingNAPI create(long l2) {
        return new IOURingNAPI(l2, null);
    }

    public static @Nullable IOURingNAPI createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingNAPI(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingNAPI.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingNAPI.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingNAPI malloc(MemoryStack memoryStack) {
        return new IOURingNAPI(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingNAPI calloc(MemoryStack memoryStack) {
        return new IOURingNAPI(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nbusy_poll_to(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)BUSY_POLL_TO);
    }

    public static byte nprefer_busy_poll(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)PREFER_BUSY_POLL);
    }

    public static ByteBuffer npad(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)PAD, 3);
    }

    public static byte npad(long l2, int n2) {
        return MemoryUtil.memGetByte(l2 + (long)PAD + Checks.check(n2, 3));
    }

    public static long nresv(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)RESV);
    }

    public static void nbusy_poll_to(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)BUSY_POLL_TO, n2);
    }

    public static void nprefer_busy_poll(long l2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)PREFER_BUSY_POLL, by);
    }

    public static void npad(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)PAD, byteBuffer.remaining());
    }

    public static void npad(long l2, int n2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)PAD + Checks.check(n2, 3), by);
    }

    public static void nresv(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)RESV, l3);
    }

    static {
        Struct.Layout layout = IOURingNAPI.__struct(IOURingNAPI.__member(4), IOURingNAPI.__member(1), IOURingNAPI.__array(1, 3), IOURingNAPI.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUSY_POLL_TO = layout.offsetof(0);
        PREFER_BUSY_POLL = layout.offsetof(1);
        PAD = layout.offsetof(2);
        RESV = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<IOURingNAPI, Buffer>
    implements NativeResource {
        private static final IOURingNAPI ELEMENT_FACTORY = IOURingNAPI.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingNAPI getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u32")
        public int busy_poll_to() {
            return IOURingNAPI.nbusy_poll_to(((Pointer.Default)this).address());
        }

        @NativeType(value="__u8")
        public byte prefer_busy_poll() {
            return IOURingNAPI.nprefer_busy_poll(((Pointer.Default)this).address());
        }

        public Buffer busy_poll_to(@NativeType(value="__u32") int n2) {
            IOURingNAPI.nbusy_poll_to(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer prefer_busy_poll(@NativeType(value="__u8") byte by) {
            IOURingNAPI.nprefer_busy_poll(((Pointer.Default)this).address(), by);
            return this;
        }
    }
}

