/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_getevents_arg")
public class IOURingGeteventsArg
extends Struct<IOURingGeteventsArg>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIGMASK;
    public static final int SIGMASK_SZ;
    public static final int MIN_WAIT_USEC;
    public static final int TS;

    protected IOURingGeteventsArg(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingGeteventsArg create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingGeteventsArg(l2, byteBuffer);
    }

    public IOURingGeteventsArg(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingGeteventsArg.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u64")
    public long sigmask() {
        return IOURingGeteventsArg.nsigmask(this.address());
    }

    @NativeType(value="__u32")
    public int sigmask_sz() {
        return IOURingGeteventsArg.nsigmask_sz(this.address());
    }

    @NativeType(value="__u32")
    public int min_wait_usec() {
        return IOURingGeteventsArg.nmin_wait_usec(this.address());
    }

    @NativeType(value="__u64")
    public long ts() {
        return IOURingGeteventsArg.nts(this.address());
    }

    public IOURingGeteventsArg sigmask(@NativeType(value="__u64") long l2) {
        IOURingGeteventsArg.nsigmask(this.address(), l2);
        return this;
    }

    public IOURingGeteventsArg sigmask_sz(@NativeType(value="__u32") int n2) {
        IOURingGeteventsArg.nsigmask_sz(this.address(), n2);
        return this;
    }

    public IOURingGeteventsArg min_wait_usec(@NativeType(value="__u32") int n2) {
        IOURingGeteventsArg.nmin_wait_usec(this.address(), n2);
        return this;
    }

    public IOURingGeteventsArg ts(@NativeType(value="__u64") long l2) {
        IOURingGeteventsArg.nts(this.address(), l2);
        return this;
    }

    public IOURingGeteventsArg set(long l2, int n2, int n3, long l3) {
        this.sigmask(l2);
        this.sigmask_sz(n2);
        this.min_wait_usec(n3);
        this.ts(l3);
        return this;
    }

    public IOURingGeteventsArg set(IOURingGeteventsArg iOURingGeteventsArg) {
        MemoryUtil.memCopy(iOURingGeteventsArg.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingGeteventsArg malloc() {
        return new IOURingGeteventsArg(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingGeteventsArg calloc() {
        return new IOURingGeteventsArg(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingGeteventsArg create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingGeteventsArg(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingGeteventsArg create(long l2) {
        return new IOURingGeteventsArg(l2, null);
    }

    public static @Nullable IOURingGeteventsArg createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingGeteventsArg(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingGeteventsArg.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingGeteventsArg.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingGeteventsArg malloc(MemoryStack memoryStack) {
        return new IOURingGeteventsArg(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingGeteventsArg calloc(MemoryStack memoryStack) {
        return new IOURingGeteventsArg(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long nsigmask(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)SIGMASK);
    }

    public static int nsigmask_sz(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SIGMASK_SZ);
    }

    public static int nmin_wait_usec(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)MIN_WAIT_USEC);
    }

    public static long nts(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)TS);
    }

    public static void nsigmask(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)SIGMASK, l3);
    }

    public static void nsigmask_sz(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SIGMASK_SZ, n2);
    }

    public static void nmin_wait_usec(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)MIN_WAIT_USEC, n2);
    }

    public static void nts(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)TS, l3);
    }

    static {
        Struct.Layout layout = IOURingGeteventsArg.__struct(IOURingGeteventsArg.__member(8), IOURingGeteventsArg.__member(4), IOURingGeteventsArg.__member(4), IOURingGeteventsArg.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIGMASK = layout.offsetof(0);
        SIGMASK_SZ = layout.offsetof(1);
        MIN_WAIT_USEC = layout.offsetof(2);
        TS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<IOURingGeteventsArg, Buffer>
    implements NativeResource {
        private static final IOURingGeteventsArg ELEMENT_FACTORY = IOURingGeteventsArg.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingGeteventsArg getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u64")
        public long sigmask() {
            return IOURingGeteventsArg.nsigmask(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int sigmask_sz() {
            return IOURingGeteventsArg.nsigmask_sz(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int min_wait_usec() {
            return IOURingGeteventsArg.nmin_wait_usec(((Pointer.Default)this).address());
        }

        @NativeType(value="__u64")
        public long ts() {
            return IOURingGeteventsArg.nts(((Pointer.Default)this).address());
        }

        public Buffer sigmask(@NativeType(value="__u64") long l2) {
            IOURingGeteventsArg.nsigmask(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer sigmask_sz(@NativeType(value="__u32") int n2) {
            IOURingGeteventsArg.nsigmask_sz(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer min_wait_usec(@NativeType(value="__u32") int n2) {
            IOURingGeteventsArg.nmin_wait_usec(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer ts(@NativeType(value="__u64") long l2) {
            IOURingGeteventsArg.nts(((Pointer.Default)this).address(), l2);
            return this;
        }
    }
}

