/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_clone_buffers")
public class IOURingCloneBuffers
extends Struct<IOURingCloneBuffers>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SRC_FD;
    public static final int FLAGS;
    public static final int PAD;

    protected IOURingCloneBuffers(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingCloneBuffers create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingCloneBuffers(l2, byteBuffer);
    }

    public IOURingCloneBuffers(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingCloneBuffers.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u32")
    public int src_fd() {
        return IOURingCloneBuffers.nsrc_fd(this.address());
    }

    @NativeType(value="__u32")
    public int flags() {
        return IOURingCloneBuffers.nflags(this.address());
    }

    public IOURingCloneBuffers src_fd(@NativeType(value="__u32") int n2) {
        IOURingCloneBuffers.nsrc_fd(this.address(), n2);
        return this;
    }

    public IOURingCloneBuffers flags(@NativeType(value="__u32") int n2) {
        IOURingCloneBuffers.nflags(this.address(), n2);
        return this;
    }

    public IOURingCloneBuffers set(int n2, int n3) {
        this.src_fd(n2);
        this.flags(n3);
        return this;
    }

    public IOURingCloneBuffers set(IOURingCloneBuffers iOURingCloneBuffers) {
        MemoryUtil.memCopy(iOURingCloneBuffers.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingCloneBuffers malloc() {
        return new IOURingCloneBuffers(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingCloneBuffers calloc() {
        return new IOURingCloneBuffers(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingCloneBuffers create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingCloneBuffers(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingCloneBuffers create(long l2) {
        return new IOURingCloneBuffers(l2, null);
    }

    public static @Nullable IOURingCloneBuffers createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingCloneBuffers(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingCloneBuffers.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingCloneBuffers.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingCloneBuffers malloc(MemoryStack memoryStack) {
        return new IOURingCloneBuffers(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingCloneBuffers calloc(MemoryStack memoryStack) {
        return new IOURingCloneBuffers(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nsrc_fd(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SRC_FD);
    }

    public static int nflags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FLAGS);
    }

    public static IntBuffer npad(long l2) {
        return MemoryUtil.memIntBuffer(l2 + (long)PAD, 6);
    }

    public static int npad(long l2, int n2) {
        return MemoryUtil.memGetInt(l2 + (long)PAD + (Checks.check(n2, 6) << 2));
    }

    public static void nsrc_fd(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SRC_FD, n2);
    }

    public static void nflags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FLAGS, n2);
    }

    public static void npad(long l2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(intBuffer, 6);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(intBuffer), l2 + (long)PAD, intBuffer.remaining() << 2);
    }

    public static void npad(long l2, int n2, int n3) {
        MemoryUtil.memPutInt(l2 + (long)PAD + (Checks.check(n2, 6) << 2), n3);
    }

    static {
        Struct.Layout layout = IOURingCloneBuffers.__struct(IOURingCloneBuffers.__member(4), IOURingCloneBuffers.__member(4), IOURingCloneBuffers.__array(4, 6));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SRC_FD = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
        PAD = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<IOURingCloneBuffers, Buffer>
    implements NativeResource {
        private static final IOURingCloneBuffers ELEMENT_FACTORY = IOURingCloneBuffers.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingCloneBuffers getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u32")
        public int src_fd() {
            return IOURingCloneBuffers.nsrc_fd(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int flags() {
            return IOURingCloneBuffers.nflags(((Pointer.Default)this).address());
        }

        public Buffer src_fd(@NativeType(value="__u32") int n2) {
            IOURingCloneBuffers.nsrc_fd(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer flags(@NativeType(value="__u32") int n2) {
            IOURingCloneBuffers.nflags(((Pointer.Default)this).address(), n2);
            return this;
        }
    }
}

