/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_clock_register")
public class IOURingClockRegister
extends Struct<IOURingClockRegister>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CLOCKID;
    public static final int __RESV;

    protected IOURingClockRegister(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingClockRegister create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingClockRegister(l2, byteBuffer);
    }

    public IOURingClockRegister(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingClockRegister.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u32")
    public int clockid() {
        return IOURingClockRegister.nclockid(this.address());
    }

    public IOURingClockRegister clockid(@NativeType(value="__u32") int n2) {
        IOURingClockRegister.nclockid(this.address(), n2);
        return this;
    }

    public IOURingClockRegister set(IOURingClockRegister iOURingClockRegister) {
        MemoryUtil.memCopy(iOURingClockRegister.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingClockRegister malloc() {
        return new IOURingClockRegister(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingClockRegister calloc() {
        return new IOURingClockRegister(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingClockRegister create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingClockRegister(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingClockRegister create(long l2) {
        return new IOURingClockRegister(l2, null);
    }

    public static @Nullable IOURingClockRegister createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingClockRegister(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingClockRegister.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingClockRegister.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingClockRegister malloc(MemoryStack memoryStack) {
        return new IOURingClockRegister(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingClockRegister calloc(MemoryStack memoryStack) {
        return new IOURingClockRegister(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nclockid(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)CLOCKID);
    }

    public static IntBuffer n__resv(long l2) {
        return MemoryUtil.memIntBuffer(l2 + (long)__RESV, 3);
    }

    public static int n__resv(long l2, int n2) {
        return MemoryUtil.memGetInt(l2 + (long)__RESV + (Checks.check(n2, 3) << 2));
    }

    public static void nclockid(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)CLOCKID, n2);
    }

    public static void n__resv(long l2, IntBuffer intBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(intBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(intBuffer), l2 + (long)__RESV, intBuffer.remaining() << 2);
    }

    public static void n__resv(long l2, int n2, int n3) {
        MemoryUtil.memPutInt(l2 + (long)__RESV + (Checks.check(n2, 3) << 2), n3);
    }

    static {
        Struct.Layout layout = IOURingClockRegister.__struct(IOURingClockRegister.__member(4), IOURingClockRegister.__array(4, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CLOCKID = layout.offsetof(0);
        __RESV = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<IOURingClockRegister, Buffer>
    implements NativeResource {
        private static final IOURingClockRegister ELEMENT_FACTORY = IOURingClockRegister.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingClockRegister getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u32")
        public int clockid() {
            return IOURingClockRegister.nclockid(((Pointer.Default)this).address());
        }

        public Buffer clockid(@NativeType(value="__u32") int n2) {
            IOURingClockRegister.nclockid(((Pointer.Default)this).address(), n2);
            return this;
        }
    }
}

