/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.linux.liburing.IOURingBuf;

@NativeType(value="struct io_uring_buf_ring")
public class IOURingBufRing
extends Struct<IOURingBufRing>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESV1;
    public static final int RESV2;
    public static final int RESV3;
    public static final int TAIL;
    public static final int BUFS;

    protected IOURingBufRing(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingBufRing create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingBufRing(l2, byteBuffer);
    }

    public IOURingBufRing(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingBufRing.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u64")
    public long resv1() {
        return IOURingBufRing.nresv1(this.address());
    }

    @NativeType(value="__u32")
    public int resv2() {
        return IOURingBufRing.nresv2(this.address());
    }

    @NativeType(value="__u16")
    public short resv3() {
        return IOURingBufRing.nresv3(this.address());
    }

    @NativeType(value="__u16")
    public short tail() {
        return IOURingBufRing.ntail(this.address());
    }

    @NativeType(value="struct io_uring_buf[0]")
    public IOURingBuf.Buffer bufs() {
        return IOURingBufRing.nbufs(this.address());
    }

    @NativeType(value="struct io_uring_buf")
    public IOURingBuf bufs(int n2) {
        return IOURingBufRing.nbufs(this.address(), n2);
    }

    public IOURingBufRing resv1(@NativeType(value="__u64") long l2) {
        IOURingBufRing.nresv1(this.address(), l2);
        return this;
    }

    public IOURingBufRing resv2(@NativeType(value="__u32") int n2) {
        IOURingBufRing.nresv2(this.address(), n2);
        return this;
    }

    public IOURingBufRing resv3(@NativeType(value="__u16") short s2) {
        IOURingBufRing.nresv3(this.address(), s2);
        return this;
    }

    public IOURingBufRing tail(@NativeType(value="__u16") short s2) {
        IOURingBufRing.ntail(this.address(), s2);
        return this;
    }

    public IOURingBufRing bufs(@NativeType(value="struct io_uring_buf[0]") IOURingBuf.Buffer buffer) {
        IOURingBufRing.nbufs(this.address(), buffer);
        return this;
    }

    public IOURingBufRing bufs(int n2, @NativeType(value="struct io_uring_buf") IOURingBuf iOURingBuf) {
        IOURingBufRing.nbufs(this.address(), n2, iOURingBuf);
        return this;
    }

    public IOURingBufRing bufs(Consumer<IOURingBuf.Buffer> consumer) {
        consumer.accept(this.bufs());
        return this;
    }

    public IOURingBufRing bufs(int n2, Consumer<IOURingBuf> consumer) {
        consumer.accept(this.bufs(n2));
        return this;
    }

    public IOURingBufRing set(IOURingBufRing iOURingBufRing) {
        MemoryUtil.memCopy(iOURingBufRing.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingBufRing malloc() {
        return new IOURingBufRing(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingBufRing calloc() {
        return new IOURingBufRing(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingBufRing create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingBufRing(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingBufRing create(long l2) {
        return new IOURingBufRing(l2, null);
    }

    public static @Nullable IOURingBufRing createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingBufRing(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingBufRing.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingBufRing.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingBufRing malloc(MemoryStack memoryStack) {
        return new IOURingBufRing(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingBufRing calloc(MemoryStack memoryStack) {
        return new IOURingBufRing(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long nresv1(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)RESV1);
    }

    public static int nresv2(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)RESV2);
    }

    public static short nresv3(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)RESV3);
    }

    public static short ntail(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)TAIL);
    }

    public static IOURingBuf.Buffer nbufs(long l2) {
        return IOURingBuf.create(l2 + (long)BUFS, 0);
    }

    public static IOURingBuf nbufs(long l2, int n2) {
        return IOURingBuf.create(l2 + (long)BUFS + Checks.check(n2, 0) * (long)IOURingBuf.SIZEOF);
    }

    public static void nresv1(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)RESV1, l3);
    }

    public static void nresv2(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)RESV2, n2);
    }

    public static void nresv3(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)RESV3, s2);
    }

    public static void ntail(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)TAIL, s2);
    }

    public static void nbufs(long l2, IOURingBuf.Buffer buffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(buffer, 0);
        }
        MemoryUtil.memCopy(((Pointer.Default)buffer).address(), l2 + (long)BUFS, buffer.remaining() * IOURingBuf.SIZEOF);
    }

    public static void nbufs(long l2, int n2, IOURingBuf iOURingBuf) {
        MemoryUtil.memCopy(iOURingBuf.address(), l2 + (long)BUFS + Checks.check(n2, 0) * (long)IOURingBuf.SIZEOF, IOURingBuf.SIZEOF);
    }

    static {
        Struct.Layout layout = IOURingBufRing.__struct(IOURingBufRing.__union(IOURingBufRing.__struct(IOURingBufRing.__member(8), IOURingBufRing.__member(4), IOURingBufRing.__member(2), IOURingBufRing.__member(2)), IOURingBufRing.__array(IOURingBuf.SIZEOF, IOURingBuf.ALIGNOF, 0)));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESV1 = layout.offsetof(2);
        RESV2 = layout.offsetof(3);
        RESV3 = layout.offsetof(4);
        TAIL = layout.offsetof(5);
        BUFS = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<IOURingBufRing, Buffer>
    implements NativeResource {
        private static final IOURingBufRing ELEMENT_FACTORY = IOURingBufRing.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingBufRing getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u64")
        public long resv1() {
            return IOURingBufRing.nresv1(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int resv2() {
            return IOURingBufRing.nresv2(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16")
        public short resv3() {
            return IOURingBufRing.nresv3(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16")
        public short tail() {
            return IOURingBufRing.ntail(((Pointer.Default)this).address());
        }

        @NativeType(value="struct io_uring_buf[0]")
        public IOURingBuf.Buffer bufs() {
            return IOURingBufRing.nbufs(((Pointer.Default)this).address());
        }

        @NativeType(value="struct io_uring_buf")
        public IOURingBuf bufs(int n2) {
            return IOURingBufRing.nbufs(((Pointer.Default)this).address(), n2);
        }

        public Buffer resv1(@NativeType(value="__u64") long l2) {
            IOURingBufRing.nresv1(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer resv2(@NativeType(value="__u32") int n2) {
            IOURingBufRing.nresv2(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer resv3(@NativeType(value="__u16") short s2) {
            IOURingBufRing.nresv3(((Pointer.Default)this).address(), s2);
            return this;
        }

        public Buffer tail(@NativeType(value="__u16") short s2) {
            IOURingBufRing.ntail(((Pointer.Default)this).address(), s2);
            return this;
        }

        public Buffer bufs(@NativeType(value="struct io_uring_buf[0]") IOURingBuf.Buffer buffer) {
            IOURingBufRing.nbufs(((Pointer.Default)this).address(), buffer);
            return this;
        }

        public Buffer bufs(int n2, @NativeType(value="struct io_uring_buf") IOURingBuf iOURingBuf) {
            IOURingBufRing.nbufs(((Pointer.Default)this).address(), n2, iOURingBuf);
            return this;
        }

        public Buffer bufs(Consumer<IOURingBuf.Buffer> consumer) {
            consumer.accept(this.bufs());
            return this;
        }

        public Buffer bufs(int n2, Consumer<IOURingBuf> consumer) {
            consumer.accept(this.bufs(n2));
            return this;
        }
    }
}

