/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct io_uring_buf")
public class IOURingBuf
extends Struct<IOURingBuf>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDR;
    public static final int LEN;
    public static final int BID;
    public static final int RESV;

    protected IOURingBuf(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURingBuf create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURingBuf(l2, byteBuffer);
    }

    public IOURingBuf(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURingBuf.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__u64")
    public long addr() {
        return IOURingBuf.naddr(this.address());
    }

    @NativeType(value="__u32")
    public int len() {
        return IOURingBuf.nlen(this.address());
    }

    @NativeType(value="__u16")
    public short bid() {
        return IOURingBuf.nbid(this.address());
    }

    public IOURingBuf addr(@NativeType(value="__u64") long l2) {
        IOURingBuf.naddr(this.address(), l2);
        return this;
    }

    public IOURingBuf len(@NativeType(value="__u32") int n2) {
        IOURingBuf.nlen(this.address(), n2);
        return this;
    }

    public IOURingBuf bid(@NativeType(value="__u16") short s2) {
        IOURingBuf.nbid(this.address(), s2);
        return this;
    }

    public IOURingBuf set(long l2, int n2, short s2) {
        this.addr(l2);
        this.len(n2);
        this.bid(s2);
        return this;
    }

    public IOURingBuf set(IOURingBuf iOURingBuf) {
        MemoryUtil.memCopy(iOURingBuf.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURingBuf malloc() {
        return new IOURingBuf(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURingBuf calloc() {
        return new IOURingBuf(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURingBuf create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURingBuf(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURingBuf create(long l2) {
        return new IOURingBuf(l2, null);
    }

    public static @Nullable IOURingBuf createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURingBuf(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURingBuf.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURingBuf.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURingBuf malloc(MemoryStack memoryStack) {
        return new IOURingBuf(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURingBuf calloc(MemoryStack memoryStack) {
        return new IOURingBuf(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long naddr(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)ADDR);
    }

    public static int nlen(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)LEN);
    }

    public static short nbid(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)BID);
    }

    public static short nresv(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)RESV);
    }

    public static void naddr(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)ADDR, l3);
    }

    public static void nlen(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)LEN, n2);
    }

    public static void nbid(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)BID, s2);
    }

    public static void nresv(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)RESV, s2);
    }

    static {
        Struct.Layout layout = IOURingBuf.__struct(IOURingBuf.__member(8), IOURingBuf.__member(4), IOURingBuf.__member(2), IOURingBuf.__member(2));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ADDR = layout.offsetof(0);
        LEN = layout.offsetof(1);
        BID = layout.offsetof(2);
        RESV = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<IOURingBuf, Buffer>
    implements NativeResource {
        private static final IOURingBuf ELEMENT_FACTORY = IOURingBuf.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURingBuf getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__u64")
        public long addr() {
            return IOURingBuf.naddr(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int len() {
            return IOURingBuf.nlen(((Pointer.Default)this).address());
        }

        @NativeType(value="__u16")
        public short bid() {
            return IOURingBuf.nbid(((Pointer.Default)this).address());
        }

        public Buffer addr(@NativeType(value="__u64") long l2) {
            IOURingBuf.naddr(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer len(@NativeType(value="__u32") int n2) {
            IOURingBuf.nlen(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer bid(@NativeType(value="__u16") short s2) {
            IOURingBuf.nbid(((Pointer.Default)this).address(), s2);
            return this;
        }
    }
}

