/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux.liburing;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.linux.liburing.IOURingCQ;
import org.lwjgl.system.linux.liburing.IOURingSQ;

@NativeType(value="struct io_uring")
public class IOURing
extends Struct<IOURing>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SQ;
    public static final int CQ;
    public static final int FLAGS;
    public static final int RING_FD;
    public static final int FEATURES;
    public static final int ENTER_RING_FD;
    public static final int INT_FLAGS;
    public static final int PAD;
    public static final int PAD2;

    protected IOURing(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOURing create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOURing(l2, byteBuffer);
    }

    public IOURing(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOURing.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct io_uring_sq")
    public IOURingSQ sq() {
        return IOURing.nsq(this.address());
    }

    @NativeType(value="struct io_uring_cq")
    public IOURingCQ cq() {
        return IOURing.ncq(this.address());
    }

    @NativeType(value="unsigned int")
    public int flags() {
        return IOURing.nflags(this.address());
    }

    public int ring_fd() {
        return IOURing.nring_fd(this.address());
    }

    @NativeType(value="unsigned int")
    public int features() {
        return IOURing.nfeatures(this.address());
    }

    public int enter_ring_fd() {
        return IOURing.nenter_ring_fd(this.address());
    }

    @NativeType(value="__u8")
    public byte int_flags() {
        return IOURing.nint_flags(this.address());
    }

    public IOURing sq(@NativeType(value="struct io_uring_sq") IOURingSQ iOURingSQ) {
        IOURing.nsq(this.address(), iOURingSQ);
        return this;
    }

    public IOURing sq(Consumer<IOURingSQ> consumer) {
        consumer.accept(this.sq());
        return this;
    }

    public IOURing cq(@NativeType(value="struct io_uring_cq") IOURingCQ iOURingCQ) {
        IOURing.ncq(this.address(), iOURingCQ);
        return this;
    }

    public IOURing cq(Consumer<IOURingCQ> consumer) {
        consumer.accept(this.cq());
        return this;
    }

    public IOURing flags(@NativeType(value="unsigned int") int n2) {
        IOURing.nflags(this.address(), n2);
        return this;
    }

    public IOURing ring_fd(int n2) {
        IOURing.nring_fd(this.address(), n2);
        return this;
    }

    public IOURing features(@NativeType(value="unsigned int") int n2) {
        IOURing.nfeatures(this.address(), n2);
        return this;
    }

    public IOURing enter_ring_fd(int n2) {
        IOURing.nenter_ring_fd(this.address(), n2);
        return this;
    }

    public IOURing int_flags(@NativeType(value="__u8") byte by) {
        IOURing.nint_flags(this.address(), by);
        return this;
    }

    public IOURing set(IOURingSQ iOURingSQ, IOURingCQ iOURingCQ, int n2, int n3, int n4, int n5, byte by) {
        this.sq(iOURingSQ);
        this.cq(iOURingCQ);
        this.flags(n2);
        this.ring_fd(n3);
        this.features(n4);
        this.enter_ring_fd(n5);
        this.int_flags(by);
        return this;
    }

    public IOURing set(IOURing iOURing) {
        MemoryUtil.memCopy(iOURing.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOURing malloc() {
        return new IOURing(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOURing calloc() {
        return new IOURing(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOURing create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOURing(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOURing create(long l2) {
        return new IOURing(l2, null);
    }

    public static @Nullable IOURing createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOURing(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOURing.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOURing.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOURing malloc(MemoryStack memoryStack) {
        return new IOURing(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOURing calloc(MemoryStack memoryStack) {
        return new IOURing(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static IOURingSQ nsq(long l2) {
        return IOURingSQ.create(l2 + (long)SQ);
    }

    public static IOURingCQ ncq(long l2) {
        return IOURingCQ.create(l2 + (long)CQ);
    }

    public static int nflags(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FLAGS);
    }

    public static int nring_fd(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)RING_FD);
    }

    public static int nfeatures(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)FEATURES);
    }

    public static int nenter_ring_fd(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)ENTER_RING_FD);
    }

    public static byte nint_flags(long l2) {
        return MemoryUtil.memGetByte(l2 + (long)INT_FLAGS);
    }

    public static ByteBuffer npad(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)PAD, 3);
    }

    public static byte npad(long l2, int n2) {
        return MemoryUtil.memGetByte(l2 + (long)PAD + Checks.check(n2, 3));
    }

    public static int npad2(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)PAD2);
    }

    public static void nsq(long l2, IOURingSQ iOURingSQ) {
        MemoryUtil.memCopy(iOURingSQ.address(), l2 + (long)SQ, IOURingSQ.SIZEOF);
    }

    public static void ncq(long l2, IOURingCQ iOURingCQ) {
        MemoryUtil.memCopy(iOURingCQ.address(), l2 + (long)CQ, IOURingCQ.SIZEOF);
    }

    public static void nflags(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FLAGS, n2);
    }

    public static void nring_fd(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)RING_FD, n2);
    }

    public static void nfeatures(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)FEATURES, n2);
    }

    public static void nenter_ring_fd(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)ENTER_RING_FD, n2);
    }

    public static void nint_flags(long l2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)INT_FLAGS, by);
    }

    public static void npad(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)PAD, byteBuffer.remaining());
    }

    public static void npad(long l2, int n2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)PAD + Checks.check(n2, 3), by);
    }

    public static void npad2(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)PAD2, n2);
    }

    public static void validate(long l2) {
        IOURingSQ.validate(l2 + (long)SQ);
        IOURingCQ.validate(l2 + (long)CQ);
    }

    static {
        Struct.Layout layout = IOURing.__struct(IOURing.__member(IOURingSQ.SIZEOF, IOURingSQ.ALIGNOF), IOURing.__member(IOURingCQ.SIZEOF, IOURingCQ.ALIGNOF), IOURing.__member(4), IOURing.__member(4), IOURing.__member(4), IOURing.__member(4), IOURing.__member(1), IOURing.__array(1, 3), IOURing.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SQ = layout.offsetof(0);
        CQ = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RING_FD = layout.offsetof(3);
        FEATURES = layout.offsetof(4);
        ENTER_RING_FD = layout.offsetof(5);
        INT_FLAGS = layout.offsetof(6);
        PAD = layout.offsetof(7);
        PAD2 = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<IOURing, Buffer>
    implements NativeResource {
        private static final IOURing ELEMENT_FACTORY = IOURing.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOURing getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct io_uring_sq")
        public IOURingSQ sq() {
            return IOURing.nsq(((Pointer.Default)this).address());
        }

        @NativeType(value="struct io_uring_cq")
        public IOURingCQ cq() {
            return IOURing.ncq(((Pointer.Default)this).address());
        }

        @NativeType(value="unsigned int")
        public int flags() {
            return IOURing.nflags(((Pointer.Default)this).address());
        }

        public int ring_fd() {
            return IOURing.nring_fd(((Pointer.Default)this).address());
        }

        @NativeType(value="unsigned int")
        public int features() {
            return IOURing.nfeatures(((Pointer.Default)this).address());
        }

        public int enter_ring_fd() {
            return IOURing.nenter_ring_fd(((Pointer.Default)this).address());
        }

        @NativeType(value="__u8")
        public byte int_flags() {
            return IOURing.nint_flags(((Pointer.Default)this).address());
        }

        public Buffer sq(@NativeType(value="struct io_uring_sq") IOURingSQ iOURingSQ) {
            IOURing.nsq(((Pointer.Default)this).address(), iOURingSQ);
            return this;
        }

        public Buffer sq(Consumer<IOURingSQ> consumer) {
            consumer.accept(this.sq());
            return this;
        }

        public Buffer cq(@NativeType(value="struct io_uring_cq") IOURingCQ iOURingCQ) {
            IOURing.ncq(((Pointer.Default)this).address(), iOURingCQ);
            return this;
        }

        public Buffer cq(Consumer<IOURingCQ> consumer) {
            consumer.accept(this.cq());
            return this;
        }

        public Buffer flags(@NativeType(value="unsigned int") int n2) {
            IOURing.nflags(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer ring_fd(int n2) {
            IOURing.nring_fd(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer features(@NativeType(value="unsigned int") int n2) {
            IOURing.nfeatures(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer enter_ring_fd(int n2) {
            IOURing.nenter_ring_fd(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer int_flags(@NativeType(value="__u8") byte by) {
            IOURing.nint_flags(((Pointer.Default)this).address(), by);
            return this;
        }
    }
}

