/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XDestroyWindowEvent
extends Struct<XDestroyWindowEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int EVENT;
    public static final int WINDOW;

    protected XDestroyWindowEvent(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected XDestroyWindowEvent create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new XDestroyWindowEvent(l2, byteBuffer);
    }

    public XDestroyWindowEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), XDestroyWindowEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int type() {
        return XDestroyWindowEvent.ntype(this.address());
    }

    @NativeType(value="unsigned long")
    public long serial() {
        return XDestroyWindowEvent.nserial(this.address());
    }

    @NativeType(value="Bool")
    public boolean send_event() {
        return XDestroyWindowEvent.nsend_event(this.address()) != 0;
    }

    @NativeType(value="Display *")
    public long display() {
        return XDestroyWindowEvent.ndisplay(this.address());
    }

    @NativeType(value="Window")
    public long event() {
        return XDestroyWindowEvent.nevent(this.address());
    }

    @NativeType(value="Window")
    public long window() {
        return XDestroyWindowEvent.nwindow(this.address());
    }

    public XDestroyWindowEvent type(int n2) {
        XDestroyWindowEvent.ntype(this.address(), n2);
        return this;
    }

    public XDestroyWindowEvent serial(@NativeType(value="unsigned long") long l2) {
        XDestroyWindowEvent.nserial(this.address(), l2);
        return this;
    }

    public XDestroyWindowEvent send_event(@NativeType(value="Bool") boolean bl) {
        XDestroyWindowEvent.nsend_event(this.address(), bl ? 1 : 0);
        return this;
    }

    public XDestroyWindowEvent display(@NativeType(value="Display *") long l2) {
        XDestroyWindowEvent.ndisplay(this.address(), l2);
        return this;
    }

    public XDestroyWindowEvent event(@NativeType(value="Window") long l2) {
        XDestroyWindowEvent.nevent(this.address(), l2);
        return this;
    }

    public XDestroyWindowEvent window(@NativeType(value="Window") long l2) {
        XDestroyWindowEvent.nwindow(this.address(), l2);
        return this;
    }

    public XDestroyWindowEvent set(int n2, long l2, boolean bl, long l3, long l4, long l5) {
        this.type(n2);
        this.serial(l2);
        this.send_event(bl);
        this.display(l3);
        this.event(l4);
        this.window(l5);
        return this;
    }

    public XDestroyWindowEvent set(XDestroyWindowEvent xDestroyWindowEvent) {
        MemoryUtil.memCopy(xDestroyWindowEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static XDestroyWindowEvent malloc() {
        return new XDestroyWindowEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static XDestroyWindowEvent calloc() {
        return new XDestroyWindowEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static XDestroyWindowEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new XDestroyWindowEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static XDestroyWindowEvent create(long l2) {
        return new XDestroyWindowEvent(l2, null);
    }

    public static @Nullable XDestroyWindowEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new XDestroyWindowEvent(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(XDestroyWindowEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = XDestroyWindowEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    @Deprecated
    public static XDestroyWindowEvent mallocStack() {
        return XDestroyWindowEvent.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XDestroyWindowEvent callocStack() {
        return XDestroyWindowEvent.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static XDestroyWindowEvent mallocStack(MemoryStack memoryStack) {
        return XDestroyWindowEvent.malloc(memoryStack);
    }

    @Deprecated
    public static XDestroyWindowEvent callocStack(MemoryStack memoryStack) {
        return XDestroyWindowEvent.calloc(memoryStack);
    }

    @Deprecated
    public static Buffer mallocStack(int n2) {
        return XDestroyWindowEvent.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int n2) {
        return XDestroyWindowEvent.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return XDestroyWindowEvent.malloc(n2, memoryStack);
    }

    @Deprecated
    public static Buffer callocStack(int n2, MemoryStack memoryStack) {
        return XDestroyWindowEvent.calloc(n2, memoryStack);
    }

    public static XDestroyWindowEvent malloc(MemoryStack memoryStack) {
        return new XDestroyWindowEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static XDestroyWindowEvent calloc(MemoryStack memoryStack) {
        return new XDestroyWindowEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ntype(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TYPE);
    }

    public static long nserial(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)SERIAL);
    }

    public static int nsend_event(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)SEND_EVENT);
    }

    public static long ndisplay(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)DISPLAY);
    }

    public static long nevent(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)EVENT);
    }

    public static long nwindow(long l2) {
        return MemoryUtil.memGetCLong(l2 + (long)WINDOW);
    }

    public static void ntype(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TYPE, n2);
    }

    public static void nserial(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)SERIAL, l3);
    }

    public static void nsend_event(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)SEND_EVENT, n2);
    }

    public static void ndisplay(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)DISPLAY, Checks.check(l3));
    }

    public static void nevent(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)EVENT, l3);
    }

    public static void nwindow(long l2, long l3) {
        MemoryUtil.memPutCLong(l2 + (long)WINDOW, l3);
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)DISPLAY));
    }

    static {
        Struct.Layout layout = XDestroyWindowEvent.__struct(XDestroyWindowEvent.__member(4), XDestroyWindowEvent.__member(CLONG_SIZE), XDestroyWindowEvent.__member(4), XDestroyWindowEvent.__member(POINTER_SIZE), XDestroyWindowEvent.__member(CLONG_SIZE), XDestroyWindowEvent.__member(CLONG_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        SERIAL = layout.offsetof(1);
        SEND_EVENT = layout.offsetof(2);
        DISPLAY = layout.offsetof(3);
        EVENT = layout.offsetof(4);
        WINDOW = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<XDestroyWindowEvent, Buffer>
    implements NativeResource {
        private static final XDestroyWindowEvent ELEMENT_FACTORY = XDestroyWindowEvent.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected XDestroyWindowEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int type() {
            return XDestroyWindowEvent.ntype(((Pointer.Default)this).address());
        }

        @NativeType(value="unsigned long")
        public long serial() {
            return XDestroyWindowEvent.nserial(((Pointer.Default)this).address());
        }

        @NativeType(value="Bool")
        public boolean send_event() {
            return XDestroyWindowEvent.nsend_event(((Pointer.Default)this).address()) != 0;
        }

        @NativeType(value="Display *")
        public long display() {
            return XDestroyWindowEvent.ndisplay(((Pointer.Default)this).address());
        }

        @NativeType(value="Window")
        public long event() {
            return XDestroyWindowEvent.nevent(((Pointer.Default)this).address());
        }

        @NativeType(value="Window")
        public long window() {
            return XDestroyWindowEvent.nwindow(((Pointer.Default)this).address());
        }

        public Buffer type(int n2) {
            XDestroyWindowEvent.ntype(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer serial(@NativeType(value="unsigned long") long l2) {
            XDestroyWindowEvent.nserial(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer send_event(@NativeType(value="Bool") boolean bl) {
            XDestroyWindowEvent.nsend_event(((Pointer.Default)this).address(), bl ? 1 : 0);
            return this;
        }

        public Buffer display(@NativeType(value="Display *") long l2) {
            XDestroyWindowEvent.ndisplay(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer event(@NativeType(value="Window") long l2) {
            XDestroyWindowEvent.nevent(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer window(@NativeType(value="Window") long l2) {
            XDestroyWindowEvent.nwindow(((Pointer.Default)this).address(), l2);
            return this;
        }
    }
}

