/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct statx_timestamp")
public class StatxTimestamp
extends Struct<StatxTimestamp>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TV_SEC;
    public static final int TV_NSEC;
    public static final int __RESERVED;

    protected StatxTimestamp(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected StatxTimestamp create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new StatxTimestamp(l2, byteBuffer);
    }

    public StatxTimestamp(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), StatxTimestamp.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="__s64")
    public long tv_sec() {
        return StatxTimestamp.ntv_sec(this.address());
    }

    @NativeType(value="__u32")
    public int tv_nsec() {
        return StatxTimestamp.ntv_nsec(this.address());
    }

    public StatxTimestamp tv_sec(@NativeType(value="__s64") long l2) {
        StatxTimestamp.ntv_sec(this.address(), l2);
        return this;
    }

    public StatxTimestamp tv_nsec(@NativeType(value="__u32") int n2) {
        StatxTimestamp.ntv_nsec(this.address(), n2);
        return this;
    }

    public StatxTimestamp set(long l2, int n2) {
        this.tv_sec(l2);
        this.tv_nsec(n2);
        return this;
    }

    public StatxTimestamp set(StatxTimestamp statxTimestamp) {
        MemoryUtil.memCopy(statxTimestamp.address(), this.address(), SIZEOF);
        return this;
    }

    public static StatxTimestamp malloc() {
        return new StatxTimestamp(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StatxTimestamp calloc() {
        return new StatxTimestamp(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StatxTimestamp create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new StatxTimestamp(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static StatxTimestamp create(long l2) {
        return new StatxTimestamp(l2, null);
    }

    public static @Nullable StatxTimestamp createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new StatxTimestamp(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StatxTimestamp.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = StatxTimestamp.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static StatxTimestamp malloc(MemoryStack memoryStack) {
        return new StatxTimestamp(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StatxTimestamp calloc(MemoryStack memoryStack) {
        return new StatxTimestamp(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long ntv_sec(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)TV_SEC);
    }

    public static int ntv_nsec(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)TV_NSEC);
    }

    public static int n__reserved(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)__RESERVED);
    }

    public static void ntv_sec(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)TV_SEC, l3);
    }

    public static void ntv_nsec(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)TV_NSEC, n2);
    }

    public static void n__reserved(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)__RESERVED, n2);
    }

    static {
        Struct.Layout layout = StatxTimestamp.__struct(StatxTimestamp.__member(8), StatxTimestamp.__member(4), StatxTimestamp.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TV_SEC = layout.offsetof(0);
        TV_NSEC = layout.offsetof(1);
        __RESERVED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<StatxTimestamp, Buffer>
    implements NativeResource {
        private static final StatxTimestamp ELEMENT_FACTORY = StatxTimestamp.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected StatxTimestamp getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="__s64")
        public long tv_sec() {
            return StatxTimestamp.ntv_sec(((Pointer.Default)this).address());
        }

        @NativeType(value="__u32")
        public int tv_nsec() {
            return StatxTimestamp.ntv_nsec(((Pointer.Default)this).address());
        }

        public Buffer tv_sec(@NativeType(value="__s64") long l2) {
            StatxTimestamp.ntv_sec(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer tv_nsec(@NativeType(value="__u32") int n2) {
            StatxTimestamp.ntv_nsec(((Pointer.Default)this).address(), n2);
            return this;
        }
    }
}

