/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct sockaddr")
public class Sockaddr
extends Struct<Sockaddr>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SA_FAMILY;
    public static final int SA_DATA;

    protected Sockaddr(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected Sockaddr create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new Sockaddr(l2, byteBuffer);
    }

    public Sockaddr(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), Sockaddr.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="sa_family_t")
    public short sa_family() {
        return Sockaddr.nsa_family(this.address());
    }

    @NativeType(value="char[14]")
    public ByteBuffer sa_data() {
        return Sockaddr.nsa_data(this.address());
    }

    @NativeType(value="char")
    public byte sa_data(int n2) {
        return Sockaddr.nsa_data(this.address(), n2);
    }

    public Sockaddr sa_family(@NativeType(value="sa_family_t") short s2) {
        Sockaddr.nsa_family(this.address(), s2);
        return this;
    }

    public Sockaddr sa_data(@NativeType(value="char[14]") ByteBuffer byteBuffer) {
        Sockaddr.nsa_data(this.address(), byteBuffer);
        return this;
    }

    public Sockaddr sa_data(int n2, @NativeType(value="char") byte by) {
        Sockaddr.nsa_data(this.address(), n2, by);
        return this;
    }

    public Sockaddr set(short s2, ByteBuffer byteBuffer) {
        this.sa_family(s2);
        this.sa_data(byteBuffer);
        return this;
    }

    public Sockaddr set(Sockaddr sockaddr) {
        MemoryUtil.memCopy(sockaddr.address(), this.address(), SIZEOF);
        return this;
    }

    public static Sockaddr malloc() {
        return new Sockaddr(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static Sockaddr calloc() {
        return new Sockaddr(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static Sockaddr create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new Sockaddr(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static Sockaddr create(long l2) {
        return new Sockaddr(l2, null);
    }

    public static @Nullable Sockaddr createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new Sockaddr(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(Sockaddr.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = Sockaddr.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static Sockaddr malloc(MemoryStack memoryStack) {
        return new Sockaddr(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static Sockaddr calloc(MemoryStack memoryStack) {
        return new Sockaddr(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static short nsa_family(long l2) {
        return MemoryUtil.memGetShort(l2 + (long)SA_FAMILY);
    }

    public static ByteBuffer nsa_data(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)SA_DATA, 14);
    }

    public static byte nsa_data(long l2, int n2) {
        return MemoryUtil.memGetByte(l2 + (long)SA_DATA + Checks.check(n2, 14));
    }

    public static void nsa_family(long l2, short s2) {
        MemoryUtil.memPutShort(l2 + (long)SA_FAMILY, s2);
    }

    public static void nsa_data(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 14);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)SA_DATA, byteBuffer.remaining());
    }

    public static void nsa_data(long l2, int n2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)SA_DATA + Checks.check(n2, 14), by);
    }

    static {
        Struct.Layout layout = Sockaddr.__struct(Sockaddr.__member(2), Sockaddr.__array(1, 14));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SA_FAMILY = layout.offsetof(0);
        SA_DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<Sockaddr, Buffer>
    implements NativeResource {
        private static final Sockaddr ELEMENT_FACTORY = Sockaddr.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Sockaddr getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="sa_family_t")
        public short sa_family() {
            return Sockaddr.nsa_family(((Pointer.Default)this).address());
        }

        @NativeType(value="char[14]")
        public ByteBuffer sa_data() {
            return Sockaddr.nsa_data(((Pointer.Default)this).address());
        }

        @NativeType(value="char")
        public byte sa_data(int n2) {
            return Sockaddr.nsa_data(((Pointer.Default)this).address(), n2);
        }

        public Buffer sa_family(@NativeType(value="sa_family_t") short s2) {
            Sockaddr.nsa_family(((Pointer.Default)this).address(), s2);
            return this;
        }

        public Buffer sa_data(@NativeType(value="char[14]") ByteBuffer byteBuffer) {
            Sockaddr.nsa_data(((Pointer.Default)this).address(), byteBuffer);
            return this;
        }

        public Buffer sa_data(int n2, @NativeType(value="char") byte by) {
            Sockaddr.nsa_data(((Pointer.Default)this).address(), n2, by);
            return this;
        }
    }
}

