/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct __kernel_timespec")
public class KernelTimespec
extends Struct<KernelTimespec>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TV_SEC;
    public static final int TV_NSEC;

    protected KernelTimespec(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected KernelTimespec create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new KernelTimespec(l2, byteBuffer);
    }

    public KernelTimespec(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), KernelTimespec.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int64_t")
    public long tv_sec() {
        return KernelTimespec.ntv_sec(this.address());
    }

    @NativeType(value="long long")
    public long tv_nsec() {
        return KernelTimespec.ntv_nsec(this.address());
    }

    public KernelTimespec tv_sec(@NativeType(value="int64_t") long l2) {
        KernelTimespec.ntv_sec(this.address(), l2);
        return this;
    }

    public KernelTimespec tv_nsec(@NativeType(value="long long") long l2) {
        KernelTimespec.ntv_nsec(this.address(), l2);
        return this;
    }

    public KernelTimespec set(long l2, long l3) {
        this.tv_sec(l2);
        this.tv_nsec(l3);
        return this;
    }

    public KernelTimespec set(KernelTimespec kernelTimespec) {
        MemoryUtil.memCopy(kernelTimespec.address(), this.address(), SIZEOF);
        return this;
    }

    public static KernelTimespec malloc() {
        return new KernelTimespec(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static KernelTimespec calloc() {
        return new KernelTimespec(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static KernelTimespec create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new KernelTimespec(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static KernelTimespec create(long l2) {
        return new KernelTimespec(l2, null);
    }

    public static @Nullable KernelTimespec createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new KernelTimespec(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(KernelTimespec.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = KernelTimespec.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static KernelTimespec malloc(MemoryStack memoryStack) {
        return new KernelTimespec(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static KernelTimespec calloc(MemoryStack memoryStack) {
        return new KernelTimespec(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static long ntv_sec(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)TV_SEC);
    }

    public static long ntv_nsec(long l2) {
        return MemoryUtil.memGetLong(l2 + (long)TV_NSEC);
    }

    public static void ntv_sec(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)TV_SEC, l3);
    }

    public static void ntv_nsec(long l2, long l3) {
        MemoryUtil.memPutLong(l2 + (long)TV_NSEC, l3);
    }

    static {
        Struct.Layout layout = KernelTimespec.__struct(KernelTimespec.__member(8), KernelTimespec.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TV_SEC = layout.offsetof(0);
        TV_NSEC = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<KernelTimespec, Buffer>
    implements NativeResource {
        private static final KernelTimespec ELEMENT_FACTORY = KernelTimespec.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected KernelTimespec getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int64_t")
        public long tv_sec() {
            return KernelTimespec.ntv_sec(((Pointer.Default)this).address());
        }

        @NativeType(value="long long")
        public long tv_nsec() {
            return KernelTimespec.ntv_nsec(((Pointer.Default)this).address());
        }

        public Buffer tv_sec(@NativeType(value="int64_t") long l2) {
            KernelTimespec.ntv_sec(((Pointer.Default)this).address(), l2);
            return this;
        }

        public Buffer tv_nsec(@NativeType(value="long long") long l2) {
            KernelTimespec.ntv_nsec(((Pointer.Default)this).address(), l2);
            return this;
        }
    }
}

