/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct iovec")
public class IOVec
extends Struct<IOVec>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int IOV_BASE;
    public static final int IOV_LEN;

    protected IOVec(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected IOVec create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new IOVec(l2, byteBuffer);
    }

    public IOVec(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), IOVec.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void *")
    public @Nullable ByteBuffer iov_base() {
        return IOVec.niov_base(this.address());
    }

    @NativeType(value="size_t")
    public long iov_len() {
        return IOVec.niov_len(this.address());
    }

    public IOVec iov_base(@NativeType(value="void *") @Nullable ByteBuffer byteBuffer) {
        IOVec.niov_base(this.address(), byteBuffer);
        return this;
    }

    public IOVec iov_len(@NativeType(value="size_t") long l2) {
        IOVec.niov_len(this.address(), l2);
        return this;
    }

    public IOVec set(@Nullable ByteBuffer byteBuffer, long l2) {
        this.iov_base(byteBuffer);
        this.iov_len(l2);
        return this;
    }

    public IOVec set(IOVec iOVec) {
        MemoryUtil.memCopy(iOVec.address(), this.address(), SIZEOF);
        return this;
    }

    public static IOVec malloc() {
        return new IOVec(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static IOVec calloc() {
        return new IOVec(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static IOVec create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new IOVec(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static IOVec create(long l2) {
        return new IOVec(l2, null);
    }

    public static @Nullable IOVec createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new IOVec(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(IOVec.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = IOVec.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static IOVec malloc(MemoryStack memoryStack) {
        return new IOVec(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static IOVec calloc(MemoryStack memoryStack) {
        return new IOVec(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static @Nullable ByteBuffer niov_base(long l2) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(l2 + (long)IOV_BASE), (int)IOVec.niov_len(l2));
    }

    public static long niov_len(long l2) {
        return MemoryUtil.memGetAddress(l2 + (long)IOV_LEN);
    }

    public static void niov_base(long l2, @Nullable ByteBuffer byteBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)IOV_BASE, MemoryUtil.memAddressSafe(byteBuffer));
    }

    public static void niov_len(long l2, long l3) {
        MemoryUtil.memPutAddress(l2 + (long)IOV_LEN, l3);
    }

    static {
        Struct.Layout layout = IOVec.__struct(IOVec.__member(POINTER_SIZE), IOVec.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        IOV_BASE = layout.offsetof(0);
        IOV_LEN = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<IOVec, Buffer>
    implements NativeResource {
        private static final IOVec ELEMENT_FACTORY = IOVec.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected IOVec getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void *")
        public @Nullable ByteBuffer iov_base() {
            return IOVec.niov_base(((Pointer.Default)this).address());
        }

        @NativeType(value="size_t")
        public long iov_len() {
            return IOVec.niov_len(((Pointer.Default)this).address());
        }

        public Buffer iov_base(@NativeType(value="void *") @Nullable ByteBuffer byteBuffer) {
            IOVec.niov_base(((Pointer.Default)this).address(), byteBuffer);
            return this;
        }

        public Buffer iov_len(@NativeType(value="size_t") long l2) {
            IOVec.niov_len(((Pointer.Default)this).address(), l2);
            return this;
        }
    }
}

