/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.linux.EpollData;

@NativeType(value="struct epoll_event")
public class EpollEvent
extends Struct<EpollEvent>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int EVENTS;
    public static final int DATA;

    protected EpollEvent(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected EpollEvent create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new EpollEvent(l2, byteBuffer);
    }

    public EpollEvent(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), EpollEvent.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int events() {
        return EpollEvent.nevents(this.address());
    }

    @NativeType(value="epoll_data_t")
    public EpollData data() {
        return EpollEvent.ndata(this.address());
    }

    public EpollEvent events(@NativeType(value="uint32_t") int n2) {
        EpollEvent.nevents(this.address(), n2);
        return this;
    }

    public EpollEvent data(@NativeType(value="epoll_data_t") EpollData epollData) {
        EpollEvent.ndata(this.address(), epollData);
        return this;
    }

    public EpollEvent data(Consumer<EpollData> consumer) {
        consumer.accept(this.data());
        return this;
    }

    public EpollEvent set(int n2, EpollData epollData) {
        this.events(n2);
        this.data(epollData);
        return this;
    }

    public EpollEvent set(EpollEvent epollEvent) {
        MemoryUtil.memCopy(epollEvent.address(), this.address(), SIZEOF);
        return this;
    }

    public static EpollEvent malloc() {
        return new EpollEvent(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static EpollEvent calloc() {
        return new EpollEvent(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static EpollEvent create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new EpollEvent(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static EpollEvent create(long l2) {
        return new EpollEvent(l2, null);
    }

    public static @Nullable EpollEvent createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new EpollEvent(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(EpollEvent.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = EpollEvent.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static EpollEvent malloc(MemoryStack memoryStack) {
        return new EpollEvent(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static EpollEvent calloc(MemoryStack memoryStack) {
        return new EpollEvent(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nevents(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)EVENTS);
    }

    public static EpollData ndata(long l2) {
        return EpollData.create(l2 + (long)DATA);
    }

    public static void nevents(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)EVENTS, n2);
    }

    public static void ndata(long l2, EpollData epollData) {
        MemoryUtil.memCopy(epollData.address(), l2 + (long)DATA, EpollData.SIZEOF);
    }

    static {
        Struct.Layout layout = EpollEvent.__struct(EpollEvent.__member(4), EpollEvent.__member(EpollData.SIZEOF, EpollData.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        EVENTS = layout.offsetof(0);
        DATA = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<EpollEvent, Buffer>
    implements NativeResource {
        private static final EpollEvent ELEMENT_FACTORY = EpollEvent.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected EpollEvent getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int events() {
            return EpollEvent.nevents(((Pointer.Default)this).address());
        }

        @NativeType(value="epoll_data_t")
        public EpollData data() {
            return EpollEvent.ndata(((Pointer.Default)this).address());
        }

        public Buffer events(@NativeType(value="uint32_t") int n2) {
            EpollEvent.nevents(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer data(@NativeType(value="epoll_data_t") EpollData epollData) {
            EpollEvent.ndata(((Pointer.Default)this).address(), epollData);
            return this;
        }

        public Buffer data(Consumer<EpollData> consumer) {
            consumer.accept(this.data());
            return this;
        }
    }
}

