/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cmsghdr")
public class CMsghdr
extends Struct<CMsghdr>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CMSG_LEN;
    public static final int CMSG_LEVEL;
    public static final int CMSG_TYPE;
    public static final int CMSG_DATA;

    protected CMsghdr(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected CMsghdr create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new CMsghdr(l2, byteBuffer);
    }

    public CMsghdr(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), CMsghdr.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="socklen_t")
    public int cmsg_len() {
        return CMsghdr.ncmsg_len(this.address());
    }

    public int cmsg_level() {
        return CMsghdr.ncmsg_level(this.address());
    }

    public int cmsg_type() {
        return CMsghdr.ncmsg_type(this.address());
    }

    @NativeType(value="char[0]")
    public ByteBuffer cmsg_data() {
        return CMsghdr.ncmsg_data(this.address());
    }

    @NativeType(value="char")
    public byte cmsg_data(int n2) {
        return CMsghdr.ncmsg_data(this.address(), n2);
    }

    public CMsghdr cmsg_len(@NativeType(value="socklen_t") int n2) {
        CMsghdr.ncmsg_len(this.address(), n2);
        return this;
    }

    public CMsghdr cmsg_level(int n2) {
        CMsghdr.ncmsg_level(this.address(), n2);
        return this;
    }

    public CMsghdr cmsg_type(int n2) {
        CMsghdr.ncmsg_type(this.address(), n2);
        return this;
    }

    public CMsghdr cmsg_data(@NativeType(value="char[0]") ByteBuffer byteBuffer) {
        CMsghdr.ncmsg_data(this.address(), byteBuffer);
        return this;
    }

    public CMsghdr cmsg_data(int n2, @NativeType(value="char") byte by) {
        CMsghdr.ncmsg_data(this.address(), n2, by);
        return this;
    }

    public CMsghdr set(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        this.cmsg_len(n2);
        this.cmsg_level(n3);
        this.cmsg_type(n4);
        this.cmsg_data(byteBuffer);
        return this;
    }

    public CMsghdr set(CMsghdr cMsghdr) {
        MemoryUtil.memCopy(cMsghdr.address(), this.address(), SIZEOF);
        return this;
    }

    public static CMsghdr malloc() {
        return new CMsghdr(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static CMsghdr calloc() {
        return new CMsghdr(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static CMsghdr create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new CMsghdr(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static CMsghdr create(long l2) {
        return new CMsghdr(l2, null);
    }

    public static @Nullable CMsghdr createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new CMsghdr(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(CMsghdr.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = CMsghdr.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    public static CMsghdr malloc(MemoryStack memoryStack) {
        return new CMsghdr(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CMsghdr calloc(MemoryStack memoryStack) {
        return new CMsghdr(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int ncmsg_len(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)CMSG_LEN);
    }

    public static int ncmsg_level(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)CMSG_LEVEL);
    }

    public static int ncmsg_type(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)CMSG_TYPE);
    }

    public static ByteBuffer ncmsg_data(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)CMSG_DATA, 0);
    }

    public static byte ncmsg_data(long l2, int n2) {
        return MemoryUtil.memGetByte(l2 + (long)CMSG_DATA + Checks.check(n2, 0));
    }

    public static void ncmsg_len(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)CMSG_LEN, n2);
    }

    public static void ncmsg_level(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)CMSG_LEVEL, n2);
    }

    public static void ncmsg_type(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)CMSG_TYPE, n2);
    }

    public static void ncmsg_data(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 0);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)CMSG_DATA, byteBuffer.remaining());
    }

    public static void ncmsg_data(long l2, int n2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)CMSG_DATA + Checks.check(n2, 0), by);
    }

    static {
        Struct.Layout layout = CMsghdr.__struct(CMsghdr.__member(4), CMsghdr.__member(4), CMsghdr.__member(4), CMsghdr.__array(1, 0));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CMSG_LEN = layout.offsetof(0);
        CMSG_LEVEL = layout.offsetof(1);
        CMSG_TYPE = layout.offsetof(2);
        CMSG_DATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<CMsghdr, Buffer>
    implements NativeResource {
        private static final CMsghdr ELEMENT_FACTORY = CMsghdr.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected CMsghdr getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="socklen_t")
        public int cmsg_len() {
            return CMsghdr.ncmsg_len(((Pointer.Default)this).address());
        }

        public int cmsg_level() {
            return CMsghdr.ncmsg_level(((Pointer.Default)this).address());
        }

        public int cmsg_type() {
            return CMsghdr.ncmsg_type(((Pointer.Default)this).address());
        }

        @NativeType(value="char[0]")
        public ByteBuffer cmsg_data() {
            return CMsghdr.ncmsg_data(((Pointer.Default)this).address());
        }

        @NativeType(value="char")
        public byte cmsg_data(int n2) {
            return CMsghdr.ncmsg_data(((Pointer.Default)this).address(), n2);
        }

        public Buffer cmsg_len(@NativeType(value="socklen_t") int n2) {
            CMsghdr.ncmsg_len(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer cmsg_level(int n2) {
            CMsghdr.ncmsg_level(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer cmsg_type(int n2) {
            CMsghdr.ncmsg_type(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer cmsg_data(@NativeType(value="char[0]") ByteBuffer byteBuffer) {
            CMsghdr.ncmsg_data(((Pointer.Default)this).address(), byteBuffer);
            return this;
        }

        public Buffer cmsg_data(int n2, @NativeType(value="char") byte by) {
            CMsghdr.ncmsg_data(((Pointer.Default)this).address(), n2, by);
            return this;
        }
    }
}

