/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;

public abstract class StructBuffer<T extends Struct<T>, SELF extends StructBuffer<T, SELF>>
extends CustomBuffer<SELF>
implements Iterable<T> {
    public StructBuffer(ByteBuffer byteBuffer, int n2) {
        int n3 = n2;
        super(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public StructBuffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
        super(l2, byteBuffer, n2, n3, n4, n5);
    }

    @Override
    public int sizeof() {
        return ((Struct)this.getElementFactory()).sizeof();
    }

    public T get() {
        T t2 = this.getElementFactory();
        return (T)((Struct)t2).create(this.address + Integer.toUnsignedLong(this.nextGetIndex()) * (long)((Struct)t2).sizeof(), this.container);
    }

    public SELF get(T t2) {
        int n2 = ((Struct)this.getElementFactory()).sizeof();
        MemoryUtil.memCopy(this.address + Integer.toUnsignedLong(this.nextGetIndex()) * (long)n2, ((Pointer.Default)t2).address(), n2);
        return (SELF)((StructBuffer)this.self());
    }

    @Override
    public SELF put(T t2) {
        int n2 = ((Struct)this.getElementFactory()).sizeof();
        MemoryUtil.memCopy(((Pointer.Default)t2).address(), this.address + Integer.toUnsignedLong(this.nextPutIndex()) * (long)n2, n2);
        return (SELF)((StructBuffer)this.self());
    }

    public T get(int n2) {
        T t2 = this.getElementFactory();
        return (T)((Struct)t2).create(this.address + Integer.toUnsignedLong(StructBuffer.check(n2, this.limit)) * (long)((Struct)t2).sizeof(), this.container);
    }

    public SELF get(int n2, T t2) {
        int n3 = ((Struct)this.getElementFactory()).sizeof();
        MemoryUtil.memCopy(this.address + Checks.check(n2, this.limit) * (long)n3, ((Pointer.Default)t2).address(), n3);
        return (SELF)((StructBuffer)this.self());
    }

    public SELF put(int n2, T t2) {
        int n3 = ((Struct)this.getElementFactory()).sizeof();
        MemoryUtil.memCopy(((Pointer.Default)t2).address(), this.address + Checks.check(n2, this.limit) * (long)n3, n3);
        return (SELF)((StructBuffer)this.self());
    }

    public SELF apply(Consumer<T> consumer) {
        consumer.accept(this.get());
        return (SELF)((StructBuffer)this.self());
    }

    public SELF apply(int n2, Consumer<T> consumer) {
        consumer.accept(this.get(n2));
        return (SELF)((StructBuffer)this.self());
    }

    @Override
    public Iterator<T> iterator() {
        return new StructIterator<T>(this.address, this.container, this.getElementFactory(), this.position, this.limit);
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        Objects.requireNonNull(consumer);
        T t2 = this.getElementFactory();
        int n2 = this.limit;
        ((Struct)t2).sizeof();
        for (int i2 = this.position; i2 < n2; ++i2) {
            consumer.accept(((Struct)t2).create(this.address + Integer.toUnsignedLong(i2) * (long)((CustomBuffer)this).sizeof(), this.container));
        }
    }

    @Override
    public Spliterator<T> spliterator() {
        return new StructSpliterator<T>(this.address, this.container, this.getElementFactory(), this.position, this.limit);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<T> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    protected abstract T getElementFactory();

    private static int check(int n2, int n3) {
        if (Checks.CHECKS && (n2 < 0 || n3 <= n2)) {
            throw new IndexOutOfBoundsException();
        }
        return n2;
    }

    static class StructSpliterator<T extends Struct<T>>
    implements Spliterator<T> {
        private long address;
        private @Nullable ByteBuffer container;
        private T factory;
        private int index;
        private int fence;

        StructSpliterator(long l2, @Nullable ByteBuffer byteBuffer, T t2, int n2, int n3) {
            this.address = l2;
            this.container = byteBuffer;
            this.factory = t2;
            this.index = n2;
            this.fence = n3;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> consumer) {
            Objects.requireNonNull(consumer);
            if (this.index < this.fence) {
                consumer.accept(((Struct)this.factory).create(this.address + Integer.toUnsignedLong(this.index++) * (long)((Struct)this.factory).sizeof(), this.container));
                return true;
            }
            return false;
        }

        @Override
        public @Nullable Spliterator<T> trySplit() {
            int n2 = this.index;
            int n3 = n2 + this.fence >>> 1;
            if (n2 < n3) {
                this.index = n3;
                return new StructSpliterator<T>(this.address, this.container, this.factory, n2, this.index);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17744;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            int n2;
            Objects.requireNonNull(consumer);
            try {
                int n3 = ((Struct)this.factory).sizeof();
                for (n2 = this.index; n2 < this.fence; ++n2) {
                    consumer.accept(((Struct)this.factory).create(this.address + Integer.toUnsignedLong(n2) * (long)n3, this.container));
                }
                return;
            }
            finally {
                this.index = n2;
            }
        }

        @Override
        public Comparator<? super T> getComparator() {
            throw new IllegalStateException();
        }
    }

    static class StructIterator<T extends Struct<T>>
    implements Iterator<T> {
        private long address;
        private @Nullable ByteBuffer container;
        private T factory;
        private int index;
        private int fence;

        StructIterator(long l2, @Nullable ByteBuffer byteBuffer, T t2, int n2, int n3) {
            this.address = l2;
            this.container = byteBuffer;
            this.factory = t2;
            this.index = n2;
            this.fence = n3;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.fence;
        }

        @Override
        public T next() {
            if (Checks.CHECKS && this.fence <= this.index) {
                throw new NoSuchElementException();
            }
            return (T)((Struct)this.factory).create(this.address + Integer.toUnsignedLong(this.index++) * (long)((Struct)this.factory).sizeof(), this.container);
        }

        @Override
        public void forEachRemaining(Consumer<? super T> consumer) {
            int n2;
            Objects.requireNonNull(consumer);
            try {
                int n3 = ((Struct)this.factory).sizeof();
                for (n2 = this.index; n2 < this.fence; ++n2) {
                    consumer.accept(((Struct)this.factory).create(this.address + Integer.toUnsignedLong(n2) * (long)n3, this.container));
                }
                return;
            }
            finally {
                this.index = n2;
            }
        }
    }
}

