/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.StructBuffer;

public abstract class Struct<SELF extends Struct<SELF>>
extends Pointer.Default {
    protected static final int DEFAULT_PACK_ALIGNMENT = Platform.get() == Platform.WINDOWS ? 8 : 0x40000000;
    protected static final int DEFAULT_ALIGN_AS = 0;
    protected @Nullable ByteBuffer container;

    public Struct(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2);
        this.container = byteBuffer;
    }

    protected abstract SELF create(long var1, @Nullable ByteBuffer var3);

    public abstract int sizeof();

    public void clear() {
        MemoryUtil.memSet(this.address(), 0, this.sizeof());
    }

    public void free() {
        MemoryUtil.nmemFree(this.address());
    }

    public boolean isNull(int n2) {
        if (Checks.DEBUG) {
            this.checkMemberOffset(n2);
        }
        return MemoryUtil.memGetAddress(this.address() + (long)n2) == 0L;
    }

    private void checkMemberOffset(int n2) {
        if (n2 < 0 || this.sizeof() - n2 < POINTER_SIZE) {
            throw new IllegalArgumentException("Invalid member offset.");
        }
    }

    protected static ByteBuffer __checkContainer(ByteBuffer byteBuffer, int n2) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)byteBuffer, n2);
        }
        return byteBuffer;
    }

    private static long getBytes(int n2, int n3) {
        return ((long)n2 & 0xFFFFFFFFL) * (long)n3;
    }

    public static long __checkMalloc(int n2, int n3) {
        long l2 = ((long)n2 & 0xFFFFFFFFL) * (long)n3;
        if (Checks.DEBUG) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid number of elements");
            }
            if (BITS32 && 0xFFFFFFFFL < l2) {
                throw new IllegalArgumentException("The request allocation is too large");
            }
        }
        return l2;
    }

    public static ByteBuffer __create(int n2, int n3) {
        int n4 = n2;
        APIUtil.apiCheckAllocation(n4, Struct.getBytes(n4, n3), Integer.MAX_VALUE);
        return ByteBuffer.allocateDirect(n2 * n3).order(ByteOrder.nativeOrder());
    }

    protected static <T extends Struct<T>> @Nullable ByteBuffer __getContainer(T t2) {
        return t2.container;
    }

    protected static @Nullable ByteBuffer __getContainer(StructBuffer<?, ?> structBuffer) {
        return structBuffer.container;
    }

    public static void validate(long l2, int n2, int n3, StructValidation structValidation) {
        for (int i2 = 0; i2 < n2; ++i2) {
            structValidation.validate(l2 + Integer.toUnsignedLong(i2) * (long)n3);
        }
    }

    public static void validate(long l2, long l3, int n2, StructValidation structValidation) {
        Struct.validate(l2, (int)l3, n2, structValidation);
    }

    protected static Member __padding(int n2, boolean bl) {
        return Struct.__padding(n2, 1, bl);
    }

    public static Member __padding(int n2, int n3, boolean bl) {
        return Struct.__member(bl ? n2 * n3 : 0, n3);
    }

    public static Member __member(int n2) {
        int n3 = n2;
        return Struct.__member(n3, n3);
    }

    public static Member __member(int n2, int n3) {
        return Struct.__member(n2, n3, false);
    }

    protected static Member __member(int n2, int n3, boolean bl) {
        return new Member(n2, n3, bl);
    }

    public static Member __array(int n2, int n3) {
        int n4 = n2;
        return Struct.__array(n4, n4, n3);
    }

    public static Member __array(int n2, int n3, int n4) {
        return new Member(n2 * n4, n3, false);
    }

    protected static Member __array(int n2, int n3, boolean bl, int n4) {
        return new Member(n2 * n4, n3, bl);
    }

    public static Layout __union(Member ... memberArray) {
        return Struct.__union(DEFAULT_PACK_ALIGNMENT, 0, memberArray);
    }

    protected static Layout __union(int n2, int n3, Member ... memberArray) {
        ArrayList<Member> arrayList = new ArrayList<Member>(memberArray.length);
        int n4 = 0;
        int n5 = n3;
        for (Member member : memberArray) {
            n4 = Math.max(n4, member.size);
            n5 = Math.max(n5, member.getAlignment(n2));
            member.offset = 0;
            arrayList.add(member);
            if (!(member instanceof Layout)) continue;
            Struct.addNestedMembers(member, arrayList, 0);
        }
        return new Layout(n4, n5, n3 != 0, arrayList.toArray(new Member[0]));
    }

    public static Layout __struct(Member ... memberArray) {
        return Struct.__struct(DEFAULT_PACK_ALIGNMENT, 0, memberArray);
    }

    protected static Layout __struct(int n2, int n3, Member ... memberArray) {
        ArrayList<Member> arrayList = new ArrayList<Member>(memberArray.length);
        int n4 = 0;
        int n5 = n3;
        for (Member member : memberArray) {
            int n6 = member.getAlignment(n2);
            member.offset = Struct.align(n4, n6);
            n4 = member.offset + member.size;
            n5 = Math.max(n5, n6);
            arrayList.add(member);
            if (!(member instanceof Layout)) continue;
            Struct.addNestedMembers(member, arrayList, member.offset);
        }
        n4 = Struct.align(n4, n5);
        return new Layout(n4, n5, n3 != 0, arrayList.toArray(new Member[0]));
    }

    private static void addNestedMembers(Member memberArray, List<Member> list, int n2) {
        memberArray = ((Layout)memberArray).members;
        int n3 = ((Layout)memberArray).members.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Member member = memberArray[i2];
            member.offset += n2;
            list.add(member);
        }
    }

    private static int align(int n2, int n3) {
        return (n2 - 1 | n3 - 1) + 1;
    }

    static {
        Library.initialize();
    }

    public static class Layout
    extends Member {
        final Member[] members;

        Layout(int n2, int n3, boolean bl, Member[] memberArray) {
            super(n2, n3, bl);
            this.members = memberArray;
        }

        public int offsetof(int n2) {
            return this.members[n2].offset;
        }
    }

    public static class Member {
        final int size;
        final int alignment;
        final boolean forcedAlignment;
        int offset;

        Member(int n2, int n3, boolean bl) {
            this.size = n2;
            this.alignment = n3;
            this.forcedAlignment = bl;
        }

        public int getSize() {
            return this.size;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public int getAlignment(int n2) {
            if (this.forcedAlignment) {
                return this.alignment;
            }
            return Math.min(this.alignment, n2);
        }
    }

    @FunctionalInterface
    public static interface StructValidation {
        public void validate(long var1);
    }
}

