/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Callback;
import org.lwjgl.system.CallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.MemoryAccessJNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.StackWalkUtil;
import org.lwjgl.system.libc.LibCStdlib;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.LibFFI;

final class MemoryManage {
    private MemoryManage() {
    }

    static MemoryUtil.MemoryAllocator getInstance() {
        Object object = Configuration.MEMORY_ALLOCATOR.get();
        if (object instanceof MemoryUtil.MemoryAllocator) {
            return (MemoryUtil.MemoryAllocator)object;
        }
        if (!"system".equals(object)) {
            String string = object == null || "jemalloc".equals(object) ? "org.lwjgl.system.jemalloc.JEmallocAllocator" : ("rpmalloc".equals(object) ? "org.lwjgl.system.rpmalloc.RPmallocAllocator" : object.toString());
            try {
                return (MemoryUtil.MemoryAllocator)Class.forName(string).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                if (Checks.DEBUG && (object != null || !(throwable instanceof ClassNotFoundException))) {
                    throwable.printStackTrace(APIUtil.DEBUG_STREAM);
                }
                APIUtil.apiLog(String.format("Warning: Failed to instantiate memory allocator: %s. Using the system default.", string));
            }
        }
        return new StdlibAllocator();
    }

    static class DebugAllocator
    implements MemoryUtil.MemoryAllocator {
        private static final ConcurrentMap<Allocation, Allocation> ALLOCATIONS = new ConcurrentHashMap<Allocation, Allocation>();
        private static final ConcurrentMap<Long, String> THREADS = new ConcurrentHashMap<Long, String>();
        private final MemoryUtil.MemoryAllocator allocator;
        private final long[] callbacks;

        DebugAllocator(MemoryUtil.MemoryAllocator memoryAllocator) {
            this.allocator = memoryAllocator;
            this.callbacks = new long[]{new CallbackI(){

                @Override
                public FFICIF getCallInterface() {
                    return APIUtil.apiCreateCIF(LibFFI.FFI_DEFAULT_ABI, LibFFI.ffi_type_pointer, LibFFI.ffi_type_pointer);
                }

                @Override
                public void callback(long l2, long l3) {
                    long l4 = MemoryUtil.memGetAddress(MemoryUtil.memGetAddress(l3));
                    MemoryUtil.memPutAddress(l2, this.malloc(l4));
                }
            }.address(), new CallbackI(){

                @Override
                public FFICIF getCallInterface() {
                    return APIUtil.apiCreateCIF(LibFFI.FFI_DEFAULT_ABI, LibFFI.ffi_type_pointer, LibFFI.ffi_type_pointer, LibFFI.ffi_type_pointer);
                }

                @Override
                public void callback(long l2, long l3) {
                    long l4 = MemoryUtil.memGetAddress(MemoryUtil.memGetAddress(l3));
                    long l5 = MemoryUtil.memGetAddress(MemoryUtil.memGetAddress(l3 + (long)POINTER_SIZE));
                    MemoryUtil.memPutAddress(l2, this.calloc(l4, l5));
                }
            }.address(), new CallbackI(){

                @Override
                public FFICIF getCallInterface() {
                    return APIUtil.apiCreateCIF(LibFFI.FFI_DEFAULT_ABI, LibFFI.ffi_type_pointer, LibFFI.ffi_type_pointer, LibFFI.ffi_type_pointer);
                }

                @Override
                public void callback(long l2, long l3) {
                    long l4 = MemoryUtil.memGetAddress(MemoryUtil.memGetAddress(l3));
                    long l5 = MemoryUtil.memGetAddress(MemoryUtil.memGetAddress(l3 + (long)POINTER_SIZE));
                    MemoryUtil.memPutAddress(l2, this.realloc(l4, l5));
                }
            }.address(), new CallbackI(){

                @Override
                public FFICIF getCallInterface() {
                    return APIUtil.apiCreateCIF(LibFFI.FFI_DEFAULT_ABI, LibFFI.ffi_type_void, LibFFI.ffi_type_pointer);
                }

                @Override
                public void callback(long l2, long l3) {
                    long l4 = MemoryUtil.memGetAddress(MemoryUtil.memGetAddress(l3));
                    this.free(l4);
                }
            }.address(), new CallbackI(){

                @Override
                public FFICIF getCallInterface() {
                    return APIUtil.apiCreateCIF(LibFFI.FFI_DEFAULT_ABI, LibFFI.ffi_type_pointer, LibFFI.ffi_type_pointer, LibFFI.ffi_type_pointer);
                }

                @Override
                public void callback(long l2, long l3) {
                    long l4 = MemoryUtil.memGetAddress(MemoryUtil.memGetAddress(l3));
                    long l5 = MemoryUtil.memGetAddress(MemoryUtil.memGetAddress(l3 + (long)POINTER_SIZE));
                    MemoryUtil.memPutAddress(l2, this.aligned_alloc(l4, l5));
                }
            }.address(), new CallbackI(){

                @Override
                public FFICIF getCallInterface() {
                    return APIUtil.apiCreateCIF(LibFFI.FFI_DEFAULT_ABI, LibFFI.ffi_type_void, LibFFI.ffi_type_pointer);
                }

                @Override
                public void callback(long l2, long l3) {
                    long l4 = MemoryUtil.memGetAddress(MemoryUtil.memGetAddress(l3));
                    this.aligned_free(l4);
                }
            }.address()};
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                long[] lArray = this.callbacks;
                int n2 = this.callbacks.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    Callback.free(lArray[i2]);
                }
                if (ALLOCATIONS.isEmpty()) {
                    return;
                }
                boolean bl = false;
                for (StackTraceElement[] stackTraceElementArray : ALLOCATIONS.keySet()) {
                    StringBuilder stringBuilder = new StringBuilder(512);
                    stringBuilder.append("[LWJGL] ").append(stackTraceElementArray.size).append(" bytes leaked, thread ").append(stackTraceElementArray.threadId).append(" (").append((String)THREADS.get(stackTraceElementArray.threadId)).append("), address: 0x").append(Long.toHexString(stackTraceElementArray.address).toUpperCase()).append("\n");
                    StackTraceElement[] stackTraceElementArray2 = ((Allocation)stackTraceElementArray).getElements();
                    if (stackTraceElementArray2 != null) {
                        stackTraceElementArray = stackTraceElementArray2;
                        int n3 = stackTraceElementArray2.length;
                        for (int i3 = 0; i3 < n3; ++i3) {
                            StackTraceElement stackTraceElement = stackTraceElementArray[i3];
                            stringBuilder.append("\tat ").append(((Object)stackTraceElement).toString()).append("\n");
                        }
                        continue;
                    }
                    bl = true;
                }
                if (bl) {
                }
            }));
        }

        @Override
        public long getMalloc() {
            return this.callbacks[0];
        }

        @Override
        public long getCalloc() {
            return this.callbacks[1];
        }

        @Override
        public long getRealloc() {
            return this.callbacks[2];
        }

        @Override
        public long getFree() {
            return this.callbacks[3];
        }

        @Override
        public long getAlignedAlloc() {
            return this.callbacks[4];
        }

        @Override
        public long getAlignedFree() {
            return this.callbacks[5];
        }

        @Override
        public long malloc(long l2) {
            return DebugAllocator.track(this.allocator.malloc(l2), l2);
        }

        @Override
        public long calloc(long l2, long l3) {
            return DebugAllocator.track(this.allocator.calloc(l2, l3), l2 * l3);
        }

        @Override
        public long realloc(long l2, long l3) {
            long l4 = DebugAllocator.untrack(l2);
            long l5 = this.allocator.realloc(l2, l3);
            if (l5 != 0L) {
                DebugAllocator.track(l5, l3);
            } else if (l3 != 0L) {
                DebugAllocator.track(l2, l4);
            }
            return l5;
        }

        @Override
        public void free(long l2) {
            DebugAllocator.untrack(l2);
            this.allocator.free(l2);
        }

        @Override
        public long aligned_alloc(long l2, long l3) {
            return DebugAllocator.track(this.allocator.aligned_alloc(l2, l3), l3);
        }

        @Override
        public void aligned_free(long l2) {
            DebugAllocator.untrack(l2);
            this.allocator.aligned_free(l2);
        }

        static long track(long l2, long l3) {
            if (l2 != 0L) {
                Allocation allocation;
                Thread thread = Thread.currentThread();
                THREADS.putIfAbsent(thread.getId(), thread.getName());
                Allocation allocation2 = allocation = new Allocation(l2, l3, thread.getId(), Configuration.DEBUG_MEMORY_ALLOCATOR_FAST.get(Boolean.FALSE) != false ? null : StackWalkUtil.stackWalkGetTrace());
                Allocation allocation3 = ALLOCATIONS.put(allocation2, allocation2);
                if (allocation3 != null) {
                    DebugAllocator.trackAbort(l2, allocation3, allocation);
                }
            }
            return l2;
        }

        private static void trackAbort(long l2, Allocation allocation, Allocation allocation2) {
            String string = Long.toHexString(l2).toUpperCase();
            DebugAllocator.trackAbortPrint(allocation, "Old", string);
            DebugAllocator.trackAbortPrint(allocation2, "New", string);
            throw new IllegalStateException("The memory address specified is already being tracked: 0x".concat(String.valueOf(string)));
        }

        private static void trackAbortPrint(Allocation stackTraceElementArray, String string, String string2) {
            StringBuilder stringBuilder = new StringBuilder(512);
            stringBuilder.append("[LWJGL] ").append(string).append(" allocation with size ").append(stackTraceElementArray.size).append(", thread ").append(stackTraceElementArray.threadId).append(" (").append((String)THREADS.get(stackTraceElementArray.threadId)).append("), address: 0x").append(string2).append("\n");
            stackTraceElementArray = ((Allocation)stackTraceElementArray).getElements();
            if (stackTraceElementArray != null) {
                for (StackTraceElement stackTraceElement : stackTraceElementArray) {
                    stringBuilder.append("\tat ").append(((Object)stackTraceElement).toString()).append("\n");
                }
            }
        }

        static long untrack(long l2) {
            if (l2 == 0L) {
                return 0L;
            }
            Allocation allocation = (Allocation)ALLOCATIONS.remove(new Allocation(l2, 0L, 0L, null));
            if (allocation == null) {
                DebugAllocator.untrackAbort(l2);
            }
            return allocation.size;
        }

        private static void untrackAbort(long l2) {
            String string = Long.toHexString(l2).toUpperCase();
            throw new IllegalStateException("The memory address specified is not being tracked: 0x".concat(String.valueOf(string)));
        }

        static void report(MemoryUtil.MemoryAllocationReport memoryAllocationReport) {
            for (Allocation allocation : ALLOCATIONS.keySet()) {
                memoryAllocationReport.invoke(allocation.address, allocation.size, allocation.threadId, (String)THREADS.get(allocation.threadId), allocation.getElements());
            }
        }

        private static <T> void aggregate(T t2, long l2, Map<T, AtomicLong> map) {
            AtomicLong atomicLong = map.computeIfAbsent(t2, object -> new AtomicLong());
            atomicLong.set(atomicLong.get() + l2);
        }

        static void report(MemoryUtil.MemoryAllocationReport memoryAllocationReport, MemoryUtil.MemoryAllocationReport.Aggregate aggregate, boolean bl) {
            switch (aggregate) {
                case ALL: {
                    DebugAllocator.reportAll(memoryAllocationReport, bl);
                    return;
                }
                case GROUP_BY_METHOD: {
                    DebugAllocator.reportByMethod(memoryAllocationReport, bl);
                    return;
                }
                case GROUP_BY_STACKTRACE: {
                    DebugAllocator.reportByStacktrace(memoryAllocationReport, bl);
                }
            }
        }

        private static void reportAll(MemoryUtil.MemoryAllocationReport memoryAllocationReport, boolean bl) {
            if (bl) {
                HashMap hashMap = new HashMap();
                for (Allocation allocation : ALLOCATIONS.values()) {
                    DebugAllocator.aggregate(allocation.threadId, allocation.size, hashMap);
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    memoryAllocationReport.invoke(0L, ((AtomicLong)entry.getValue()).get(), (Long)entry.getKey(), (String)THREADS.get(entry.getKey()), null);
                }
                return;
            }
            long l2 = 0L;
            for (Allocation allocation : ALLOCATIONS.values()) {
                l2 += allocation.size;
            }
            memoryAllocationReport.invoke(0L, l2, 0L, null, null);
        }

        private static void reportByMethod(MemoryUtil.MemoryAllocationReport memoryAllocationReport, boolean bl) {
            if (bl) {
                Object object = new HashMap<Long, Map>();
                for (Allocation object2 : ALLOCATIONS.keySet()) {
                    StackTraceElement[] stackTraceElementArray = object2.getElements();
                    if (stackTraceElementArray == null) continue;
                    Map map = object.computeIfAbsent(object2.threadId, l2 -> new HashMap());
                    DebugAllocator.aggregate(stackTraceElementArray[0], object2.size, map);
                }
                for (Map.Entry entry : object.entrySet()) {
                    long l3 = (Long)entry.getKey();
                    object = (String)THREADS.get(l3);
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        memoryAllocationReport.invoke(0L, ((AtomicLong)entry2.getValue()).get(), l3, (String)object, (StackTraceElement)entry2.getKey());
                    }
                }
                return;
            }
            HashMap hashMap = new HashMap();
            for (Allocation allocation : ALLOCATIONS.keySet()) {
                StackTraceElement[] stackTraceElementArray = allocation.getElements();
                if (stackTraceElementArray == null) continue;
                DebugAllocator.aggregate(stackTraceElementArray[0], allocation.size, hashMap);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                memoryAllocationReport.invoke(0L, ((AtomicLong)entry.getValue()).get(), 0L, null, (StackTraceElement)entry.getKey());
            }
        }

        private static void reportByStacktrace(MemoryUtil.MemoryAllocationReport memoryAllocationReport, boolean bl) {
            if (bl) {
                Object object = new HashMap<Long, Map>();
                for (Allocation object2 : ALLOCATIONS.keySet()) {
                    StackTraceElement[] stackTraceElementArray = object2.getElements();
                    if (stackTraceElementArray == null) continue;
                    Map map = object.computeIfAbsent(object2.threadId, l2 -> new HashMap());
                    DebugAllocator.aggregate(new AllocationKey(stackTraceElementArray), object2.size, map);
                }
                for (Map.Entry entry : object.entrySet()) {
                    long l3 = (Long)entry.getKey();
                    object = ((Map)entry.getValue()).entrySet().iterator();
                    while (object.hasNext()) {
                        Map.Entry entry2 = (Map.Entry)object.next();
                        memoryAllocationReport.invoke(0L, ((AtomicLong)entry2.getValue()).get(), l3, (String)THREADS.get(l3), ((AllocationKey)entry2.getKey()).elements);
                    }
                }
                return;
            }
            HashMap hashMap = new HashMap();
            for (Allocation allocation : ALLOCATIONS.keySet()) {
                StackTraceElement[] stackTraceElementArray = allocation.getElements();
                if (stackTraceElementArray == null) continue;
                DebugAllocator.aggregate(new AllocationKey(stackTraceElementArray), allocation.size, hashMap);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                memoryAllocationReport.invoke(0L, ((AtomicLong)entry.getValue()).get(), 0L, null, ((AllocationKey)entry.getKey()).elements);
            }
        }

        static class AllocationKey {
            final StackTraceElement[] elements;

            AllocationKey(StackTraceElement[] stackTraceElementArray) {
                this.elements = stackTraceElementArray;
            }

            public boolean equals(Object object) {
                return this == object || Arrays.equals(this.elements, ((AllocationKey)object).elements);
            }

            public int hashCode() {
                return Arrays.hashCode(this.elements);
            }
        }

        static class Allocation {
            final long address;
            final long size;
            final long threadId;
            private final Object @Nullable [] stacktrace;

            Allocation(long l2, long l3, long l4, Object @Nullable [] objectArray) {
                this.address = l2;
                this.size = l3;
                this.threadId = l4;
                this.stacktrace = objectArray;
            }

            private StackTraceElement @Nullable [] getElements() {
                if (this.stacktrace == null) {
                    return null;
                }
                return StackWalkUtil.stackWalkArray(this.stacktrace);
            }

            public boolean equals(Object object) {
                return this.address == ((Allocation)object).address;
            }

            public int hashCode() {
                return Long.hashCode(this.address);
            }
        }
    }

    static class StdlibAllocator
    implements MemoryUtil.MemoryAllocator {
        private StdlibAllocator() {
        }

        @Override
        public long getMalloc() {
            return MemoryAccessJNI.malloc;
        }

        @Override
        public long getCalloc() {
            return MemoryAccessJNI.calloc;
        }

        @Override
        public long getRealloc() {
            return MemoryAccessJNI.realloc;
        }

        @Override
        public long getFree() {
            return MemoryAccessJNI.free;
        }

        @Override
        public long getAlignedAlloc() {
            return MemoryAccessJNI.aligned_alloc;
        }

        @Override
        public long getAlignedFree() {
            return MemoryAccessJNI.aligned_free;
        }

        @Override
        public long malloc(long l2) {
            return LibCStdlib.nmalloc(l2);
        }

        @Override
        public long calloc(long l2, long l3) {
            return LibCStdlib.ncalloc(l2, l3);
        }

        @Override
        public long realloc(long l2, long l3) {
            return LibCStdlib.nrealloc(l2, l3);
        }

        @Override
        public void free(long l2) {
            LibCStdlib.nfree(l2);
        }

        @Override
        public long aligned_alloc(long l2, long l3) {
            return LibCStdlib.naligned_alloc(l2, l3);
        }

        @Override
        public void aligned_free(long l2) {
            LibCStdlib.naligned_free(l2);
        }
    }
}

