/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.CallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.MemoryManage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.jni.JNINativeInterface;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIClosure;
import org.lwjgl.system.libffi.LibFFI;

public abstract class Callback
implements NativeResource,
Pointer {
    private static final boolean DEBUG_ALLOCATOR = Configuration.DEBUG_MEMORY_ALLOCATOR.get(Boolean.FALSE);
    private static final ClosureRegistry CLOSURE_REGISTRY;
    private static final long CALLBACK_HANDLER;
    private long address;

    public Callback(FFICIF fFICIF) {
        this.address = Callback.create(fFICIF, this);
    }

    public Callback(long l2) {
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        this.address = l2;
    }

    @Override
    public long address() {
        return this.address;
    }

    @Override
    public void free() {
        Callback.free(this.address());
    }

    private static native long getCallbackHandler(Method var0);

    static long create(FFICIF fFICIF, Object object) {
        long l2;
        FFIClosure fFIClosure;
        MemoryStack memoryStack = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
            fFIClosure = LibFFI.ffi_closure_alloc(FFIClosure.SIZEOF, pointerBuffer);
            if (fFIClosure == null) {
                throw new OutOfMemoryError();
            }
            l2 = pointerBuffer.get(0);
            if (DEBUG_ALLOCATOR) {
                MemoryManage.DebugAllocator.track(l2, FFIClosure.SIZEOF);
            }
            if (memoryStack != null) {
                memoryStack.close();
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (memoryStack != null) {
                    if (throwable != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        memoryStack.close();
                    }
                }
                throw throwable4;
            }
        }
        long l3 = JNINativeInterface.NewGlobalRef(object);
        if (LibFFI.ffi_prep_closure_loc(fFIClosure, fFICIF, CALLBACK_HANDLER, l3, l2) != 0) {
            JNINativeInterface.DeleteGlobalRef(l3);
            LibFFI.ffi_closure_free(fFIClosure);
            throw new RuntimeException("Failed to prepare the libffi closure");
        }
        CLOSURE_REGISTRY.put(l2, fFIClosure);
        return l2;
    }

    public static <T extends CallbackI> T get(long l2) {
        return (T)((CallbackI)MemoryUtil.memGlobalRefToObject(CLOSURE_REGISTRY.get(l2).user_data()));
    }

    public static <T extends CallbackI> @Nullable T getSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return Callback.get(l2);
    }

    public static void free(long l2) {
        if (DEBUG_ALLOCATOR) {
            MemoryManage.DebugAllocator.untrack(l2);
        }
        FFIClosure fFIClosure = CLOSURE_REGISTRY.remove(l2);
        JNINativeInterface.DeleteGlobalRef(fFIClosure.user_data());
        LibFFI.ffi_closure_free(fFIClosure);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Callback)) {
            return false;
        }
        return this.address == ((Callback)(object = (Callback)object)).address();
    }

    public int hashCode() {
        return (int)(this.address ^ this.address >>> 32);
    }

    public String toString() {
        return String.format("%s pointer [0x%X]", this.getClass().getSimpleName(), this.address);
    }

    static {
        MemoryStack memoryStack = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
            FFIClosure fFIClosure = LibFFI.ffi_closure_alloc(FFIClosure.SIZEOF, pointerBuffer);
            if (fFIClosure == null) {
                throw new OutOfMemoryError();
            }
            if (pointerBuffer.get(0) == fFIClosure.address()) {
                APIUtil.apiLog("Closure Registry: simple");
                CLOSURE_REGISTRY = new ClosureRegistry(){

                    @Override
                    public final void put(long l2, FFIClosure fFIClosure) {
                    }

                    @Override
                    public final FFIClosure get(long l2) {
                        return FFIClosure.create(l2);
                    }

                    @Override
                    public final FFIClosure remove(long l2) {
                        return this.get(l2);
                    }
                };
            } else {
                APIUtil.apiLog("Closure Registry: ConcurrentHashMap");
                CLOSURE_REGISTRY = new ClosureRegistry(){
                    private final ConcurrentHashMap<Long, FFIClosure> map = new ConcurrentHashMap();

                    @Override
                    public final void put(long l2, FFIClosure fFIClosure) {
                        this.map.put(l2, fFIClosure);
                    }

                    @Override
                    public final FFIClosure get(long l2) {
                        return this.map.get(l2);
                    }

                    @Override
                    public final FFIClosure remove(long l2) {
                        return this.map.remove(l2);
                    }
                };
            }
            LibFFI.ffi_closure_free(fFIClosure);
            if (memoryStack != null) {
                memoryStack.close();
            }
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (memoryStack != null) {
                    if (throwable != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        memoryStack.close();
                    }
                }
                throw throwable4;
            }
        }
        try {
            CALLBACK_HANDLER = Callback.getCallbackHandler(CallbackI.class.getDeclaredMethod("callback", Long.TYPE, Long.TYPE));
        }
        catch (Exception exception) {
            throw new IllegalStateException("Failed to initialize the native callback handler.", exception);
        }
        MemoryUtil.getAllocator();
    }

    static interface ClosureRegistry {
        public void put(long var1, FFIClosure var3);

        public FFIClosure get(long var1);

        public FFIClosure remove(long var1);
    }
}

