/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.freebsd.FreeBSDLibrary;
import org.lwjgl.system.libffi.FFICIF;
import org.lwjgl.system.libffi.FFIType;
import org.lwjgl.system.libffi.LibFFI;
import org.lwjgl.system.linux.LinuxLibrary;
import org.lwjgl.system.macosx.MacOSXLibrary;
import org.lwjgl.system.windows.WindowsLibrary;

public final class APIUtil {
    public static final PrintStream DEBUG_STREAM = APIUtil.getDebugStream();
    private static final Pattern API_VERSION_PATTERN;

    private static PrintStream getDebugStream() {
        PrintStream printStream = System.err;
        Object object = Configuration.DEBUG_STREAM.get();
        if (object instanceof String) {
            try {
                printStream = (PrintStream)((Supplier)Class.forName((String)object).getConstructor(new Class[0]).newInstance(new Object[0])).get();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (object instanceof Supplier) {
            printStream = (PrintStream)((Supplier)object).get();
        } else if (object instanceof PrintStream) {
            printStream = (PrintStream)object;
        }
        return printStream;
    }

    private APIUtil() {
    }

    public static void apiLog(CharSequence charSequence) {
        if (Checks.DEBUG) {
            new StringBuilder("[LWJGL] ").append((Object)charSequence).append("\n");
        }
    }

    public static void apiLogMore(CharSequence charSequence) {
        if (Checks.DEBUG) {
            new StringBuilder("\t").append((Object)charSequence).append("\n");
        }
    }

    public static void apiLogMissing(String string, ByteBuffer object) {
        if (Checks.DEBUG) {
            ByteBuffer byteBuffer = object;
            object = MemoryUtil.memASCII(byteBuffer, byteBuffer.remaining() - 1);
            new StringBuilder("[LWJGL] Failed to locate address for ").append(string).append(" function ").append((String)object).append("\n");
        }
    }

    public static String apiFindLibrary(String object, String string) {
        String string2;
        block12: {
            Object object2 = Platform.get().mapLibraryName(string);
            object = Files.find(Paths.get((String)object, new String[0]).toAbsolutePath(), Integer.MAX_VALUE, (arg_0, arg_1) -> APIUtil.lambda$apiFindLibrary$0((String)object2, arg_0, arg_1), new FileVisitOption[0]);
            object2 = null;
            try {
                string2 = object.findFirst().map(Path::toString).orElse(string);
                if (object == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        Throwable throwable2 = throwable;
                        object2 = throwable;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (object != null) {
                            if (object2 != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable4) {
                                    ((Throwable)object2).addSuppressed(throwable4);
                                }
                            } else {
                                object.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                catch (IOException iOException) {
                    return string;
                }
            }
            object.close();
        }
        return string2;
    }

    public static SharedLibrary apiCreateLibrary(String string) {
        switch (Platform.get()) {
            case FREEBSD: {
                return new FreeBSDLibrary(string);
            }
            case LINUX: {
                return new LinuxLibrary(string);
            }
            case MACOSX: {
                return MacOSXLibrary.create(string);
            }
            case WINDOWS: {
                return new WindowsLibrary(string);
            }
        }
        throw new IllegalStateException();
    }

    public static long apiGetFunctionAddress(FunctionProvider functionProvider, String string) {
        long l2 = functionProvider.getFunctionAddress(string);
        if (l2 == 0L) {
            APIUtil.requiredFunctionMissing(string);
        }
        return l2;
    }

    private static void requiredFunctionMissing(String string) {
        if (!Configuration.DISABLE_FUNCTION_CHECKS.get(Boolean.FALSE).booleanValue()) {
            throw new NullPointerException("A required function is missing: ".concat(String.valueOf(string)));
        }
    }

    public static long apiGetFunctionAddressOptional(SharedLibrary sharedLibrary, String string) {
        long l2 = sharedLibrary.getFunctionAddress(string);
        if (Checks.DEBUG_FUNCTIONS && l2 == 0L) {
            APIUtil.optionalFunctionMissing(sharedLibrary, string);
        }
        return l2;
    }

    private static void optionalFunctionMissing(SharedLibrary sharedLibrary, String string) {
        if (Checks.DEBUG) {
            new StringBuilder("[LWJGL] Failed to locate address for ").append(sharedLibrary.getName()).append(" function ").append(string).append("\n");
        }
    }

    public static @Nullable ByteBuffer apiGetMappedBuffer(@Nullable ByteBuffer byteBuffer, long l2, int n2) {
        if (byteBuffer != null && MemoryUtil.memAddress(byteBuffer) == l2 && byteBuffer.capacity() == n2) {
            return byteBuffer;
        }
        if (l2 == 0L) {
            return null;
        }
        return MemoryUtil.wrapBufferByte(l2, n2);
    }

    public static long apiGetBytes(int n2, int n3) {
        return ((long)n2 & 0xFFFFFFFFL) << n3;
    }

    public static long apiCheckAllocation(int n2, long l2, long l3) {
        if (Checks.DEBUG) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Invalid number of elements");
            }
            if (l3 + Long.MIN_VALUE < l2 + Long.MIN_VALUE) {
                throw new IllegalArgumentException("The request allocation is too large");
            }
        }
        return l2;
    }

    public static @Nullable APIVersion apiParseVersion(Configuration<?> object) {
        object = (object = ((Configuration)object).get()) instanceof String ? APIUtil.apiParseVersion((String)object) : (object instanceof APIVersion ? (APIVersion)object : null);
        return object;
    }

    public static APIVersion apiParseVersion(String string) {
        Matcher matcher = API_VERSION_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Malformed API version string [%s]", string));
        }
        return new APIVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3), matcher.group(4));
    }

    public static void apiFilterExtensions(Set<String> set, Configuration<Object> object) {
        Object t2 = ((Configuration)object).get();
        if (t2 == null) {
            return;
        }
        if (t2 instanceof String) {
            String exception = (String)t2;
            if (exception.indexOf(46) != -1) {
                try {
                    Predicate predicate = (Predicate)Class.forName(exception).newInstance();
                    set.removeIf(predicate);
                    return;
                }
                catch (Exception exception2) {
                    throw new RuntimeException(exception2);
                }
            }
            for (String string : exception.split(",")) {
                set.remove(string);
            }
            return;
        }
        if (t2 instanceof List) {
            List list = (List)t2;
            set.removeAll(list);
            return;
        }
        if (t2 instanceof Predicate) {
            Predicate predicate = (Predicate)t2;
            set.removeIf(predicate);
            return;
        }
        throw new IllegalStateException("Unsupported " + ((Configuration)object).getProperty() + " value specified.");
    }

    public static String apiUnknownToken(int n2) {
        return APIUtil.apiUnknownToken("Unknown", n2);
    }

    public static String apiUnknownToken(String string, int n2) {
        return String.format("%s [0x%X]", string, n2);
    }

    public static Map<Integer, String> apiClassTokens(@Nullable BiPredicate<Field, Integer> biPredicate, @Nullable Map<Integer, String> map, Class<?> ... classArray) {
        if (map == null) {
            map = new HashMap<Integer, String>(64);
        }
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            for (Field field : classArray[i2].getDeclaredFields()) {
                if ((field.getModifiers() & 0x19) != 25 || field.getType() != Integer.TYPE) continue;
                try {
                    Integer n3 = field.getInt(null);
                    if (biPredicate != null && !biPredicate.test(field, n3)) continue;
                    String string = map.get(n3);
                    map.put(n3, string == null ? field.getName() : string + "|" + field.getName());
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        }
        return map;
    }

    public static long apiArray(MemoryStack default_, long ... lArray) {
        default_ = MemoryUtil.memPointerBuffer(((MemoryStack)default_).nmalloc(MemoryStack.POINTER_SIZE, lArray.length << MemoryStack.POINTER_SHIFT), lArray.length);
        for (long l2 : lArray) {
            ((PointerBuffer)default_).put(l2);
        }
        return default_.address;
    }

    public static long apiArray(MemoryStack default_, ByteBuffer ... byteBufferArray) {
        default_ = MemoryUtil.memPointerBuffer(((MemoryStack)default_).nmalloc(MemoryStack.POINTER_SIZE, byteBufferArray.length << MemoryStack.POINTER_SHIFT), byteBufferArray.length);
        for (ByteBuffer byteBuffer : byteBufferArray) {
            ((PointerBuffer)default_).put(byteBuffer);
        }
        return default_.address;
    }

    public static long apiArrayp(MemoryStack default_, ByteBuffer ... byteBufferArray) {
        long l2 = APIUtil.apiArray((MemoryStack)default_, byteBufferArray);
        default_ = ((MemoryStack)default_).mallocPointer(byteBufferArray.length);
        for (ByteBuffer byteBuffer : byteBufferArray) {
            ((PointerBuffer)default_).put(byteBuffer.remaining());
        }
        return l2;
    }

    public static long apiArray(MemoryStack default_, Encoder encoder, CharSequence ... charSequenceArray) {
        default_ = ((MemoryStack)default_).mallocPointer(charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            ((PointerBuffer)default_).put(encoder.encode(charSequence, true));
        }
        return default_.address;
    }

    public static long apiArrayi(MemoryStack object, Encoder encoder, CharSequence ... charSequenceArray) {
        PointerBuffer pointerBuffer = ((MemoryStack)object).mallocPointer(charSequenceArray.length);
        object = ((MemoryStack)object).mallocInt(charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            ByteBuffer object2 = encoder.encode(charSequence, false);
            pointerBuffer.put(object2);
            ((IntBuffer)object).put(object2.capacity());
        }
        return pointerBuffer.address;
    }

    public static long apiArrayp(MemoryStack default_, Encoder encoder, CharSequence ... charSequenceArray) {
        PointerBuffer pointerBuffer = ((MemoryStack)default_).mallocPointer(charSequenceArray.length);
        default_ = ((MemoryStack)default_).mallocPointer(charSequenceArray.length);
        for (CharSequence charSequence : charSequenceArray) {
            ByteBuffer object = encoder.encode(charSequence, false);
            pointerBuffer.put(object);
            ((PointerBuffer)default_).put(object.capacity());
        }
        return pointerBuffer.address;
    }

    public static void apiArrayFree(long l2, int n2) {
        while (--n2 >= 0) {
            MemoryUtil.nmemFree(MemoryUtil.memGetAddress(l2 + Integer.toUnsignedLong(n2) * (long)MemoryStack.POINTER_SIZE));
        }
    }

    public static FFIType apiCreateStruct(FFIType ... fFITypeArray) {
        MemoryUtil.MemoryAllocator memoryAllocator = MemoryUtil.getAllocator();
        PointerBuffer pointerBuffer = PointerBuffer.create(memoryAllocator.malloc((fFITypeArray.length + 1) * MemoryStack.POINTER_SIZE), fFITypeArray.length + 1);
        for (int i2 = 0; i2 < fFITypeArray.length; ++i2) {
            pointerBuffer.put(i2, fFITypeArray[i2]);
        }
        pointerBuffer.put(fFITypeArray.length, 0L);
        return FFIType.create(memoryAllocator.calloc(1L, FFIType.SIZEOF)).type((short)13).elements(pointerBuffer);
    }

    private static FFIType prep(FFIType object) {
        MemoryStack memoryStack = MemoryStack.stackPush();
        Throwable throwable = null;
        try {
            if (LibFFI.ffi_prep_cif(FFICIF.calloc(memoryStack), LibFFI.FFI_DEFAULT_ABI, (FFIType)object, null) != 0) {
                throw new IllegalStateException("Failed to prepare LibFFI type.");
            }
            if (memoryStack != null) {
                memoryStack.close();
            }
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (memoryStack != null) {
                    if (throwable != null) {
                        try {
                            memoryStack.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        memoryStack.close();
                    }
                }
                throw throwable3;
            }
        }
        return object;
    }

    public static FFIType apiCreateUnion(FFIType ... fFITypeArray) {
        MemoryUtil.MemoryAllocator memoryAllocator = MemoryUtil.getAllocator();
        FFIType fFIType = APIUtil.prep(fFITypeArray[0]);
        short s2 = fFITypeArray[0].alignment();
        for (int i2 = 1; i2 < fFITypeArray.length; ++i2) {
            FFIType fFIType2 = APIUtil.prep(fFITypeArray[i2]);
            if (fFIType.size() < fFIType2.size()) {
                fFIType = fFIType2;
            }
            if (s2 >= fFIType2.alignment()) continue;
            s2 = fFIType2.alignment();
        }
        return FFIType.create(memoryAllocator.malloc(FFIType.SIZEOF)).size(fFIType.size()).alignment(s2).type((short)13).elements(PointerBuffer.create(memoryAllocator.malloc(2 * MemoryStack.POINTER_SIZE), 2).put(0, fFIType).put(1, 0L));
    }

    public static FFIType apiCreateArray(FFIType fFIType, int n2) {
        MemoryUtil.MemoryAllocator memoryAllocator = MemoryUtil.getAllocator();
        PointerBuffer pointerBuffer = PointerBuffer.create(memoryAllocator.malloc((n2 + 1) * MemoryStack.POINTER_SIZE), n2 + 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            pointerBuffer.put(i2, fFIType);
        }
        pointerBuffer.put(n2, 0L);
        return FFIType.create(memoryAllocator.calloc(1L, FFIType.SIZEOF)).type((short)13).elements(pointerBuffer);
    }

    public static FFICIF apiCreateCIF(int n2, FFIType fFIType, FFIType ... fFITypeArray) {
        MemoryUtil.MemoryAllocator memoryAllocator = MemoryUtil.getAllocator();
        PointerBuffer pointerBuffer = PointerBuffer.create(memoryAllocator.malloc(fFITypeArray.length * MemoryStack.POINTER_SIZE), fFITypeArray.length);
        for (int i2 = 0; i2 < fFITypeArray.length; ++i2) {
            pointerBuffer.put(i2, fFITypeArray[i2]);
        }
        FFICIF fFICIF = FFICIF.create(memoryAllocator.malloc(FFICIF.SIZEOF));
        n2 = LibFFI.ffi_prep_cif(fFICIF, n2, fFIType, pointerBuffer);
        if (n2 != 0) {
            throw new IllegalStateException("Failed to prepare libffi CIF: ".concat(String.valueOf(n2)));
        }
        return fFICIF;
    }

    public static FFICIF apiCreateCIFVar(int n2, int n3, FFIType fFIType, FFIType ... fFITypeArray) {
        MemoryUtil.MemoryAllocator memoryAllocator = MemoryUtil.getAllocator();
        PointerBuffer pointerBuffer = PointerBuffer.create(memoryAllocator.malloc(fFITypeArray.length * MemoryStack.POINTER_SIZE), fFITypeArray.length);
        for (int i2 = 0; i2 < fFITypeArray.length; ++i2) {
            pointerBuffer.put(i2, fFITypeArray[i2]);
        }
        FFICIF fFICIF = FFICIF.create(memoryAllocator.malloc(FFICIF.SIZEOF));
        n2 = LibFFI.ffi_prep_cif_var(fFICIF, n2, n3, fFIType, pointerBuffer);
        if (n2 != 0) {
            throw new IllegalStateException("Failed to prepare libffi var CIF: ".concat(String.valueOf(n2)));
        }
        return fFICIF;
    }

    public static int apiStdcall() {
        if (Platform.get() == Platform.WINDOWS && Pointer.BITS32) {
            return LibFFI.FFI_STDCALL;
        }
        return LibFFI.FFI_DEFAULT_ABI;
    }

    public static void apiClosureRet(long l2, boolean bl) {
        MemoryUtil.memPutAddress(l2, bl ? 1L : 0L);
    }

    public static void apiClosureRet(long l2, byte by) {
        MemoryUtil.memPutAddress(l2, (long)by & 0xFFL);
    }

    public static void apiClosureRet(long l2, short s2) {
        MemoryUtil.memPutAddress(l2, (long)s2 & 0xFFFFL);
    }

    public static void apiClosureRet(long l2, int n2) {
        MemoryUtil.memPutAddress(l2, (long)n2 & 0xFFFFFFFFL);
    }

    public static void apiClosureRetL(long l2, long l3) {
        MemoryUtil.memPutLong(l2, l3);
    }

    public static void apiClosureRetP(long l2, long l3) {
        MemoryUtil.memPutAddress(l2, l3);
    }

    public static void apiClosureRet(long l2, float f2) {
        MemoryUtil.memPutFloat(l2, f2);
    }

    public static void apiClosureRet(long l2, double d2) {
        MemoryUtil.memPutDouble(l2, d2);
    }

    private static /* synthetic */ boolean lambda$apiFindLibrary$0(String string, Path path, BasicFileAttributes basicFileAttributes) {
        return basicFileAttributes.isRegularFile() && path.getFileName().toString().equals(string);
    }

    static {
        String string = "[^\\d\\n\\r]*";
        String string2 = "(\\d+)[.](\\d+)(?:[.](\\S+))?";
        String string3 = "(?:\\s+(.+?))?\\s*";
        API_VERSION_PATTERN = Pattern.compile("^" + string + string2 + string3 + "$", 32);
    }

    public static interface Encoder {
        public ByteBuffer encode(CharSequence var1, boolean var2);
    }

    public static class APIVersion
    implements Comparable<APIVersion> {
        public final int major;
        public final int minor;
        public final @Nullable String revision;
        public final @Nullable String implementation;

        public APIVersion(int n2, int n3) {
            this(n2, n3, null, null);
        }

        public APIVersion(int n2, int n3, @Nullable String string, @Nullable String string2) {
            this.major = n2;
            this.minor = n3;
            this.revision = string;
            this.implementation = string2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(16);
            stringBuilder.append(this.major).append('.').append(this.minor);
            if (this.revision != null) {
                stringBuilder.append('.').append(this.revision);
            }
            if (this.implementation != null) {
                stringBuilder.append(" (").append(this.implementation).append(')');
            }
            return stringBuilder.toString();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof APIVersion)) {
                return false;
            }
            object = (APIVersion)object;
            return this.major == ((APIVersion)object).major && this.minor == ((APIVersion)object).major && Objects.equals(this.revision, ((APIVersion)object).revision) && Objects.equals(this.implementation, ((APIVersion)object).implementation);
        }

        public int hashCode() {
            return ((this.major * 31 + this.minor) * 31 + (this.revision != null ? this.revision.hashCode() : 0)) * 31 + (this.implementation != null ? this.implementation.hashCode() : 0);
        }

        @Override
        public int compareTo(APIVersion aPIVersion) {
            if (this.major != aPIVersion.major) {
                return Integer.compare(this.major, aPIVersion.major);
            }
            if (this.minor != aPIVersion.minor) {
                return Integer.compare(this.minor, aPIVersion.minor);
            }
            return 0;
        }
    }
}

