/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbtt__bitmap")
public class STBTTBitmap
extends Struct<STBTTBitmap>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int W;
    public static final int H;
    public static final int STRIDE;
    public static final int PIXELS;

    protected STBTTBitmap(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected STBTTBitmap create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new STBTTBitmap(l2, byteBuffer);
    }

    public STBTTBitmap(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBTTBitmap.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int w() {
        return STBTTBitmap.nw(this.address());
    }

    public int h() {
        return STBTTBitmap.nh(this.address());
    }

    public int stride() {
        return STBTTBitmap.nstride(this.address());
    }

    @NativeType(value="unsigned char *")
    public ByteBuffer pixels(int n2) {
        return STBTTBitmap.npixels(this.address(), n2);
    }

    public STBTTBitmap w(int n2) {
        STBTTBitmap.nw(this.address(), n2);
        return this;
    }

    public STBTTBitmap h(int n2) {
        STBTTBitmap.nh(this.address(), n2);
        return this;
    }

    public STBTTBitmap stride(int n2) {
        STBTTBitmap.nstride(this.address(), n2);
        return this;
    }

    public STBTTBitmap pixels(@NativeType(value="unsigned char *") ByteBuffer byteBuffer) {
        STBTTBitmap.npixels(this.address(), byteBuffer);
        return this;
    }

    public STBTTBitmap set(int n2, int n3, int n4, ByteBuffer byteBuffer) {
        this.w(n2);
        this.h(n3);
        this.stride(n4);
        this.pixels(byteBuffer);
        return this;
    }

    public STBTTBitmap set(STBTTBitmap sTBTTBitmap) {
        MemoryUtil.memCopy(sTBTTBitmap.address(), this.address(), SIZEOF);
        return this;
    }

    public static STBTTBitmap malloc() {
        return new STBTTBitmap(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static STBTTBitmap calloc() {
        return new STBTTBitmap(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static STBTTBitmap create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new STBTTBitmap(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBTTBitmap create(long l2) {
        return new STBTTBitmap(l2, null);
    }

    public static @Nullable STBTTBitmap createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBTTBitmap(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(STBTTBitmap.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = STBTTBitmap.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    @Deprecated
    public static STBTTBitmap mallocStack() {
        return STBTTBitmap.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static STBTTBitmap callocStack() {
        return STBTTBitmap.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static STBTTBitmap mallocStack(MemoryStack memoryStack) {
        return STBTTBitmap.malloc(memoryStack);
    }

    @Deprecated
    public static STBTTBitmap callocStack(MemoryStack memoryStack) {
        return STBTTBitmap.calloc(memoryStack);
    }

    @Deprecated
    public static Buffer mallocStack(int n2) {
        return STBTTBitmap.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int n2) {
        return STBTTBitmap.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBTTBitmap.malloc(n2, memoryStack);
    }

    @Deprecated
    public static Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBTTBitmap.calloc(n2, memoryStack);
    }

    public static STBTTBitmap malloc(MemoryStack memoryStack) {
        return new STBTTBitmap(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static STBTTBitmap calloc(MemoryStack memoryStack) {
        return new STBTTBitmap(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static int nw(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)W);
    }

    public static int nh(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)H);
    }

    public static int nstride(long l2) {
        return MemoryUtil.memGetInt(l2 + (long)STRIDE);
    }

    public static ByteBuffer npixels(long l2, int n2) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(l2 + (long)PIXELS), n2);
    }

    public static void nw(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)W, n2);
    }

    public static void nh(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)H, n2);
    }

    public static void nstride(long l2, int n2) {
        MemoryUtil.memPutInt(l2 + (long)STRIDE, n2);
    }

    public static void npixels(long l2, ByteBuffer byteBuffer) {
        MemoryUtil.memPutAddress(l2 + (long)PIXELS, MemoryUtil.memAddress(byteBuffer));
    }

    public static void validate(long l2) {
        Checks.check(MemoryUtil.memGetAddress(l2 + (long)PIXELS));
    }

    static {
        Struct.Layout layout = STBTTBitmap.__struct(STBTTBitmap.__member(4), STBTTBitmap.__member(4), STBTTBitmap.__member(4), STBTTBitmap.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        W = layout.offsetof(0);
        H = layout.offsetof(1);
        STRIDE = layout.offsetof(2);
        PIXELS = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<STBTTBitmap, Buffer>
    implements NativeResource {
        private static final STBTTBitmap ELEMENT_FACTORY = STBTTBitmap.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected STBTTBitmap getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int w() {
            return STBTTBitmap.nw(((Pointer.Default)this).address());
        }

        public int h() {
            return STBTTBitmap.nh(((Pointer.Default)this).address());
        }

        public int stride() {
            return STBTTBitmap.nstride(((Pointer.Default)this).address());
        }

        @NativeType(value="unsigned char *")
        public ByteBuffer pixels(int n2) {
            return STBTTBitmap.npixels(((Pointer.Default)this).address(), n2);
        }

        public Buffer w(int n2) {
            STBTTBitmap.nw(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer h(int n2) {
            STBTTBitmap.nh(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer stride(int n2) {
            STBTTBitmap.nstride(((Pointer.Default)this).address(), n2);
            return this;
        }

        public Buffer pixels(@NativeType(value="unsigned char *") ByteBuffer byteBuffer) {
            STBTTBitmap.npixels(((Pointer.Default)this).address(), byteBuffer);
            return this;
        }
    }
}

