/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbtt_aligned_quad")
public class STBTTAlignedQuad
extends Struct<STBTTAlignedQuad>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X0;
    public static final int Y0;
    public static final int S0;
    public static final int T0;
    public static final int X1;
    public static final int Y1;
    public static final int S1;
    public static final int T1;

    protected STBTTAlignedQuad(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected STBTTAlignedQuad create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new STBTTAlignedQuad(l2, byteBuffer);
    }

    public STBTTAlignedQuad(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), STBTTAlignedQuad.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x0() {
        return STBTTAlignedQuad.nx0(this.address());
    }

    public float y0() {
        return STBTTAlignedQuad.ny0(this.address());
    }

    public float s0() {
        return STBTTAlignedQuad.ns0(this.address());
    }

    public float t0() {
        return STBTTAlignedQuad.nt0(this.address());
    }

    public float x1() {
        return STBTTAlignedQuad.nx1(this.address());
    }

    public float y1() {
        return STBTTAlignedQuad.ny1(this.address());
    }

    public float s1() {
        return STBTTAlignedQuad.ns1(this.address());
    }

    public float t1() {
        return STBTTAlignedQuad.nt1(this.address());
    }

    public static STBTTAlignedQuad malloc() {
        return new STBTTAlignedQuad(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static STBTTAlignedQuad calloc() {
        return new STBTTAlignedQuad(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static STBTTAlignedQuad create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new STBTTAlignedQuad(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static STBTTAlignedQuad create(long l2) {
        return new STBTTAlignedQuad(l2, null);
    }

    public static @Nullable STBTTAlignedQuad createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new STBTTAlignedQuad(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(STBTTAlignedQuad.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = STBTTAlignedQuad.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    @Deprecated
    public static STBTTAlignedQuad mallocStack() {
        return STBTTAlignedQuad.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static STBTTAlignedQuad callocStack() {
        return STBTTAlignedQuad.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static STBTTAlignedQuad mallocStack(MemoryStack memoryStack) {
        return STBTTAlignedQuad.malloc(memoryStack);
    }

    @Deprecated
    public static STBTTAlignedQuad callocStack(MemoryStack memoryStack) {
        return STBTTAlignedQuad.calloc(memoryStack);
    }

    @Deprecated
    public static Buffer mallocStack(int n2) {
        return STBTTAlignedQuad.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int n2) {
        return STBTTAlignedQuad.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return STBTTAlignedQuad.malloc(n2, memoryStack);
    }

    @Deprecated
    public static Buffer callocStack(int n2, MemoryStack memoryStack) {
        return STBTTAlignedQuad.calloc(n2, memoryStack);
    }

    public static STBTTAlignedQuad malloc(MemoryStack memoryStack) {
        return new STBTTAlignedQuad(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static STBTTAlignedQuad calloc(MemoryStack memoryStack) {
        return new STBTTAlignedQuad(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static float nx0(long l2) {
        return MemoryUtil.memGetFloat(l2 + (long)X0);
    }

    public static float ny0(long l2) {
        return MemoryUtil.memGetFloat(l2 + (long)Y0);
    }

    public static float ns0(long l2) {
        return MemoryUtil.memGetFloat(l2 + (long)S0);
    }

    public static float nt0(long l2) {
        return MemoryUtil.memGetFloat(l2 + (long)T0);
    }

    public static float nx1(long l2) {
        return MemoryUtil.memGetFloat(l2 + (long)X1);
    }

    public static float ny1(long l2) {
        return MemoryUtil.memGetFloat(l2 + (long)Y1);
    }

    public static float ns1(long l2) {
        return MemoryUtil.memGetFloat(l2 + (long)S1);
    }

    public static float nt1(long l2) {
        return MemoryUtil.memGetFloat(l2 + (long)T1);
    }

    static {
        Struct.Layout layout = STBTTAlignedQuad.__struct(STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4), STBTTAlignedQuad.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X0 = layout.offsetof(0);
        Y0 = layout.offsetof(1);
        S0 = layout.offsetof(2);
        T0 = layout.offsetof(3);
        X1 = layout.offsetof(4);
        Y1 = layout.offsetof(5);
        S1 = layout.offsetof(6);
        T1 = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<STBTTAlignedQuad, Buffer>
    implements NativeResource {
        private static final STBTTAlignedQuad ELEMENT_FACTORY = STBTTAlignedQuad.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected STBTTAlignedQuad getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public float x0() {
            return STBTTAlignedQuad.nx0(((Pointer.Default)this).address());
        }

        public float y0() {
            return STBTTAlignedQuad.ny0(((Pointer.Default)this).address());
        }

        public float s0() {
            return STBTTAlignedQuad.ns0(((Pointer.Default)this).address());
        }

        public float t0() {
            return STBTTAlignedQuad.nt0(((Pointer.Default)this).address());
        }

        public float x1() {
            return STBTTAlignedQuad.nx1(((Pointer.Default)this).address());
        }

        public float y1() {
            return STBTTAlignedQuad.ny1(((Pointer.Default)this).address());
        }

        public float s1() {
            return STBTTAlignedQuad.ns1(((Pointer.Default)this).address());
        }

        public float t1() {
            return STBTTAlignedQuad.nt1(((Pointer.Default)this).address());
        }
    }
}

