/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.stb.LibSTB;
import org.lwjgl.stb.STBIRInputCallbackI;
import org.lwjgl.stb.STBIRKernelCallbackI;
import org.lwjgl.stb.STBIROutputCallbackI;
import org.lwjgl.stb.STBIRSupportCallbackI;
import org.lwjgl.stb.STBIR_RESIZE;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class STBImageResize {
    public static final int STBIR_1CHANNEL = 1;
    public static final int STBIR_2CHANNEL = 2;
    public static final int STBIR_RGB = 3;
    public static final int STBIR_BGR = 0;
    public static final int STBIR_4CHANNEL = 5;
    public static final int STBIR_RGBA = 4;
    public static final int STBIR_BGRA = 6;
    public static final int STBIR_ARGB = 7;
    public static final int STBIR_ABGR = 8;
    public static final int STBIR_RA = 9;
    public static final int STBIR_AR = 10;
    public static final int STBIR_RGBA_PM = 11;
    public static final int STBIR_BGRA_PM = 12;
    public static final int STBIR_ARGB_PM = 13;
    public static final int STBIR_ABGR_PM = 14;
    public static final int STBIR_RA_PM = 15;
    public static final int STBIR_AR_PM = 16;
    public static final int STBIR_RGBA_NO_AW = 11;
    public static final int STBIR_BGRA_NO_AW = 12;
    public static final int STBIR_ARGB_NO_AW = 13;
    public static final int STBIR_ABGR_NO_AW = 14;
    public static final int STBIR_RA_NO_AW = 15;
    public static final int STBIR_AR_NO_AW = 16;
    public static final int STBIR_EDGE_CLAMP = 0;
    public static final int STBIR_EDGE_REFLECT = 1;
    public static final int STBIR_EDGE_WRAP = 2;
    public static final int STBIR_EDGE_ZERO = 3;
    public static final int STBIR_FILTER_DEFAULT = 0;
    public static final int STBIR_FILTER_BOX = 1;
    public static final int STBIR_FILTER_TRIANGLE = 2;
    public static final int STBIR_FILTER_CUBICBSPLINE = 3;
    public static final int STBIR_FILTER_CATMULLROM = 4;
    public static final int STBIR_FILTER_MITCHELL = 5;
    public static final int STBIR_FILTER_POINT_SAMPLE = 6;
    public static final int STBIR_FILTER_OTHER = 7;
    public static final int STBIR_TYPE_UINT8 = 0;
    public static final int STBIR_TYPE_UINT8_SRGB = 1;
    public static final int STBIR_TYPE_UINT8_SRGB_ALPHA = 2;
    public static final int STBIR_TYPE_UINT16 = 3;
    public static final int STBIR_TYPE_FLOAT = 4;
    public static final int STBIR_TYPE_HALF_FLOAT = 5;
    private static final int[] stbir_pixel_layout_channels;
    private static final int[] stbir_type_size;

    protected STBImageResize() {
        throw new UnsupportedOperationException();
    }

    public static native long nstbir_resize_uint8_srgb(long var0, int var2, int var3, int var4, long var5, int var7, int var8, int var9, int var10);

    @NativeType(value="unsigned char *")
    public static @Nullable ByteBuffer stbir_resize_uint8_srgb(@NativeType(value="unsigned char const *") ByteBuffer byteBuffer, int n2, int n3, int n4, @NativeType(value="unsigned char *") @Nullable ByteBuffer byteBuffer2, int n5, int n6, int n7, @NativeType(value="stbir_pixel_layout") int n8) {
        int n9 = STBImageResize.calculateBufferSize(n5, n6, n7, n8, 1);
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer2, n9);
        }
        return MemoryUtil.memByteBufferSafe(STBImageResize.nstbir_resize_uint8_srgb(MemoryUtil.memAddress(byteBuffer), n2, n3, n4, MemoryUtil.memAddressSafe(byteBuffer2), n5, n6, n7, n8), n9);
    }

    @NativeType(value="unsigned char *")
    public static @Nullable ByteBuffer stbir_resize_uint8_srgb(@NativeType(value="unsigned char const *") ByteBuffer byteBuffer, int n2, int n3, int n4, @NativeType(value="unsigned char *") @Nullable ByteBuffer byteBuffer2, int n5, int n6, int n7, @NativeType(value="stbir_pixel_layout") int n8, long l2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer2, l2);
        }
        return MemoryUtil.memByteBufferSafe(STBImageResize.nstbir_resize_uint8_srgb(MemoryUtil.memAddress(byteBuffer), n2, n3, n4, MemoryUtil.memAddressSafe(byteBuffer2), n5, n6, n7, n8), (int)l2);
    }

    public static native long nstbir_resize_uint8_linear(long var0, int var2, int var3, int var4, long var5, int var7, int var8, int var9, int var10);

    @NativeType(value="unsigned char *")
    public static @Nullable ByteBuffer stbir_resize_uint8_linear(@NativeType(value="unsigned char const *") ByteBuffer byteBuffer, int n2, int n3, int n4, @NativeType(value="unsigned char *") @Nullable ByteBuffer byteBuffer2, int n5, int n6, int n7, @NativeType(value="stbir_pixel_layout") int n8) {
        int n9 = STBImageResize.calculateBufferSize(n5, n6, n7, n8, 1);
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer2, n9);
        }
        return MemoryUtil.memByteBufferSafe(STBImageResize.nstbir_resize_uint8_linear(MemoryUtil.memAddress(byteBuffer), n2, n3, n4, MemoryUtil.memAddressSafe(byteBuffer2), n5, n6, n7, n8), n9);
    }

    @NativeType(value="unsigned char *")
    public static @Nullable ByteBuffer stbir_resize_uint8_linear(@NativeType(value="unsigned char const *") ByteBuffer byteBuffer, int n2, int n3, int n4, @NativeType(value="unsigned char *") @Nullable ByteBuffer byteBuffer2, int n5, int n6, int n7, @NativeType(value="stbir_pixel_layout") int n8, long l2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer2, l2);
        }
        return MemoryUtil.memByteBufferSafe(STBImageResize.nstbir_resize_uint8_linear(MemoryUtil.memAddress(byteBuffer), n2, n3, n4, MemoryUtil.memAddressSafe(byteBuffer2), n5, n6, n7, n8), (int)l2);
    }

    public static native long nstbir_resize_float_linear(long var0, int var2, int var3, int var4, long var5, int var7, int var8, int var9, int var10);

    @NativeType(value="float *")
    public static @Nullable FloatBuffer stbir_resize_float_linear(@NativeType(value="float const *") FloatBuffer floatBuffer, int n2, int n3, int n4, @NativeType(value="float *") @Nullable FloatBuffer floatBuffer2, int n5, int n6, int n7, @NativeType(value="stbir_pixel_layout") int n8) {
        int n9 = STBImageResize.calculateBufferSize(n5, n6, n7, n8, 4);
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)floatBuffer2, n9);
        }
        return MemoryUtil.memFloatBufferSafe(STBImageResize.nstbir_resize_float_linear(MemoryUtil.memAddress(floatBuffer), n2, n3, n4, MemoryUtil.memAddressSafe(floatBuffer2), n5, n6, n7, n8), n9);
    }

    @NativeType(value="float *")
    public static @Nullable FloatBuffer stbir_resize_float_linear(@NativeType(value="float const *") FloatBuffer floatBuffer, int n2, int n3, int n4, @NativeType(value="float *") @Nullable FloatBuffer floatBuffer2, int n5, int n6, int n7, @NativeType(value="stbir_pixel_layout") int n8, long l2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)floatBuffer2, l2);
        }
        return MemoryUtil.memFloatBufferSafe(STBImageResize.nstbir_resize_float_linear(MemoryUtil.memAddress(floatBuffer), n2, n3, n4, MemoryUtil.memAddressSafe(floatBuffer2), n5, n6, n7, n8), (int)l2);
    }

    public static native long nstbir_resize(long var0, int var2, int var3, int var4, long var5, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    @NativeType(value="void *")
    public static @Nullable ByteBuffer stbir_resize(@NativeType(value="void const *") ByteBuffer byteBuffer, int n2, int n3, int n4, @NativeType(value="void *") @Nullable ByteBuffer byteBuffer2, int n5, int n6, int n7, @NativeType(value="stbir_pixel_layout") int n8, @NativeType(value="stbir_datatype") int n9, @NativeType(value="stbir_edge") int n10, @NativeType(value="stbir_filter") int n11) {
        int n12 = STBImageResize.calculateBufferSize(n5, n6, n7, n8, stbir_type_size[n9]);
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer2, n12);
        }
        return MemoryUtil.memByteBufferSafe(STBImageResize.nstbir_resize(MemoryUtil.memAddress(byteBuffer), n2, n3, n4, MemoryUtil.memAddressSafe(byteBuffer2), n5, n6, n7, n8, n9, n10, n11), n12);
    }

    @NativeType(value="void *")
    public static @Nullable ByteBuffer stbir_resize(@NativeType(value="void const *") ByteBuffer byteBuffer, int n2, int n3, int n4, @NativeType(value="void *") @Nullable ByteBuffer byteBuffer2, int n5, int n6, int n7, @NativeType(value="stbir_pixel_layout") int n8, @NativeType(value="stbir_datatype") int n9, @NativeType(value="stbir_edge") int n10, @NativeType(value="stbir_filter") int n11, long l2) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer2, l2);
        }
        return MemoryUtil.memByteBufferSafe(STBImageResize.nstbir_resize(MemoryUtil.memAddress(byteBuffer), n2, n3, n4, MemoryUtil.memAddressSafe(byteBuffer2), n5, n6, n7, n8, n9, n10, n11), (int)l2);
    }

    public static native void nstbir_resize_init(long var0, long var2, int var4, int var5, int var6, long var7, int var9, int var10, int var11, int var12, int var13);

    public static void stbir_resize_init(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, @NativeType(value="void const *") ByteBuffer byteBuffer, int n2, int n3, int n4, @NativeType(value="void *") @Nullable ByteBuffer byteBuffer2, int n5, int n6, int n7, @NativeType(value="stbir_pixel_layout") int n8, @NativeType(value="stbir_datatype") int n9) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)byteBuffer2, STBImageResize.calculateBufferSize(n5, n6, n7, n8, stbir_type_size[n9]));
        }
        STBImageResize.nstbir_resize_init(sTBIR_RESIZE.address(), MemoryUtil.memAddress(byteBuffer), n2, n3, n4, MemoryUtil.memAddressSafe(byteBuffer2), n5, n6, n7, n8, n9);
    }

    public static native void nstbir_set_datatypes(long var0, int var2, int var3);

    public static void stbir_set_datatypes(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, @NativeType(value="stbir_datatype") int n2, @NativeType(value="stbir_datatype") int n3) {
        STBImageResize.nstbir_set_datatypes(sTBIR_RESIZE.address(), n2, n3);
    }

    public static native void nstbir_set_pixel_callbacks(long var0, long var2, long var4);

    public static void stbir_set_pixel_callbacks(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, @NativeType(value="stbir_input_callback *") @Nullable STBIRInputCallbackI sTBIRInputCallbackI, @NativeType(value="stbir_output_callback *") @Nullable STBIROutputCallbackI sTBIROutputCallbackI) {
        STBImageResize.nstbir_set_pixel_callbacks(sTBIR_RESIZE.address(), MemoryUtil.memAddressSafe(sTBIRInputCallbackI), MemoryUtil.memAddressSafe(sTBIROutputCallbackI));
    }

    public static native void nstbir_set_user_data(long var0, long var2);

    public static void stbir_set_user_data(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, @NativeType(value="void *") long l2) {
        STBImageResize.nstbir_set_user_data(sTBIR_RESIZE.address(), l2);
    }

    public static native void nstbir_set_buffer_ptrs(long var0, long var2, int var4, long var5, int var7);

    public static void stbir_set_buffer_ptrs(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, @NativeType(value="void const *") ByteBuffer byteBuffer, int n2, @NativeType(value="void *") @Nullable ByteBuffer byteBuffer2, int n3) {
        STBImageResize.nstbir_set_buffer_ptrs(sTBIR_RESIZE.address(), MemoryUtil.memAddress(byteBuffer), n2, MemoryUtil.memAddressSafe(byteBuffer2), n3);
    }

    public static native int nstbir_set_pixel_layouts(long var0, int var2, int var3);

    public static int stbir_set_pixel_layouts(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, @NativeType(value="stbir_pixel_layout") int n2, @NativeType(value="stbir_pixel_layout") int n3) {
        return STBImageResize.nstbir_set_pixel_layouts(sTBIR_RESIZE.address(), n2, n3);
    }

    public static native int nstbir_set_edgemodes(long var0, int var2, int var3);

    public static int stbir_set_edgemodes(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, @NativeType(value="stbir_edge") int n2, @NativeType(value="stbir_edge") int n3) {
        return STBImageResize.nstbir_set_edgemodes(sTBIR_RESIZE.address(), n2, n3);
    }

    public static native int nstbir_set_filters(long var0, int var2, int var3);

    public static int stbir_set_filters(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, @NativeType(value="stbir_filter") int n2, @NativeType(value="stbir_filter") int n3) {
        return STBImageResize.nstbir_set_filters(sTBIR_RESIZE.address(), n2, n3);
    }

    public static native int nstbir_set_filter_callbacks(long var0, long var2, long var4, long var6, long var8);

    public static int stbir_set_filter_callbacks(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, @NativeType(value="stbir__kernel_callback *") @Nullable STBIRKernelCallbackI sTBIRKernelCallbackI, @NativeType(value="stbir__support_callback *") @Nullable STBIRSupportCallbackI sTBIRSupportCallbackI, @NativeType(value="stbir__kernel_callback *") @Nullable STBIRKernelCallbackI sTBIRKernelCallbackI2, @NativeType(value="stbir__support_callback *") @Nullable STBIRSupportCallbackI sTBIRSupportCallbackI2) {
        return STBImageResize.nstbir_set_filter_callbacks(sTBIR_RESIZE.address(), MemoryUtil.memAddressSafe(sTBIRKernelCallbackI), MemoryUtil.memAddressSafe(sTBIRSupportCallbackI), MemoryUtil.memAddressSafe(sTBIRKernelCallbackI2), MemoryUtil.memAddressSafe(sTBIRSupportCallbackI2));
    }

    public static native int nstbir_set_pixel_subrect(long var0, int var2, int var3, int var4, int var5);

    public static int stbir_set_pixel_subrect(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, int n2, int n3, int n4, int n5) {
        return STBImageResize.nstbir_set_pixel_subrect(sTBIR_RESIZE.address(), n2, n3, n4, n5);
    }

    public static native int nstbir_set_input_subrect(long var0, double var2, double var4, double var6, double var8);

    public static int stbir_set_input_subrect(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, double d2, double d3, double d4, double d5) {
        return STBImageResize.nstbir_set_input_subrect(sTBIR_RESIZE.address(), d2, d3, d4, d5);
    }

    public static native int nstbir_set_output_pixel_subrect(long var0, int var2, int var3, int var4, int var5);

    public static int stbir_set_output_pixel_subrect(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, int n2, int n3, int n4, int n5) {
        return STBImageResize.nstbir_set_output_pixel_subrect(sTBIR_RESIZE.address(), n2, n3, n4, n5);
    }

    public static native int nstbir_set_non_pm_alpha_speed_over_quality(long var0, int var2);

    public static int stbir_set_non_pm_alpha_speed_over_quality(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, @NativeType(value="int") boolean bl) {
        return STBImageResize.nstbir_set_non_pm_alpha_speed_over_quality(sTBIR_RESIZE.address(), bl ? 1 : 0);
    }

    public static native int nstbir_build_samplers(long var0);

    public static int stbir_build_samplers(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE) {
        return STBImageResize.nstbir_build_samplers(sTBIR_RESIZE.address());
    }

    public static native void nstbir_free_samplers(long var0);

    public static void stbir_free_samplers(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE) {
        STBImageResize.nstbir_free_samplers(sTBIR_RESIZE.address());
    }

    public static native int nstbir_resize_extended(long var0);

    public static int stbir_resize_extended(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE) {
        return STBImageResize.nstbir_resize_extended(sTBIR_RESIZE.address());
    }

    public static native int nstbir_build_samplers_with_splits(long var0, int var2);

    public static int stbir_build_samplers_with_splits(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, int n2) {
        return STBImageResize.nstbir_build_samplers_with_splits(sTBIR_RESIZE.address(), n2);
    }

    public static native int nstbir_resize_extended_split(long var0, int var2, int var3);

    public static int stbir_resize_extended_split(@NativeType(value="STBIR_RESIZE *") STBIR_RESIZE sTBIR_RESIZE, int n2, int n3) {
        return STBImageResize.nstbir_resize_extended_split(sTBIR_RESIZE.address(), n2, n3);
    }

    private static int calculateBufferSize(int n2, int n3, int n4, int n5, int n6) {
        return n3 * (n4 == 0 ? n2 * stbir_pixel_layout_channels[n5] * n6 : n4);
    }

    static {
        LibSTB.initialize();
        stbir_pixel_layout_channels = new int[]{3, 1, 2, 3, 4, 4, 4, 4, 4, 2, 2, 4, 4, 4, 4, 2, 2};
        stbir_type_size = new int[]{1, 1, 1, 2, 4, 2};
    }
}

