/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLDebugMessageAMDCallbackI;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class AMDDebugOutput {
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_AMD = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_AMD = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_AMD = 37189;
    public static final int GL_DEBUG_SEVERITY_HIGH_AMD = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_AMD = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_AMD = 37192;
    public static final int GL_DEBUG_CATEGORY_API_ERROR_AMD = 37193;
    public static final int GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = 37194;
    public static final int GL_DEBUG_CATEGORY_DEPRECATION_AMD = 37195;
    public static final int GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = 37196;
    public static final int GL_DEBUG_CATEGORY_PERFORMANCE_AMD = 37197;
    public static final int GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD = 37198;
    public static final int GL_DEBUG_CATEGORY_APPLICATION_AMD = 37199;
    public static final int GL_DEBUG_CATEGORY_OTHER_AMD = 37200;

    protected AMDDebugOutput() {
        throw new UnsupportedOperationException();
    }

    public static native void nglDebugMessageEnableAMD(int var0, int var1, int var2, long var3, boolean var5);

    public static void glDebugMessageEnableAMD(@NativeType(value="GLenum") int n2, @NativeType(value="GLenum") int n3, @NativeType(value="GLuint const *") @Nullable IntBuffer intBuffer, @NativeType(value="GLboolean") boolean bl) {
        AMDDebugOutput.nglDebugMessageEnableAMD(n2, n3, Checks.remainingSafe(intBuffer), MemoryUtil.memAddressSafe(intBuffer), bl);
    }

    public static void glDebugMessageEnableAMD(@NativeType(value="GLenum") int n2, @NativeType(value="GLenum") int n3, @NativeType(value="GLuint const *") int n4, @NativeType(value="GLboolean") boolean bl) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            IntBuffer intBuffer = memoryStack.ints(n4);
            AMDDebugOutput.nglDebugMessageEnableAMD(n2, n3, 1, MemoryUtil.memAddress(intBuffer), bl);
            return;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static native void nglDebugMessageInsertAMD(int var0, int var1, int var2, int var3, long var4);

    public static void glDebugMessageInsertAMD(@NativeType(value="GLenum") int n2, @NativeType(value="GLenum") int n3, @NativeType(value="GLuint") int n4, @NativeType(value="GLchar const *") ByteBuffer byteBuffer) {
        AMDDebugOutput.nglDebugMessageInsertAMD(n2, n3, n4, byteBuffer.remaining(), MemoryUtil.memAddress(byteBuffer));
    }

    public static void glDebugMessageInsertAMD(@NativeType(value="GLenum") int n2, @NativeType(value="GLenum") int n3, @NativeType(value="GLuint") int n4, @NativeType(value="GLchar const *") CharSequence charSequence) {
        MemoryStack memoryStack = MemoryStack.stackGet();
        int n5 = memoryStack.getPointer();
        try {
            int n6 = memoryStack.nUTF8(charSequence, false);
            long l2 = memoryStack.getPointerAddress();
            AMDDebugOutput.nglDebugMessageInsertAMD(n2, n3, n4, n6, l2);
            return;
        }
        finally {
            memoryStack.setPointer(n5);
        }
    }

    public static native void nglDebugMessageCallbackAMD(long var0, long var2);

    public static void glDebugMessageCallbackAMD(@NativeType(value="GLDEBUGPROCAMD") @Nullable GLDebugMessageAMDCallbackI gLDebugMessageAMDCallbackI, @NativeType(value="void *") long l2) {
        AMDDebugOutput.nglDebugMessageCallbackAMD(MemoryUtil.memAddressSafe(gLDebugMessageAMDCallbackI), l2);
    }

    public static native int nglGetDebugMessageLogAMD(int var0, int var1, long var2, long var4, long var6, long var8, long var10);

    @NativeType(value="GLuint")
    public static int glGetDebugMessageLogAMD(@NativeType(value="GLuint") int n2, @NativeType(value="GLenum *") @Nullable IntBuffer intBuffer, @NativeType(value="GLenum *") @Nullable IntBuffer intBuffer2, @NativeType(value="GLuint *") @Nullable IntBuffer intBuffer3, @NativeType(value="GLsizei *") @Nullable IntBuffer intBuffer4, @NativeType(value="GLchar *") @Nullable ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)intBuffer, n2);
            Checks.checkSafe((Buffer)intBuffer2, n2);
            Checks.checkSafe((Buffer)intBuffer3, n2);
            Checks.checkSafe((Buffer)intBuffer4, n2);
        }
        return AMDDebugOutput.nglGetDebugMessageLogAMD(n2, Checks.remainingSafe(byteBuffer), MemoryUtil.memAddressSafe(intBuffer), MemoryUtil.memAddressSafe(intBuffer2), MemoryUtil.memAddressSafe(intBuffer3), MemoryUtil.memAddressSafe(intBuffer4), MemoryUtil.memAddressSafe(byteBuffer));
    }

    public static void glDebugMessageEnableAMD(@NativeType(value="GLenum") int n2, @NativeType(value="GLenum") int n3, @NativeType(value="GLuint const *") int @Nullable [] nArray, @NativeType(value="GLboolean") boolean bl) {
        long l2 = GL.getICD().glDebugMessageEnableAMD;
        if (Checks.CHECKS) {
            Checks.check(l2);
        }
        JNI.callPV(n2, n3, Checks.lengthSafe(nArray), nArray, bl, l2);
    }

    @NativeType(value="GLuint")
    public static int glGetDebugMessageLogAMD(@NativeType(value="GLuint") int n2, @NativeType(value="GLenum *") int @Nullable [] nArray, @NativeType(value="GLenum *") int @Nullable [] nArray2, @NativeType(value="GLuint *") int @Nullable [] nArray3, @NativeType(value="GLsizei *") int @Nullable [] nArray4, @NativeType(value="GLchar *") @Nullable ByteBuffer byteBuffer) {
        long l2 = GL.getICD().glGetDebugMessageLogAMD;
        if (Checks.CHECKS) {
            Checks.check(l2);
            Checks.checkSafe(nArray, n2);
            Checks.checkSafe(nArray2, n2);
            Checks.checkSafe(nArray3, n2);
            Checks.checkSafe(nArray4, n2);
        }
        return JNI.callPPPPPI(n2, Checks.remainingSafe(byteBuffer), nArray, nArray2, nArray3, nArray4, MemoryUtil.memAddressSafe(byteBuffer), l2);
    }

    static {
        GL.initialize();
    }
}

