/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct GLFWgamepadstate")
public class GLFWGamepadState
extends Struct<GLFWGamepadState>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUTTONS;
    public static final int AXES;

    protected GLFWGamepadState(long l2, @Nullable ByteBuffer byteBuffer) {
        super(l2, byteBuffer);
    }

    @Override
    protected GLFWGamepadState create(long l2, @Nullable ByteBuffer byteBuffer) {
        return new GLFWGamepadState(l2, byteBuffer);
    }

    public GLFWGamepadState(ByteBuffer byteBuffer) {
        super(MemoryUtil.memAddress(byteBuffer), GLFWGamepadState.__checkContainer(byteBuffer, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned char[15]")
    public ByteBuffer buttons() {
        return GLFWGamepadState.nbuttons(this.address());
    }

    @NativeType(value="unsigned char")
    public byte buttons(int n2) {
        return GLFWGamepadState.nbuttons(this.address(), n2);
    }

    @NativeType(value="float[6]")
    public FloatBuffer axes() {
        return GLFWGamepadState.naxes(this.address());
    }

    public float axes(int n2) {
        return GLFWGamepadState.naxes(this.address(), n2);
    }

    public GLFWGamepadState buttons(@NativeType(value="unsigned char[15]") ByteBuffer byteBuffer) {
        GLFWGamepadState.nbuttons(this.address(), byteBuffer);
        return this;
    }

    public GLFWGamepadState buttons(int n2, @NativeType(value="unsigned char") byte by) {
        GLFWGamepadState.nbuttons(this.address(), n2, by);
        return this;
    }

    public GLFWGamepadState axes(@NativeType(value="float[6]") FloatBuffer floatBuffer) {
        GLFWGamepadState.naxes(this.address(), floatBuffer);
        return this;
    }

    public GLFWGamepadState axes(int n2, float f2) {
        GLFWGamepadState.naxes(this.address(), n2, f2);
        return this;
    }

    public GLFWGamepadState set(ByteBuffer byteBuffer, FloatBuffer floatBuffer) {
        this.buttons(byteBuffer);
        this.axes(floatBuffer);
        return this;
    }

    public GLFWGamepadState set(GLFWGamepadState gLFWGamepadState) {
        MemoryUtil.memCopy(gLFWGamepadState.address(), this.address(), SIZEOF);
        return this;
    }

    public static GLFWGamepadState malloc() {
        return new GLFWGamepadState(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static GLFWGamepadState calloc() {
        return new GLFWGamepadState(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static GLFWGamepadState create() {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer(SIZEOF);
        return new GLFWGamepadState(MemoryUtil.memAddress(byteBuffer), byteBuffer);
    }

    public static GLFWGamepadState create(long l2) {
        return new GLFWGamepadState(l2, null);
    }

    public static @Nullable GLFWGamepadState createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new GLFWGamepadState(l2, null);
    }

    public static Buffer malloc(int n2) {
        return new Buffer(MemoryUtil.nmemAllocChecked(GLFWGamepadState.__checkMalloc(n2, SIZEOF)), n2);
    }

    public static Buffer calloc(int n2) {
        return new Buffer(MemoryUtil.nmemCallocChecked(n2, SIZEOF), n2);
    }

    public static Buffer create(int n2) {
        ByteBuffer byteBuffer = GLFWGamepadState.__create(n2, SIZEOF);
        int n3 = n2;
        return new Buffer(MemoryUtil.memAddress(byteBuffer), byteBuffer, -1, 0, n3, n3);
    }

    public static Buffer create(long l2, int n2) {
        return new Buffer(l2, n2);
    }

    public static @Nullable Buffer createSafe(long l2, int n2) {
        if (l2 == 0L) {
            return null;
        }
        return new Buffer(l2, n2);
    }

    @Deprecated
    public static GLFWGamepadState mallocStack() {
        return GLFWGamepadState.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static GLFWGamepadState callocStack() {
        return GLFWGamepadState.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static GLFWGamepadState mallocStack(MemoryStack memoryStack) {
        return GLFWGamepadState.malloc(memoryStack);
    }

    @Deprecated
    public static GLFWGamepadState callocStack(MemoryStack memoryStack) {
        return GLFWGamepadState.calloc(memoryStack);
    }

    @Deprecated
    public static Buffer mallocStack(int n2) {
        return GLFWGamepadState.malloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int n2) {
        return GLFWGamepadState.calloc(n2, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int n2, MemoryStack memoryStack) {
        return GLFWGamepadState.malloc(n2, memoryStack);
    }

    @Deprecated
    public static Buffer callocStack(int n2, MemoryStack memoryStack) {
        return GLFWGamepadState.calloc(n2, memoryStack);
    }

    public static GLFWGamepadState malloc(MemoryStack memoryStack) {
        return new GLFWGamepadState(memoryStack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static GLFWGamepadState calloc(MemoryStack memoryStack) {
        return new GLFWGamepadState(memoryStack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.nmalloc(ALIGNOF, n2 * SIZEOF), n2);
    }

    public static Buffer calloc(int n2, MemoryStack memoryStack) {
        return new Buffer(memoryStack.ncalloc(ALIGNOF, n2, SIZEOF), n2);
    }

    public static ByteBuffer nbuttons(long l2) {
        return MemoryUtil.memByteBuffer(l2 + (long)BUTTONS, 15);
    }

    public static byte nbuttons(long l2, int n2) {
        return MemoryUtil.memGetByte(l2 + (long)BUTTONS + Checks.check(n2, 15));
    }

    public static FloatBuffer naxes(long l2) {
        return MemoryUtil.memFloatBuffer(l2 + (long)AXES, 6);
    }

    public static float naxes(long l2, int n2) {
        return MemoryUtil.memGetFloat(l2 + (long)AXES + (Checks.check(n2, 6) << 2));
    }

    public static void nbuttons(long l2, ByteBuffer byteBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(byteBuffer, 15);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(byteBuffer), l2 + (long)BUTTONS, byteBuffer.remaining());
    }

    public static void nbuttons(long l2, int n2, byte by) {
        MemoryUtil.memPutByte(l2 + (long)BUTTONS + Checks.check(n2, 15), by);
    }

    public static void naxes(long l2, FloatBuffer floatBuffer) {
        if (Checks.CHECKS) {
            Checks.checkGT(floatBuffer, 6);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(floatBuffer), l2 + (long)AXES, floatBuffer.remaining() << 2);
    }

    public static void naxes(long l2, int n2, float f2) {
        MemoryUtil.memPutFloat(l2 + (long)AXES + (Checks.check(n2, 6) << 2), f2);
    }

    static {
        Struct.Layout layout = GLFWGamepadState.__struct(GLFWGamepadState.__array(1, 15), GLFWGamepadState.__array(4, 6));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUTTONS = layout.offsetof(0);
        AXES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<GLFWGamepadState, Buffer>
    implements NativeResource {
        private static final GLFWGamepadState ELEMENT_FACTORY = GLFWGamepadState.create(-1L);

        public Buffer(ByteBuffer byteBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            super(byteBuffer2, byteBuffer2.remaining() / SIZEOF);
        }

        public Buffer(long l2, int n2) {
            int n3 = n2;
            super(l2, null, -1, 0, n3, n3);
        }

        Buffer(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            super(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long l2, @Nullable ByteBuffer byteBuffer, int n2, int n3, int n4, int n5) {
            return new Buffer(l2, byteBuffer, n2, n3, n4, n5);
        }

        @Override
        protected GLFWGamepadState getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="unsigned char[15]")
        public ByteBuffer buttons() {
            return GLFWGamepadState.nbuttons(((Pointer.Default)this).address());
        }

        @NativeType(value="unsigned char")
        public byte buttons(int n2) {
            return GLFWGamepadState.nbuttons(((Pointer.Default)this).address(), n2);
        }

        @NativeType(value="float[6]")
        public FloatBuffer axes() {
            return GLFWGamepadState.naxes(((Pointer.Default)this).address());
        }

        public float axes(int n2) {
            return GLFWGamepadState.naxes(((Pointer.Default)this).address(), n2);
        }

        public Buffer buttons(@NativeType(value="unsigned char[15]") ByteBuffer byteBuffer) {
            GLFWGamepadState.nbuttons(((Pointer.Default)this).address(), byteBuffer);
            return this;
        }

        public Buffer buttons(int n2, @NativeType(value="unsigned char") byte by) {
            GLFWGamepadState.nbuttons(((Pointer.Default)this).address(), n2, by);
            return this;
        }

        public Buffer axes(@NativeType(value="float[6]") FloatBuffer floatBuffer) {
            GLFWGamepadState.naxes(((Pointer.Default)this).address(), floatBuffer);
            return this;
        }

        public Buffer axes(int n2, float f2) {
            GLFWGamepadState.naxes(((Pointer.Default)this).address(), n2, f2);
            return this;
        }
    }
}

