/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.io.PrintStream;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Callback;
import org.lwjgl.system.MemoryUtil;

public abstract class GLFWErrorCallback
extends Callback
implements GLFWErrorCallbackI {
    public static GLFWErrorCallback create(long l2) {
        GLFWErrorCallbackI gLFWErrorCallbackI = (GLFWErrorCallbackI)Callback.get(l2);
        if (gLFWErrorCallbackI instanceof GLFWErrorCallback) {
            return (GLFWErrorCallback)gLFWErrorCallbackI;
        }
        return new Container(l2, gLFWErrorCallbackI);
    }

    public static @Nullable GLFWErrorCallback createSafe(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return GLFWErrorCallback.create(l2);
    }

    public static GLFWErrorCallback create(GLFWErrorCallbackI gLFWErrorCallbackI) {
        if (gLFWErrorCallbackI instanceof GLFWErrorCallback) {
            return (GLFWErrorCallback)gLFWErrorCallbackI;
        }
        return new Container(gLFWErrorCallbackI.address(), gLFWErrorCallbackI);
    }

    protected GLFWErrorCallback() {
        super(CIF);
    }

    GLFWErrorCallback(long l2) {
        super(l2);
    }

    public static String getDescription(long l2) {
        return MemoryUtil.memUTF8(l2);
    }

    public static GLFWErrorCallback createPrint() {
        return GLFWErrorCallback.createPrint(APIUtil.DEBUG_STREAM);
    }

    public static GLFWErrorCallback createPrint(final PrintStream printStream) {
        return new GLFWErrorCallback(){
            private Map<Integer, String> ERROR_CODES = APIUtil.apiClassTokens((field, n2) -> 65536 < n2 && n2 < 131072, null, GLFW.class);

            @Override
            public final void invoke(int n2, long l2) {
                String string = 1.getDescription(l2);
                StringBuilder stringBuilder = new StringBuilder(512);
                stringBuilder.append("[LWJGL] ").append(this.ERROR_CODES.get(n2)).append(" error\n\tDescription : ").append(string).append("\n\tStacktrace  :\n");
                StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
                for (int i2 = 4; i2 < stackTraceElementArray.length; ++i2) {
                    stringBuilder.append("\t\t");
                    stringBuilder.append(stackTraceElementArray[i2]);
                    stringBuilder.append("\n");
                }
            }
        };
    }

    public static GLFWErrorCallback createThrow() {
        return new GLFWErrorCallback(){

            @Override
            public final void invoke(int n2, long l2) {
                throw new IllegalStateException(String.format("GLFW error [0x%X]: %s", n2, 2.getDescription(l2)));
            }
        };
    }

    public GLFWErrorCallback set() {
        GLFW.glfwSetErrorCallback(this);
        return this;
    }

    static final class Container
    extends GLFWErrorCallback {
        private final GLFWErrorCallbackI delegate;

        Container(long l2, GLFWErrorCallbackI gLFWErrorCallbackI) {
            super(l2);
            this.delegate = gLFWErrorCallbackI;
        }

        @Override
        public final void invoke(int n2, long l2) {
            this.delegate.invoke(n2, l2);
        }
    }
}

