/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.io.InputStream;
import java.net.URL;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jspecify.annotations.Nullable;
import org.lwjgl.VersionImpl;

public final class Version {
    public static final int VERSION_MAJOR = 3;
    public static final int VERSION_MINOR = 3;
    public static final int VERSION_REVISION = 6;
    public static final BuildType BUILD_TYPE = BuildType.STABLE;
    private static final String versionPlain = "3.3." + 6 + Version.BUILD_TYPE.postfix;
    private static final String version = versionPlain + VersionImpl.find();

    private Version() {
    }

    public static void main(String[] stringArray) {
    }

    public static String getVersion() {
        return version;
    }

    static String createImplementation(String string, String string2) {
        string2 = "+" + (string2.startsWith("build ") && 6 < string2.length() ? string2.substring(6) : string2);
        if (string.contains("SNAPSHOT") || string.contains("snapshot")) {
            return "-snapshot".concat(String.valueOf(string2));
        }
        return string2;
    }

    static @Nullable String findImplementationFromManifest() {
        Object object = Version.class.getClassLoader();
        Object object2 = ((ClassLoader)object).getResource("org/lwjgl/Version.class");
        if (object2 != null) {
            object2 = ((URL)object2).toString();
            try {
                if (((String)object2).startsWith("jar:")) {
                    object2 = Version.readImplementationFromManifest(Objects.requireNonNull(Version.class.getResource("/META-INF/MANIFEST.MF")));
                    if (object2 != null) {
                        return object2;
                    }
                } else if (((String)object2).startsWith("resource:")) {
                    object = ((ClassLoader)object).getResources("META-INF/MANIFEST.MF");
                    while (object.hasMoreElements()) {
                        object2 = Version.readImplementationFromManifest((URL)object.nextElement());
                        if (object2 == null) continue;
                        return object2;
                    }
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable String readImplementationFromManifest(URL object) {
        try {
            String string;
            Object object2;
            Throwable throwable;
            block14: {
                block13: {
                    block12: {
                        object = ((URL)object).openStream();
                        throwable = null;
                        object2 = new Manifest((InputStream)object).getMainAttributes();
                        if ("lwjgl".equals(((Attributes)object2).getValue(Attributes.Name.IMPLEMENTATION_TITLE))) break block12;
                        if (object == null) return null;
                        ((InputStream)object).close();
                        return null;
                    }
                    if ("lwjgl.org".equals(((Attributes)object2).getValue(Attributes.Name.IMPLEMENTATION_VENDOR))) break block13;
                    if (object == null) return null;
                    ((InputStream)object).close();
                    return null;
                }
                string = ((Attributes)object2).getValue(Attributes.Name.SPECIFICATION_VERSION);
                object2 = ((Attributes)object2).getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                if (string != null && object2 != null) break block14;
                if (object == null) return null;
                ((InputStream)object).close();
                return null;
            }
            try {
                object2 = Version.createImplementation(string, (String)object2);
                if (object == null) return object2;
            }
            catch (Throwable throwable2) {
                try {
                    object2 = throwable2;
                    throwable = throwable2;
                    throw object2;
                }
                catch (Throwable throwable3) {
                    if (object == null) throw throwable3;
                    if (throwable == null) {
                        ((InputStream)object).close();
                        throw throwable3;
                    }
                    try {
                        ((InputStream)object).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
            }
            ((InputStream)object).close();
            return object2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static enum BuildType {
        ALPHA("a"),
        BETA("b"),
        STABLE("");

        public final String postfix;

        private BuildType(String string2) {
            this.postfix = string2;
        }
    }
}

