/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.CLongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryUtil;

public final class BufferUtils {
    private BufferUtils() {
    }

    public static ByteBuffer createByteBuffer(int n2) {
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
    }

    static int getAllocationSize(int n2, int n3) {
        int n4 = n2;
        APIUtil.apiCheckAllocation(n4, APIUtil.apiGetBytes(n4, n3), Integer.MAX_VALUE);
        return n2 << n3;
    }

    public static ShortBuffer createShortBuffer(int n2) {
        return BufferUtils.createByteBuffer(BufferUtils.getAllocationSize(n2, 1)).asShortBuffer();
    }

    public static CharBuffer createCharBuffer(int n2) {
        return BufferUtils.createByteBuffer(BufferUtils.getAllocationSize(n2, 1)).asCharBuffer();
    }

    public static IntBuffer createIntBuffer(int n2) {
        return BufferUtils.createByteBuffer(BufferUtils.getAllocationSize(n2, 2)).asIntBuffer();
    }

    public static LongBuffer createLongBuffer(int n2) {
        return BufferUtils.createByteBuffer(BufferUtils.getAllocationSize(n2, 3)).asLongBuffer();
    }

    public static CLongBuffer createCLongBuffer(int n2) {
        return CLongBuffer.allocateDirect(n2);
    }

    public static FloatBuffer createFloatBuffer(int n2) {
        return BufferUtils.createByteBuffer(BufferUtils.getAllocationSize(n2, 2)).asFloatBuffer();
    }

    public static DoubleBuffer createDoubleBuffer(int n2) {
        return BufferUtils.createByteBuffer(BufferUtils.getAllocationSize(n2, 3)).asDoubleBuffer();
    }

    public static PointerBuffer createPointerBuffer(int n2) {
        return PointerBuffer.allocateDirect(n2);
    }

    public static void zeroBuffer(ByteBuffer byteBuffer) {
        MemoryUtil.memSet(byteBuffer, 0);
    }

    public static void zeroBuffer(ShortBuffer shortBuffer) {
        MemoryUtil.memSet(shortBuffer, 0);
    }

    public static void zeroBuffer(CharBuffer charBuffer) {
        MemoryUtil.memSet(charBuffer, 0);
    }

    public static void zeroBuffer(IntBuffer intBuffer) {
        MemoryUtil.memSet(intBuffer, 0);
    }

    public static void zeroBuffer(FloatBuffer floatBuffer) {
        MemoryUtil.memSet(floatBuffer, 0);
    }

    public static void zeroBuffer(LongBuffer longBuffer) {
        MemoryUtil.memSet(longBuffer, 0);
    }

    public static void zeroBuffer(DoubleBuffer doubleBuffer) {
        MemoryUtil.memSet(doubleBuffer, 0);
    }

    public static <T extends CustomBuffer<T>> void zeroBuffer(T t2) {
        MemoryUtil.memSet(t2, 0);
    }
}

