/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import org.joml.Random;
import org.joml.sampling.Callback2d;
import org.joml.sampling.Callback3d;
import org.joml.sampling.Math;

public class UniformSampling {

    public static class Sphere {
        private final Random rnd;

        public Sphere(long l2, int n2, Callback3d callback3d) {
            this.rnd = new Random(l2);
            this.generate(n2, callback3d);
        }

        public void generate(int n2, Callback3d callback3d) {
            int n3 = 0;
            while (n3 < n2) {
                float f2 = this.rnd.nextFloat() * 2.0f - 1.0f;
                float f3 = this.rnd.nextFloat() * 2.0f - 1.0f;
                float f4 = f2;
                float f5 = f3;
                if (f4 * f4 + f5 * f5 >= 1.0f) continue;
                float f6 = f2;
                float f7 = f3;
                float f8 = (float)Math.sqrt(1.0 - (double)(f6 * f6) - (double)(f7 * f7));
                float f9 = f2 * 2.0f * f8;
                f8 = f3 * 2.0f * f8;
                float f10 = f2;
                float f11 = f3;
                f2 = 1.0f - 2.0f * (f10 * f10 + f11 * f11);
                callback3d.onNewSample(f9, f8, f2);
                ++n3;
            }
        }
    }

    public static class Disk {
        private final Random rnd;

        public Disk(long l2, int n2, Callback2d callback2d) {
            this.rnd = new Random(l2);
            this.generate(n2, callback2d);
        }

        private void generate(int n2, Callback2d callback2d) {
            for (int i2 = 0; i2 < n2; ++i2) {
                float f2 = this.rnd.nextFloat();
                float f3 = this.rnd.nextFloat() * 2.0f * (float)java.lang.Math.PI;
                f2 = Math.sqrt(f2);
                float f4 = f2 * (float)Math.sin_roquen_9((double)f3 + 1.5707963267948966);
                callback2d.onNewSample(f4, f2 *= (float)Math.sin_roquen_9(f3));
            }
        }
    }
}

