/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import java.util.ArrayList;
import org.joml.Random;
import org.joml.Vector2f;
import org.joml.sampling.Callback2d;
import org.joml.sampling.Math;

public class PoissonSampling {

    public static class Disk {
        private final Vector2f[] grid;
        private final float diskRadius;
        private final float diskRadiusSquared;
        private final float minDist;
        private final float minDistSquared;
        private final float cellSize;
        private final int numCells;
        private final Random rnd;
        private final ArrayList processList;

        public Disk(long l2, float f2, float f3, int n2, Callback2d callback2d) {
            this.diskRadius = f2;
            float f4 = f2;
            this.diskRadiusSquared = f4 * f4;
            this.minDist = f3;
            float f5 = f3;
            this.minDistSquared = f5 * f5;
            this.rnd = new Random(l2);
            this.cellSize = f3 / (float)Math.sqrt(2.0);
            this.numCells = (int)(f2 * 2.0f / this.cellSize) + 1;
            this.grid = new Vector2f[this.numCells * this.numCells];
            this.processList = new ArrayList();
            this.compute(n2, callback2d);
        }

        private void compute(int n2, Callback2d callback2d) {
            float f2;
            float f3;
            float f4;
            float f5;
            do {
                f3 = this.rnd.nextFloat() * 2.0f - 1.0f;
                f2 = this.rnd.nextFloat() * 2.0f - 1.0f;
                f5 = f3;
                f4 = f2;
            } while (f5 * f5 + f4 * f4 > 1.0f);
            Vector2f vector2f = new Vector2f(f3, f2);
            this.processList.add(vector2f);
            callback2d.onNewSample(vector2f.x, vector2f.y);
            this.insert(vector2f);
            while (!this.processList.isEmpty()) {
                int n3 = this.rnd.nextInt(this.processList.size());
                Vector2f vector2f2 = (Vector2f)this.processList.get(n3);
                boolean bl = false;
                for (int i2 = 0; i2 < n2; ++i2) {
                    f2 = this.rnd.nextFloat() * ((float)java.lang.Math.PI * 2);
                    float f6 = this.minDist * (this.rnd.nextFloat() + 1.0f);
                    float f7 = (float)((double)f6 * Math.sin_roquen_9((double)f2 + 1.5707963267948966));
                    f2 = (float)((double)f6 * Math.sin_roquen_9(f2));
                    float f8 = f7 += vector2f2.x;
                    float f9 = f2 += vector2f2.y;
                    if (f8 * f8 + f9 * f9 > this.diskRadiusSquared || this.searchNeighbors(f7, f2)) continue;
                    bl = true;
                    callback2d.onNewSample(f7, f2);
                    Vector2f vector2f3 = new Vector2f(f7, f2);
                    this.processList.add(vector2f3);
                    this.insert(vector2f3);
                    break;
                }
                if (bl) continue;
                this.processList.remove(n3);
            }
        }

        private boolean searchNeighbors(float f2, float f3) {
            float f4 = 1.0f / this.cellSize;
            int n2 = (int)((f3 + this.diskRadius) * f4);
            int n3 = (int)((f2 + this.diskRadius) * f4);
            if (this.grid[n2 * this.numCells + n3] != null) {
                return true;
            }
            int n4 = Math.max(0, n3 - 1);
            int n5 = Math.max(0, n2 - 1);
            n3 = Math.min(n3 + 1, this.numCells - 1);
            n2 = Math.min(n2 + 1, this.numCells - 1);
            while (n5 <= n2) {
                for (int i2 = n4; i2 <= n3; ++i2) {
                    Vector2f vector2f = this.grid[n5 * this.numCells + i2];
                    if (vector2f == null) continue;
                    float f5 = vector2f.x - f2;
                    float f6 = vector2f.y - f3;
                    float f7 = f5;
                    float f8 = f6;
                    if (!(f7 * f7 + f8 * f8 < this.minDistSquared)) continue;
                    return true;
                }
                ++n5;
            }
            return false;
        }

        private void insert(Vector2f vector2f) {
            float f2 = 1.0f / this.cellSize;
            int n2 = (int)((vector2f.y + this.diskRadius) * f2);
            int n3 = (int)((vector2f.x + this.diskRadius) * f2);
            this.grid[n2 * this.numCells + n3] = vector2f;
        }
    }
}

