/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import java.nio.FloatBuffer;
import org.joml.Math;

public class Convolution {
    public static void gaussianKernel(int n2, int n3, float f2, FloatBuffer floatBuffer) {
        if ((n2 & 1) == 0) {
            throw new IllegalArgumentException("rows must be an odd number");
        }
        if ((n3 & 1) == 0) {
            throw new IllegalArgumentException("cols must be an odd number");
        }
        if (floatBuffer == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        if (floatBuffer.remaining() < n2 * n3) {
            throw new IllegalArgumentException("dest must have at least " + n2 * n3 + " remaining values");
        }
        float f3 = 0.0f;
        int n4 = floatBuffer.position();
        f2 = (float)(1.0 / (2.0 * (double)f2 * (double)f2));
        int n5 = 0;
        for (int i2 = -(n2 - 1) / 2; i2 <= (n2 - 1) / 2; ++i2) {
            int n6 = -(n3 - 1) / 2;
            while (n6 <= (n3 - 1) / 2) {
                int n7 = i2;
                int n8 = n6++;
                float f4 = (float)Math.exp((float)(-(n7 * n7 + n8 * n8)) * f2);
                floatBuffer.put(n4 + n5, f4);
                f3 += f4;
                ++n5;
            }
        }
        f3 = 1.0f / f3;
        for (n5 = 0; n5 < n2 * n3; ++n5) {
            floatBuffer.put(n4 + n5, floatBuffer.get(n4 + n5) * f3);
        }
    }

    public static void gaussianKernel(int n2, int n3, float f2, float[] fArray) {
        if ((n2 & 1) == 0) {
            throw new IllegalArgumentException("rows must be an odd number");
        }
        if ((n3 & 1) == 0) {
            throw new IllegalArgumentException("cols must be an odd number");
        }
        if (fArray == null) {
            throw new IllegalArgumentException("dest must not be null");
        }
        if (fArray.length < n2 * n3) {
            throw new IllegalArgumentException("dest must have a size of at least " + n2 * n3);
        }
        float f3 = 0.0f;
        f2 = (float)(1.0 / (2.0 * (double)f2 * (double)f2));
        int n4 = 0;
        for (int i2 = -(n2 - 1) / 2; i2 <= (n2 - 1) / 2; ++i2) {
            int n5 = -(n3 - 1) / 2;
            while (n5 <= (n3 - 1) / 2) {
                float f4;
                int n6 = i2;
                int n7 = n5++;
                fArray[n4] = f4 = (float)Math.exp((float)(-(n6 * n6 + n7 * n7)) * f2);
                f3 += f4;
                ++n4;
            }
        }
        f3 = 1.0f / f3;
        for (n4 = 0; n4 < n2 * n3; ++n4) {
            fArray[n4] = fArray[n4] * f3;
        }
    }
}

