/*
 * Decompiled with CFR 0.152.
 */
package org.joml.sampling;

import java.nio.FloatBuffer;
import java.util.ArrayList;
import org.joml.Random;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.sampling.Callback2d;
import org.joml.sampling.Callback3d;
import org.joml.sampling.Math;

public class BestCandidateSampling {

    public static class Cube {
        private int numSamples;
        private int numCandidates = 60;
        private long seed;

        public Cube seed(long l2) {
            this.seed = l2;
            return this;
        }

        public Cube numSamples(int n2) {
            this.numSamples = n2;
            return this;
        }

        public Cube numCandidates(int n2) {
            this.numCandidates = n2;
            return this;
        }

        public Cube generate(final float[] fArray) {
            final IntHolder intHolder = new IntHolder();
            return this.generate(new Callback3d(){

                public void onNewSample(float f2, float f3, float f4) {
                    fArray[3 * intHolder.value] = f2;
                    fArray[3 * intHolder.value + 1] = f3;
                    fArray[3 * intHolder.value + 2] = f4;
                    ++intHolder.value;
                }
            });
        }

        public Cube generate(final FloatBuffer floatBuffer) {
            final IntHolder intHolder = new IntHolder();
            final int n2 = floatBuffer.position();
            return this.generate(new Callback3d(){

                public void onNewSample(float f2, float f3, float f4) {
                    floatBuffer.put(n2 + 3 * intHolder.value, f2);
                    floatBuffer.put(n2 + 3 * intHolder.value + 1, f3);
                    floatBuffer.put(n2 + 3 * intHolder.value + 2, f4);
                    ++intHolder.value;
                }
            });
        }

        public Cube generate(Callback3d callback3d) {
            Octree octree = new Octree(-1.0f, -1.0f, -1.0f, 2.0f);
            Random random = new Random(this.seed);
            for (int i2 = 0; i2 < this.numSamples; ++i2) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                float f5 = 0.0f;
                for (int i3 = 0; i3 < this.numCandidates; ++i3) {
                    float f6;
                    float f7 = random.nextFloat() * 2.0f - 1.0f;
                    float f8 = random.nextFloat() * 2.0f - 1.0f;
                    float f9 = random.nextFloat() * 2.0f - 1.0f;
                    float f10 = octree.nearest(f7, f8, f9, f5, Float.POSITIVE_INFINITY);
                    if (!(f6 > f5)) continue;
                    f5 = f10;
                    f2 = f7;
                    f3 = f8;
                    f4 = f9;
                }
                callback3d.onNewSample(f2, f3, f4);
                octree.insert(new Vector3f(f2, f3, f4));
            }
            return this;
        }
    }

    static class Octree {
        private static final int MAX_OBJECTS_PER_NODE = 32;
        private static final int PXNYNZ = 0;
        private static final int NXNYNZ = 1;
        private static final int NXPYNZ = 2;
        private static final int PXPYNZ = 3;
        private static final int PXNYPZ = 4;
        private static final int NXNYPZ = 5;
        private static final int NXPYPZ = 6;
        private static final int PXPYPZ = 7;
        private float minX;
        private float minY;
        private float minZ;
        private float hs;
        private ArrayList objects;
        private Octree[] children;

        Octree(float f2, float f3, float f4, float f5) {
            this.minX = f2;
            this.minY = f3;
            this.minZ = f4;
            this.hs = f5 * 0.5f;
        }

        private void split() {
            this.children = new Octree[8];
            this.children[1] = new Octree(this.minX, this.minY, this.minZ, this.hs);
            this.children[0] = new Octree(this.minX + this.hs, this.minY, this.minZ, this.hs);
            this.children[2] = new Octree(this.minX, this.minY + this.hs, this.minZ, this.hs);
            this.children[3] = new Octree(this.minX + this.hs, this.minY + this.hs, this.minZ, this.hs);
            this.children[5] = new Octree(this.minX, this.minY, this.minZ + this.hs, this.hs);
            this.children[4] = new Octree(this.minX + this.hs, this.minY, this.minZ + this.hs, this.hs);
            this.children[6] = new Octree(this.minX, this.minY + this.hs, this.minZ + this.hs, this.hs);
            this.children[7] = new Octree(this.minX + this.hs, this.minY + this.hs, this.minZ + this.hs, this.hs);
        }

        private void insertIntoChild(Vector3f vector3f) {
            this.children[this.octant(vector3f.x, vector3f.y, vector3f.z)].insert(vector3f);
        }

        void insert(Vector3f vector3f) {
            if (this.children != null) {
                this.insertIntoChild(vector3f);
                return;
            }
            if (this.objects != null && this.objects.size() == 32) {
                this.split();
                for (int i2 = 0; i2 < this.objects.size(); ++i2) {
                    Octree octree = this;
                    octree.insertIntoChild((Vector3f)octree.objects.get(i2));
                }
                this.objects = null;
                this.insertIntoChild(vector3f);
                return;
            }
            if (this.objects == null) {
                this.objects = new ArrayList(32);
            }
            this.objects.add(vector3f);
        }

        private int octant(float f2, float f3, float f4) {
            if (f2 < this.minX + this.hs) {
                if (f3 < this.minY + this.hs) {
                    if (f4 < this.minZ + this.hs) {
                        return 1;
                    }
                    return 5;
                }
                if (f4 < this.minZ + this.hs) {
                    return 2;
                }
                return 6;
            }
            if (f3 < this.minY + this.hs) {
                if (f4 < this.minZ + this.hs) {
                    return 0;
                }
                return 4;
            }
            if (f4 < this.minZ + this.hs) {
                return 3;
            }
            return 7;
        }

        float nearest(float f2, float f3, float f4, float f5, float f6) {
            float f7 = f6;
            if (f2 < this.minX - f6 || f2 > this.minX + this.hs * 2.0f + f6 || f3 < this.minY - f6 || f3 > this.minY + this.hs * 2.0f + f6 || f4 < this.minZ - f6 || f4 > this.minZ + this.hs * 2.0f + f6) {
                return f6;
            }
            if (this.children != null) {
                int n2 = this.octant(f2, f3, f4);
                for (int i2 = 0; i2 < 8; ++i2) {
                    float f8;
                    f7 = Math.min(this.children[n2].nearest(f2, f3, f4, f5, f7), f7);
                    if (f8 <= f5) {
                        return f5;
                    }
                    n2 = n2 + 1 & 7;
                }
                return f7;
            }
            float f9 = f6;
            f6 = f9 * f9;
            float f10 = f5;
            float f11 = f10 * f10;
            for (int i3 = 0; this.objects != null && i3 < this.objects.size(); ++i3) {
                float f12;
                f7 = ((Vector3f)this.objects.get(i3)).distanceSquared(f2, f3, f4);
                if (f12 <= f11) {
                    return f5;
                }
                if (!(f7 < f6)) continue;
                f6 = f7;
            }
            return Math.sqrt(f6);
        }
    }

    public static class Quad {
        private int numSamples;
        private int numCandidates = 60;
        private long seed;

        public Quad seed(long l2) {
            this.seed = l2;
            return this;
        }

        public Quad numSamples(int n2) {
            this.numSamples = n2;
            return this;
        }

        public Quad numCandidates(int n2) {
            this.numCandidates = n2;
            return this;
        }

        public Quad generate(final float[] fArray) {
            final IntHolder intHolder = new IntHolder();
            return this.generate(new Callback2d(){

                public void onNewSample(float f2, float f3) {
                    fArray[2 * intHolder.value] = f2;
                    fArray[2 * intHolder.value + 1] = f3;
                    ++intHolder.value;
                }
            });
        }

        public Quad generate(final FloatBuffer floatBuffer) {
            final IntHolder intHolder = new IntHolder();
            final int n2 = floatBuffer.position();
            return this.generate(new Callback2d(){

                public void onNewSample(float f2, float f3) {
                    floatBuffer.put(n2 + 3 * intHolder.value, f2);
                    floatBuffer.put(n2 + 3 * intHolder.value + 1, f3);
                    ++intHolder.value;
                }
            });
        }

        public Quad generate(Callback2d callback2d) {
            QuadTree quadTree = new QuadTree(-1.0f, -1.0f, 2.0f);
            Random random = new Random(this.seed);
            for (int i2 = 0; i2 < this.numSamples; ++i2) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                for (int i3 = 0; i3 < this.numCandidates; ++i3) {
                    float f5;
                    float f6 = random.nextFloat() * 2.0f - 1.0f;
                    float f7 = random.nextFloat() * 2.0f - 1.0f;
                    float f8 = quadTree.nearest(f6, f7, f4, Float.POSITIVE_INFINITY);
                    if (!(f5 > f4)) continue;
                    f4 = f8;
                    f2 = f6;
                    f3 = f7;
                }
                callback2d.onNewSample(f2, f3);
                quadTree.insert(new Vector2f(f2, f3));
            }
            return this;
        }
    }

    public static class Disk {
        private int numSamples;
        private int numCandidates = 60;
        private long seed;

        public Disk seed(long l2) {
            this.seed = l2;
            return this;
        }

        public Disk numSamples(int n2) {
            this.numSamples = n2;
            return this;
        }

        public Disk numCandidates(int n2) {
            this.numCandidates = n2;
            return this;
        }

        public Disk generate(final float[] fArray) {
            final IntHolder intHolder = new IntHolder();
            return this.generate(new Callback2d(){

                public void onNewSample(float f2, float f3) {
                    fArray[2 * intHolder.value] = f2;
                    fArray[2 * intHolder.value + 1] = f3;
                    ++intHolder.value;
                }
            });
        }

        public Disk generate(final FloatBuffer floatBuffer) {
            final IntHolder intHolder = new IntHolder();
            final int n2 = floatBuffer.position();
            return this.generate(new Callback2d(){

                public void onNewSample(float f2, float f3) {
                    floatBuffer.put(n2 + 3 * intHolder.value, f2);
                    floatBuffer.put(n2 + 3 * intHolder.value + 1, f3);
                    ++intHolder.value;
                }
            });
        }

        public Disk generate(Callback2d callback2d) {
            QuadTree quadTree = new QuadTree(-1.0f, -1.0f, 2.0f);
            Random random = new Random(this.seed);
            for (int i2 = 0; i2 < this.numSamples; ++i2) {
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = 0.0f;
                for (int i3 = 0; i3 < this.numCandidates; ++i3) {
                    float f5;
                    float f6;
                    float f7;
                    float f8;
                    float f9;
                    do {
                        f7 = random.nextFloat() * 2.0f - 1.0f;
                        f6 = random.nextFloat() * 2.0f - 1.0f;
                        f9 = f7;
                        f8 = f6;
                    } while (f9 * f9 + f8 * f8 > 1.0f);
                    float f10 = quadTree.nearest(f7, f6, f4, Float.POSITIVE_INFINITY);
                    if (!(f5 > f4)) continue;
                    f4 = f10;
                    f2 = f7;
                    f3 = f6;
                }
                callback2d.onNewSample(f2, f3);
                quadTree.insert(new Vector2f(f2, f3));
            }
            return this;
        }
    }

    static class QuadTree {
        private static final int MAX_OBJECTS_PER_NODE = 32;
        private static final int PXNY = 0;
        private static final int NXNY = 1;
        private static final int NXPY = 2;
        private static final int PXPY = 3;
        private float minX;
        private float minY;
        private float hs;
        private ArrayList objects;
        private QuadTree[] children;

        QuadTree(float f2, float f3, float f4) {
            this.minX = f2;
            this.minY = f3;
            this.hs = f4 * 0.5f;
        }

        private void split() {
            this.children = new QuadTree[4];
            this.children[1] = new QuadTree(this.minX, this.minY, this.hs);
            this.children[0] = new QuadTree(this.minX + this.hs, this.minY, this.hs);
            this.children[2] = new QuadTree(this.minX, this.minY + this.hs, this.hs);
            this.children[3] = new QuadTree(this.minX + this.hs, this.minY + this.hs, this.hs);
        }

        private void insertIntoChild(Vector2f vector2f) {
            this.children[this.quadrant(vector2f.x, vector2f.y)].insert(vector2f);
        }

        void insert(Vector2f vector2f) {
            if (this.children != null) {
                this.insertIntoChild(vector2f);
                return;
            }
            if (this.objects != null && this.objects.size() == 32) {
                this.split();
                for (int i2 = 0; i2 < this.objects.size(); ++i2) {
                    QuadTree quadTree = this;
                    quadTree.insertIntoChild((Vector2f)quadTree.objects.get(i2));
                }
                this.objects = null;
                this.insertIntoChild(vector2f);
                return;
            }
            if (this.objects == null) {
                this.objects = new ArrayList(32);
            }
            this.objects.add(vector2f);
        }

        private int quadrant(float f2, float f3) {
            if (f2 < this.minX + this.hs) {
                if (f3 < this.minY + this.hs) {
                    return 1;
                }
                return 2;
            }
            if (f3 < this.minY + this.hs) {
                return 0;
            }
            return 3;
        }

        float nearest(float f2, float f3, float f4, float f5) {
            float f6 = f5;
            if (f2 < this.minX - f5 || f2 > this.minX + this.hs * 2.0f + f5 || f3 < this.minY - f5 || f3 > this.minY + this.hs * 2.0f + f5) {
                return f5;
            }
            if (this.children != null) {
                int n2 = this.quadrant(f2, f3);
                for (int i2 = 0; i2 < 4; ++i2) {
                    float f7;
                    f6 = Math.min(this.children[n2].nearest(f2, f3, f4, f6), f6);
                    if (f7 <= f4) {
                        return f4;
                    }
                    n2 = n2 + 1 & 3;
                }
                return f6;
            }
            float f8 = f5;
            f5 = f8 * f8;
            float f9 = f4;
            float f10 = f9 * f9;
            for (int i3 = 0; this.objects != null && i3 < this.objects.size(); ++i3) {
                float f11;
                f6 = ((Vector2f)this.objects.get(i3)).distanceSquared(f2, f3);
                if (f11 <= f10) {
                    return f4;
                }
                if (!(f6 < f5)) continue;
                f5 = f6;
            }
            return Math.sqrt(f5);
        }
    }

    public static class Sphere {
        private boolean onHemisphere;
        private int numSamples;
        private int numCandidates = 60;
        private long seed;

        public Sphere generate(final float[] fArray) {
            final IntHolder intHolder = new IntHolder();
            return this.generate(new Callback3d(){

                public void onNewSample(float f2, float f3, float f4) {
                    fArray[3 * intHolder.value] = f2;
                    fArray[3 * intHolder.value + 1] = f3;
                    fArray[3 * intHolder.value + 2] = f4;
                    ++intHolder.value;
                }
            });
        }

        public Sphere generate(final FloatBuffer floatBuffer) {
            final IntHolder intHolder = new IntHolder();
            final int n2 = floatBuffer.position();
            return this.generate(new Callback3d(){

                public void onNewSample(float f2, float f3, float f4) {
                    floatBuffer.put(n2 + 3 * intHolder.value, f2);
                    floatBuffer.put(n2 + 3 * intHolder.value + 1, f3);
                    floatBuffer.put(n2 + 3 * intHolder.value + 2, f4);
                    ++intHolder.value;
                }
            });
        }

        public Sphere seed(long l2) {
            this.seed = l2;
            return this;
        }

        public Sphere numSamples(int n2) {
            this.numSamples = n2;
            return this;
        }

        public Sphere numCandidates(int n2) {
            this.numCandidates = n2;
            return this;
        }

        public Sphere onHemisphere(boolean bl) {
            this.onHemisphere = bl;
            return this;
        }

        public Sphere generate(Callback3d callback3d) {
            Random random = new Random(this.seed);
            Node node = new Node();
            for (int i2 = 0; i2 < this.numSamples; ++i2) {
                float f2 = Float.NaN;
                float f3 = Float.NaN;
                float f4 = Float.NaN;
                float f5 = 0.0f;
                for (int i3 = 0; i3 < this.numCandidates; ++i3) {
                    float f6;
                    float f7;
                    float f8;
                    float f9;
                    float f10;
                    do {
                        f8 = random.nextFloat() * 2.0f - 1.0f;
                        f7 = random.nextFloat() * 2.0f - 1.0f;
                        f10 = f8;
                        f9 = f7;
                    } while (f10 * f10 + f9 * f9 > 1.0f);
                    float f11 = f8;
                    float f12 = f7;
                    float f13 = (float)Math.sqrt(1.0 - (double)(f11 * f11) - (double)(f12 * f12));
                    float f14 = f8 * 2.0f * f13;
                    f13 = f7 * 2.0f * f13;
                    float f15 = f8;
                    float f16 = f7;
                    f8 = 1.0f - 2.0f * (f15 * f15 + f16 * f16);
                    if (this.onHemisphere) {
                        f8 = Math.abs(f8);
                    }
                    f7 = node.nearest(f14, f13, f8);
                    if (!(f6 > f5)) continue;
                    f5 = f7;
                    f2 = f14;
                    f3 = f13;
                    f4 = f8;
                }
                callback3d.onNewSample(f2, f3, f4);
                node.insert(new Vector3f(f2, f3, f4));
            }
            return this;
        }

        static final class Node {
            private static final int MAX_OBJECTS_PER_NODE = 32;
            private float v0x;
            private float v0y;
            private float v0z;
            private float v1x;
            private float v1y;
            private float v1z;
            private float v2x;
            private float v2y;
            private float v2z;
            private float cx;
            private float cy;
            private float cz;
            private float arc;
            private ArrayList objects;
            private Node[] children;

            Node() {
                this.children = new Node[8];
                this.arc = (float)java.lang.Math.PI * 2;
                this.children[0] = new Node(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f);
                this.children[1] = new Node(0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
                this.children[2] = new Node(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f);
                this.children[3] = new Node(0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
                this.children[4] = new Node(-1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f);
                this.children[5] = new Node(0.0f, 0.0f, 1.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                this.children[6] = new Node(1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f);
                this.children[7] = new Node(0.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f, 0.0f);
            }

            private Node(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
                this.v0x = f2;
                this.v0y = f3;
                this.v0z = f4;
                this.v1x = f5;
                this.v1y = f6;
                this.v1z = f7;
                this.v2x = f8;
                this.v2y = f9;
                this.v2z = f10;
                this.cx = (this.v0x + this.v1x + this.v2x) / 3.0f;
                this.cy = (this.v0y + this.v1y + this.v2y) / 3.0f;
                this.cz = (this.v0z + this.v1z + this.v2z) / 3.0f;
                f2 = Math.invsqrt(this.cx * this.cx + this.cy * this.cy + this.cz * this.cz);
                this.cx *= f2;
                this.cy *= f2;
                this.cz *= f2;
                Node node = this;
                f2 = node.greatCircleDist(node.cx, this.cy, this.cz, this.v0x, this.v0y, this.v0z);
                Node node2 = this;
                f3 = node2.greatCircleDist(node2.cx, this.cy, this.cz, this.v1x, this.v1y, this.v1z);
                Node node3 = this;
                f4 = node3.greatCircleDist(node3.cx, this.cy, this.cz, this.v2x, this.v2y, this.v2z);
                this.arc = f2 = Math.max(Math.max(f2, f3), f4) * 1.7f;
            }

            private void split() {
                float f2 = this.v1x + this.v2x;
                float f3 = this.v1y + this.v2y;
                float f4 = this.v1z + this.v2z;
                float f5 = f2;
                float f6 = f3;
                float f7 = f4;
                float f8 = Math.invsqrt(f5 * f5 + f6 * f6 + f7 * f7);
                f2 *= f8;
                f3 *= f8;
                f4 *= f8;
                f8 = this.v0x + this.v2x;
                float f9 = this.v0y + this.v2y;
                float f10 = this.v0z + this.v2z;
                float f11 = f8;
                float f12 = f9;
                float f13 = f10;
                float f14 = Math.invsqrt(f11 * f11 + f12 * f12 + f13 * f13);
                f8 *= f14;
                f9 *= f14;
                f10 *= f14;
                f14 = this.v0x + this.v1x;
                float f15 = this.v0y + this.v1y;
                float f16 = this.v0z + this.v1z;
                float f17 = f14;
                float f18 = f15;
                float f19 = f16;
                float f20 = Math.invsqrt(f17 * f17 + f18 * f18 + f19 * f19);
                this.children = new Node[4];
                this.children[0] = new Node(this.v0x, this.v0y, this.v0z, f14 *= f20, f15 *= f20, f16 *= f20, f8, f9, f10);
                this.children[1] = new Node(this.v1x, this.v1y, this.v1z, f2, f3, f4, f14, f15, f16);
                this.children[2] = new Node(this.v2x, this.v2y, this.v2z, f8, f9, f10, f2, f3, f4);
                this.children[3] = new Node(f2, f3, f4, f8, f9, f10, f14, f15, f16);
            }

            private void insertIntoChild(Vector3f vector3f) {
                for (int i2 = 0; i2 < this.children.length; ++i2) {
                    Node node = this.children[i2];
                    if (!Node.isPointOnSphericalTriangle(vector3f.x, vector3f.y, vector3f.z, node.v0x, node.v0y, node.v0z, node.v1x, node.v1y, node.v1z, node.v2x, node.v2y, node.v2z, 1.0E-6f)) continue;
                    node.insert(vector3f);
                    return;
                }
            }

            final void insert(Vector3f vector3f) {
                if (this.children != null) {
                    this.insertIntoChild(vector3f);
                    return;
                }
                if (this.objects != null && this.objects.size() == 32) {
                    this.split();
                    for (int i2 = 0; i2 < 32; ++i2) {
                        Node node = this;
                        node.insertIntoChild((Vector3f)node.objects.get(i2));
                    }
                    this.objects = null;
                    this.insertIntoChild(vector3f);
                    return;
                }
                if (this.objects == null) {
                    this.objects = new ArrayList(32);
                }
                this.objects.add(vector3f);
            }

            private static boolean isPointOnSphericalTriangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14) {
                float f15;
                float f16 = f3 * (f13 -= f7) - f4 * (f12 -= f6);
                float f17 = f4 * (f11 -= f5) - f2 * f13;
                float f18 = f2 * f12 - f3 * f11;
                float f19 = (f8 -= f5) * f16 + (f9 -= f6) * f17 + (f10 -= f7) * f18;
                if (f15 > -f14 && f19 < f14) {
                    return false;
                }
                if ((f16 = ((f5 = -f5) * f16 + (f6 = -f6) * f17 + (f7 = -f7) * f18) * (f19 = 1.0f / f19)) < 0.0f || f16 > 1.0f) {
                    return false;
                }
                f17 = f6 * f10 - f7 * f9;
                if ((f2 = (f2 * f17 + f3 * (f7 = f7 * f8 - f5 * f10) + f4 * (f5 = f5 * f9 - f6 * f8)) * f19) < 0.0f || f16 + f2 > 1.0f) {
                    return false;
                }
                return (f11 * f17 + f12 * f7 + f13 * f5) * f19 >= f14;
            }

            private int child(float f2, float f3, float f4) {
                for (int i2 = 0; i2 < this.children.length; ++i2) {
                    Node node = this.children[i2];
                    if (!Node.isPointOnSphericalTriangle(f2, f3, f4, node.v0x, node.v0y, node.v0z, node.v1x, node.v1y, node.v1z, node.v2x, node.v2y, node.v2z, 1.0E-5f)) continue;
                    return i2;
                }
                return 0;
            }

            private float greatCircleDist(float f2, float f3, float f4, float f5, float f6, float f7) {
                f2 = f2 * f5 + f3 * f6 + f4 * f7;
                return (float)(-1.5707963267948966 * (double)f2 + 1.5707963267948966);
            }

            final float nearest(float f2, float f3, float f4) {
                return this.nearest(f2, f3, f4, Float.POSITIVE_INFINITY);
            }

            final float nearest(float f2, float f3, float f4, float f5) {
                if (this.greatCircleDist(f2, f3, f4, this.cx, this.cy, this.cz) - this.arc > f5) {
                    return f5;
                }
                if (this.children != null) {
                    int n2 = this.children.length;
                    int n3 = n2 - 1;
                    int n4 = this.child(f2, f3, f4);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        f5 = Math.min(this.children[n4].nearest(f2, f3, f4, f5), f5);
                        n4 = n4 + 1 & n3;
                    }
                    return f5;
                }
                for (int i3 = 0; this.objects != null && i3 < this.objects.size(); ++i3) {
                    float f6;
                    Vector3f vector3f = (Vector3f)this.objects.get(i3);
                    float f7 = this.greatCircleDist(vector3f.x, vector3f.y, vector3f.z, f2, f3, f4);
                    if (!(f6 < f5)) continue;
                    f5 = f7;
                }
                return f5;
            }
        }
    }

    static final class IntHolder {
        int value;

        private IntHolder() {
        }
    }
}

