/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaternionfc;
import org.joml.Runtime;
import org.joml.Vector2d;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4d;
import org.joml.Vector4dc;
import org.joml.Vector4fc;
import org.joml.Vector4i;
import org.joml.Vector4ic;

public class Vector4f
implements Externalizable,
Cloneable,
Vector4fc {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4f() {
        this.w = 1.0f;
    }

    public Vector4f(Vector4fc vector4fc) {
        this.x = vector4fc.x();
        this.y = vector4fc.y();
        this.z = vector4fc.z();
        this.w = vector4fc.w();
    }

    public Vector4f(Vector4dc vector4dc) {
        this.x = (float)vector4dc.x();
        this.y = (float)vector4dc.y();
        this.z = (float)vector4dc.z();
        this.w = (float)vector4dc.w();
    }

    public Vector4f(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
    }

    public Vector4f(Vector3fc vector3fc, float f2) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        this.w = f2;
    }

    public Vector4f(Vector3ic vector3ic, float f2) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = f2;
    }

    public Vector4f(Vector2fc vector2fc, float f2, float f3) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = f2;
        this.w = f3;
    }

    public Vector4f(Vector2ic vector2ic, float f2, float f3) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = f2;
        this.w = f3;
    }

    public Vector4f(float f2) {
        this.x = f2;
        this.y = f2;
        this.z = f2;
        this.w = f2;
    }

    public Vector4f(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
    }

    public Vector4f(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
    }

    public Vector4f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector4f(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
    }

    public Vector4f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
    }

    public Vector4f(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n2, floatBuffer);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public Vector3f xyz(Vector3f vector3f) {
        return vector3f.set(this.x, this.y, this.z);
    }

    public Vector3d xyz(Vector3d vector3d) {
        return vector3d.set(this.x, this.y, this.z);
    }

    public Vector2f xy(Vector2f vector2f) {
        return vector2f.set(this.x, this.y);
    }

    public Vector2d xy(Vector2d vector2d) {
        return vector2d.set(this.x, this.y);
    }

    public Vector4f set(Vector4fc vector4fc) {
        if (vector4fc == this) {
            return this;
        }
        this.x = vector4fc.x();
        this.y = vector4fc.y();
        this.z = vector4fc.z();
        this.w = vector4fc.w();
        return this;
    }

    public Vector4f set(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
        return this;
    }

    public Vector4f set(Vector4dc vector4dc) {
        this.x = (float)vector4dc.x();
        this.y = (float)vector4dc.y();
        this.z = (float)vector4dc.z();
        this.w = (float)vector4dc.w();
        return this;
    }

    public Vector4f set(Vector3fc vector3fc, float f2) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        this.w = f2;
        return this;
    }

    public Vector4f set(Vector3dc vector3dc) {
        this.x = (float)vector3dc.x();
        this.y = (float)vector3dc.y();
        this.z = (float)vector3dc.z();
        return this;
    }

    public Vector4f set(Vector3ic vector3ic, float f2) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = f2;
        return this;
    }

    public Vector4f set(Vector2fc vector2fc, float f2, float f3) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = f2;
        this.w = f3;
        return this;
    }

    public Vector4f set(Vector2ic vector2ic, float f2, float f3) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = f2;
        this.w = f3;
        return this;
    }

    public Vector4f set(float f2) {
        this.x = f2;
        this.y = f2;
        this.z = f2;
        this.w = f2;
        return this;
    }

    public Vector4f set(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
        return this;
    }

    public Vector4f set(float f2, float f3, float f4) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        return this;
    }

    public Vector4f set(double d2) {
        this.x = (float)d2;
        this.y = (float)d2;
        this.z = (float)d2;
        this.w = (float)d2;
        return this;
    }

    public Vector4f set(double d2, double d3, double d4, double d5) {
        this.x = (float)d2;
        this.y = (float)d3;
        this.z = (float)d4;
        this.w = (float)d5;
        return this;
    }

    public Vector4f set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
        return this;
    }

    public Vector4f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector4f set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Vector4f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Vector4f set(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n2, floatBuffer);
        return this;
    }

    public Vector4f setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l2);
        return this;
    }

    public Vector4f setComponent(int n2, float f2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                this.x = f2;
                break;
            }
            case 1: {
                this.y = f2;
                break;
            }
            case 2: {
                this.z = f2;
                break;
            }
            case 3: {
                this.w = f2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public FloatBuffer get(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n2, floatBuffer);
        return floatBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Vector4fc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Vector4f sub(Vector4fc vector4fc) {
        return this.sub(vector4fc, this);
    }

    public Vector4f sub(float f2, float f3, float f4, float f5) {
        return this.sub(f2, f3, f4, f5, this);
    }

    public Vector4f sub(Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = this.x - vector4fc.x();
        vector4f.y = this.y - vector4fc.y();
        vector4f.z = this.z - vector4fc.z();
        vector4f.w = this.w - vector4fc.w();
        return vector4f;
    }

    public Vector4f sub(float f2, float f3, float f4, float f5, Vector4f vector4f) {
        vector4f.x = this.x - f2;
        vector4f.y = this.y - f3;
        vector4f.z = this.z - f4;
        vector4f.w = this.w - f5;
        return vector4f;
    }

    public Vector4f add(Vector4fc vector4fc) {
        return this.add(vector4fc, this);
    }

    public Vector4f add(Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = this.x + vector4fc.x();
        vector4f.y = this.y + vector4fc.y();
        vector4f.z = this.z + vector4fc.z();
        vector4f.w = this.w + vector4fc.w();
        return vector4f;
    }

    public Vector4f add(float f2, float f3, float f4, float f5) {
        return this.add(f2, f3, f4, f5, this);
    }

    public Vector4f add(float f2, float f3, float f4, float f5, Vector4f vector4f) {
        vector4f.x = this.x + f2;
        vector4f.y = this.y + f3;
        vector4f.z = this.z + f4;
        vector4f.w = this.w + f5;
        return vector4f;
    }

    public Vector4f fma(Vector4fc vector4fc, Vector4fc vector4fc2) {
        return this.fma(vector4fc, vector4fc2, this);
    }

    public Vector4f fma(float f2, Vector4fc vector4fc) {
        return this.fma(f2, vector4fc, this);
    }

    public Vector4f fma(Vector4fc vector4fc, Vector4fc vector4fc2, Vector4f vector4f) {
        vector4f.x = Math.fma(vector4fc.x(), vector4fc2.x(), this.x);
        vector4f.y = Math.fma(vector4fc.y(), vector4fc2.y(), this.y);
        vector4f.z = Math.fma(vector4fc.z(), vector4fc2.z(), this.z);
        vector4f.w = Math.fma(vector4fc.w(), vector4fc2.w(), this.w);
        return vector4f;
    }

    public Vector4f fma(float f2, Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = Math.fma(f2, vector4fc.x(), this.x);
        vector4f.y = Math.fma(f2, vector4fc.y(), this.y);
        vector4f.z = Math.fma(f2, vector4fc.z(), this.z);
        vector4f.w = Math.fma(f2, vector4fc.w(), this.w);
        return vector4f;
    }

    public Vector4f mulAdd(Vector4fc vector4fc, Vector4fc vector4fc2) {
        return this.mulAdd(vector4fc, vector4fc2, this);
    }

    public Vector4f mulAdd(float f2, Vector4fc vector4fc) {
        return this.mulAdd(f2, vector4fc, this);
    }

    public Vector4f mulAdd(Vector4fc vector4fc, Vector4fc vector4fc2, Vector4f vector4f) {
        vector4f.x = Math.fma(this.x, vector4fc.x(), vector4fc2.x());
        vector4f.y = Math.fma(this.y, vector4fc.y(), vector4fc2.y());
        vector4f.z = Math.fma(this.z, vector4fc.z(), vector4fc2.z());
        return vector4f;
    }

    public Vector4f mulAdd(float f2, Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = Math.fma(this.x, f2, vector4fc.x());
        vector4f.y = Math.fma(this.y, f2, vector4fc.y());
        vector4f.z = Math.fma(this.z, f2, vector4fc.z());
        return vector4f;
    }

    public Vector4f mul(Vector4fc vector4fc) {
        return this.mul(vector4fc, this);
    }

    public Vector4f mul(Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = this.x * vector4fc.x();
        vector4f.y = this.y * vector4fc.y();
        vector4f.z = this.z * vector4fc.z();
        vector4f.w = this.w * vector4fc.w();
        return vector4f;
    }

    public Vector4f div(Vector4fc vector4fc) {
        return this.div(vector4fc, this);
    }

    public Vector4f div(Vector4fc vector4fc, Vector4f vector4f) {
        vector4f.x = this.x / vector4fc.x();
        vector4f.y = this.y / vector4fc.y();
        vector4f.z = this.z / vector4fc.z();
        vector4f.w = this.w / vector4fc.w();
        return vector4f;
    }

    public Vector4f mul(Matrix4fc matrix4fc) {
        return this.mul(matrix4fc, this);
    }

    public Vector4f mul(Matrix4fc matrix4fc, Vector4f vector4f) {
        int n2 = matrix4fc.properties();
        if ((n2 & 4) != 0) {
            return vector4f.set(this);
        }
        if ((n2 & 8) != 0) {
            return this.mulTranslation(matrix4fc, vector4f);
        }
        if ((n2 & 2) != 0) {
            return this.mulAffine(matrix4fc, vector4f);
        }
        return this.mulGeneric(matrix4fc, vector4f);
    }

    public Vector4f mulAffine(Matrix4fc matrix4fc) {
        return this.mulAffine(matrix4fc, this);
    }

    public Vector4f mulAffine(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = this.w;
        vector4f.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m10(), f3, Math.fma(matrix4fc.m20(), f4, matrix4fc.m30() * f5)));
        vector4f.y = Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m21(), f4, matrix4fc.m31() * f5)));
        vector4f.z = Math.fma(matrix4fc.m02(), f2, Math.fma(matrix4fc.m12(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m32() * f5)));
        vector4f.w = f5;
        return vector4f;
    }

    public Vector4f mulTranspose(Matrix4fc matrix4fc) {
        return this.mulTranspose(matrix4fc, this);
    }

    public Vector4f mulTranspose(Matrix4fc matrix4fc, Vector4f vector4f) {
        int n2 = matrix4fc.properties();
        if ((n2 & 4) != 0) {
            return vector4f.set(this);
        }
        if ((n2 & 2) != 0) {
            return this.mulAffineTranspose(matrix4fc, vector4f);
        }
        return this.mulGenericTranspose(matrix4fc, vector4f);
    }

    public Vector4f mulAffineTranspose(Matrix4fc matrix4fc) {
        return this.mulAffineTranspose(matrix4fc, this);
    }

    public Vector4f mulAffineTranspose(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = this.w;
        vector4f.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m01(), f3, matrix4fc.m02() * f4));
        vector4f.y = Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m11(), f3, matrix4fc.m12() * f4));
        vector4f.z = Math.fma(matrix4fc.m20(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m22() * f4));
        vector4f.w = Math.fma(matrix4fc.m30(), f2, Math.fma(matrix4fc.m31(), f3, matrix4fc.m32() * f4 + f5));
        return vector4f;
    }

    public Vector4f mulGenericTranspose(Matrix4fc matrix4fc) {
        return this.mulGenericTranspose(matrix4fc, this);
    }

    public Vector4f mulGenericTranspose(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = this.w;
        vector4f.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m01(), f3, Math.fma(matrix4fc.m02(), f4, matrix4fc.m03() * f5)));
        vector4f.y = Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m12(), f4, matrix4fc.m13() * f5)));
        vector4f.z = Math.fma(matrix4fc.m20(), f2, Math.fma(matrix4fc.m21(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m23() * f5)));
        vector4f.w = Math.fma(matrix4fc.m30(), f2, Math.fma(matrix4fc.m31(), f3, Math.fma(matrix4fc.m32(), f4, matrix4fc.m33() * f5)));
        return vector4f;
    }

    public Vector4f mulTranslation(Matrix4fc matrix4fc) {
        return this.mulTranslation(matrix4fc, this);
    }

    public Vector4f mulTranslation(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = this.w;
        vector4f.x = Math.fma(matrix4fc.m30(), f5, f2);
        vector4f.y = Math.fma(matrix4fc.m31(), f5, f3);
        vector4f.z = Math.fma(matrix4fc.m32(), f5, f4);
        vector4f.w = f5;
        return vector4f;
    }

    public Vector4f mulGeneric(Matrix4fc matrix4fc) {
        return this.mulGeneric(matrix4fc, this);
    }

    public Vector4f mulGeneric(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = this.w;
        vector4f.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m10(), f3, Math.fma(matrix4fc.m20(), f4, matrix4fc.m30() * f5)));
        vector4f.y = Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m21(), f4, matrix4fc.m31() * f5)));
        vector4f.z = Math.fma(matrix4fc.m02(), f2, Math.fma(matrix4fc.m12(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m32() * f5)));
        vector4f.w = Math.fma(matrix4fc.m03(), f2, Math.fma(matrix4fc.m13(), f3, Math.fma(matrix4fc.m23(), f4, matrix4fc.m33() * f5)));
        return vector4f;
    }

    public Vector4f mul(Matrix4x3fc matrix4x3fc) {
        return this.mul(matrix4x3fc, this);
    }

    public Vector4f mul(Matrix4x3fc matrix4x3fc, Vector4f vector4f) {
        int n2 = matrix4x3fc.properties();
        if ((n2 & 4) != 0) {
            return vector4f.set(this);
        }
        if ((n2 & 8) != 0) {
            return this.mulTranslation(matrix4x3fc, vector4f);
        }
        return this.mulGeneric(matrix4x3fc, vector4f);
    }

    public Vector4f mulGeneric(Matrix4x3fc matrix4x3fc) {
        return this.mulGeneric(matrix4x3fc, this);
    }

    public Vector4f mulGeneric(Matrix4x3fc matrix4x3fc, Vector4f vector4f) {
        float f2 = Math.fma(matrix4x3fc.m00(), this.x, Math.fma(matrix4x3fc.m10(), this.y, Math.fma(matrix4x3fc.m20(), this.z, matrix4x3fc.m30() * this.w)));
        float f3 = Math.fma(matrix4x3fc.m01(), this.x, Math.fma(matrix4x3fc.m11(), this.y, Math.fma(matrix4x3fc.m21(), this.z, matrix4x3fc.m31() * this.w)));
        float f4 = Math.fma(matrix4x3fc.m02(), this.x, Math.fma(matrix4x3fc.m12(), this.y, Math.fma(matrix4x3fc.m22(), this.z, matrix4x3fc.m32() * this.w)));
        vector4f.x = f2;
        vector4f.y = f3;
        vector4f.z = f4;
        vector4f.w = this.w;
        return vector4f;
    }

    public Vector4f mulTranslation(Matrix4x3fc matrix4x3fc) {
        return this.mulTranslation(matrix4x3fc, this);
    }

    public Vector4f mulTranslation(Matrix4x3fc matrix4x3fc, Vector4f vector4f) {
        vector4f.x = Math.fma(matrix4x3fc.m30(), this.w, this.x);
        vector4f.y = Math.fma(matrix4x3fc.m31(), this.w, this.y);
        vector4f.z = Math.fma(matrix4x3fc.m32(), this.w, this.z);
        vector4f.w = this.w;
        return vector4f;
    }

    public Vector4f mulProject(Matrix4fc matrix4fc) {
        return this.mulProject(matrix4fc, this);
    }

    public Vector4f mulProject(Matrix4fc matrix4fc, Vector4f vector4f) {
        int n2 = matrix4fc.properties();
        if ((n2 & 4) != 0) {
            return vector4f.set(this);
        }
        if ((n2 & 8) != 0) {
            return this.mulProjectTranslation(matrix4fc, vector4f);
        }
        if ((n2 & 2) != 0) {
            return this.mulProjectAffine(matrix4fc, vector4f);
        }
        return this.mulProjectGeneric(matrix4fc, vector4f);
    }

    public Vector3f mulProject(Matrix4fc matrix4fc, Vector3f vector3f) {
        int n2 = matrix4fc.properties();
        if ((n2 & 4) != 0) {
            return vector3f.set(this);
        }
        if ((n2 & 8) != 0) {
            return this.mulProjectTranslation(matrix4fc, vector3f);
        }
        if ((n2 & 2) != 0) {
            return this.mulProjectAffine(matrix4fc, vector3f);
        }
        return this.mulProjectGeneric(matrix4fc, vector3f);
    }

    public Vector4f mulProjectGeneric(Matrix4fc matrix4fc) {
        return this.mulProjectGeneric(matrix4fc, this);
    }

    public Vector4f mulProjectGeneric(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f2 = 1.0f / Math.fma(matrix4fc.m03(), this.x, Math.fma(matrix4fc.m13(), this.y, Math.fma(matrix4fc.m23(), this.z, matrix4fc.m33() * this.w)));
        float f3 = Math.fma(matrix4fc.m00(), this.x, Math.fma(matrix4fc.m10(), this.y, Math.fma(matrix4fc.m20(), this.z, matrix4fc.m30() * this.w))) * f2;
        float f4 = Math.fma(matrix4fc.m01(), this.x, Math.fma(matrix4fc.m11(), this.y, Math.fma(matrix4fc.m21(), this.z, matrix4fc.m31() * this.w))) * f2;
        float f5 = Math.fma(matrix4fc.m02(), this.x, Math.fma(matrix4fc.m12(), this.y, Math.fma(matrix4fc.m22(), this.z, matrix4fc.m32() * this.w))) * f2;
        vector4f.x = f3;
        vector4f.y = f4;
        vector4f.z = f5;
        vector4f.w = 1.0f;
        return vector4f;
    }

    public Vector3f mulProjectGeneric(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f2 = 1.0f / Math.fma(matrix4fc.m03(), this.x, Math.fma(matrix4fc.m13(), this.y, Math.fma(matrix4fc.m23(), this.z, matrix4fc.m33() * this.w)));
        float f3 = Math.fma(matrix4fc.m00(), this.x, Math.fma(matrix4fc.m10(), this.y, Math.fma(matrix4fc.m20(), this.z, matrix4fc.m30() * this.w))) * f2;
        float f4 = Math.fma(matrix4fc.m01(), this.x, Math.fma(matrix4fc.m11(), this.y, Math.fma(matrix4fc.m21(), this.z, matrix4fc.m31() * this.w))) * f2;
        float f5 = Math.fma(matrix4fc.m02(), this.x, Math.fma(matrix4fc.m12(), this.y, Math.fma(matrix4fc.m22(), this.z, matrix4fc.m32() * this.w))) * f2;
        vector3f.x = f3;
        vector3f.y = f4;
        vector3f.z = f5;
        return vector3f;
    }

    public Vector4f mulProjectTranslation(Matrix4fc matrix4fc) {
        return this.mulProjectTranslation(matrix4fc, this);
    }

    public Vector4f mulProjectTranslation(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f2 = 1.0f / this.w;
        float f3 = Math.fma(matrix4fc.m00(), this.x, matrix4fc.m30() * this.w) * f2;
        float f4 = Math.fma(matrix4fc.m11(), this.y, matrix4fc.m31() * this.w) * f2;
        float f5 = Math.fma(matrix4fc.m22(), this.z, matrix4fc.m32() * this.w) * f2;
        vector4f.x = f3;
        vector4f.y = f4;
        vector4f.z = f5;
        vector4f.w = 1.0f;
        return vector4f;
    }

    public Vector3f mulProjectTranslation(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f2 = 1.0f / this.w;
        float f3 = Math.fma(matrix4fc.m00(), this.x, matrix4fc.m30() * this.w) * f2;
        float f4 = Math.fma(matrix4fc.m11(), this.y, matrix4fc.m31() * this.w) * f2;
        float f5 = Math.fma(matrix4fc.m22(), this.z, matrix4fc.m32() * this.w) * f2;
        vector3f.x = f3;
        vector3f.y = f4;
        vector3f.z = f5;
        return vector3f;
    }

    public Vector4f mulProjectAffine(Matrix4fc matrix4fc) {
        return this.mulProjectAffine(matrix4fc, this);
    }

    public Vector4f mulProjectAffine(Matrix4fc matrix4fc, Vector4f vector4f) {
        float f2 = 1.0f / this.w;
        float f3 = Math.fma(matrix4fc.m00(), this.x, Math.fma(matrix4fc.m10(), this.y, Math.fma(matrix4fc.m20(), this.z, matrix4fc.m30() * this.w))) * f2;
        float f4 = Math.fma(matrix4fc.m01(), this.x, Math.fma(matrix4fc.m11(), this.y, Math.fma(matrix4fc.m21(), this.z, matrix4fc.m31() * this.w))) * f2;
        float f5 = Math.fma(matrix4fc.m02(), this.x, Math.fma(matrix4fc.m12(), this.y, Math.fma(matrix4fc.m22(), this.z, matrix4fc.m32() * this.w))) * f2;
        vector4f.x = f3;
        vector4f.y = f4;
        vector4f.z = f5;
        vector4f.w = 1.0f;
        return vector4f;
    }

    public Vector3f mulProjectAffine(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f2 = 1.0f / this.w;
        float f3 = Math.fma(matrix4fc.m00(), this.x, Math.fma(matrix4fc.m10(), this.y, Math.fma(matrix4fc.m20(), this.z, matrix4fc.m30() * this.w))) * f2;
        float f4 = Math.fma(matrix4fc.m01(), this.x, Math.fma(matrix4fc.m11(), this.y, Math.fma(matrix4fc.m21(), this.z, matrix4fc.m31() * this.w))) * f2;
        float f5 = Math.fma(matrix4fc.m02(), this.x, Math.fma(matrix4fc.m12(), this.y, Math.fma(matrix4fc.m22(), this.z, matrix4fc.m32() * this.w))) * f2;
        vector3f.x = f3;
        vector3f.y = f4;
        vector3f.z = f5;
        return vector3f;
    }

    public Vector4f mul(float f2) {
        return this.mul(f2, this);
    }

    public Vector4f mul(float f2, Vector4f vector4f) {
        vector4f.x = this.x * f2;
        vector4f.y = this.y * f2;
        vector4f.z = this.z * f2;
        vector4f.w = this.w * f2;
        return vector4f;
    }

    public Vector4f mul(float f2, float f3, float f4, float f5) {
        return this.mul(f2, f3, f4, f5, this);
    }

    public Vector4f mul(float f2, float f3, float f4, float f5, Vector4f vector4f) {
        vector4f.x = this.x * f2;
        vector4f.y = this.y * f3;
        vector4f.z = this.z * f4;
        vector4f.w = this.w * f5;
        return vector4f;
    }

    public Vector4f div(float f2) {
        return this.div(f2, this);
    }

    public Vector4f div(float f2, Vector4f vector4f) {
        f2 = 1.0f / f2;
        vector4f.x = this.x * f2;
        vector4f.y = this.y * f2;
        vector4f.z = this.z * f2;
        vector4f.w = this.w * f2;
        return vector4f;
    }

    public Vector4f div(float f2, float f3, float f4, float f5) {
        return this.div(f2, f3, f4, f5, this);
    }

    public Vector4f div(float f2, float f3, float f4, float f5, Vector4f vector4f) {
        vector4f.x = this.x / f2;
        vector4f.y = this.y / f3;
        vector4f.z = this.z / f4;
        vector4f.w = this.w / f5;
        return vector4f;
    }

    public Vector4f rotate(Quaternionfc quaternionfc) {
        Vector4f vector4f = this;
        return quaternionfc.transform(vector4f, vector4f);
    }

    public Vector4f rotate(Quaternionfc quaternionfc, Vector4f vector4f) {
        return quaternionfc.transform(this, vector4f);
    }

    public Vector4f rotateAxis(float f2, float f3, float f4, float f5) {
        return this.rotateAxis(f2, f3, f4, f5, this);
    }

    public Vector4f rotateAxis(float f2, float f3, float f4, float f5, Vector4f vector4f) {
        if (f4 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotateX(f3 * f2, vector4f);
        }
        if (f3 == 0.0f && f5 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotateY(f4 * f2, vector4f);
        }
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f5)) {
            return this.rotateZ(f5 * f2, vector4f);
        }
        return this.rotateAxisInternal(f2, f3, f4, f5, vector4f);
    }

    private Vector4f rotateAxisInternal(float f2, float f3, float f4, float f5, Vector4f vector4f) {
        float f6 = Math.sin(f2 *= 0.5f);
        f3 *= f6;
        f4 *= f6;
        f5 *= f6;
        f2 = Math.cosFromSin(f6, f2);
        f6 = f2 * f2;
        float f7 = f3;
        float f8 = f7 * f7;
        float f9 = f4;
        float f10 = f9 * f9;
        float f11 = f5;
        float f12 = f11 * f11;
        float f13 = f5 * f2;
        float f14 = f3 * f4;
        float f15 = f3 * f5;
        float f16 = f4 * f2;
        f4 *= f5;
        f2 = f3 * f2;
        f3 = this.x;
        f5 = this.y;
        float f17 = this.z;
        vector4f.x = (f6 + f8 - f12 - f10) * f3 + (-f13 + f14 - f13 + f14) * f5 + (f16 + f15 + f15 + f16) * f17;
        float f18 = f4;
        vector4f.y = (f14 + f13 + f13 + f14) * f3 + (f10 - f12 + f6 - f8) * f5 + (f18 + f18 - f2 - f2) * f17;
        float f19 = f4;
        vector4f.z = (f15 - f16 + f15 - f16) * f3 + (f19 + f19 + f2 + f2) * f5 + (f12 - f10 - f8 + f6) * f17;
        return vector4f;
    }

    public Vector4f rotateX(float f2) {
        return this.rotateX(f2, this);
    }

    public Vector4f rotateX(float f2, Vector4f vector4f) {
        float f3 = Math.sin(f2);
        f2 = Math.cosFromSin(f3, f2);
        float f4 = this.y * f2 - this.z * f3;
        f2 = this.y * f3 + this.z * f2;
        vector4f.x = this.x;
        vector4f.y = f4;
        vector4f.z = f2;
        vector4f.w = this.w;
        return vector4f;
    }

    public Vector4f rotateY(float f2) {
        return this.rotateY(f2, this);
    }

    public Vector4f rotateY(float f2, Vector4f vector4f) {
        float f3 = Math.sin(f2);
        f2 = Math.cosFromSin(f3, f2);
        float f4 = this.x * f2 + this.z * f3;
        f2 = -this.x * f3 + this.z * f2;
        vector4f.x = f4;
        vector4f.y = this.y;
        vector4f.z = f2;
        vector4f.w = this.w;
        return vector4f;
    }

    public Vector4f rotateZ(float f2) {
        return this.rotateZ(f2, this);
    }

    public Vector4f rotateZ(float f2, Vector4f vector4f) {
        float f3 = Math.sin(f2);
        f2 = Math.cosFromSin(f3, f2);
        float f4 = this.x * f2 - this.y * f3;
        f2 = this.x * f3 + this.y * f2;
        vector4f.x = f4;
        vector4f.y = f2;
        vector4f.z = this.z;
        vector4f.w = this.w;
        return vector4f;
    }

    public float lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public static float lengthSquared(float f2, float f3, float f4, float f5) {
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        return Math.fma(f6, f6, Math.fma(f7, f7, Math.fma(f8, f8, f9 * f9)));
    }

    public static float lengthSquared(int n2, int n3, int n4, int n5) {
        int n6 = n5;
        return Math.fma(n2, n2, Math.fma(n3, n3, Math.fma(n4, n4, n6 * n6)));
    }

    public float length() {
        return Math.sqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w))));
    }

    public static float length(float f2, float f3, float f4, float f5) {
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        return Math.sqrt(Math.fma(f6, f6, Math.fma(f7, f7, Math.fma(f8, f8, f9 * f9))));
    }

    public Vector4f normalize() {
        Vector4f vector4f = this;
        return vector4f.normalize(vector4f);
    }

    public Vector4f normalize(Vector4f vector4f) {
        float f2 = 1.0f / this.length();
        vector4f.x = this.x * f2;
        vector4f.y = this.y * f2;
        vector4f.z = this.z * f2;
        vector4f.w = this.w * f2;
        return vector4f;
    }

    public Vector4f normalize(float f2) {
        return this.normalize(f2, this);
    }

    public Vector4f normalize(float f2, Vector4f vector4f) {
        f2 = 1.0f / this.length() * f2;
        vector4f.x = this.x * f2;
        vector4f.y = this.y * f2;
        vector4f.z = this.z * f2;
        vector4f.w = this.w * f2;
        return vector4f;
    }

    public Vector4f normalize3() {
        Vector4f vector4f = this;
        return vector4f.normalize3(vector4f);
    }

    public Vector4f normalize3(Vector4f vector4f) {
        float f2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        vector4f.x = this.x * f2;
        vector4f.y = this.y * f2;
        vector4f.z = this.z * f2;
        vector4f.w = this.w * f2;
        return vector4f;
    }

    public float distance(Vector4fc vector4fc) {
        return this.distance(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4fc.w());
    }

    public float distance(float f2, float f3, float f4, float f5) {
        f2 = this.x - f2;
        f3 = this.y - f3;
        f4 = this.z - f4;
        f5 = this.w - f5;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        return Math.sqrt(Math.fma(f6, f6, Math.fma(f7, f7, Math.fma(f8, f8, f9 * f9))));
    }

    public float distanceSquared(Vector4fc vector4fc) {
        return this.distanceSquared(vector4fc.x(), vector4fc.y(), vector4fc.z(), vector4fc.w());
    }

    public float distanceSquared(float f2, float f3, float f4, float f5) {
        f2 = this.x - f2;
        f3 = this.y - f3;
        f4 = this.z - f4;
        f5 = this.w - f5;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        return Math.fma(f6, f6, Math.fma(f7, f7, Math.fma(f8, f8, f9 * f9)));
    }

    public static float distance(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f2 -= f6;
        float f11 = f3 -= f7;
        float f12 = f4 -= f8;
        float f13 = f5 -= f9;
        return Math.sqrt(Math.fma(f10, f10, Math.fma(f11, f11, Math.fma(f12, f12, f13 * f13))));
    }

    public static float distanceSquared(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f2 -= f6;
        float f11 = f3 -= f7;
        float f12 = f4 -= f8;
        float f13 = f5 -= f9;
        return Math.fma(f10, f10, Math.fma(f11, f11, Math.fma(f12, f12, f13 * f13)));
    }

    public float dot(Vector4fc vector4fc) {
        return Math.fma(this.x, vector4fc.x(), Math.fma(this.y, vector4fc.y(), Math.fma(this.z, vector4fc.z(), this.w * vector4fc.w())));
    }

    public float dot(float f2, float f3, float f4, float f5) {
        return Math.fma(this.x, f2, Math.fma(this.y, f3, Math.fma(this.z, f4, this.w * f5)));
    }

    public float angleCos(Vector4fc vector4fc) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = this.w;
        float f6 = f2;
        float f7 = f3;
        float f8 = f4;
        float f9 = f5;
        float f10 = Math.fma(f6, f6, Math.fma(f7, f7, Math.fma(f8, f8, f9 * f9)));
        float f11 = Math.fma(vector4fc.x(), vector4fc.x(), Math.fma(vector4fc.y(), vector4fc.y(), Math.fma(vector4fc.z(), vector4fc.z(), vector4fc.w() * vector4fc.w())));
        return Math.fma(f2, vector4fc.x(), Math.fma(f3, vector4fc.y(), Math.fma(f4, vector4fc.z(), f5 * vector4fc.w()))) / Math.sqrt(f10 * f11);
    }

    public float angle(Vector4fc vector4fc) {
        float f2;
        float f3 = this.angleCos(vector4fc);
        f3 = f2 < 1.0f ? f3 : 1.0f;
        return Math.acos(f3 > -1.0f ? f3 : -1.0f);
    }

    public Vector4f zero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        this.w = 0.0f;
        return this;
    }

    public Vector4f negate() {
        Vector4f vector4f = this;
        return vector4f.negate(vector4f);
    }

    public Vector4f negate(Vector4f vector4f) {
        vector4f.x = -this.x;
        vector4f.y = -this.y;
        vector4f.z = -this.z;
        vector4f.w = -this.w;
        return vector4f;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " " + Runtime.format(this.w, numberFormat) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
        objectOutput.writeFloat(this.w);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.set(objectInput.readFloat(), objectInput.readFloat(), objectInput.readFloat(), objectInput.readFloat());
    }

    public Vector4f min(Vector4fc vector4fc) {
        return this.min(vector4fc, this);
    }

    public Vector4f min(Vector4fc vector4fc, Vector4f vector4f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = this.w;
        vector4f.x = f2 < vector4fc.x() ? f2 : vector4fc.x();
        vector4f.y = f3 < vector4fc.y() ? f3 : vector4fc.y();
        vector4f.z = f4 < vector4fc.z() ? f4 : vector4fc.z();
        vector4f.w = f5 < vector4fc.w() ? f5 : vector4fc.w();
        return vector4f;
    }

    public Vector4f max(Vector4fc vector4fc) {
        return this.max(vector4fc, this);
    }

    public Vector4f max(Vector4fc vector4fc, Vector4f vector4f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = this.w;
        vector4f.x = f2 > vector4fc.x() ? f2 : vector4fc.x();
        vector4f.y = f3 > vector4fc.y() ? f3 : vector4fc.y();
        vector4f.z = f4 > vector4fc.z() ? f4 : vector4fc.z();
        vector4f.w = f5 > vector4fc.w() ? f5 : vector4fc.w();
        return vector4f;
    }

    public int hashCode() {
        return (((31 + Float.floatToIntBits(this.w)) * 31 + Float.floatToIntBits(this.x)) * 31 + Float.floatToIntBits(this.y)) * 31 + Float.floatToIntBits(this.z);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Vector4f)object;
        if (Float.floatToIntBits(this.w) != Float.floatToIntBits(((Vector4f)object).w)) {
            return false;
        }
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(((Vector4f)object).x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(((Vector4f)object).y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(((Vector4f)object).z);
    }

    public boolean equals(Vector4fc vector4fc, float f2) {
        if (this == vector4fc) {
            return true;
        }
        if (vector4fc == null) {
            return false;
        }
        if (this.getClass() != vector4fc.getClass()) {
            return false;
        }
        if (!Runtime.equals(this.x, vector4fc.x(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.y, vector4fc.y(), f2)) {
            return false;
        }
        if (!Runtime.equals(this.z, vector4fc.z(), f2)) {
            return false;
        }
        return Runtime.equals(this.w, vector4fc.w(), f2);
    }

    public boolean equals(float f2, float f3, float f4, float f5) {
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(f2)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(f3)) {
            return false;
        }
        if (Float.floatToIntBits(this.z) != Float.floatToIntBits(f4)) {
            return false;
        }
        return Float.floatToIntBits(this.w) == Float.floatToIntBits(f5);
    }

    public Vector4f smoothStep(Vector4fc vector4fc, float f2, Vector4f vector4f) {
        float f3 = f2;
        float f4 = f3 * f3;
        float f5 = f4 * f2;
        float f6 = this.x;
        float f7 = this.y;
        float f8 = this.z;
        float f9 = this.w;
        float f10 = f6;
        vector4f.x = (f10 + f10 - vector4fc.x() - vector4fc.x()) * f5 + (3.0f * vector4fc.x() - 3.0f * f6) * f4 + f6 * f2 + f6;
        float f11 = f7;
        vector4f.y = (f11 + f11 - vector4fc.y() - vector4fc.y()) * f5 + (3.0f * vector4fc.y() - 3.0f * f7) * f4 + f7 * f2 + f7;
        float f12 = f8;
        vector4f.z = (f12 + f12 - vector4fc.z() - vector4fc.z()) * f5 + (3.0f * vector4fc.z() - 3.0f * f8) * f4 + f8 * f2 + f8;
        float f13 = f9;
        vector4f.w = (f13 + f13 - vector4fc.w() - vector4fc.w()) * f5 + (3.0f * vector4fc.w() - 3.0f * f9) * f4 + f9 * f2 + f9;
        return vector4f;
    }

    public Vector4f hermite(Vector4fc vector4fc, Vector4fc vector4fc2, Vector4fc vector4fc3, float f2, Vector4f vector4f) {
        float f3 = f2;
        float f4 = f3 * f3;
        float f5 = f4 * f2;
        float f6 = this.x;
        float f7 = this.y;
        float f8 = this.z;
        float f9 = this.w;
        float f10 = f6;
        vector4f.x = (f10 + f10 - vector4fc2.x() - vector4fc2.x() + vector4fc3.x() + vector4fc.x()) * f5 + (3.0f * vector4fc2.x() - 3.0f * f6 - vector4fc.x() - vector4fc.x() - vector4fc3.x()) * f4 + f6 * f2 + f6;
        float f11 = f7;
        vector4f.y = (f11 + f11 - vector4fc2.y() - vector4fc2.y() + vector4fc3.y() + vector4fc.y()) * f5 + (3.0f * vector4fc2.y() - 3.0f * f7 - vector4fc.y() - vector4fc.y() - vector4fc3.y()) * f4 + f7 * f2 + f7;
        float f12 = f8;
        vector4f.z = (f12 + f12 - vector4fc2.z() - vector4fc2.z() + vector4fc3.z() + vector4fc.z()) * f5 + (3.0f * vector4fc2.z() - 3.0f * f8 - vector4fc.z() - vector4fc.z() - vector4fc3.z()) * f4 + f8 * f2 + f8;
        float f13 = f9;
        vector4f.w = (f13 + f13 - vector4fc2.w() - vector4fc2.w() + vector4fc3.w() + vector4fc.w()) * f5 + (3.0f * vector4fc2.w() - 3.0f * f9 - vector4fc.w() - vector4fc.w() - vector4fc3.w()) * f4 + f9 * f2 + f9;
        return vector4f;
    }

    public Vector4f lerp(Vector4fc vector4fc, float f2) {
        return this.lerp(vector4fc, f2, this);
    }

    public Vector4f lerp(Vector4fc vector4fc, float f2, Vector4f vector4f) {
        vector4f.x = Math.fma(vector4fc.x() - this.x, f2, this.x);
        vector4f.y = Math.fma(vector4fc.y() - this.y, f2, this.y);
        vector4f.z = Math.fma(vector4fc.z() - this.z, f2, this.z);
        vector4f.w = Math.fma(vector4fc.w() - this.w, f2, this.w);
        return vector4f;
    }

    public float get(int n2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector4i get(int n2, Vector4i vector4i) {
        vector4i.x = Math.roundUsing(this.x(), n2);
        vector4i.y = Math.roundUsing(this.y(), n2);
        vector4i.z = Math.roundUsing(this.z(), n2);
        vector4i.w = Math.roundUsing(this.w(), n2);
        return vector4i;
    }

    public Vector4f get(Vector4f vector4f) {
        vector4f.x = this.x();
        vector4f.y = this.y();
        vector4f.z = this.z();
        vector4f.w = this.w();
        return vector4f;
    }

    public Vector4d get(Vector4d vector4d) {
        vector4d.x = this.x();
        vector4d.y = this.y();
        vector4d.z = this.z();
        vector4d.w = this.w();
        return vector4d;
    }

    public int maxComponent() {
        float f2 = Math.abs(this.x);
        float f3 = Math.abs(this.y);
        float f4 = Math.abs(this.z);
        float f5 = Math.abs(this.w);
        if (f2 >= f3 && f2 >= f4 && f2 >= f5) {
            return 0;
        }
        if (f3 >= f4 && f3 >= f5) {
            return 1;
        }
        if (f4 >= f5) {
            return 2;
        }
        return 3;
    }

    public int minComponent() {
        float f2 = Math.abs(this.x);
        float f3 = Math.abs(this.y);
        float f4 = Math.abs(this.z);
        float f5 = Math.abs(this.w);
        if (f2 < f3 && f2 < f4 && f2 < f5) {
            return 0;
        }
        if (f3 < f4 && f3 < f5) {
            return 1;
        }
        if (f4 < f5) {
            return 2;
        }
        return 3;
    }

    public Vector4f floor() {
        Vector4f vector4f = this;
        return vector4f.floor(vector4f);
    }

    public Vector4f floor(Vector4f vector4f) {
        vector4f.x = Math.floor(this.x);
        vector4f.y = Math.floor(this.y);
        vector4f.z = Math.floor(this.z);
        vector4f.w = Math.floor(this.w);
        return vector4f;
    }

    public Vector4f ceil() {
        Vector4f vector4f = this;
        return vector4f.ceil(vector4f);
    }

    public Vector4f ceil(Vector4f vector4f) {
        vector4f.x = Math.ceil(this.x);
        vector4f.y = Math.ceil(this.y);
        vector4f.z = Math.ceil(this.z);
        vector4f.w = Math.ceil(this.w);
        return vector4f;
    }

    public Vector4f round() {
        Vector4f vector4f = this;
        return vector4f.round(vector4f);
    }

    public Vector4f round(Vector4f vector4f) {
        vector4f.x = Math.round(this.x);
        vector4f.y = Math.round(this.y);
        vector4f.z = Math.round(this.z);
        vector4f.w = Math.round(this.w);
        return vector4f;
    }

    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }

    public Vector4f absolute() {
        Vector4f vector4f = this;
        return vector4f.absolute(vector4f);
    }

    public Vector4f absolute(Vector4f vector4f) {
        vector4f.x = Math.abs(this.x);
        vector4f.y = Math.abs(this.y);
        vector4f.z = Math.abs(this.z);
        vector4f.w = Math.abs(this.w);
        return vector4f;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

