/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix4dc;
import org.joml.Matrix4fc;
import org.joml.Matrix4x3dc;
import org.joml.Matrix4x3fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Quaterniondc;
import org.joml.Runtime;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4dc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.joml.Vector4i;
import org.joml.Vector4ic;

public class Vector4d
implements Externalizable,
Cloneable,
Vector4dc {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;
    public double z;
    public double w;

    public Vector4d() {
        this.w = 1.0;
    }

    public Vector4d(Vector4dc vector4dc) {
        this.x = vector4dc.x();
        this.y = vector4dc.y();
        this.z = vector4dc.z();
        this.w = vector4dc.w();
    }

    public Vector4d(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
    }

    public Vector4d(Vector3dc vector3dc, double d2) {
        this.x = vector3dc.x();
        this.y = vector3dc.y();
        this.z = vector3dc.z();
        this.w = d2;
    }

    public Vector4d(Vector3ic vector3ic, double d2) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = d2;
    }

    public Vector4d(Vector2dc vector2dc, double d2, double d3) {
        this.x = vector2dc.x();
        this.y = vector2dc.y();
        this.z = d2;
        this.w = d3;
    }

    public Vector4d(Vector2ic vector2ic, double d2, double d3) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = d2;
        this.w = d3;
    }

    public Vector4d(double d2) {
        this.x = d2;
        this.y = d2;
        this.z = d2;
        this.w = d2;
    }

    public Vector4d(Vector4fc vector4fc) {
        this.x = vector4fc.x();
        this.y = vector4fc.y();
        this.z = vector4fc.z();
        this.w = vector4fc.w();
    }

    public Vector4d(Vector3fc vector3fc, double d2) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        this.w = d2;
    }

    public Vector4d(Vector2fc vector2fc, double d2, double d3) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = d2;
        this.w = d3;
    }

    public Vector4d(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
    }

    public Vector4d(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
    }

    public Vector4d(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.w = dArray[3];
    }

    public Vector4d(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector4d(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
    }

    public Vector4d(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
    }

    public Vector4d(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n2, doubleBuffer);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public double w() {
        return this.w;
    }

    public Vector3f xyz(Vector3f vector3f) {
        return vector3f.set(this.x, this.y, this.z);
    }

    public Vector3d xyz(Vector3d vector3d) {
        return vector3d.set(this.x, this.y, this.z);
    }

    public Vector2f xy(Vector2f vector2f) {
        return vector2f.set(this.x, this.y);
    }

    public Vector2d xy(Vector2d vector2d) {
        return vector2d.set(this.x, this.y);
    }

    public Vector4d set(Vector4dc vector4dc) {
        if (vector4dc == this) {
            return this;
        }
        this.x = vector4dc.x();
        this.y = vector4dc.y();
        this.z = vector4dc.z();
        this.w = vector4dc.w();
        return this;
    }

    public Vector4d set(Vector4fc vector4fc) {
        this.x = vector4fc.x();
        this.y = vector4fc.y();
        this.z = vector4fc.z();
        this.w = vector4fc.w();
        return this;
    }

    public Vector4d set(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
        return this;
    }

    public Vector4d set(Vector3dc vector3dc, double d2) {
        this.x = vector3dc.x();
        this.y = vector3dc.y();
        this.z = vector3dc.z();
        this.w = d2;
        return this;
    }

    public Vector4d set(Vector3ic vector3ic, double d2) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = d2;
        return this;
    }

    public Vector4d set(Vector3fc vector3fc, double d2) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        this.w = d2;
        return this;
    }

    public Vector4d set(Vector2dc vector2dc, double d2, double d3) {
        this.x = vector2dc.x();
        this.y = vector2dc.y();
        this.z = d2;
        this.w = d3;
        return this;
    }

    public Vector4d set(Vector2ic vector2ic, double d2, double d3) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = d2;
        this.w = d3;
        return this;
    }

    public Vector4d set(double d2) {
        this.x = d2;
        this.y = d2;
        this.z = d2;
        this.w = d2;
        return this;
    }

    public Vector4d set(Vector2fc vector2fc, double d2, double d3) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = d2;
        this.w = d3;
        return this;
    }

    public Vector4d set(double d2, double d3, double d4, double d5) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        this.w = d5;
        return this;
    }

    public Vector4d set(double d2, double d3, double d4) {
        this.x = d2;
        this.y = d3;
        this.z = d4;
        return this;
    }

    public Vector4d set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
        this.w = dArray[3];
        return this;
    }

    public Vector4d set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        this.w = fArray[3];
        return this;
    }

    public Vector4d set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector4d set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Vector4d set(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, doubleBuffer.position(), doubleBuffer);
        return this;
    }

    public Vector4d set(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.get(this, n2, doubleBuffer);
        return this;
    }

    public Vector4d setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l2);
        return this;
    }

    public Vector4d setComponent(int n2, double d2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                this.x = d2;
                break;
            }
            case 1: {
                this.y = d2;
                break;
            }
            case 2: {
                this.z = d2;
                break;
            }
            case 3: {
                this.w = d2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public DoubleBuffer get(DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, doubleBuffer.position(), doubleBuffer);
        return doubleBuffer;
    }

    public DoubleBuffer get(int n2, DoubleBuffer doubleBuffer) {
        MemUtil.INSTANCE.put(this, n2, doubleBuffer);
        return doubleBuffer;
    }

    public ByteBuffer getf(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer getf(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.putf(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public FloatBuffer get(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n2, floatBuffer);
        return floatBuffer;
    }

    public Vector4dc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Vector4d sub(Vector4dc vector4dc) {
        return this.sub(vector4dc, this);
    }

    public Vector4d sub(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x - vector4dc.x();
        vector4d.y = this.y - vector4dc.y();
        vector4d.z = this.z - vector4dc.z();
        vector4d.w = this.w - vector4dc.w();
        return vector4d;
    }

    public Vector4d sub(Vector4fc vector4fc) {
        return this.sub(vector4fc, this);
    }

    public Vector4d sub(Vector4fc vector4fc, Vector4d vector4d) {
        vector4d.x = this.x - (double)vector4fc.x();
        vector4d.y = this.y - (double)vector4fc.y();
        vector4d.z = this.z - (double)vector4fc.z();
        vector4d.w = this.w - (double)vector4fc.w();
        return vector4d;
    }

    public Vector4d sub(double d2, double d3, double d4, double d5) {
        return this.sub(d2, d3, d4, d5, this);
    }

    public Vector4d sub(double d2, double d3, double d4, double d5, Vector4d vector4d) {
        vector4d.x = this.x - d2;
        vector4d.y = this.y - d3;
        vector4d.z = this.z - d4;
        vector4d.w = this.w - d5;
        return vector4d;
    }

    public Vector4d add(Vector4dc vector4dc) {
        return this.add(vector4dc, this);
    }

    public Vector4d add(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x + vector4dc.x();
        vector4d.y = this.y + vector4dc.y();
        vector4d.z = this.z + vector4dc.z();
        vector4d.w = this.w + vector4dc.w();
        return vector4d;
    }

    public Vector4d add(Vector4fc vector4fc, Vector4d vector4d) {
        vector4d.x = this.x + (double)vector4fc.x();
        vector4d.y = this.y + (double)vector4fc.y();
        vector4d.z = this.z + (double)vector4fc.z();
        vector4d.w = this.w + (double)vector4fc.w();
        return vector4d;
    }

    public Vector4d add(double d2, double d3, double d4, double d5) {
        return this.add(d2, d3, d4, d5, this);
    }

    public Vector4d add(double d2, double d3, double d4, double d5, Vector4d vector4d) {
        vector4d.x = this.x + d2;
        vector4d.y = this.y + d3;
        vector4d.z = this.z + d4;
        vector4d.w = this.w + d5;
        return vector4d;
    }

    public Vector4d add(Vector4fc vector4fc) {
        return this.add(vector4fc, this);
    }

    public Vector4d fma(Vector4dc vector4dc, Vector4dc vector4dc2) {
        return this.fma(vector4dc, vector4dc2, this);
    }

    public Vector4d fma(double d2, Vector4dc vector4dc) {
        return this.fma(d2, vector4dc, this);
    }

    public Vector4d fma(Vector4dc vector4dc, Vector4dc vector4dc2, Vector4d vector4d) {
        vector4d.x = Math.fma(vector4dc.x(), vector4dc2.x(), this.x);
        vector4d.y = Math.fma(vector4dc.y(), vector4dc2.y(), this.y);
        vector4d.z = Math.fma(vector4dc.z(), vector4dc2.z(), this.z);
        vector4d.w = Math.fma(vector4dc.w(), vector4dc2.w(), this.w);
        return vector4d;
    }

    public Vector4d fma(double d2, Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = Math.fma(d2, vector4dc.x(), this.x);
        vector4d.y = Math.fma(d2, vector4dc.y(), this.y);
        vector4d.z = Math.fma(d2, vector4dc.z(), this.z);
        vector4d.w = Math.fma(d2, vector4dc.w(), this.w);
        return vector4d;
    }

    public Vector4d mulAdd(Vector4dc vector4dc, Vector4dc vector4dc2) {
        return this.mulAdd(vector4dc, vector4dc2, this);
    }

    public Vector4d mulAdd(double d2, Vector4dc vector4dc) {
        return this.mulAdd(d2, vector4dc, this);
    }

    public Vector4d mulAdd(Vector4dc vector4dc, Vector4dc vector4dc2, Vector4d vector4d) {
        vector4d.x = Math.fma(this.x, vector4dc.x(), vector4dc2.x());
        vector4d.y = Math.fma(this.y, vector4dc.y(), vector4dc2.y());
        vector4d.z = Math.fma(this.z, vector4dc.z(), vector4dc2.z());
        return vector4d;
    }

    public Vector4d mulAdd(double d2, Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = Math.fma(this.x, d2, vector4dc.x());
        vector4d.y = Math.fma(this.y, d2, vector4dc.y());
        vector4d.z = Math.fma(this.z, d2, vector4dc.z());
        return vector4d;
    }

    public Vector4d mul(Vector4dc vector4dc) {
        return this.mul(vector4dc, this);
    }

    public Vector4d mul(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x * vector4dc.x();
        vector4d.y = this.y * vector4dc.y();
        vector4d.z = this.z * vector4dc.z();
        vector4d.w = this.w * vector4dc.w();
        return vector4d;
    }

    public Vector4d div(Vector4dc vector4dc) {
        return this.div(vector4dc, this);
    }

    public Vector4d div(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x / vector4dc.x();
        vector4d.y = this.y / vector4dc.y();
        vector4d.z = this.z / vector4dc.z();
        vector4d.w = this.w / vector4dc.w();
        return vector4d;
    }

    public Vector4d mul(Vector4fc vector4fc) {
        return this.mul(vector4fc, this);
    }

    public Vector4d mul(Vector4fc vector4fc, Vector4d vector4d) {
        vector4d.x = this.x * (double)vector4fc.x();
        vector4d.y = this.y * (double)vector4fc.y();
        vector4d.z = this.z * (double)vector4fc.z();
        vector4d.w = this.w * (double)vector4fc.w();
        return vector4d;
    }

    public Vector4d mul(Matrix4dc matrix4dc) {
        return this.mul(matrix4dc, this);
    }

    public Vector4d mul(Matrix4dc matrix4dc, Vector4d vector4d) {
        int n2 = matrix4dc.properties();
        if ((n2 & 4) != 0) {
            return vector4d.set(this);
        }
        if ((n2 & 8) != 0) {
            return this.mulTranslation(matrix4dc, vector4d);
        }
        if ((n2 & 2) != 0) {
            return this.mulAffine(matrix4dc, vector4d);
        }
        return this.mulGeneric(matrix4dc, vector4d);
    }

    public Vector4d mulTranspose(Matrix4dc matrix4dc) {
        return this.mulTranspose(matrix4dc, this);
    }

    public Vector4d mulTranspose(Matrix4dc matrix4dc, Vector4d vector4d) {
        int n2 = matrix4dc.properties();
        if ((n2 & 4) != 0) {
            return vector4d.set(this);
        }
        if ((n2 & 2) != 0) {
            return this.mulAffineTranspose(matrix4dc, vector4d);
        }
        return this.mulGenericTranspose(matrix4dc, vector4d);
    }

    public Vector4d mulTranslation(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        double d5 = this.w;
        vector4d.x = Math.fma(matrix4dc.m30(), d5, d2);
        vector4d.y = Math.fma(matrix4dc.m31(), d5, d3);
        vector4d.z = Math.fma(matrix4dc.m32(), d5, d4);
        vector4d.w = d5;
        return vector4d;
    }

    public Vector4d mulTranslation(Matrix4fc matrix4fc, Vector4d vector4d) {
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        double d5 = this.w;
        vector4d.x = Math.fma((double)matrix4fc.m30(), d5, d2);
        vector4d.y = Math.fma((double)matrix4fc.m31(), d5, d3);
        vector4d.z = Math.fma((double)matrix4fc.m32(), d5, d4);
        vector4d.w = d5;
        return vector4d;
    }

    public Vector4d mulAffine(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w)));
        double d3 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w)));
        double d4 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d mulGeneric(Matrix4dc matrix4dc) {
        return this.mulGeneric(matrix4dc, this);
    }

    public Vector4d mulGeneric(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w)));
        double d3 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w)));
        double d4 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w)));
        double d5 = Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = d5;
        return vector4d;
    }

    public Vector4d mulAffineTranspose(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        double d5 = this.w;
        vector4d.x = Math.fma(matrix4dc.m00(), d2, Math.fma(matrix4dc.m01(), d3, matrix4dc.m02() * d4));
        vector4d.y = Math.fma(matrix4dc.m10(), d2, Math.fma(matrix4dc.m11(), d3, matrix4dc.m12() * d4));
        vector4d.z = Math.fma(matrix4dc.m20(), d2, Math.fma(matrix4dc.m21(), d3, matrix4dc.m22() * d4));
        vector4d.w = Math.fma(matrix4dc.m30(), d2, Math.fma(matrix4dc.m31(), d3, matrix4dc.m32() * d4 + d5));
        return vector4d;
    }

    public Vector4d mulGenericTranspose(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = this.x;
        double d3 = this.y;
        double d4 = this.z;
        double d5 = this.w;
        vector4d.x = Math.fma(matrix4dc.m00(), d2, Math.fma(matrix4dc.m01(), d3, Math.fma(matrix4dc.m02(), d4, matrix4dc.m03() * d5)));
        vector4d.y = Math.fma(matrix4dc.m10(), d2, Math.fma(matrix4dc.m11(), d3, Math.fma(matrix4dc.m12(), d4, matrix4dc.m13() * d5)));
        vector4d.z = Math.fma(matrix4dc.m20(), d2, Math.fma(matrix4dc.m21(), d3, Math.fma(matrix4dc.m22(), d4, matrix4dc.m23() * d5)));
        vector4d.w = Math.fma(matrix4dc.m30(), d2, Math.fma(matrix4dc.m31(), d3, Math.fma(matrix4dc.m32(), d4, matrix4dc.m33() * d5)));
        return vector4d;
    }

    public Vector4d mul(Matrix4x3dc matrix4x3dc) {
        return this.mul(matrix4x3dc, this);
    }

    public Vector4d mul(Matrix4x3dc matrix4x3dc, Vector4d vector4d) {
        int n2 = matrix4x3dc.properties();
        if ((n2 & 4) != 0) {
            return vector4d.set(this);
        }
        if ((n2 & 8) != 0) {
            return this.mulTranslation(matrix4x3dc, vector4d);
        }
        return this.mulGeneric(matrix4x3dc, vector4d);
    }

    public Vector4d mulGeneric(Matrix4x3dc matrix4x3dc, Vector4d vector4d) {
        double d2 = Math.fma(matrix4x3dc.m00(), this.x, Math.fma(matrix4x3dc.m10(), this.y, Math.fma(matrix4x3dc.m20(), this.z, matrix4x3dc.m30() * this.w)));
        double d3 = Math.fma(matrix4x3dc.m01(), this.x, Math.fma(matrix4x3dc.m11(), this.y, Math.fma(matrix4x3dc.m21(), this.z, matrix4x3dc.m31() * this.w)));
        double d4 = Math.fma(matrix4x3dc.m02(), this.x, Math.fma(matrix4x3dc.m12(), this.y, Math.fma(matrix4x3dc.m22(), this.z, matrix4x3dc.m32() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d mulTranslation(Matrix4x3dc matrix4x3dc, Vector4d vector4d) {
        vector4d.x = Math.fma(matrix4x3dc.m30(), this.w, this.x);
        vector4d.y = Math.fma(matrix4x3dc.m31(), this.w, this.y);
        vector4d.z = Math.fma(matrix4x3dc.m32(), this.w, this.z);
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d mul(Matrix4x3fc matrix4x3fc) {
        return this.mul(matrix4x3fc, this);
    }

    public Vector4d mul(Matrix4x3fc matrix4x3fc, Vector4d vector4d) {
        int n2 = matrix4x3fc.properties();
        if ((n2 & 4) != 0) {
            return vector4d.set(this);
        }
        if ((n2 & 8) != 0) {
            return this.mulTranslation(matrix4x3fc, vector4d);
        }
        return this.mulGeneric(matrix4x3fc, vector4d);
    }

    public Vector4d mulGeneric(Matrix4x3fc matrix4x3fc, Vector4d vector4d) {
        double d2 = Math.fma((double)matrix4x3fc.m00(), this.x, Math.fma((double)matrix4x3fc.m10(), this.y, Math.fma((double)matrix4x3fc.m20(), this.z, (double)matrix4x3fc.m30() * this.w)));
        double d3 = Math.fma((double)matrix4x3fc.m01(), this.x, Math.fma((double)matrix4x3fc.m11(), this.y, Math.fma((double)matrix4x3fc.m21(), this.z, (double)matrix4x3fc.m31() * this.w)));
        double d4 = Math.fma((double)matrix4x3fc.m02(), this.x, Math.fma((double)matrix4x3fc.m12(), this.y, Math.fma((double)matrix4x3fc.m22(), this.z, (double)matrix4x3fc.m32() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d mulTranslation(Matrix4x3fc matrix4x3fc, Vector4d vector4d) {
        vector4d.x = Math.fma((double)matrix4x3fc.m30(), this.w, this.x);
        vector4d.y = Math.fma((double)matrix4x3fc.m31(), this.w, this.y);
        vector4d.z = Math.fma((double)matrix4x3fc.m32(), this.w, this.z);
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d mul(Matrix4fc matrix4fc) {
        return this.mul(matrix4fc, this);
    }

    public Vector4d mul(Matrix4fc matrix4fc, Vector4d vector4d) {
        int n2 = matrix4fc.properties();
        if ((n2 & 4) != 0) {
            return vector4d.set(this);
        }
        if ((n2 & 8) != 0) {
            return this.mulTranslation(matrix4fc, vector4d);
        }
        if ((n2 & 2) != 0) {
            return this.mulAffine(matrix4fc, vector4d);
        }
        return this.mulGeneric(matrix4fc, vector4d);
    }

    public Vector4d mulAffine(Matrix4fc matrix4fc) {
        return this.mulAffine(matrix4fc, this);
    }

    public Vector4d mulAffine(Matrix4fc matrix4fc, Vector4d vector4d) {
        double d2 = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, Math.fma((double)matrix4fc.m20(), this.z, (double)matrix4fc.m30() * this.w)));
        double d3 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m21(), this.z, (double)matrix4fc.m31() * this.w)));
        double d4 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m32() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d mulGeneric(Matrix4fc matrix4fc) {
        return this.mulGeneric(matrix4fc, this);
    }

    public Vector4d mulGeneric(Matrix4fc matrix4fc, Vector4d vector4d) {
        double d2 = Math.fma((double)matrix4fc.m00(), this.x, Math.fma((double)matrix4fc.m10(), this.y, Math.fma((double)matrix4fc.m20(), this.z, (double)matrix4fc.m30() * this.w)));
        double d3 = Math.fma((double)matrix4fc.m01(), this.x, Math.fma((double)matrix4fc.m11(), this.y, Math.fma((double)matrix4fc.m21(), this.z, (double)matrix4fc.m31() * this.w)));
        double d4 = Math.fma((double)matrix4fc.m02(), this.x, Math.fma((double)matrix4fc.m12(), this.y, Math.fma((double)matrix4fc.m22(), this.z, (double)matrix4fc.m32() * this.w)));
        double d5 = Math.fma((double)matrix4fc.m03(), this.x, Math.fma((double)matrix4fc.m13(), this.y, Math.fma((double)matrix4fc.m23(), this.z, (double)matrix4fc.m33() * this.w)));
        vector4d.x = d2;
        vector4d.y = d3;
        vector4d.z = d4;
        vector4d.w = d5;
        return vector4d;
    }

    public Vector4d mulProjectGeneric(Matrix4dc matrix4dc) {
        return this.mulProjectGeneric(matrix4dc, this);
    }

    public Vector4d mulProjectGeneric(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = 1.0 / Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * this.w)));
        double d3 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w))) * d2;
        double d4 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w))) * d2;
        double d5 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w))) * d2;
        vector4d.x = d3;
        vector4d.y = d4;
        vector4d.z = d5;
        vector4d.w = 1.0;
        return vector4d;
    }

    public Vector4d mulProjectTranslation(Matrix4dc matrix4dc) {
        return this.mulProjectTranslation(matrix4dc, this);
    }

    public Vector4d mulProjectTranslation(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = 1.0 / this.w;
        double d3 = Math.fma(matrix4dc.m00(), this.x, matrix4dc.m30() * this.w) * d2;
        double d4 = Math.fma(matrix4dc.m11(), this.y, matrix4dc.m31() * this.w) * d2;
        double d5 = Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w) * d2;
        vector4d.x = d3;
        vector4d.y = d4;
        vector4d.z = d5;
        vector4d.w = 1.0;
        return vector4d;
    }

    public Vector3d mulProjectTranslation(Matrix4dc matrix4dc, Vector3d vector3d) {
        double d2 = 1.0 / this.w;
        double d3 = Math.fma(matrix4dc.m00(), this.x, matrix4dc.m30() * this.w) * d2;
        double d4 = Math.fma(matrix4dc.m11(), this.y, matrix4dc.m31() * this.w) * d2;
        double d5 = Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w) * d2;
        vector3d.x = d3;
        vector3d.y = d4;
        vector3d.z = d5;
        return vector3d;
    }

    public Vector4d mulProjectAffine(Matrix4dc matrix4dc) {
        return this.mulProjectAffine(matrix4dc, this);
    }

    public Vector4d mulProjectAffine(Matrix4dc matrix4dc, Vector4d vector4d) {
        double d2 = 1.0 / this.w;
        double d3 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w))) * d2;
        double d4 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w))) * d2;
        double d5 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w))) * d2;
        vector4d.x = d3;
        vector4d.y = d4;
        vector4d.z = d5;
        vector4d.w = 1.0;
        return vector4d;
    }

    public Vector3d mulProjectAffine(Matrix4dc matrix4dc, Vector3d vector3d) {
        double d2 = 1.0 / this.w;
        double d3 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w))) * d2;
        double d4 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w))) * d2;
        double d5 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w))) * d2;
        vector3d.x = d3;
        vector3d.y = d4;
        vector3d.z = d5;
        return vector3d;
    }

    public Vector4d mulProject(Matrix4dc matrix4dc) {
        return this.mulProject(matrix4dc, this);
    }

    public Vector4d mulProject(Matrix4dc matrix4dc, Vector4d vector4d) {
        int n2 = matrix4dc.properties();
        if ((n2 & 4) != 0) {
            return vector4d.set(this);
        }
        if ((n2 & 8) != 0) {
            return this.mulProjectTranslation(matrix4dc, vector4d);
        }
        if ((n2 & 2) != 0) {
            return this.mulProjectAffine(matrix4dc, vector4d);
        }
        return this.mulProjectGeneric(matrix4dc, vector4d);
    }

    public Vector3d mulProject(Matrix4dc matrix4dc, Vector3d vector3d) {
        int n2 = matrix4dc.properties();
        if ((n2 & 4) != 0) {
            return vector3d.set(this);
        }
        if ((n2 & 8) != 0) {
            return this.mulProjectTranslation(matrix4dc, vector3d);
        }
        if ((n2 & 2) != 0) {
            return this.mulProjectAffine(matrix4dc, vector3d);
        }
        return this.mulProjectGeneric(matrix4dc, vector3d);
    }

    public Vector3d mulProjectGeneric(Matrix4dc matrix4dc, Vector3d vector3d) {
        double d2 = 1.0 / Math.fma(matrix4dc.m03(), this.x, Math.fma(matrix4dc.m13(), this.y, Math.fma(matrix4dc.m23(), this.z, matrix4dc.m33() * this.w)));
        double d3 = Math.fma(matrix4dc.m00(), this.x, Math.fma(matrix4dc.m10(), this.y, Math.fma(matrix4dc.m20(), this.z, matrix4dc.m30() * this.w))) * d2;
        double d4 = Math.fma(matrix4dc.m01(), this.x, Math.fma(matrix4dc.m11(), this.y, Math.fma(matrix4dc.m21(), this.z, matrix4dc.m31() * this.w))) * d2;
        double d5 = Math.fma(matrix4dc.m02(), this.x, Math.fma(matrix4dc.m12(), this.y, Math.fma(matrix4dc.m22(), this.z, matrix4dc.m32() * this.w))) * d2;
        vector3d.x = d3;
        vector3d.y = d4;
        vector3d.z = d5;
        return vector3d;
    }

    public Vector4d mul(double d2) {
        return this.mul(d2, this);
    }

    public Vector4d mul(double d2, Vector4d vector4d) {
        vector4d.x = this.x * d2;
        vector4d.y = this.y * d2;
        vector4d.z = this.z * d2;
        vector4d.w = this.w * d2;
        return vector4d;
    }

    public Vector4d div(double d2) {
        return this.div(d2, this);
    }

    public Vector4d div(double d2, Vector4d vector4d) {
        double d3 = 1.0 / d2;
        vector4d.x = this.x * d3;
        vector4d.y = this.y * d3;
        vector4d.z = this.z * d3;
        vector4d.w = this.w * d3;
        return vector4d;
    }

    public Vector4d rotate(Quaterniondc quaterniondc) {
        Vector4d vector4d = this;
        quaterniondc.transform(vector4d, vector4d);
        return this;
    }

    public Vector4d rotate(Quaterniondc quaterniondc, Vector4d vector4d) {
        quaterniondc.transform(this, vector4d);
        return vector4d;
    }

    public Vector4d rotateAxis(double d2, double d3, double d4, double d5) {
        return this.rotateAxis(d2, d3, d4, d5, this);
    }

    public Vector4d rotateAxis(double d2, double d3, double d4, double d5, Vector4d vector4d) {
        if (d4 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d3)) {
            return this.rotateX(d3 * d2, vector4d);
        }
        if (d3 == 0.0 && d5 == 0.0 && Math.absEqualsOne(d4)) {
            return this.rotateY(d4 * d2, vector4d);
        }
        if (d3 == 0.0 && d4 == 0.0 && Math.absEqualsOne(d5)) {
            return this.rotateZ(d5 * d2, vector4d);
        }
        return this.rotateAxisInternal(d2, d3, d4, d5, vector4d);
    }

    private Vector4d rotateAxisInternal(double d2, double d3, double d4, double d5, Vector4d vector4d) {
        double d6 = d2 * 0.5;
        double d7 = Math.sin(d6);
        double d8 = d3 * d7;
        double d9 = d4 * d7;
        double d10 = d5 * d7;
        double d11 = Math.cosFromSin(d7, d6);
        double d12 = d11 * d11;
        double d13 = d8;
        double d14 = d13 * d13;
        double d15 = d9;
        double d16 = d15 * d15;
        double d17 = d10;
        double d18 = d17 * d17;
        double d19 = d10 * d11;
        double d20 = d8 * d9;
        double d21 = d8 * d10;
        double d22 = d9 * d11;
        double d23 = d9 * d10;
        double d24 = d8 * d11;
        double d25 = (d12 + d14 - d18 - d16) * this.x + (-d19 + d20 - d19 + d20) * this.y + (d22 + d21 + d21 + d22) * this.z;
        double d26 = d23;
        double d27 = (d20 + d19 + d19 + d20) * this.x + (d16 - d18 + d12 - d14) * this.y + (d26 + d26 - d24 - d24) * this.z;
        double d28 = d23;
        double d29 = (d21 - d22 + d21 - d22) * this.x + (d28 + d28 + d24 + d24) * this.y + (d18 - d16 - d14 + d12) * this.z;
        vector4d.x = d25;
        vector4d.y = d27;
        vector4d.z = d29;
        return vector4d;
    }

    public Vector4d rotateX(double d2) {
        return this.rotateX(d2, this);
    }

    public Vector4d rotateX(double d2, Vector4d vector4d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = this.y * d4 - this.z * d3;
        double d6 = this.y * d3 + this.z * d4;
        vector4d.x = this.x;
        vector4d.y = d5;
        vector4d.z = d6;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d rotateY(double d2) {
        return this.rotateY(d2, this);
    }

    public Vector4d rotateY(double d2, Vector4d vector4d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = this.x * d4 + this.z * d3;
        double d6 = -this.x * d3 + this.z * d4;
        vector4d.x = d5;
        vector4d.y = this.y;
        vector4d.z = d6;
        vector4d.w = this.w;
        return vector4d;
    }

    public Vector4d rotateZ(double d2) {
        return this.rotateZ(d2, this);
    }

    public Vector4d rotateZ(double d2, Vector4d vector4d) {
        double d3 = Math.sin(d2);
        double d4 = Math.cosFromSin(d3, d2);
        double d5 = this.x * d4 - this.y * d3;
        double d6 = this.x * d3 + this.y * d4;
        vector4d.x = d5;
        vector4d.y = d6;
        vector4d.z = this.z;
        vector4d.w = this.w;
        return vector4d;
    }

    public double lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
    }

    public static double lengthSquared(double d2, double d3, double d4, double d5) {
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        return Math.fma(d6, d6, Math.fma(d7, d7, Math.fma(d8, d8, d9 * d9)));
    }

    public double length() {
        return Math.sqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w))));
    }

    public static double length(double d2, double d3, double d4, double d5) {
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        return Math.sqrt(Math.fma(d6, d6, Math.fma(d7, d7, Math.fma(d8, d8, d9 * d9))));
    }

    public Vector4d normalize() {
        Vector4d vector4d = this;
        return vector4d.normalize(vector4d);
    }

    public Vector4d normalize(Vector4d vector4d) {
        double d2 = 1.0 / this.length();
        vector4d.x = this.x * d2;
        vector4d.y = this.y * d2;
        vector4d.z = this.z * d2;
        vector4d.w = this.w * d2;
        return vector4d;
    }

    public Vector4d normalize(double d2) {
        return this.normalize(d2, this);
    }

    public Vector4d normalize(double d2, Vector4d vector4d) {
        double d3 = 1.0 / this.length() * d2;
        vector4d.x = this.x * d3;
        vector4d.y = this.y * d3;
        vector4d.z = this.z * d3;
        vector4d.w = this.w * d3;
        return vector4d;
    }

    public Vector4d normalize3() {
        Vector4d vector4d = this;
        return vector4d.normalize3(vector4d);
    }

    public Vector4d normalize3(Vector4d vector4d) {
        double d2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        vector4d.x = this.x * d2;
        vector4d.y = this.y * d2;
        vector4d.z = this.z * d2;
        vector4d.w = this.w * d2;
        return vector4d;
    }

    public double distance(Vector4dc vector4dc) {
        double d2 = this.x - vector4dc.x();
        double d3 = this.y - vector4dc.y();
        double d4 = this.z - vector4dc.z();
        double d5 = this.w - vector4dc.w();
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        return Math.sqrt(Math.fma(d6, d6, Math.fma(d7, d7, Math.fma(d8, d8, d9 * d9))));
    }

    public double distance(double d2, double d3, double d4, double d5) {
        double d6 = this.x - d2;
        double d7 = this.y - d3;
        double d8 = this.z - d4;
        double d9 = this.w - d5;
        double d10 = d6;
        double d11 = d7;
        double d12 = d8;
        double d13 = d9;
        return Math.sqrt(Math.fma(d10, d10, Math.fma(d11, d11, Math.fma(d12, d12, d13 * d13))));
    }

    public double distanceSquared(Vector4dc vector4dc) {
        double d2 = this.x - vector4dc.x();
        double d3 = this.y - vector4dc.y();
        double d4 = this.z - vector4dc.z();
        double d5 = this.w - vector4dc.w();
        double d6 = d2;
        double d7 = d3;
        double d8 = d4;
        double d9 = d5;
        return Math.fma(d6, d6, Math.fma(d7, d7, Math.fma(d8, d8, d9 * d9)));
    }

    public double distanceSquared(double d2, double d3, double d4, double d5) {
        double d6 = this.x - d2;
        double d7 = this.y - d3;
        double d8 = this.z - d4;
        double d9 = this.w - d5;
        double d10 = d6;
        double d11 = d7;
        double d12 = d8;
        double d13 = d9;
        return Math.fma(d10, d10, Math.fma(d11, d11, Math.fma(d12, d12, d13 * d13)));
    }

    public static double distance(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d2 - d6;
        double d11 = d3 - d7;
        double d12 = d4 - d8;
        double d13 = d5 - d9;
        double d14 = d10;
        double d15 = d11;
        double d16 = d12;
        double d17 = d13;
        return Math.sqrt(Math.fma(d14, d14, Math.fma(d15, d15, Math.fma(d16, d16, d17 * d17))));
    }

    public static double distanceSquared(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d2 - d6;
        double d11 = d3 - d7;
        double d12 = d4 - d8;
        double d13 = d5 - d9;
        double d14 = d10;
        double d15 = d11;
        double d16 = d12;
        double d17 = d13;
        return Math.fma(d14, d14, Math.fma(d15, d15, Math.fma(d16, d16, d17 * d17)));
    }

    public double dot(Vector4dc vector4dc) {
        return Math.fma(this.x, vector4dc.x(), Math.fma(this.y, vector4dc.y(), Math.fma(this.z, vector4dc.z(), this.w * vector4dc.w())));
    }

    public double dot(double d2, double d3, double d4, double d5) {
        return Math.fma(this.x, d2, Math.fma(this.y, d3, Math.fma(this.z, d4, this.w * d5)));
    }

    public double angleCos(Vector4dc vector4dc) {
        double d2 = Math.fma(this.x, this.x, Math.fma(this.y, this.y, Math.fma(this.z, this.z, this.w * this.w)));
        double d3 = Math.fma(vector4dc.x(), vector4dc.x(), Math.fma(vector4dc.y(), vector4dc.y(), Math.fma(vector4dc.z(), vector4dc.z(), vector4dc.w() * vector4dc.w())));
        return Math.fma(this.x, vector4dc.x(), Math.fma(this.y, vector4dc.y(), Math.fma(this.z, vector4dc.z(), this.w * vector4dc.w()))) / Math.sqrt(d2 * d3);
    }

    public double angle(Vector4dc vector4dc) {
        double d2;
        double d3 = this.angleCos(vector4dc);
        d3 = d2 < 1.0 ? d3 : 1.0;
        return Math.acos(d3 > -1.0 ? d3 : -1.0);
    }

    public Vector4d zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.w = 0.0;
        return this;
    }

    public Vector4d negate() {
        Vector4d vector4d = this;
        return vector4d.negate(vector4d);
    }

    public Vector4d negate(Vector4d vector4d) {
        vector4d.x = -this.x;
        vector4d.y = -this.y;
        vector4d.z = -this.z;
        vector4d.w = -this.w;
        return vector4d;
    }

    public Vector4d min(Vector4dc vector4dc) {
        return this.min(vector4dc, this);
    }

    public Vector4d min(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x < vector4dc.x() ? this.x : vector4dc.x();
        vector4d.y = this.y < vector4dc.y() ? this.y : vector4dc.y();
        vector4d.z = this.z < vector4dc.z() ? this.z : vector4dc.z();
        vector4d.w = this.w < vector4dc.w() ? this.w : vector4dc.w();
        return vector4d;
    }

    public Vector4d max(Vector4dc vector4dc) {
        return this.max(vector4dc, this);
    }

    public Vector4d max(Vector4dc vector4dc, Vector4d vector4d) {
        vector4d.x = this.x > vector4dc.x() ? this.x : vector4dc.x();
        vector4d.y = this.y > vector4dc.y() ? this.y : vector4dc.y();
        vector4d.z = this.z > vector4dc.z() ? this.z : vector4dc.z();
        vector4d.w = this.w > vector4dc.w() ? this.w : vector4dc.w();
        return vector4d;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + " " + Runtime.format(this.w, numberFormat) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeDouble(this.x);
        objectOutput.writeDouble(this.y);
        objectOutput.writeDouble(this.z);
        objectOutput.writeDouble(this.w);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readDouble();
        this.y = objectInput.readDouble();
        this.z = objectInput.readDouble();
        this.w = objectInput.readDouble();
    }

    public int hashCode() {
        long l2;
        long l3 = l2 = Double.doubleToLongBits(this.w);
        int n2 = 31 + (int)(l3 ^ l3 >>> 32);
        long l4 = l2 = Double.doubleToLongBits(this.x);
        n2 = n2 * 31 + (int)(l4 ^ l4 >>> 32);
        long l5 = l2 = Double.doubleToLongBits(this.y);
        n2 = n2 * 31 + (int)(l5 ^ l5 >>> 32);
        long l6 = l2 = Double.doubleToLongBits(this.z);
        return n2 * 31 + (int)(l6 ^ l6 >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Vector4d)object;
        if (Double.doubleToLongBits(this.w) != Double.doubleToLongBits(((Vector4d)object).w)) {
            return false;
        }
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(((Vector4d)object).x)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(((Vector4d)object).y)) {
            return false;
        }
        return Double.doubleToLongBits(this.z) == Double.doubleToLongBits(((Vector4d)object).z);
    }

    public boolean equals(Vector4dc vector4dc, double d2) {
        if (this == vector4dc) {
            return true;
        }
        if (vector4dc == null) {
            return false;
        }
        if (this.getClass() != vector4dc.getClass()) {
            return false;
        }
        if (!Runtime.equals(this.x, vector4dc.x(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.y, vector4dc.y(), d2)) {
            return false;
        }
        if (!Runtime.equals(this.z, vector4dc.z(), d2)) {
            return false;
        }
        return Runtime.equals(this.w, vector4dc.w(), d2);
    }

    public boolean equals(double d2, double d3, double d4, double d5) {
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(d2)) {
            return false;
        }
        if (Double.doubleToLongBits(this.y) != Double.doubleToLongBits(d3)) {
            return false;
        }
        if (Double.doubleToLongBits(this.z) != Double.doubleToLongBits(d4)) {
            return false;
        }
        return Double.doubleToLongBits(this.w) == Double.doubleToLongBits(d5);
    }

    public Vector4d smoothStep(Vector4dc vector4dc, double d2, Vector4d vector4d) {
        double d3 = d2;
        double d4 = d3 * d3;
        double d5 = d4 * d2;
        vector4d.x = (this.x + this.x - vector4dc.x() - vector4dc.x()) * d5 + (3.0 * vector4dc.x() - 3.0 * this.x) * d4 + this.x * d2 + this.x;
        vector4d.y = (this.y + this.y - vector4dc.y() - vector4dc.y()) * d5 + (3.0 * vector4dc.y() - 3.0 * this.y) * d4 + this.y * d2 + this.y;
        vector4d.z = (this.z + this.z - vector4dc.z() - vector4dc.z()) * d5 + (3.0 * vector4dc.z() - 3.0 * this.z) * d4 + this.z * d2 + this.z;
        vector4d.w = (this.w + this.w - vector4dc.w() - vector4dc.w()) * d5 + (3.0 * vector4dc.w() - 3.0 * this.w) * d4 + this.w * d2 + this.w;
        return vector4d;
    }

    public Vector4d hermite(Vector4dc vector4dc, Vector4dc vector4dc2, Vector4dc vector4dc3, double d2, Vector4d vector4d) {
        double d3 = d2;
        double d4 = d3 * d3;
        double d5 = d4 * d2;
        vector4d.x = (this.x + this.x - vector4dc2.x() - vector4dc2.x() + vector4dc3.x() + vector4dc.x()) * d5 + (3.0 * vector4dc2.x() - 3.0 * this.x - vector4dc.x() - vector4dc.x() - vector4dc3.x()) * d4 + this.x * d2 + this.x;
        vector4d.y = (this.y + this.y - vector4dc2.y() - vector4dc2.y() + vector4dc3.y() + vector4dc.y()) * d5 + (3.0 * vector4dc2.y() - 3.0 * this.y - vector4dc.y() - vector4dc.y() - vector4dc3.y()) * d4 + this.y * d2 + this.y;
        vector4d.z = (this.z + this.z - vector4dc2.z() - vector4dc2.z() + vector4dc3.z() + vector4dc.z()) * d5 + (3.0 * vector4dc2.z() - 3.0 * this.z - vector4dc.z() - vector4dc.z() - vector4dc3.z()) * d4 + this.z * d2 + this.z;
        vector4d.w = (this.w + this.w - vector4dc2.w() - vector4dc2.w() + vector4dc3.w() + vector4dc.w()) * d5 + (3.0 * vector4dc2.w() - 3.0 * this.w - vector4dc.w() - vector4dc.w() - vector4dc3.w()) * d4 + this.w * d2 + this.w;
        return vector4d;
    }

    public Vector4d lerp(Vector4dc vector4dc, double d2) {
        return this.lerp(vector4dc, d2, this);
    }

    public Vector4d lerp(Vector4dc vector4dc, double d2, Vector4d vector4d) {
        vector4d.x = Math.fma(vector4dc.x() - this.x, d2, this.x);
        vector4d.y = Math.fma(vector4dc.y() - this.y, d2, this.y);
        vector4d.z = Math.fma(vector4dc.z() - this.z, d2, this.z);
        vector4d.w = Math.fma(vector4dc.w() - this.w, d2, this.w);
        return vector4d;
    }

    public double get(int n2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector4i get(int n2, Vector4i vector4i) {
        vector4i.x = Math.roundUsing(this.x(), n2);
        vector4i.y = Math.roundUsing(this.y(), n2);
        vector4i.z = Math.roundUsing(this.z(), n2);
        vector4i.w = Math.roundUsing(this.w(), n2);
        return vector4i;
    }

    public Vector4f get(Vector4f vector4f) {
        vector4f.x = (float)this.x();
        vector4f.y = (float)this.y();
        vector4f.z = (float)this.z();
        vector4f.w = (float)this.w();
        return vector4f;
    }

    public Vector4d get(Vector4d vector4d) {
        vector4d.x = this.x();
        vector4d.y = this.y();
        vector4d.z = this.z();
        vector4d.w = this.w();
        return vector4d;
    }

    public int maxComponent() {
        double d2 = Math.abs(this.x);
        double d3 = Math.abs(this.y);
        double d4 = Math.abs(this.z);
        double d5 = Math.abs(this.w);
        if (d2 >= d3 && d2 >= d4 && d2 >= d5) {
            return 0;
        }
        if (d3 >= d4 && d3 >= d5) {
            return 1;
        }
        if (d4 >= d5) {
            return 2;
        }
        return 3;
    }

    public int minComponent() {
        double d2 = Math.abs(this.x);
        double d3 = Math.abs(this.y);
        double d4 = Math.abs(this.z);
        double d5 = Math.abs(this.w);
        if (d2 < d3 && d2 < d4 && d2 < d5) {
            return 0;
        }
        if (d3 < d4 && d3 < d5) {
            return 1;
        }
        if (d4 < d5) {
            return 2;
        }
        return 3;
    }

    public Vector4d floor() {
        Vector4d vector4d = this;
        return vector4d.floor(vector4d);
    }

    public Vector4d floor(Vector4d vector4d) {
        vector4d.x = Math.floor(this.x);
        vector4d.y = Math.floor(this.y);
        vector4d.z = Math.floor(this.z);
        vector4d.w = Math.floor(this.w);
        return vector4d;
    }

    public Vector4d ceil() {
        Vector4d vector4d = this;
        return vector4d.ceil(vector4d);
    }

    public Vector4d ceil(Vector4d vector4d) {
        vector4d.x = Math.ceil(this.x);
        vector4d.y = Math.ceil(this.y);
        vector4d.z = Math.ceil(this.z);
        vector4d.w = Math.ceil(this.w);
        return vector4d;
    }

    public Vector4d round() {
        Vector4d vector4d = this;
        return vector4d.round(vector4d);
    }

    public Vector4d round(Vector4d vector4d) {
        vector4d.x = Math.round(this.x);
        vector4d.y = Math.round(this.y);
        vector4d.z = Math.round(this.z);
        vector4d.w = Math.round(this.w);
        return vector4d;
    }

    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z) && Math.isFinite(this.w);
    }

    public Vector4d absolute() {
        Vector4d vector4d = this;
        return vector4d.absolute(vector4d);
    }

    public Vector4d absolute(Vector4d vector4d) {
        vector4d.x = Math.abs(this.x);
        vector4d.y = Math.abs(this.y);
        vector4d.z = Math.abs(this.z);
        vector4d.w = Math.abs(this.w);
        return vector4d;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

