/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2L;
import org.joml.Vector2Lc;
import org.joml.Vector2d;
import org.joml.Vector2f;
import org.joml.Vector2ic;
import org.joml.Vector3L;
import org.joml.Vector3Lc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector3ic;
import org.joml.Vector4Lc;
import org.joml.Vector4dc;
import org.joml.Vector4fc;
import org.joml.Vector4ic;

public class Vector4L
implements Externalizable,
Cloneable,
Vector4Lc {
    private static final long serialVersionUID = 1L;
    public long x;
    public long y;
    public long z;
    public long w;

    public Vector4L() {
        this.w = 1L;
    }

    public Vector4L(Vector4Lc vector4Lc) {
        this.x = vector4Lc.x();
        this.y = vector4Lc.y();
        this.z = vector4Lc.z();
        this.w = vector4Lc.w();
    }

    public Vector4L(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
    }

    public Vector4L(Vector3Lc vector3Lc, long l2) {
        this.x = vector3Lc.x();
        this.y = vector3Lc.y();
        this.z = vector3Lc.z();
        this.w = l2;
    }

    public Vector4L(Vector3ic vector3ic, long l2) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = l2;
    }

    public Vector4L(Vector2Lc vector2Lc, long l2, long l3) {
        this.x = vector2Lc.x();
        this.y = vector2Lc.y();
        this.z = l2;
        this.w = l3;
    }

    public Vector4L(Vector2ic vector2ic, long l2, long l3) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = l2;
        this.w = l3;
    }

    public Vector4L(Vector3fc vector3fc, float f2, int n2) {
        this.x = Math.roundLongUsing(vector3fc.x(), n2);
        this.y = Math.roundLongUsing(vector3fc.y(), n2);
        this.z = Math.roundLongUsing(vector3fc.z(), n2);
        this.w = Math.roundLongUsing(f2, n2);
    }

    public Vector4L(Vector4fc vector4fc, int n2) {
        this.x = Math.roundLongUsing(vector4fc.x(), n2);
        this.y = Math.roundLongUsing(vector4fc.y(), n2);
        this.z = Math.roundLongUsing(vector4fc.z(), n2);
        this.w = Math.roundLongUsing(vector4fc.w(), n2);
    }

    public Vector4L(Vector4dc vector4dc, int n2) {
        this.x = Math.roundLongUsing(vector4dc.x(), n2);
        this.y = Math.roundLongUsing(vector4dc.y(), n2);
        this.z = Math.roundLongUsing(vector4dc.z(), n2);
        this.w = Math.roundLongUsing(vector4dc.w(), n2);
    }

    public Vector4L(long l2) {
        this.x = l2;
        this.y = l2;
        this.z = l2;
        this.w = l2;
    }

    public Vector4L(long l2, long l3, long l4, long l5) {
        this.x = l2;
        this.y = l3;
        this.z = l4;
        this.w = l5;
    }

    public Vector4L(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
        this.z = nArray[2];
        this.w = nArray[3];
    }

    public Vector4L(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector4L(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
    }

    public Vector4L(LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, longBuffer.position(), longBuffer);
    }

    public Vector4L(int n2, LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, n2, longBuffer);
    }

    public long x() {
        return this.x;
    }

    public long y() {
        return this.y;
    }

    public long z() {
        return this.z;
    }

    public long w() {
        return this.w;
    }

    public Vector3f xyz(Vector3f vector3f) {
        return vector3f.set(this.x, this.y, this.z);
    }

    public Vector3d xyz(Vector3d vector3d) {
        return vector3d.set(this.x, this.y, this.z);
    }

    public Vector3L xyz(Vector3L vector3L) {
        return vector3L.set(this.x, this.y, this.z);
    }

    public Vector2f xy(Vector2f vector2f) {
        return vector2f.set(this.x, this.y);
    }

    public Vector2d xy(Vector2d vector2d) {
        return vector2d.set(this.x, this.y);
    }

    public Vector2L xy(Vector2L vector2L) {
        return vector2L.set(this.x, this.y);
    }

    public Vector4L set(Vector4Lc vector4Lc) {
        this.x = vector4Lc.x();
        this.y = vector4Lc.y();
        this.z = vector4Lc.z();
        this.w = vector4Lc.w();
        return this;
    }

    public Vector4L set(Vector4ic vector4ic) {
        this.x = vector4ic.x();
        this.y = vector4ic.y();
        this.z = vector4ic.z();
        this.w = vector4ic.w();
        return this;
    }

    public Vector4L set(Vector4dc vector4dc) {
        this.x = (int)vector4dc.x();
        this.y = (int)vector4dc.y();
        this.z = (int)vector4dc.z();
        this.w = (int)vector4dc.w();
        return this;
    }

    public Vector4L set(Vector4dc vector4dc, int n2) {
        this.x = Math.roundLongUsing(vector4dc.x(), n2);
        this.y = Math.roundLongUsing(vector4dc.y(), n2);
        this.z = Math.roundLongUsing(vector4dc.z(), n2);
        this.w = Math.roundLongUsing(vector4dc.w(), n2);
        return this;
    }

    public Vector4L set(Vector4fc vector4fc, int n2) {
        this.x = Math.roundLongUsing(vector4fc.x(), n2);
        this.y = Math.roundLongUsing(vector4fc.y(), n2);
        this.z = Math.roundLongUsing(vector4fc.z(), n2);
        this.w = Math.roundLongUsing(vector4fc.w(), n2);
        return this;
    }

    public Vector4L set(Vector3ic vector3ic, long l2) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        this.w = l2;
        return this;
    }

    public Vector4L set(Vector2ic vector2ic, long l2, long l3) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = l2;
        this.w = l3;
        return this;
    }

    public Vector4L set(long l2) {
        this.x = l2;
        this.y = l2;
        this.z = l2;
        this.w = l2;
        return this;
    }

    public Vector4L set(long l2, long l3, long l4, long l5) {
        this.x = l2;
        this.y = l3;
        this.z = l4;
        this.w = l5;
        return this;
    }

    public Vector4L set(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
        this.z = nArray[2];
        this.w = nArray[3];
        return this;
    }

    public Vector4L set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector4L set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Vector4L set(LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, longBuffer.position(), longBuffer);
        return this;
    }

    public Vector4L set(int n2, LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, n2, longBuffer);
        return this;
    }

    public Vector4L setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l2);
        return this;
    }

    public long get(int n2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
            case 3: {
                return this.w;
            }
        }
        throw new IllegalArgumentException();
    }

    public int maxComponent() {
        long l2 = Math.abs(this.x);
        long l3 = Math.abs(this.y);
        long l4 = Math.abs(this.z);
        long l5 = Math.abs(this.w);
        if (l2 >= l3 && l2 >= l4 && l2 >= l5) {
            return 0;
        }
        if (l3 >= l4 && l3 >= l5) {
            return 1;
        }
        if (l4 >= l5) {
            return 2;
        }
        return 3;
    }

    public int minComponent() {
        long l2 = Math.abs(this.x);
        long l3 = Math.abs(this.y);
        long l4 = Math.abs(this.z);
        long l5 = Math.abs(this.w);
        if (l2 < l3 && l2 < l4 && l2 < l5) {
            return 0;
        }
        if (l3 < l4 && l3 < l5) {
            return 1;
        }
        if (l4 < l5) {
            return 2;
        }
        return 3;
    }

    public Vector4L setComponent(int n2, long l2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                this.x = l2;
                break;
            }
            case 1: {
                this.y = l2;
                break;
            }
            case 2: {
                this.z = l2;
                break;
            }
            case 3: {
                this.w = l2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public LongBuffer get(LongBuffer longBuffer) {
        MemUtil.INSTANCE.put(this, longBuffer.position(), longBuffer);
        return longBuffer;
    }

    public LongBuffer get(int n2, LongBuffer longBuffer) {
        MemUtil.INSTANCE.put(this, n2, longBuffer);
        return longBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Vector4Lc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Vector4L sub(Vector4Lc vector4Lc) {
        return this.sub(vector4Lc, this);
    }

    public Vector4L sub(Vector4Lc vector4Lc, Vector4L vector4L) {
        vector4L.x = this.x - vector4Lc.x();
        vector4L.y = this.y - vector4Lc.y();
        vector4L.z = this.z - vector4Lc.z();
        vector4L.w = this.w - vector4Lc.w();
        return vector4L;
    }

    public Vector4L sub(Vector4ic vector4ic) {
        return this.sub(vector4ic, this);
    }

    public Vector4L sub(Vector4ic vector4ic, Vector4L vector4L) {
        vector4L.x = this.x - (long)vector4ic.x();
        vector4L.y = this.y - (long)vector4ic.y();
        vector4L.z = this.z - (long)vector4ic.z();
        vector4L.w = this.w - (long)vector4ic.w();
        return vector4L;
    }

    public Vector4L sub(long l2, long l3, long l4, long l5) {
        return this.sub(l2, l3, l4, l5, this);
    }

    public Vector4L sub(long l2, long l3, long l4, long l5, Vector4L vector4L) {
        vector4L.x = this.x - l2;
        vector4L.y = this.y - l3;
        vector4L.z = this.z - l4;
        vector4L.w = this.w - l5;
        return vector4L;
    }

    public Vector4L add(Vector4Lc vector4Lc) {
        return this.add(vector4Lc, this);
    }

    public Vector4L add(Vector4Lc vector4Lc, Vector4L vector4L) {
        vector4L.x = this.x + vector4Lc.x();
        vector4L.y = this.y + vector4Lc.y();
        vector4L.z = this.z + vector4Lc.z();
        vector4L.w = this.w + vector4Lc.w();
        return vector4L;
    }

    public Vector4L add(Vector4ic vector4ic) {
        return this.add(vector4ic, this);
    }

    public Vector4L add(Vector4ic vector4ic, Vector4L vector4L) {
        vector4L.x = this.x + (long)vector4ic.x();
        vector4L.y = this.y + (long)vector4ic.y();
        vector4L.z = this.z + (long)vector4ic.z();
        vector4L.w = this.w + (long)vector4ic.w();
        return vector4L;
    }

    public Vector4L add(long l2, long l3, long l4, long l5) {
        return this.add(l2, l3, l4, l5, this);
    }

    public Vector4L add(long l2, long l3, long l4, long l5, Vector4L vector4L) {
        vector4L.x = this.x + l2;
        vector4L.y = this.y + l3;
        vector4L.z = this.z + l4;
        vector4L.w = this.w + l5;
        return vector4L;
    }

    public Vector4L mul(Vector4Lc vector4Lc) {
        return this.mul(vector4Lc, this);
    }

    public Vector4L mul(Vector4Lc vector4Lc, Vector4L vector4L) {
        vector4L.x = this.x * vector4Lc.x();
        vector4L.y = this.y * vector4Lc.y();
        vector4L.z = this.z * vector4Lc.z();
        vector4L.w = this.w * vector4Lc.w();
        return vector4L;
    }

    public Vector4L mul(Vector4ic vector4ic) {
        return this.mul(vector4ic, this);
    }

    public Vector4L mul(Vector4ic vector4ic, Vector4L vector4L) {
        vector4L.x = this.x * (long)vector4ic.x();
        vector4L.y = this.y * (long)vector4ic.y();
        vector4L.z = this.z * (long)vector4ic.z();
        vector4L.w = this.w * (long)vector4ic.w();
        return vector4L;
    }

    public Vector4L div(Vector4Lc vector4Lc) {
        return this.div(vector4Lc, this);
    }

    public Vector4L div(Vector4Lc vector4Lc, Vector4L vector4L) {
        vector4L.x = this.x / vector4Lc.x();
        vector4L.y = this.y / vector4Lc.y();
        vector4L.z = this.z / vector4Lc.z();
        vector4L.w = this.w / vector4Lc.w();
        return vector4L;
    }

    public Vector4L div(Vector4ic vector4ic) {
        return this.div(vector4ic, this);
    }

    public Vector4L div(Vector4ic vector4ic, Vector4L vector4L) {
        vector4L.x = this.x / (long)vector4ic.x();
        vector4L.y = this.y / (long)vector4ic.y();
        vector4L.z = this.z / (long)vector4ic.z();
        vector4L.w = this.w / (long)vector4ic.w();
        return vector4L;
    }

    public Vector4L mul(long l2) {
        return this.mul(l2, this);
    }

    public Vector4L mul(long l2, Vector4L vector4L) {
        vector4L.x = this.x * l2;
        vector4L.y = this.y * l2;
        vector4L.z = this.z * l2;
        vector4L.w = this.w * l2;
        return vector4L;
    }

    public Vector4L div(float f2) {
        return this.div(f2, this);
    }

    public Vector4L div(float f2, Vector4L vector4L) {
        f2 = 1.0f / f2;
        vector4L.x = (int)((float)this.x * f2);
        vector4L.y = (int)((float)this.y * f2);
        vector4L.z = (int)((float)this.z * f2);
        vector4L.w = (int)((float)this.w * f2);
        return vector4L;
    }

    public Vector4L div(long l2) {
        return this.div(l2, this);
    }

    public Vector4L div(long l2, Vector4L vector4L) {
        vector4L.x = this.x / l2;
        vector4L.y = this.y / l2;
        vector4L.z = this.z / l2;
        vector4L.w = this.w / l2;
        return vector4L;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public static long lengthSquared(long l2, long l3, long l4, long l5) {
        long l6 = l2;
        long l7 = l3;
        long l8 = l4;
        long l9 = l5;
        return l6 * l6 + l7 * l7 + l8 * l8 + l9 * l9;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public static double length(long l2, long l3, long l4, long l5) {
        long l6 = l2;
        long l7 = l3;
        long l8 = l4;
        long l9 = l5;
        return Math.sqrt(l6 * l6 + l7 * l7 + l8 * l8 + l9 * l9);
    }

    public double distance(Vector4Lc vector4Lc) {
        return this.distance(vector4Lc.x(), vector4Lc.y(), vector4Lc.z(), vector4Lc.w());
    }

    public double distance(Vector4ic vector4ic) {
        return this.distance(vector4ic.x(), vector4ic.y(), vector4ic.z(), vector4ic.w());
    }

    public double distance(long l2, long l3, long l4, long l5) {
        long l6;
        long l7 = this.x - l2;
        long l8 = this.y - l3;
        long l9 = this.z - l4;
        long l10 = l6 = this.w - l5;
        return Math.sqrt(Math.fma(l7, l7, Math.fma(l8, l8, Math.fma(l9, l9, l10 * l10))));
    }

    public long gridDistance(Vector4Lc vector4Lc) {
        return Math.abs(vector4Lc.x() - this.x()) + Math.abs(vector4Lc.y() - this.y()) + Math.abs(vector4Lc.z() - this.z()) + Math.abs(vector4Lc.w() - this.w());
    }

    public long gridDistance(Vector4ic vector4ic) {
        return Math.abs((long)vector4ic.x() - this.x()) + Math.abs((long)vector4ic.y() - this.y()) + Math.abs((long)vector4ic.z() - this.z()) + Math.abs((long)vector4ic.w() - this.w());
    }

    public long gridDistance(long l2, long l3, long l4, long l5) {
        return Math.abs(l2 - this.x()) + Math.abs(l3 - this.y()) + Math.abs(l4 - this.z()) + Math.abs(l5 - this.w());
    }

    public long distanceSquared(Vector4Lc vector4Lc) {
        return this.distanceSquared(vector4Lc.x(), vector4Lc.y(), vector4Lc.z(), vector4Lc.w());
    }

    public long distanceSquared(Vector4ic vector4ic) {
        return this.distanceSquared(vector4ic.x(), vector4ic.y(), vector4ic.z(), vector4ic.w());
    }

    public long distanceSquared(long l2, long l3, long l4, long l5) {
        long l6 = this.x - l2;
        long l7 = this.y - l3;
        long l8 = this.z - l4;
        long l9 = this.w - l5;
        long l10 = l6;
        long l11 = l7;
        long l12 = l8;
        long l13 = l9;
        return l10 * l10 + l11 * l11 + l12 * l12 + l13 * l13;
    }

    public static double distance(long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9) {
        long l10 = l2 - l6;
        long l11 = l3 - l7;
        long l12 = l4 - l8;
        long l13 = l5 - l9;
        long l14 = l10;
        long l15 = l11;
        long l16 = l12;
        long l17 = l13;
        return Math.sqrt(l14 * l14 + l15 * l15 + l16 * l16 + l17 * l17);
    }

    public static long distanceSquared(long l2, long l3, long l4, long l5, long l6, long l7, long l8, long l9) {
        long l10 = l2 - l6;
        long l11 = l3 - l7;
        long l12 = l4 - l8;
        long l13 = l5 - l9;
        long l14 = l10;
        long l15 = l11;
        long l16 = l12;
        long l17 = l13;
        return l14 * l14 + l15 * l15 + l16 * l16 + l17 * l17;
    }

    public long dot(Vector4Lc vector4Lc) {
        return this.x * vector4Lc.x() + this.y * vector4Lc.y() + this.z * vector4Lc.z() + this.w * vector4Lc.w();
    }

    public long dot(Vector4ic vector4ic) {
        return this.x * (long)vector4ic.x() + this.y * (long)vector4ic.y() + this.z * (long)vector4ic.z() + this.w * (long)vector4ic.w();
    }

    public Vector4L zero() {
        this.x = 0L;
        this.y = 0L;
        this.z = 0L;
        this.w = 0L;
        return this;
    }

    public Vector4L negate() {
        Vector4L vector4L = this;
        return vector4L.negate(vector4L);
    }

    public Vector4L negate(Vector4L vector4L) {
        vector4L.x = -this.x;
        vector4L.y = -this.y;
        vector4L.z = -this.z;
        vector4L.w = -this.w;
        return vector4L;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + numberFormat.format(this.x) + " " + numberFormat.format(this.y) + " " + numberFormat.format(this.z) + " " + numberFormat.format(this.w) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.x);
        objectOutput.writeLong(this.y);
        objectOutput.writeLong(this.z);
        objectOutput.writeLong(this.w);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readLong();
        this.y = objectInput.readLong();
        this.z = objectInput.readLong();
        this.w = objectInput.readLong();
    }

    public Vector4L min(Vector4Lc vector4Lc) {
        return this.min(vector4Lc, this);
    }

    public Vector4L min(Vector4Lc vector4Lc, Vector4L vector4L) {
        vector4L.x = this.x < vector4Lc.x() ? this.x : vector4Lc.x();
        vector4L.y = this.y < vector4Lc.y() ? this.y : vector4Lc.y();
        vector4L.z = this.z < vector4Lc.z() ? this.z : vector4Lc.z();
        vector4L.w = this.w < vector4Lc.w() ? this.w : vector4Lc.w();
        return vector4L;
    }

    public Vector4L max(Vector4Lc vector4Lc) {
        return this.max(vector4Lc, this);
    }

    public Vector4L max(Vector4Lc vector4Lc, Vector4L vector4L) {
        vector4L.x = this.x > vector4Lc.x() ? this.x : vector4Lc.x();
        vector4L.y = this.y > vector4Lc.y() ? this.y : vector4Lc.y();
        vector4L.z = this.z > vector4Lc.z() ? this.z : vector4Lc.z();
        vector4L.w = this.w > vector4Lc.w() ? this.w : vector4Lc.w();
        return vector4L;
    }

    public Vector4L absolute() {
        Vector4L vector4L = this;
        return vector4L.absolute(vector4L);
    }

    public Vector4L absolute(Vector4L vector4L) {
        vector4L.x = Math.abs(this.x);
        vector4L.y = Math.abs(this.y);
        vector4L.z = Math.abs(this.z);
        vector4L.w = Math.abs(this.w);
        return vector4L;
    }

    public int hashCode() {
        return (((31 + (int)(this.x ^ this.x >>> 32)) * 31 + (int)(this.y ^ this.y >>> 32)) * 31 + (int)(this.z ^ this.z >>> 32)) * 31 + (int)(this.w ^ this.w >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Vector4L)object;
        if (this.x != ((Vector4L)object).x) {
            return false;
        }
        if (this.y != ((Vector4L)object).y) {
            return false;
        }
        if (this.z != ((Vector4L)object).z) {
            return false;
        }
        return this.w == ((Vector4L)object).w;
    }

    public boolean equals(long l2, long l3, long l4, long l5) {
        if (this.x != l2) {
            return false;
        }
        if (this.y != l3) {
            return false;
        }
        if (this.z != l4) {
            return false;
        }
        return this.w == l5;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

