/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2L;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector2ic;
import org.joml.Vector3Lc;
import org.joml.Vector3dc;
import org.joml.Vector3fc;

public class Vector3L
implements Externalizable,
Cloneable,
Vector3Lc {
    private static final long serialVersionUID = 1L;
    public long x;
    public long y;
    public long z;

    public Vector3L() {
    }

    public Vector3L(int n2) {
        this.x = n2;
        this.y = n2;
        this.z = n2;
    }

    public Vector3L(int n2, int n3, int n4) {
        this.x = n2;
        this.y = n3;
        this.z = n4;
    }

    public Vector3L(Vector3Lc vector3Lc) {
        this.x = vector3Lc.x();
        this.y = vector3Lc.y();
        this.z = vector3Lc.z();
    }

    public Vector3L(Vector2ic vector2ic, int n2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = n2;
    }

    public Vector3L(float f2, float f3, float f4, int n2) {
        this.x = Math.roundLongUsing(f2, n2);
        this.y = Math.roundLongUsing(f3, n2);
        this.z = Math.roundLongUsing(f4, n2);
    }

    public Vector3L(double d2, double d3, double d4, int n2) {
        this.x = Math.roundLongUsing(d2, n2);
        this.y = Math.roundLongUsing(d3, n2);
        this.z = Math.roundLongUsing(d4, n2);
    }

    public Vector3L(Vector2fc vector2fc, float f2, int n2) {
        this.x = Math.roundLongUsing(vector2fc.x(), n2);
        this.y = Math.roundLongUsing(vector2fc.y(), n2);
        this.z = Math.roundLongUsing(f2, n2);
    }

    public Vector3L(Vector3fc vector3fc, int n2) {
        this.x = Math.roundLongUsing(vector3fc.x(), n2);
        this.y = Math.roundLongUsing(vector3fc.y(), n2);
        this.z = Math.roundLongUsing(vector3fc.z(), n2);
    }

    public Vector3L(Vector2dc vector2dc, float f2, int n2) {
        this.x = Math.roundLongUsing(vector2dc.x(), n2);
        this.y = Math.roundLongUsing(vector2dc.y(), n2);
        this.z = Math.roundLongUsing(f2, n2);
    }

    public Vector3L(Vector3dc vector3dc, int n2) {
        this.x = Math.roundLongUsing(vector3dc.x(), n2);
        this.y = Math.roundLongUsing(vector3dc.y(), n2);
        this.z = Math.roundLongUsing(vector3dc.z(), n2);
    }

    public Vector3L(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
        this.z = nArray[2];
    }

    public Vector3L(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector3L(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
    }

    public Vector3L(LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, longBuffer.position(), longBuffer);
    }

    public Vector3L(int n2, LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, n2, longBuffer);
    }

    public long x() {
        return this.x;
    }

    public long y() {
        return this.y;
    }

    public long z() {
        return this.z;
    }

    public Vector2f xy(Vector2f vector2f) {
        return vector2f.set(this.x, this.y);
    }

    public Vector2d xy(Vector2d vector2d) {
        return vector2d.set(this.x, this.y);
    }

    public Vector2L xy(Vector2L vector2L) {
        return vector2L.set(this.x, this.y);
    }

    public Vector3L set(Vector3Lc vector3Lc) {
        this.x = vector3Lc.x();
        this.y = vector3Lc.y();
        this.z = vector3Lc.z();
        return this;
    }

    public Vector3L set(Vector3dc vector3dc) {
        this.x = (int)vector3dc.x();
        this.y = (int)vector3dc.y();
        this.z = (int)vector3dc.z();
        return this;
    }

    public Vector3L set(Vector3dc vector3dc, int n2) {
        this.x = Math.roundLongUsing(vector3dc.x(), n2);
        this.y = Math.roundLongUsing(vector3dc.y(), n2);
        this.z = Math.roundLongUsing(vector3dc.z(), n2);
        return this;
    }

    public Vector3L set(Vector3fc vector3fc, int n2) {
        this.x = Math.roundLongUsing(vector3fc.x(), n2);
        this.y = Math.roundLongUsing(vector3fc.y(), n2);
        this.z = Math.roundLongUsing(vector3fc.z(), n2);
        return this;
    }

    public Vector3L set(Vector2ic vector2ic, long l2) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = l2;
        return this;
    }

    public Vector3L set(long l2) {
        this.x = l2;
        this.y = l2;
        this.z = l2;
        return this;
    }

    public Vector3L set(long l2, long l3, long l4) {
        this.x = l2;
        this.y = l3;
        this.z = l4;
        return this;
    }

    public Vector3L set(long[] lArray) {
        this.x = lArray[0];
        this.y = lArray[1];
        this.z = lArray[2];
        return this;
    }

    public Vector3L set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector3L set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Vector3L set(LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, longBuffer.position(), longBuffer);
        return this;
    }

    public Vector3L set(int n2, LongBuffer longBuffer) {
        MemUtil.INSTANCE.get(this, n2, longBuffer);
        return this;
    }

    public Vector3L setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l2);
        return this;
    }

    public long get(int n2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector3L setComponent(int n2, int n3) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                this.x = n3;
                break;
            }
            case 1: {
                this.y = n3;
                break;
            }
            case 2: {
                this.z = n3;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public LongBuffer get(LongBuffer longBuffer) {
        MemUtil.INSTANCE.put(this, longBuffer.position(), longBuffer);
        return longBuffer;
    }

    public LongBuffer get(int n2, LongBuffer longBuffer) {
        MemUtil.INSTANCE.put(this, n2, longBuffer);
        return longBuffer;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public Vector3Lc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Vector3L sub(Vector3Lc vector3Lc) {
        return this.sub(vector3Lc, this);
    }

    public Vector3L sub(Vector3Lc vector3Lc, Vector3L vector3L) {
        vector3L.x = this.x - vector3Lc.x();
        vector3L.y = this.y - vector3Lc.y();
        vector3L.z = this.z - vector3Lc.z();
        return vector3L;
    }

    public Vector3L sub(long l2, long l3, long l4) {
        return this.sub(l2, l3, l4, this);
    }

    public Vector3L sub(long l2, long l3, long l4, Vector3L vector3L) {
        vector3L.x = this.x - l2;
        vector3L.y = this.y - l3;
        vector3L.z = this.z - l4;
        return vector3L;
    }

    public Vector3L add(Vector3Lc vector3Lc) {
        return this.add(vector3Lc, this);
    }

    public Vector3L add(Vector3Lc vector3Lc, Vector3L vector3L) {
        vector3L.x = this.x + vector3Lc.x();
        vector3L.y = this.y + vector3Lc.y();
        vector3L.z = this.z + vector3Lc.z();
        return vector3L;
    }

    public Vector3L add(long l2, long l3, long l4) {
        return this.add(l2, l3, l4, this);
    }

    public Vector3L add(long l2, long l3, long l4, Vector3L vector3L) {
        vector3L.x = this.x + l2;
        vector3L.y = this.y + l3;
        vector3L.z = this.z + l4;
        return vector3L;
    }

    public Vector3L mul(long l2) {
        return this.mul(l2, this);
    }

    public Vector3L mul(long l2, Vector3L vector3L) {
        vector3L.x = this.x * l2;
        vector3L.y = this.y * l2;
        vector3L.z = this.z * l2;
        return vector3L;
    }

    public Vector3L mul(Vector3Lc vector3Lc) {
        return this.mul(vector3Lc, this);
    }

    public Vector3L mul(Vector3Lc vector3Lc, Vector3L vector3L) {
        vector3L.x = this.x * vector3Lc.x();
        vector3L.y = this.y * vector3Lc.y();
        vector3L.z = this.z * vector3Lc.z();
        return vector3L;
    }

    public Vector3L mul(long l2, long l3, long l4) {
        return this.mul(l2, l3, l4, this);
    }

    public Vector3L mul(long l2, long l3, long l4, Vector3L vector3L) {
        vector3L.x = this.x * l2;
        vector3L.y = this.y * l3;
        vector3L.z = this.z * l4;
        return vector3L;
    }

    public Vector3L div(float f2) {
        return this.div(f2, this);
    }

    public Vector3L div(float f2, Vector3L vector3L) {
        f2 = 1.0f / f2;
        vector3L.x = (int)((float)this.x * f2);
        vector3L.y = (int)((float)this.y * f2);
        vector3L.z = (int)((float)this.z * f2);
        return vector3L;
    }

    public Vector3L div(long l2) {
        return this.div(l2, this);
    }

    public Vector3L div(long l2, Vector3L vector3L) {
        vector3L.x = this.x / l2;
        vector3L.y = this.y / l2;
        vector3L.z = this.z / l2;
        return vector3L;
    }

    public long lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public static long lengthSquared(long l2, long l3, long l4) {
        long l5 = l2;
        long l6 = l3;
        long l7 = l4;
        return l5 * l5 + l6 * l6 + l7 * l7;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public static double length(long l2, long l3, long l4) {
        long l5 = l2;
        long l6 = l3;
        long l7 = l4;
        return Math.sqrt(l5 * l5 + l6 * l6 + l7 * l7);
    }

    public double distance(Vector3Lc vector3Lc) {
        long l2 = this.x - vector3Lc.x();
        long l3 = this.y - vector3Lc.y();
        long l4 = this.z - vector3Lc.z();
        long l5 = l2;
        long l6 = l3;
        long l7 = l4;
        return Math.sqrt(l5 * l5 + l6 * l6 + l7 * l7);
    }

    public double distance(long l2, long l3, long l4) {
        long l5 = this.x - l2;
        long l6 = this.y - l3;
        long l7 = this.z - l4;
        long l8 = l5;
        long l9 = l6;
        long l10 = l7;
        return Math.sqrt(l8 * l8 + l9 * l9 + l10 * l10);
    }

    public long gridDistance(Vector3Lc vector3Lc) {
        return Math.abs(vector3Lc.x() - this.x()) + Math.abs(vector3Lc.y() - this.y()) + Math.abs(vector3Lc.z() - this.z());
    }

    public long gridDistance(long l2, long l3, long l4) {
        return Math.abs(l2 - this.x()) + Math.abs(l3 - this.y()) + Math.abs(l4 - this.z());
    }

    public long distanceSquared(Vector3Lc vector3Lc) {
        long l2 = this.x - vector3Lc.x();
        long l3 = this.y - vector3Lc.y();
        long l4 = this.z - vector3Lc.z();
        long l5 = l2;
        long l6 = l3;
        long l7 = l4;
        return l5 * l5 + l6 * l6 + l7 * l7;
    }

    public long distanceSquared(long l2, long l3, long l4) {
        long l5 = this.x - l2;
        long l6 = this.y - l3;
        long l7 = this.z - l4;
        long l8 = l5;
        long l9 = l6;
        long l10 = l7;
        return l8 * l8 + l9 * l9 + l10 * l10;
    }

    public static double distance(long l2, long l3, long l4, long l5, long l6, long l7) {
        return Math.sqrt(Vector3L.distanceSquared(l2, l3, l4, l5, l6, l7));
    }

    public static long distanceSquared(long l2, long l3, long l4, long l5, long l6, long l7) {
        long l8 = l2 - l5;
        long l9 = l3 - l6;
        long l10 = l4 - l7;
        long l11 = l8;
        long l12 = l9;
        long l13 = l10;
        return l11 * l11 + l12 * l12 + l13 * l13;
    }

    public Vector3L zero() {
        this.x = 0L;
        this.y = 0L;
        this.z = 0L;
        return this;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + numberFormat.format(this.x) + " " + numberFormat.format(this.y) + " " + numberFormat.format(this.z) + ")";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.x);
        objectOutput.writeLong(this.y);
        objectOutput.writeLong(this.z);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readLong();
        this.y = objectInput.readLong();
        this.z = objectInput.readLong();
    }

    public Vector3L negate() {
        Vector3L vector3L = this;
        return vector3L.negate(vector3L);
    }

    public Vector3L negate(Vector3L vector3L) {
        vector3L.x = -this.x;
        vector3L.y = -this.y;
        vector3L.z = -this.z;
        return vector3L;
    }

    public Vector3L min(Vector3Lc vector3Lc) {
        return this.min(vector3Lc, this);
    }

    public Vector3L min(Vector3Lc vector3Lc, Vector3L vector3L) {
        vector3L.x = this.x < vector3Lc.x() ? this.x : vector3Lc.x();
        vector3L.y = this.y < vector3Lc.y() ? this.y : vector3Lc.y();
        vector3L.z = this.z < vector3Lc.z() ? this.z : vector3Lc.z();
        return vector3L;
    }

    public Vector3L max(Vector3Lc vector3Lc) {
        return this.max(vector3Lc, this);
    }

    public Vector3L max(Vector3Lc vector3Lc, Vector3L vector3L) {
        vector3L.x = this.x > vector3Lc.x() ? this.x : vector3Lc.x();
        vector3L.y = this.y > vector3Lc.y() ? this.y : vector3Lc.y();
        vector3L.z = this.z > vector3Lc.z() ? this.z : vector3Lc.z();
        return vector3L;
    }

    public int maxComponent() {
        float f2 = Math.abs(this.x);
        float f3 = Math.abs(this.y);
        float f4 = Math.abs(this.z);
        if (f2 >= f3 && f2 >= f4) {
            return 0;
        }
        if (f3 >= f4) {
            return 1;
        }
        return 2;
    }

    public int minComponent() {
        float f2 = Math.abs(this.x);
        float f3 = Math.abs(this.y);
        float f4 = Math.abs(this.z);
        if (f2 < f3 && f2 < f4) {
            return 0;
        }
        if (f3 < f4) {
            return 1;
        }
        return 2;
    }

    public Vector3L absolute() {
        Vector3L vector3L = this;
        return vector3L.absolute(vector3L);
    }

    public Vector3L absolute(Vector3L vector3L) {
        vector3L.x = Math.abs(this.x);
        vector3L.y = Math.abs(this.y);
        vector3L.z = Math.abs(this.z);
        return vector3L;
    }

    public int hashCode() {
        return ((31 + (int)(this.x ^ this.x >>> 32)) * 31 + (int)(this.y ^ this.y >>> 32)) * 31 + (int)(this.z ^ this.z >>> 32);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Vector3L)object;
        if (this.x != ((Vector3L)object).x) {
            return false;
        }
        if (this.y != ((Vector3L)object).y) {
            return false;
        }
        return this.z == ((Vector3L)object).z;
    }

    public boolean equals(long l2, long l3, long l4) {
        if (this.x != l2) {
            return false;
        }
        if (this.y != l3) {
            return false;
        }
        return this.z == l4;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

