/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2ic;

public class Vector2i
implements Externalizable,
Cloneable,
Vector2ic {
    private static final long serialVersionUID = 1L;
    public int x;
    public int y;

    public Vector2i() {
    }

    public Vector2i(int n2) {
        this.x = n2;
        this.y = n2;
    }

    public Vector2i(int n2, int n3) {
        this.x = n2;
        this.y = n3;
    }

    public Vector2i(float f2, float f3, int n2) {
        this.x = Math.roundUsing(f2, n2);
        this.y = Math.roundUsing(f3, n2);
    }

    public Vector2i(double d2, double d3, int n2) {
        this.x = Math.roundUsing(d2, n2);
        this.y = Math.roundUsing(d3, n2);
    }

    public Vector2i(Vector2ic vector2ic) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
    }

    public Vector2i(Vector2fc vector2fc, int n2) {
        this.x = Math.roundUsing(vector2fc.x(), n2);
        this.y = Math.roundUsing(vector2fc.y(), n2);
    }

    public Vector2i(Vector2dc vector2dc, int n2) {
        this.x = Math.roundUsing(vector2dc.x(), n2);
        this.y = Math.roundUsing(vector2dc.y(), n2);
    }

    public Vector2i(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
    }

    public Vector2i(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector2i(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
    }

    public Vector2i(IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, intBuffer.position(), intBuffer);
    }

    public Vector2i(int n2, IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, n2, intBuffer);
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public Vector2i set(int n2) {
        this.x = n2;
        this.y = n2;
        return this;
    }

    public Vector2i set(int n2, int n3) {
        this.x = n2;
        this.y = n3;
        return this;
    }

    public Vector2i set(Vector2ic vector2ic) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        return this;
    }

    public Vector2i set(Vector2dc vector2dc) {
        this.x = (int)vector2dc.x();
        this.y = (int)vector2dc.y();
        return this;
    }

    public Vector2i set(Vector2dc vector2dc, int n2) {
        this.x = Math.roundUsing(vector2dc.x(), n2);
        this.y = Math.roundUsing(vector2dc.y(), n2);
        return this;
    }

    public Vector2i set(Vector2fc vector2fc, int n2) {
        this.x = Math.roundUsing(vector2fc.x(), n2);
        this.y = Math.roundUsing(vector2fc.y(), n2);
        return this;
    }

    public Vector2i set(int[] nArray) {
        this.x = nArray[0];
        this.y = nArray[1];
        return this;
    }

    public Vector2i set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector2i set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Vector2i set(IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, intBuffer.position(), intBuffer);
        return this;
    }

    public Vector2i set(int n2, IntBuffer intBuffer) {
        MemUtil.INSTANCE.get(this, n2, intBuffer);
        return this;
    }

    public Vector2i setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l2);
        return this;
    }

    public int get(int n2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector2i setComponent(int n2, int n3) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                this.x = n3;
                break;
            }
            case 1: {
                this.y = n3;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public IntBuffer get(IntBuffer intBuffer) {
        MemUtil.INSTANCE.put(this, intBuffer.position(), intBuffer);
        return intBuffer;
    }

    public IntBuffer get(int n2, IntBuffer intBuffer) {
        MemUtil.INSTANCE.put(this, n2, intBuffer);
        return intBuffer;
    }

    public Vector2ic getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Vector2i sub(Vector2ic vector2ic) {
        return this.sub(vector2ic, this);
    }

    public Vector2i sub(Vector2ic vector2ic, Vector2i vector2i) {
        vector2i.x = this.x - vector2ic.x();
        vector2i.y = this.y - vector2ic.y();
        return vector2i;
    }

    public Vector2i sub(int n2, int n3) {
        return this.sub(n2, n3, this);
    }

    public Vector2i sub(int n2, int n3, Vector2i vector2i) {
        vector2i.x = this.x - n2;
        vector2i.y = this.y - n3;
        return vector2i;
    }

    public long lengthSquared() {
        return (long)this.x * (long)this.x + (long)this.y * (long)this.y;
    }

    public static long lengthSquared(int n2, int n3) {
        return (long)n2 * (long)n2 + (long)n3 * (long)n3;
    }

    public double length() {
        return Math.sqrt((long)this.x * (long)this.x + (long)this.y * (long)this.y);
    }

    public static double length(int n2, int n3) {
        return Math.sqrt((long)n2 * (long)n2 + (long)n3 * (long)n3);
    }

    public double distance(Vector2ic vector2ic) {
        int n2 = this.x - vector2ic.x();
        int n3 = this.y - vector2ic.y();
        return Math.sqrt((long)n2 * (long)n2 + (long)n3 * (long)n3);
    }

    public double distance(int n2, int n3) {
        n2 = this.x - n2;
        n3 = this.y - n3;
        return Math.sqrt((long)n2 * (long)n2 + (long)n3 * (long)n3);
    }

    public long distanceSquared(Vector2ic vector2ic) {
        int n2 = this.x - vector2ic.x();
        int n3 = this.y - vector2ic.y();
        return (long)n2 * (long)n2 + (long)n3 * (long)n3;
    }

    public long distanceSquared(int n2, int n3) {
        n2 = this.x - n2;
        n3 = this.y - n3;
        return (long)n2 * (long)n2 + (long)n3 * (long)n3;
    }

    public long gridDistance(Vector2ic vector2ic) {
        return Math.abs(vector2ic.x() - this.x()) + Math.abs(vector2ic.y() - this.y());
    }

    public long gridDistance(int n2, int n3) {
        return Math.abs(n2 - this.x()) + Math.abs(n3 - this.y());
    }

    public static double distance(int n2, int n3, int n4, int n5) {
        return Math.sqrt((long)(n2 -= n4) * (long)n2 + (long)(n3 -= n5) * (long)n3);
    }

    public static long distanceSquared(int n2, int n3, int n4, int n5) {
        return (long)(n2 -= n4) * (long)n2 + (long)(n3 -= n5) * (long)n3;
    }

    public Vector2i add(Vector2ic vector2ic) {
        this.x += vector2ic.x();
        this.y += vector2ic.y();
        return this;
    }

    public Vector2i add(Vector2ic vector2ic, Vector2i vector2i) {
        vector2i.x = this.x + vector2ic.x();
        vector2i.y = this.y + vector2ic.y();
        return vector2i;
    }

    public Vector2i add(int n2, int n3) {
        return this.add(n2, n3, this);
    }

    public Vector2i add(int n2, int n3, Vector2i vector2i) {
        vector2i.x = this.x + n2;
        vector2i.y = this.y + n3;
        return vector2i;
    }

    public Vector2i mul(int n2) {
        return this.mul(n2, this);
    }

    public Vector2i mul(int n2, Vector2i vector2i) {
        vector2i.x = this.x * n2;
        vector2i.y = this.y * n2;
        return vector2i;
    }

    public Vector2i mul(Vector2ic vector2ic) {
        return this.mul(vector2ic, this);
    }

    public Vector2i mul(Vector2ic vector2ic, Vector2i vector2i) {
        vector2i.x = this.x * vector2ic.x();
        vector2i.y = this.y * vector2ic.y();
        return vector2i;
    }

    public Vector2i mul(int n2, int n3) {
        return this.mul(n2, n3, this);
    }

    public Vector2i mul(int n2, int n3, Vector2i vector2i) {
        vector2i.x = this.x * n2;
        vector2i.y = this.y * n3;
        return vector2i;
    }

    public Vector2i div(float f2) {
        return this.div(f2, this);
    }

    public Vector2i div(float f2, Vector2i vector2i) {
        f2 = 1.0f / f2;
        vector2i.x = (int)((float)this.x * f2);
        vector2i.y = (int)((float)this.y * f2);
        return vector2i;
    }

    public Vector2i div(int n2) {
        return this.div(n2, this);
    }

    public Vector2i div(int n2, Vector2i vector2i) {
        vector2i.x = this.x / n2;
        vector2i.y = this.y / n2;
        return vector2i;
    }

    public Vector2i zero() {
        this.x = 0;
        this.y = 0;
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.x);
        objectOutput.writeInt(this.y);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readInt();
        this.y = objectInput.readInt();
    }

    public Vector2i negate() {
        Vector2i vector2i = this;
        return vector2i.negate(vector2i);
    }

    public Vector2i negate(Vector2i vector2i) {
        vector2i.x = -this.x;
        vector2i.y = -this.y;
        return vector2i;
    }

    public Vector2i min(Vector2ic vector2ic) {
        return this.min(vector2ic, this);
    }

    public Vector2i min(Vector2ic vector2ic, Vector2i vector2i) {
        vector2i.x = this.x < vector2ic.x() ? this.x : vector2ic.x();
        vector2i.y = this.y < vector2ic.y() ? this.y : vector2ic.y();
        return vector2i;
    }

    public Vector2i max(Vector2ic vector2ic) {
        return this.max(vector2ic, this);
    }

    public Vector2i max(Vector2ic vector2ic, Vector2i vector2i) {
        vector2i.x = this.x > vector2ic.x() ? this.x : vector2ic.x();
        vector2i.y = this.y > vector2ic.y() ? this.y : vector2ic.y();
        return vector2i;
    }

    public int maxComponent() {
        int n2;
        int n3 = Math.abs(this.x);
        if (n3 >= (n2 = Math.abs(this.y))) {
            return 0;
        }
        return 1;
    }

    public int minComponent() {
        int n2;
        int n3 = Math.abs(this.x);
        if (n3 < (n2 = Math.abs(this.y))) {
            return 0;
        }
        return 1;
    }

    public Vector2i absolute() {
        Vector2i vector2i = this;
        return vector2i.absolute(vector2i);
    }

    public Vector2i absolute(Vector2i vector2i) {
        vector2i.x = Math.abs(this.x);
        vector2i.y = Math.abs(this.y);
        return vector2i;
    }

    public int hashCode() {
        return (31 + this.x) * 31 + this.y;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Vector2i)object;
        if (this.x != ((Vector2i)object).x) {
            return false;
        }
        return this.y == ((Vector2i)object).y;
    }

    public boolean equals(int n2, int n3) {
        if (this.x != n2) {
            return false;
        }
        return this.y == n3;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + numberFormat.format(this.x) + " " + numberFormat.format(this.y) + ")";
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

