/*
 * Decompiled with CFR 0.152.
 */
package org.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import org.joml.Math;
import org.joml.Matrix2dc;
import org.joml.Matrix2fc;
import org.joml.Matrix3x2fc;
import org.joml.MemUtil;
import org.joml.Options;
import org.joml.Runtime;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2fc;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3dc;
import org.joml.Vector3fc;
import org.joml.Vector3ic;

public class Vector2f
implements Externalizable,
Cloneable,
Vector2fc {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;

    public Vector2f() {
    }

    public Vector2f(float f2) {
        this.x = f2;
        this.y = f2;
    }

    public Vector2f(float f2, float f3) {
        this.x = f2;
        this.y = f3;
    }

    public Vector2f(Vector2fc vector2fc) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
    }

    public Vector2f(Vector2dc vector2dc) {
        this.x = (float)vector2dc.x();
        this.y = (float)vector2dc.y();
    }

    public Vector2f(Vector2ic vector2ic) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
    }

    public Vector2f(Vector3fc vector3fc) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
    }

    public Vector2f(Vector3dc vector3dc) {
        this.x = (float)vector3dc.x();
        this.y = (float)vector3dc.y();
    }

    public Vector2f(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
    }

    public Vector2f(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
    }

    public Vector2f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector2f(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
    }

    public Vector2f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
    }

    public Vector2f(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n2, floatBuffer);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public Vector2f set(float f2) {
        this.x = f2;
        this.y = f2;
        return this;
    }

    public Vector2f set(float f2, float f3) {
        this.x = f2;
        this.y = f3;
        return this;
    }

    public Vector2f set(double d2) {
        this.x = (float)d2;
        this.y = (float)d2;
        return this;
    }

    public Vector2f set(double d2, double d3) {
        this.x = (float)d2;
        this.y = (float)d3;
        return this;
    }

    public Vector2f set(Vector2fc vector2fc) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        return this;
    }

    public Vector2f set(Vector2ic vector2ic) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        return this;
    }

    public Vector2f set(Vector2dc vector2dc) {
        this.x = (float)vector2dc.x();
        this.y = (float)vector2dc.y();
        return this;
    }

    public Vector2f set(Vector3dc vector3dc) {
        this.x = (float)vector3dc.x();
        this.y = (float)vector3dc.y();
        return this;
    }

    public Vector2f set(Vector3fc vector3fc) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        return this;
    }

    public Vector2f set(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        return this;
    }

    public Vector2f set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        return this;
    }

    public Vector2f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector2f set(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n2, byteBuffer);
        return this;
    }

    public Vector2f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Vector2f set(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n2, floatBuffer);
        return this;
    }

    public Vector2f setFromAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.get(this, l2);
        return this;
    }

    public float get(int n2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IllegalArgumentException();
    }

    public Vector2i get(int n2, Vector2i vector2i) {
        vector2i.x = Math.roundUsing(this.x(), n2);
        vector2i.y = Math.roundUsing(this.y(), n2);
        return vector2i;
    }

    public Vector2f get(Vector2f vector2f) {
        vector2f.x = this.x();
        vector2f.y = this.y();
        return vector2f;
    }

    public Vector2d get(Vector2d vector2d) {
        vector2d.x = this.x();
        vector2d.y = this.y();
        return vector2d;
    }

    public Vector2f setComponent(int n2, float f2) throws IllegalArgumentException {
        switch (n2) {
            case 0: {
                this.x = f2;
                break;
            }
            case 1: {
                this.y = f2;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    public ByteBuffer get(int n2, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n2, byteBuffer);
        return byteBuffer;
    }

    public FloatBuffer get(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    public FloatBuffer get(int n2, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n2, floatBuffer);
        return floatBuffer;
    }

    public Vector2fc getToAddress(long l2) {
        if (Options.NO_UNSAFE) {
            throw new UnsupportedOperationException("Not supported when using joml.nounsafe");
        }
        MemUtil.MemUtilUnsafe.put(this, l2);
        return this;
    }

    public Vector2f perpendicular() {
        float f2 = this.y;
        this.y = -this.x;
        this.x = f2;
        return this;
    }

    public Vector2f sub(Vector2fc vector2fc) {
        return this.sub(vector2fc, this);
    }

    public Vector2f sub(Vector2fc vector2fc, Vector2f vector2f) {
        vector2f.x = this.x - vector2fc.x();
        vector2f.y = this.y - vector2fc.y();
        return vector2f;
    }

    public Vector2f sub(float f2, float f3) {
        return this.sub(f2, f3, this);
    }

    public Vector2f sub(float f2, float f3, Vector2f vector2f) {
        vector2f.x = this.x - f2;
        vector2f.y = this.y - f3;
        return vector2f;
    }

    public float dot(Vector2fc vector2fc) {
        return this.x * vector2fc.x() + this.y * vector2fc.y();
    }

    public float angle(Vector2fc vector2fc) {
        float f2 = this.x * vector2fc.x() + this.y * vector2fc.y();
        return Math.atan2(this.x * vector2fc.y() - this.y * vector2fc.x(), f2);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public static float lengthSquared(float f2, float f3) {
        float f4 = f2;
        float f5 = f3;
        return f4 * f4 + f5 * f5;
    }

    public float length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public static float length(float f2, float f3) {
        float f4 = f2;
        float f5 = f3;
        return Math.sqrt(f4 * f4 + f5 * f5);
    }

    public float distance(Vector2fc vector2fc) {
        float f2 = this.x - vector2fc.x();
        float f3 = this.y - vector2fc.y();
        float f4 = f2;
        float f5 = f3;
        return Math.sqrt(f4 * f4 + f5 * f5);
    }

    public float distanceSquared(Vector2fc vector2fc) {
        float f2 = this.x - vector2fc.x();
        float f3 = this.y - vector2fc.y();
        float f4 = f2;
        float f5 = f3;
        return f4 * f4 + f5 * f5;
    }

    public float distance(float f2, float f3) {
        f2 = this.x - f2;
        f3 = this.y - f3;
        float f4 = f2;
        float f5 = f3;
        return Math.sqrt(f4 * f4 + f5 * f5);
    }

    public float distanceSquared(float f2, float f3) {
        f2 = this.x - f2;
        f3 = this.y - f3;
        float f4 = f2;
        float f5 = f3;
        return f4 * f4 + f5 * f5;
    }

    public static float distance(float f2, float f3, float f4, float f5) {
        float f6 = f2 -= f4;
        float f7 = f3 -= f5;
        return Math.sqrt(f6 * f6 + f7 * f7);
    }

    public static float distanceSquared(float f2, float f3, float f4, float f5) {
        float f6 = f2 -= f4;
        float f7 = f3 -= f5;
        return f6 * f6 + f7 * f7;
    }

    public Vector2f normalize() {
        Vector2f vector2f = this;
        return vector2f.normalize(vector2f);
    }

    public Vector2f normalize(Vector2f vector2f) {
        float f2 = Math.invsqrt(this.x * this.x + this.y * this.y);
        vector2f.x = this.x * f2;
        vector2f.y = this.y * f2;
        return vector2f;
    }

    public Vector2f normalize(float f2) {
        return this.normalize(f2, this);
    }

    public Vector2f normalize(float f2, Vector2f vector2f) {
        f2 = Math.invsqrt(this.x * this.x + this.y * this.y) * f2;
        vector2f.x = this.x * f2;
        vector2f.y = this.y * f2;
        return vector2f;
    }

    public Vector2f add(Vector2fc vector2fc) {
        return this.add(vector2fc, this);
    }

    public Vector2f add(Vector2fc vector2fc, Vector2f vector2f) {
        vector2f.x = this.x + vector2fc.x();
        vector2f.y = this.y + vector2fc.y();
        return vector2f;
    }

    public Vector2f add(float f2, float f3) {
        return this.add(f2, f3, this);
    }

    public Vector2f add(float f2, float f3, Vector2f vector2f) {
        vector2f.x = this.x + f2;
        vector2f.y = this.y + f3;
        return vector2f;
    }

    public Vector2f zero() {
        this.x = 0.0f;
        this.y = 0.0f;
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.x = objectInput.readFloat();
        this.y = objectInput.readFloat();
    }

    public Vector2f negate() {
        Vector2f vector2f = this;
        return vector2f.negate(vector2f);
    }

    public Vector2f negate(Vector2f vector2f) {
        vector2f.x = -this.x;
        vector2f.y = -this.y;
        return vector2f;
    }

    public Vector2f mul(float f2) {
        return this.mul(f2, this);
    }

    public Vector2f mul(float f2, Vector2f vector2f) {
        vector2f.x = this.x * f2;
        vector2f.y = this.y * f2;
        return vector2f;
    }

    public Vector2f mul(float f2, float f3) {
        return this.mul(f2, f3, this);
    }

    public Vector2f mul(float f2, float f3, Vector2f vector2f) {
        vector2f.x = this.x * f2;
        vector2f.y = this.y * f3;
        return vector2f;
    }

    public Vector2f mul(Vector2fc vector2fc) {
        return this.mul(vector2fc, this);
    }

    public Vector2f mul(Vector2fc vector2fc, Vector2f vector2f) {
        vector2f.x = this.x * vector2fc.x();
        vector2f.y = this.y * vector2fc.y();
        return vector2f;
    }

    public Vector2f div(Vector2fc vector2fc) {
        return this.div(vector2fc, this);
    }

    public Vector2f div(Vector2fc vector2fc, Vector2f vector2f) {
        vector2f.x = this.x / vector2fc.x();
        vector2f.y = this.y / vector2fc.y();
        return vector2f;
    }

    public Vector2f div(float f2) {
        return this.div(f2, this);
    }

    public Vector2f div(float f2, Vector2f vector2f) {
        f2 = 1.0f / f2;
        vector2f.x = this.x * f2;
        vector2f.y = this.y * f2;
        return vector2f;
    }

    public Vector2f div(float f2, float f3) {
        return this.div(f2, f3, this);
    }

    public Vector2f div(float f2, float f3, Vector2f vector2f) {
        vector2f.x = this.x / f2;
        vector2f.y = this.y / f3;
        return vector2f;
    }

    public Vector2f mul(Matrix2fc matrix2fc) {
        return this.mul(matrix2fc, this);
    }

    public Vector2f mul(Matrix2fc matrix2fc, Vector2f vector2f) {
        float f2 = matrix2fc.m00() * this.x + matrix2fc.m10() * this.y;
        float f3 = matrix2fc.m01() * this.x + matrix2fc.m11() * this.y;
        vector2f.x = f2;
        vector2f.y = f3;
        return vector2f;
    }

    public Vector2f mul(Matrix2dc matrix2dc) {
        return this.mul(matrix2dc, this);
    }

    public Vector2f mul(Matrix2dc matrix2dc, Vector2f vector2f) {
        double d2 = matrix2dc.m00() * (double)this.x + matrix2dc.m10() * (double)this.y;
        double d3 = matrix2dc.m01() * (double)this.x + matrix2dc.m11() * (double)this.y;
        vector2f.x = (float)d2;
        vector2f.y = (float)d3;
        return vector2f;
    }

    public Vector2f mulTranspose(Matrix2fc matrix2fc) {
        return this.mulTranspose(matrix2fc, this);
    }

    public Vector2f mulTranspose(Matrix2fc matrix2fc, Vector2f vector2f) {
        float f2 = matrix2fc.m00() * this.x + matrix2fc.m01() * this.y;
        float f3 = matrix2fc.m10() * this.x + matrix2fc.m11() * this.y;
        vector2f.x = f2;
        vector2f.y = f3;
        return vector2f;
    }

    public Vector2f mulPosition(Matrix3x2fc matrix3x2fc) {
        return this.mulPosition(matrix3x2fc, this);
    }

    public Vector2f mulPosition(Matrix3x2fc matrix3x2fc, Vector2f vector2f) {
        vector2f.x = matrix3x2fc.m00() * this.x + matrix3x2fc.m10() * this.y + matrix3x2fc.m20();
        vector2f.y = matrix3x2fc.m01() * this.x + matrix3x2fc.m11() * this.y + matrix3x2fc.m21();
        return vector2f;
    }

    public Vector2f mulDirection(Matrix3x2fc matrix3x2fc) {
        return this.mulDirection(matrix3x2fc, this);
    }

    public Vector2f mulDirection(Matrix3x2fc matrix3x2fc, Vector2f vector2f) {
        vector2f.x = matrix3x2fc.m00() * this.x + matrix3x2fc.m10() * this.y;
        vector2f.y = matrix3x2fc.m01() * this.x + matrix3x2fc.m11() * this.y;
        return vector2f;
    }

    public Vector2f lerp(Vector2fc vector2fc, float f2) {
        return this.lerp(vector2fc, f2, this);
    }

    public Vector2f lerp(Vector2fc vector2fc, float f2, Vector2f vector2f) {
        vector2f.x = this.x + (vector2fc.x() - this.x) * f2;
        vector2f.y = this.y + (vector2fc.y() - this.y) * f2;
        return vector2f;
    }

    public int hashCode() {
        return (31 + Float.floatToIntBits(this.x)) * 31 + Float.floatToIntBits(this.y);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Vector2f)object;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(((Vector2f)object).x)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(((Vector2f)object).y);
    }

    public boolean equals(Vector2fc vector2fc, float f2) {
        if (this == vector2fc) {
            return true;
        }
        if (vector2fc == null) {
            return false;
        }
        if (this.getClass() != vector2fc.getClass()) {
            return false;
        }
        if (!Runtime.equals(this.x, vector2fc.x(), f2)) {
            return false;
        }
        return Runtime.equals(this.y, vector2fc.y(), f2);
    }

    public boolean equals(float f2, float f3) {
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(f2)) {
            return false;
        }
        return Float.floatToIntBits(this.y) == Float.floatToIntBits(f3);
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + ")";
    }

    public Vector2f fma(Vector2fc vector2fc, Vector2fc vector2fc2) {
        return this.fma(vector2fc, vector2fc2, this);
    }

    public Vector2f fma(float f2, Vector2fc vector2fc) {
        return this.fma(f2, vector2fc, this);
    }

    public Vector2f fma(Vector2fc vector2fc, Vector2fc vector2fc2, Vector2f vector2f) {
        vector2f.x = Math.fma(vector2fc.x(), vector2fc2.x(), this.x);
        vector2f.y = Math.fma(vector2fc.y(), vector2fc2.y(), this.y);
        return vector2f;
    }

    public Vector2f fma(float f2, Vector2fc vector2fc, Vector2f vector2f) {
        vector2f.x = Math.fma(f2, vector2fc.x(), this.x);
        vector2f.y = Math.fma(f2, vector2fc.y(), this.y);
        return vector2f;
    }

    public Vector2f min(Vector2fc vector2fc) {
        return this.min(vector2fc, this);
    }

    public Vector2f min(Vector2fc vector2fc, Vector2f vector2f) {
        vector2f.x = this.x < vector2fc.x() ? this.x : vector2fc.x();
        vector2f.y = this.y < vector2fc.y() ? this.y : vector2fc.y();
        return vector2f;
    }

    public Vector2f max(Vector2fc vector2fc) {
        return this.max(vector2fc, this);
    }

    public Vector2f max(Vector2fc vector2fc, Vector2f vector2f) {
        vector2f.x = this.x > vector2fc.x() ? this.x : vector2fc.x();
        vector2f.y = this.y > vector2fc.y() ? this.y : vector2fc.y();
        return vector2f;
    }

    public int maxComponent() {
        float f2;
        float f3 = Math.abs(this.x);
        if (f3 >= (f2 = Math.abs(this.y))) {
            return 0;
        }
        return 1;
    }

    public int minComponent() {
        float f2;
        float f3 = Math.abs(this.x);
        if (f3 < (f2 = Math.abs(this.y))) {
            return 0;
        }
        return 1;
    }

    public Vector2f floor() {
        Vector2f vector2f = this;
        return vector2f.floor(vector2f);
    }

    public Vector2f floor(Vector2f vector2f) {
        vector2f.x = Math.floor(this.x);
        vector2f.y = Math.floor(this.y);
        return vector2f;
    }

    public Vector2f ceil() {
        Vector2f vector2f = this;
        return vector2f.ceil(vector2f);
    }

    public Vector2f ceil(Vector2f vector2f) {
        vector2f.x = Math.ceil(this.x);
        vector2f.y = Math.ceil(this.y);
        return vector2f;
    }

    public Vector2f round() {
        Vector2f vector2f = this;
        return vector2f.round(vector2f);
    }

    public Vector2f round(Vector2f vector2f) {
        vector2f.x = Math.round(this.x);
        vector2f.y = Math.round(this.y);
        return vector2f;
    }

    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y);
    }

    public Vector2f absolute() {
        Vector2f vector2f = this;
        return vector2f.absolute(vector2f);
    }

    public Vector2f absolute(Vector2f vector2f) {
        vector2f.x = Math.abs(this.x);
        vector2f.y = Math.abs(this.y);
        return vector2f;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

